/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;

public class Alertable
extends BaseTreeNode {
    private int nBad;
    private int nNotBad;

    private short getState() {
        short result = this.nBad > 0 ? (short)-1 : (this.nNotBad > 0 ? (short)1 : 0);
        return result;
    }

    public void reset() {
        this.nBad = 0;
        this.nNotBad = 0;
    }

    public void change(int deltaBad, int deltaNotBad) {
        this.nBad += deltaBad;
        if (this.nBad < 0) {
            this.nBad = 0;
        }
        this.nNotBad += deltaNotBad;
        if (this.nNotBad < 0) {
            this.nNotBad = 0;
        }
        BaseTree.MyTree.nodeChanged(this);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.render(renderer, tree, selected, expanded, leaf, row, hasFocus);
        Color color = Color.black;
        switch (this.getState()) {
            case -1: {
                color = Color.red;
                renderer.setIcon(IconFactory.getStateCriticalIcon());
                break;
            }
            case 1: {
                color = NameListTreeCellRenderer.darkerGreen;
                renderer.setIcon(IconFactory.getStateNotBadIcon());
            }
        }
        this.nodeColor = color;
        if (!selected) {
            renderer.setForeground(color);
        }
    }
}

