/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.ObjectChangeListener;

public class ChangeManager {
    private static Map<Integer, List<ObjectChangeListener>> listenerListMap = new HashMap<Integer, List<ObjectChangeListener>>();

    public static void removeListener(ObjectChangeListener listener) {
        for (List<ObjectChangeListener> listenerList : listenerListMap.values()) {
            Iterator<ObjectChangeListener> listenerIt = listenerList.iterator();
            while (listenerIt.hasNext()) {
                if (listenerIt.next() != listener) continue;
                listenerIt.remove();
            }
        }
    }

    public static void addListener(ObjectChangeListener listener, short type) {
        List<ObjectChangeListener> listenerList = listenerListMap.get(type);
        if (listenerList == null) {
            listenerList = new LinkedList<ObjectChangeListener>();
            listenerListMap.put(Integer.valueOf(type), listenerList);
        }
        listenerList.add(listener);
    }

    public static void signalChange(int changeType, NameList object) {
        List<ObjectChangeListener> listenerList = listenerListMap.get(object.nlInfo);
        if (listenerList != null) {
            for (ObjectChangeListener listener : listenerList) {
                listener.changeOccurred(changeType, object);
            }
        }
    }
}

