/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DDIremover;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.PrintComponent;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.UilButtonPanelBean;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.xmsg.MessageLog;

public class DataDisplayInfo
implements Runnable,
ActionListener,
PrintPreviewable {
    public JComponent panel = null;
    public BaseTreeNode treeNode = null;
    private String description = MessageLog.getMessageNoID("GUI5004L");
    public String helpID = "welcome_gettingstarted";
    public boolean displayInScrollPane = true;
    public boolean displayUnsavedChangeMsg = true;
    protected PageFormat pf = null;
    protected int maxPageNumber = 1;
    protected int scale = 100;
    protected boolean imageRescaled = false;
    protected BufferedImage bi = null;
    protected Image img = null;
    protected JLabel creatorName = null;
    protected JLabel printTime = null;
    protected int pageableHeight = 0;
    protected static IGuiMain guiMain;
    private DataDisplayInfo prev = null;
    private DataDisplayInfo next = null;
    private DataDisplayInfo prevLRU = null;
    private DataDisplayInfo nextLRU = null;
    private boolean onDDIchain = false;
    private static DataDisplayInfo ddiRoot;
    private static DataDisplayInfo ddiCurr;
    private static int ddiCount;
    private static DataDisplayInfo ddiLastLRU;
    static boolean removeWithoutShow;
    private ButtonGroup radioGroup = null;
    public JDialog subMenuDialog = null;
    public Submenu[] submenus;
    private int actionButtonCount = 0;
    Hashtable radioButtons = null;
    private static boolean focusAlreadyLost;

    public DataDisplayInfo() {
        guiMain = GuiManager.getGuiManager().getGuiMain();
    }

    public DataDisplayInfo(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    public void reDisplay() {
        this.show();
    }

    public void losingFocus() {
    }

    public void panelToBeNulled() {
    }

    public void goingAway() {
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        return false;
    }

    public void saveAndClose() {
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void printData(Container dashboard) {
        Container thing = null;
        MegaTable table = null;
        JTabbedPane tabPane = null;
        int tabIndex = 0;
        String tabTitle = null;
        Icon tabIcon = null;
        if (dashboard != null) {
            thing = dashboard;
        } else {
            if (this.panel instanceof JTabbedPane) {
                tabPane = (JTabbedPane)this.panel;
                tabIndex = tabPane.getSelectedIndex();
                tabTitle = tabPane.getTitleAt(tabIndex);
                tabIcon = tabPane.getIconAt(tabIndex);
                thing = (Container)tabPane.getComponentAt(tabIndex);
            } else {
                thing = this.panel;
            }
            Component[] thingsStuff = thing.getComponents();
            for (int i = 0; i < thingsStuff.length; ++i) {
                if (!(thingsStuff[i] instanceof MegaTable)) continue;
                table = (MegaTable)thingsStuff[i];
                break;
            }
        }
        if (table != null && ((BaseTableModel)table.getDataSource()).getAdjuster() != null) {
            PrintTableData.printTable(this, table, GuiUtil.getUserName(), this.description, this.description);
        } else {
            PrintOptions options;
            PrintOutputChooser chooser = new PrintOutputChooser();
            boolean pdfAllowed = false;
            if (this instanceof SavedReportDDI) {
                SavedReportDDI srddi = (SavedReportDDI)this;
                pdfAllowed = srddi.getPdfAllowed();
            }
            if ((options = chooser.getOptions(false, pdfAllowed)) != null) {
                if (dashboard != null) {
                    thing = DataDisplayInfo.guiMain.getNullDDI().panel;
                }
                if (options.outputType == 1) {
                    new PrintPreviewPanel(this, this.description, true);
                    return;
                }
                PrintComponent.print(options, thing, GuiUtil.getUserName(), null, this.description, true);
            }
        }
    }

    public int fitToPage(PageFormat pf) {
        int width = this.panel.getWidth();
        int height = this.panel.getHeight();
        int pageWidth = (int)pf.getImageableWidth();
        if (this.pageableHeight == 0) {
            this.pageableHeight = (int)pf.getImageableHeight();
        }
        int imgWidth = this.bi.getWidth(this);
        int imgHeight = this.bi.getHeight(this);
        double nCol = Math.min((double)pageWidth / (double)imgWidth, 1.0);
        double nRow = Math.min((double)this.pageableHeight / (double)imgHeight, 1.0);
        this.scale = (int)(Math.min(nCol, nRow) * 100.0);
        this.img = this.bi.getScaledInstance(width * this.scale / 100, height * this.scale / 100, 4);
        this.img.flush();
        this.imageRescaled = false;
        return this.scale;
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        if (this.panel == null) {
            return 1;
        }
        this.pf = pf;
        int width = this.panel.getWidth();
        int height = this.panel.getHeight();
        if (width == 0 || height == 0) {
            width = this.panel.getPreferredSize().width;
            height = this.panel.getPreferredSize().height;
        }
        if (this.bi == null) {
            this.bi = new BufferedImage(width, height, 1);
            Color oldBG = this.panel.getBackground();
            this.panel.setBackground(Color.white);
            this.panel.paint(this.bi.createGraphics());
            this.panel.setBackground(oldBG);
            this.img = this.bi.getScaledInstance(width * this.scale / 100, height * this.scale / 100, 4);
            this.img.flush();
            this.imageRescaled = false;
        }
        if (pageIndex >= this.maxPageNumber || this.bi == null) {
            return 1;
        }
        if (this.imageRescaled) {
            this.img = this.bi.getScaledInstance(width * this.scale / 100, height * this.scale / 100, 4);
            this.img.flush();
            this.imageRescaled = false;
        }
        g.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        int pageWidth = (int)pf.getImageableWidth();
        int pageHeight = (int)pf.getImageableHeight();
        int imgWidth = this.img.getWidth(this);
        int imgHeight = this.img.getHeight(this);
        if (imgWidth == 0 || imgHeight == 0) {
            return 1;
        }
        FontMetrics fm = g.getFontMetrics(this.panel.getFont());
        int footerHeight = fm.getMaxAscent() + fm.getMaxDescent();
        int headerHeight = footerHeight * 2;
        this.pageableHeight = pageHeight - (footerHeight + headerHeight + fm.getAscent());
        int nCol = Math.max((int)Math.ceil((double)imgWidth / (double)pageWidth), 1);
        int nRow = Math.max((int)Math.ceil((double)imgHeight / (double)this.pageableHeight), 1);
        this.maxPageNumber = nCol * nRow;
        int iCol = pageIndex % nCol;
        int iRow = pageIndex / nCol;
        int x = iCol * pageWidth;
        int y = iRow * this.pageableHeight;
        int wImage = Math.min(pageWidth, imgWidth - x);
        int hImage = Math.min(this.pageableHeight, imgHeight - y);
        g.setColor(Color.black);
        if (pageIndex == 0) {
            g.drawString(PrintPreviewable.CREATED_BY + " " + GuiUtil.getUserName() + "     " + PrintPreviewable.PRINTED_ON + " " + Util.formatDateTime(new Date()), 0, fm.getAscent());
        }
        g.drawImage(this.img, 0, headerHeight, wImage, hImage + headerHeight, x, y += headerHeight, x + wImage, y + hImage, this);
        g.drawString(Util.getString("LABEL_PAGE_X_OF_Y", Integer.toString(pageIndex + 1), Integer.toString(this.maxPageNumber)), 0, (int)(pf.getImageableHeight() - (double)fm.getMaxDescent()));
        return 0;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public void run() {
    }

    public static DataDisplayInfo getCurrent() {
        return ddiCurr;
    }

    public DataDisplayInfo getPrev() {
        return this.prev;
    }

    public DataDisplayInfo getNext() {
        return this.next;
    }

    public static DataDisplayInfo getRoot() {
        return ddiRoot;
    }

    public final void loseFocus() {
        if (!focusAlreadyLost) {
            focusAlreadyLost = true;
            this.losingFocus();
        }
    }

    public void show() {
        if (this.addToChain()) {
            if (ddiCurr != null) {
                ddiCurr.loseFocus();
            }
            ddiCurr = this;
            this.makeLastLRU();
            DataDisplayInfo.makePanelsNull();
            guiMain.setView(this);
            focusAlreadyLost = false;
        } else {
            this.remove();
        }
    }

    public final void currentPanelReplaced() {
        if (ddiCurr == this) {
            guiMain.setView(this);
        } else {
            this.show();
        }
    }

    private final boolean addToChain() {
        guiMain = GuiManager.getGuiManager().getGuiMain();
        if (this.onDDIchain) {
            return true;
        }
        this.onDDIchain = true;
        DDIremover ddiRem = null;
        UserPreferences prefs = guiMain.getUserPrefs();
        if (prefs == null) {
            System.out.println("Pref is null");
        }
        if (++ddiCount > DataDisplayInfo.guiMain.getUserPrefs().maxDDIs) {
            if (ddiRoot != null && !ddiRoot.changesPending()) {
                removeWithoutShow = true;
                ddiRoot.remove();
                removeWithoutShow = false;
            } else {
                ddiRem = new DDIremover();
                if (!ddiRem.wasDDIremoved) {
                    return false;
                }
                ddiRem.dispose();
            }
        }
        if (this.treeNode == null) {
            this.treeNode = (BaseTreeNode)BaseTree.pBaseTree.getLastSelectedPathComponent();
            if (this.treeNode != null) {
                if (this instanceof CreateOrEditDDI) {
                    Object o;
                    CreateOrEditDDI editDDI = (CreateOrEditDDI)this;
                    if (!(editDDI.ID == 0 || (o = this.treeNode.getUserObject()) instanceof NameList && ((NameList)o).nlID == editDDI.ID)) {
                        this.treeNode = null;
                    }
                }
                if (this.treeNode != null && this.treeNode.ddi == null) {
                    this.treeNode.ddi = this;
                }
            }
        }
        this.prev = ddiCurr;
        if (ddiCurr != null) {
            this.next = DataDisplayInfo.ddiCurr.next;
            DataDisplayInfo.ddiCurr.next = this;
            if (this.next != null) {
                this.next.prev = this;
            }
        } else {
            this.next = null;
        }
        if (ddiRoot == null) {
            ddiRoot = this;
        }
        return true;
    }

    private final void makeLastLRU() {
        if (ddiLastLRU != this) {
            if (this.prevLRU != null) {
                this.prevLRU.nextLRU = this.nextLRU;
            }
            if (this.nextLRU != null) {
                this.nextLRU.prevLRU = this.prevLRU;
            }
            this.prevLRU = ddiLastLRU;
            if (ddiLastLRU != null) {
                DataDisplayInfo.ddiLastLRU.nextLRU = this;
            }
            this.nextLRU = null;
            ddiLastLRU = this;
        }
    }

    public final void nullOutPanel() {
        if (this.panel != null) {
            this.panelToBeNulled();
            this.panel = null;
        }
    }

    private static void makePanelsNull() {
        DataDisplayInfo ddi = ddiLastLRU;
        int i = 1;
        while (ddi != null) {
            if (i++ > DataDisplayInfo.guiMain.getUserPrefs().maxPanels) {
                ddi.nullOutPanel();
            }
            ddi = ddi.prevLRU;
        }
    }

    public final void remove() {
        if (this.prevLRU != null) {
            this.prevLRU.nextLRU = this.nextLRU;
        }
        if (this.nextLRU != null) {
            this.nextLRU.prevLRU = this.prevLRU;
        }
        if (ddiLastLRU == this) {
            ddiLastLRU = this.prevLRU;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        if (ddiRoot == this) {
            ddiRoot = this.next;
        }
        if (this.treeNode != null && this.treeNode.ddi == this) {
            this.treeNode.ddi = null;
        }
        --ddiCount;
        if (ddiCurr == this) {
            this.loseFocus();
            DataDisplayInfo dataDisplayInfo = ddiCurr = this.prev != null ? this.prev : this.next;
            if (!removeWithoutShow) {
                if (ddiCurr == null) {
                    guiMain.showNull();
                } else {
                    ddiCurr.reDisplay();
                }
            }
        } else if (!removeWithoutShow) {
            guiMain.setPrevNext();
        }
        this.goingAway();
        this.onDDIchain = false;
    }

    public final boolean fileClose() {
        boolean removeDDI = true;
        if (this.displayUnsavedChangeMsg && guiMain.isProperAdmin() && this.changesPending()) {
            String s = MessageLog.getMessageNoID("GUI5017L");
            int action = JOptionPane.showConfirmDialog(guiMain.getFrame(), s, this.description, 1);
            switch (action) {
                case 1: {
                    break;
                }
                case 0: {
                    this.saveAndClose();
                }
                default: {
                    removeDDI = false;
                }
            }
        }
        if (removeDDI) {
            this.remove();
        }
        return removeDDI;
    }

    public static void removeAllWithoutChanges() {
        DataDisplayInfo removeDDI = ddiRoot;
        removeWithoutShow = true;
        while (removeDDI != null) {
            DataDisplayInfo nextToRemove = removeDDI.next;
            if (!removeDDI.changesPending()) {
                removeDDI.remove();
            }
            removeDDI = nextToRemove;
        }
        removeWithoutShow = false;
    }

    public void createAndShowButtonSubMenu() {
        if (this.submenus[0] != null) {
            String s = null;
            JMenuItem menuItem = null;
            JRadioButton newButton = null;
            this.radioGroup = new ButtonGroup();
            this.subMenuDialog = new JDialog(guiMain.getFrame(), true);
            GuiUtil.centerDialog(this.subMenuDialog);
            JPanel panel = new JPanel(new BorderLayout());
            JPanel radioPanel = new JPanel(new GridLayout());
            JPanel bottomPanel = new JPanel(new FlowLayout());
            Container cp = this.subMenuDialog.getContentPane();
            this.radioButtons = new Hashtable();
            JMenu menu = this.submenus[0].menu;
            JPopupMenu pm = menu.getPopupMenu();
            int mc = pm.getComponentCount();
            for (int j = 0; j < mc; ++j) {
                menuItem = (JMenuItem)pm.getComponent(j);
                s = menuItem.getName();
                newButton = j == 0 ? new JRadioButton(s, true) : new JRadioButton(s, false);
                newButton.setActionCommand(menuItem.getActionCommand());
                ActionListener[] als = (ActionListener[])menuItem.getListeners(ActionListener.class);
                if (als.length > 0) {
                    this.radioButtons.put(menuItem.getActionCommand(), als[0]);
                }
                this.radioGroup.add(newButton);
                radioPanel.add(newButton);
            }
            panel.add((Component)radioPanel, "Center");
            JButton b = new JButton(Util.getString("LABEL_OK"));
            b.addActionListener(this);
            bottomPanel.add(b);
            b = new JButton(Util.getString("LABEL_CANCEL"));
            b.addActionListener(this);
            bottomPanel.add(b);
            panel.add((Component)bottomPanel, "South");
            cp.add(panel);
            this.subMenuDialog.pack();
            this.subMenuDialog.setVisible(true);
        }
    }

    public JPanel getButtonPanel(JPopupMenu popup) {
        UilButtonPanelBean buttonPanel = new UilButtonPanelBean();
        buttonPanel.setSpacerSize(4);
        JPanel holder = new JPanel(new FlowLayout(0, 0, 0));
        holder.setBorder(new CompoundBorder(new EmptyBorder(4, 2, 6, 2), GuiUtil.getBorder()));
        holder.add(buttonPanel);
        JButton b = null;
        String s = null;
        Component menuItem = null;
        int c = popup.getComponentCount();
        c = 0;
        for (int i = 0; i < c; ++i) {
            menuItem = popup.getComponent(i);
            b = new JButton();
            b.setToolTipText(((JMenuItem)menuItem).getToolTipText());
            s = menuItem.getName();
            if (!menuItem.isEnabled()) continue;
            if (menuItem instanceof JMenu) {
                b.setText(s + "...");
                b.addActionListener(this);
                if (this.submenus == null) {
                    this.submenus = new Submenu[1];
                }
                Submenu sub = new Submenu();
                sub.name = b.getText();
                sub.menu = (JMenu)menuItem;
                this.submenus[0] = sub;
            } else {
                b.setText(s);
                b.setActionCommand(((JMenuItem)menuItem).getActionCommand());
                ActionListener[] als = (ActionListener[])menuItem.getListeners(ActionListener.class);
                for (int j = 0; j < als.length; ++j) {
                    b.addActionListener(als[j]);
                }
            }
            buttonPanel.add(b);
            ++this.actionButtonCount;
        }
        return holder;
    }

    public int getActionButtonCount() {
        return this.actionButtonCount;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand() == Util.getString("LABEL_CANCEL")) {
            if (this.subMenuDialog != null) {
                this.subMenuDialog.dispose();
            }
        } else if (ae.getActionCommand() == Util.getString("LABEL_OK")) {
            if (this.subMenuDialog != null) {
                this.subMenuDialog.dispose();
            }
            ButtonModel mod = this.radioGroup.getSelection();
            String ac = mod.getActionCommand();
            ActionListener al = (ActionListener)this.radioButtons.get(ac);
            JRadioButton rb = new JRadioButton();
            rb.addActionListener(al);
            rb.setActionCommand(ac);
            rb.doClick();
        } else if (ae.getActionCommand() == Util.getString("LABEL_SAVE")) {
            if (this.subMenuDialog != null) {
                this.subMenuDialog.dispose();
            }
        } else {
            this.createAndShowButtonSubMenu();
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
        this.imageRescaled = true;
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    public void setBufferedImage(BufferedImage bi) {
        this.bi = bi;
    }

    public int getNumberOfPages() {
        return this.maxPageNumber;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pf;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public String getDescription() {
        return Util.getTranslatedName(this.description);
    }

    public String getTrueDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    static {
        ddiRoot = null;
        ddiCurr = null;
        ddiCount = 0;
        ddiLastLRU = null;
        removeWithoutShow = false;
        focusAlreadyLost = true;
    }

    public class Submenu {
        public String name;
        public JMenu menu;
    }
}

