/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.UilDateFieldBean;

public class DateSelector
extends JPanel
implements ActionListener {
    private JButton calendarButton;
    private JButton okButton;
    private JButton cancelButton;
    private int maxYear;
    private static final int MIN_YEAR = 2000;
    private UilDateFieldBean dateField = new UilDateFieldBean();
    private Calendar calendar = Calendar.getInstance();

    public DateSelector() {
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateSelector(long milliseconds) {
        this.calendar.setTime(new Date(milliseconds));
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateSelector(short year, short month, short day) {
        if (year == 0) {
            this.initFromCalendar(this.calendar);
        } else {
            this.initFromShorts(year, month, day);
        }
        this.buildPanel();
    }

    private void initFromCalendar(Calendar cal) {
        this.dateField.setTime(cal.getTime());
    }

    private void initFromShorts(short year, short month, short day) {
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
    }

    public void setDate(short year, short month, short day) {
        this.initFromShorts(year, month, day);
        this.setDate();
    }

    public void setDate(long milliseconds) {
        this.calendar.setTime(new Date(milliseconds));
        this.initFromCalendar(this.calendar);
        this.setDate();
    }

    public short[] getDate() {
        this.getSelection();
        short[] date = new short[]{(short)this.calendar.get(1), (short)this.calendar.get(2), (short)this.calendar.get(5)};
        return date;
    }

    public long getLongDate() {
        this.getSelection();
        return this.calendar.getTime().getTime();
    }

    public long getStartOfDay() {
        this.getSelection();
        Calendar dateTime = Calendar.getInstance();
        dateTime.set(1, this.calendar.get(1));
        dateTime.set(2, this.calendar.get(2));
        dateTime.set(5, this.calendar.get(5));
        dateTime.set(11, 0);
        dateTime.set(12, 0);
        dateTime.set(13, 0);
        dateTime.set(14, 0);
        return dateTime.getTime().getTime();
    }

    public long getEndOfDay() {
        this.getSelection();
        Calendar dateTime = Calendar.getInstance();
        dateTime.set(1, this.calendar.get(1));
        dateTime.set(2, this.calendar.get(2));
        dateTime.set(5, this.calendar.get(5));
        dateTime.set(11, 23);
        dateTime.set(12, 59);
        dateTime.set(13, 59);
        dateTime.set(14, 999);
        return dateTime.getTime().getTime();
    }

    public void setEnabled(boolean state) {
        this.dateField.setEnabled(state);
    }

    private void buildPanel() {
        this.dateField.setYearRange(2000, Calendar.getInstance().get(1) + 2);
        this.dateField.setOpaque(false);
        this.maxYear = Calendar.getInstance().get(1) + 2;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        this.add((Component)this.dateField, gbc);
        this.add(Box.createHorizontalStrut(3), gbc);
    }

    private void setDate() {
        this.dateField.setTime(this.calendar.getTime());
    }

    private void getSelection() {
        this.calendar.setTime(this.dateField.getTime());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
    }
}

