/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExportFileChooser {
    JFileChooser chooser;
    MyFileFilter reportFileFilter;
    MyFileFilter csvFileFilter;
    MyFileFilter csvHeadFileFilter;
    MyFileFilter htmlFileFilter;
    int reportType = 2;
    boolean includeHeaders = false;
    boolean includeTotals = true;
    boolean CSVonly;
    static final int FORMATTED = 1;
    static final int CSV = 2;
    static final int IMPORTABLE = 3;
    static final int HTML = 4;
    static final String TITLE = MessageLog.getMessageNoID("GUI5069L");
    static final String SAVE = MessageLog.getMessageNoID("GUI5006L");
    static final String EXPORT = MessageLog.getMessageNoID("GUI5069L");
    static final String CSV_FILE = MessageLog.getMessageNoID("GUI5074L");
    static final String REPORT_FILE = MessageLog.getMessageNoID("GUI5076L");
    static final String CSV_FILE_HEADERS = MessageLog.getMessageNoID("GUI5086L");
    static final String HTML_FILE = MessageLog.getMessageNoID("GUI5100L");
    static final String LOWER_CSV_SUFFIX = ".csv";
    static final String LOWER_REPORT_SUFFIX = ".txt";
    static final String LOWER_HTML_SUFFIX = ".html";
    static final String UPPER_CSV_SUFFIX = ".csv".toUpperCase();
    static final String UPPER_REPORT_SUFFIX = ".txt".toUpperCase();
    static final String UPPER_HTML_SUFFIX = ".html".toUpperCase();
    int csvLength = ".csv".length();
    int reportLength = ".txt".length();
    int htmlLength = ".html".length();
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ExportFileChooser(boolean CSVonly) {
        this.CSVonly = CSVonly;
    }

    public int getType() {
        return this.reportType;
    }

    public boolean getHeaders() {
        return this.includeHeaders;
    }

    public boolean getTotals() {
        return this.includeTotals;
    }

    public String getName(String path, String fileName) {
        String result = null;
        this.chooser = new JFileChooser();
        this.chooser.setApproveButtonText(EXPORT);
        this.chooser.setDialogTitle(TITLE);
        this.chooser.setFileSelectionMode(0);
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.reportFileFilter = new MyFileFilter(UPPER_REPORT_SUFFIX, REPORT_FILE);
        this.csvFileFilter = new MyFileFilter(UPPER_CSV_SUFFIX, CSV_FILE);
        this.csvHeadFileFilter = new MyFileFilter(UPPER_CSV_SUFFIX, CSV_FILE_HEADERS);
        this.htmlFileFilter = new MyFileFilter(UPPER_HTML_SUFFIX, HTML_FILE);
        if (!this.CSVonly) {
            this.chooser.addChoosableFileFilter(this.reportFileFilter);
        }
        this.chooser.addChoosableFileFilter(this.csvFileFilter);
        this.chooser.addChoosableFileFilter(this.csvHeadFileFilter);
        if (!this.CSVonly) {
            this.chooser.addChoosableFileFilter(this.htmlFileFilter);
        }
        File file = new File(path + fileName);
        this.chooser.setCurrentDirectory(file);
        this.chooser.setFileFilter(this.csvFileFilter);
        int status = this.chooser.showDialog(this.guiMain.getFrame(), EXPORT);
        if (status == 0) {
            String suf = this.getTypeAndSuffix();
            try {
                File resultFile;
                result = this.chooser.getSelectedFile().getCanonicalPath();
                String resultUC = result.toUpperCase();
                String sufUC = suf.toUpperCase();
                if (!resultUC.endsWith(sufUC)) {
                    result = result + suf;
                }
                if ((resultFile = new File(result)).exists()) {
                    String confirmMsg = MessageLog.getMessageNoID("GUI1622I", new Object[]{result});
                    if (!GuiUtil.getConfirmation(this.guiMain.getFrame(), "TITLE", confirmMsg, false)) {
                        result = null;
                    }
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return result;
    }

    public String getTypeAndSuffix() {
        MyFileFilter filter = (MyFileFilter)this.chooser.getFileFilter();
        String name = this.chooser.getName();
        if (filter == this.reportFileFilter) {
            this.reportType = 1;
        } else if (filter == this.htmlFileFilter) {
            this.reportType = 4;
        } else {
            this.reportType = 2;
            if (filter == this.csvHeadFileFilter) {
                this.includeHeaders = true;
            }
        }
        return filter.suffix;
    }

    private class MyFileFilter
    extends FileFilter {
        String suffix;
        private String description;

        public MyFileFilter(String suffix, String description) {
            this.suffix = suffix;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean accept(File file) {
            String name = file.getName().toUpperCase();
            return file.isDirectory() || name.endsWith(this.suffix);
        }
    }
}

