/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.aperi.TStorm.common.PrintHistoryChart;
import org.eclipse.aperi.TStorm.common.PrintHtmlTable;
import org.eclipse.aperi.TStorm.common.WriteReports;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.ExportFileChooser;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.tables.MegaTable;

public class ExportTableData {
    public static void export(Container thing, String creator, String title) {
        Component[] stuff = thing.getComponents();
        if (stuff != null) {
            for (int i = 0; i < stuff.length; ++i) {
                if (!(stuff[i] instanceof MegaTable)) continue;
                MegaTable table = (MegaTable)stuff[i];
                ExportTableData.exportTable(table, creator, title);
                break;
            }
        }
    }

    public static void exportTable(MegaTable table, String creator, String title) {
        ExportFileChooser chooser = new ExportFileChooser(false);
        PrintWriter writer = ExportTableData.getPrintWriter(chooser, creator, title);
        if (writer != null) {
            BaseTableModel model = (BaseTableModel)table.getDataSource();
            int[] columnArray = null;
            columnArray = model.getAdjuster().fixColumnArray(columnArray);
            int[] rowMap = table.getViewToModelIndices();
            int reportType = chooser.getType();
            if (reportType == 4) {
                new PrintHtmlTable().printHtml(model.getAdjuster(), writer, columnArray, GuiUtil.getUserName(), title, rowMap);
            } else {
                WriteReports reporter = new WriteReports();
                if (reportType == 2) {
                    reporter.writeCSV(model.getAdjuster(), writer, columnArray, chooser.getHeaders(), chooser.getTotals(), rowMap);
                } else {
                    reporter.writeFormatted(model.getAdjuster(), writer, columnArray, rowMap);
                }
            }
            writer.close();
        }
    }

    public static void exportHistory(int subtype, Object[] arrays, String creator, String title, String columnHeader) {
        ExportFileChooser chooser = new ExportFileChooser(true);
        PrintWriter writer = ExportTableData.getPrintWriter(chooser, creator, title);
        if (writer != null) {
            if (!chooser.getHeaders()) {
                columnHeader = null;
            }
            new PrintHistoryChart().print(subtype, arrays, writer, columnHeader);
            writer.close();
        }
    }

    private static PrintWriter getPrintWriter(ExportFileChooser chooser, String creator, String title) {
        PrintWriter whiner = null;
        IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
        String path = guiMain.getUserPrefs().exportPath;
        if (path == null || path.charAt(0) == ' ') {
            path = System.getProperty("user.dir", " ");
        }
        path = path + File.separatorChar;
        if (title == null) {
            title = "report.csv";
        } else {
            title = title + ".csv";
            title = WriteReports.adjustFileName(title);
        }
        String fileName = chooser.getName(path, title);
        if (fileName != null) {
            OutputStreamWriter stream = null;
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                stream = chooser.getType() == 4 || System.getProperty("os.name", " ").regionMatches(true, 0, "win", 0, 3) ? new OutputStreamWriter((OutputStream)fos, "UTF-8") : new OutputStreamWriter(fos);
            }
            catch (IOException e) {
                GuiUtil.displayErrorMessage(e.getMessage());
                stream = null;
            }
            if (stream != null) {
                whiner = new PrintWriter((Writer)stream, true);
            }
        }
        return whiner;
    }
}

