/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.net.Socket;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiGotResponse;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiSendRequest
extends Thread {
    private Request request;
    private GuiClient.RequestNode node;

    public GuiSendRequest(Request pRequest, GuiClient.RequestNode pNode) {
        this.request = pRequest;
        this.node = pNode;
    }

    public void run() {
        int status = 12;
        String errorMessage = null;
        Response response = null;
        if (response == null) {
            try {
                Socket socket = new Socket(GuiClient.server, GuiClient.port);
                SocketTransceiver t = new SocketTransceiver(socket, GuiClient.server, 1800);
                response = t.transmitRequest(this.request, null);
                t.close();
                if (response == null) {
                    status = 12;
                    errorMessage = MessageLog.getMessage("GUI0022M", null);
                } else {
                    status = response.status;
                    errorMessage = response.getErrorMessage();
                    if (response.responseData instanceof NameList[]) {
                        response.responseData = NameList.unpackList((NameList[])response.responseData);
                    }
                }
            }
            catch (Exception e) {
                status = 12;
                errorMessage = MessageLog.getMessage("GUI0023M", null);
            }
        }
        SwingUtilities.invokeLater(new GuiGotResponse((short)status, response, errorMessage, this.node));
    }
}

