/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.eclipse.aperi.gui.About;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.HelpBrokerTS;
import org.eclipse.aperi.xmsg.MessageLog;

public class Help
implements ActionListener {
    private static HelpSet rootHelpSet = null;
    private static HelpBrokerTS helpBroker = null;
    private static final String HELP_ROOT_DIR = "org/eclipse/aperi/gui/help/";
    private static final String helpSetNameData = "data/data_helpset.hs";
    private static final String helpSetNameADM = "admin_services/adm_services_helpset.hs";
    private static final String helpSetNameCommon = "common/common_helpset.hs";
    private static final String helpSetNameDisk = "disk/disk_manager_helpset.hs";
    private static final String helpSetNameFabric = "fabric/fabric_helpset.hs";
    private static final String helpSetNameTape = "tape/tape_helpset.hs";
    private static final String helpSetNameGettingStarted = "getting_started/gettingstarted_helpset.hs";
    public static final String defaultHelp = "welcome_gettingstarted";
    public static final String helpDirText = MessageLog.getMessageNoID("GUI0073L");
    public static final String helpCSText = MessageLog.getMessageNoID("GUI0075L");
    public static final String helpAboutText = MessageLog.getMessageNoID("GUI0074L");
    private JMenuItem helpDir = new JMenuItem();
    private JMenuItem helpCS = new JMenuItem();
    private JMenuItem about = new JMenuItem();

    public Help() {
        this.buildHelpRoot(helpSetNameGettingStarted);
        this.addHelpSet(helpSetNameADM);
        this.addHelpSet(helpSetNameCommon);
        this.addHelpSet(helpSetNameData);
        this.addHelpSet(helpSetNameDisk);
        this.addHelpSet(helpSetNameFabric);
        this.addHelpSet(helpSetNameTape);
    }

    private URL findHelpSet(String helpSetName) {
        URL url = HelpSet.findHelpSet((ClassLoader)Help.class.getClassLoader(), (String)(HELP_ROOT_DIR + helpSetName));
        if (url == null) {
            throw new RuntimeException("Help Set org/eclipse/aperi/gui/help/" + helpSetName + " not found");
        }
        return url;
    }

    private HelpSet newHelpSet(String helpSetName) {
        HelpSet helpSet = null;
        try {
            helpSet = new HelpSet(Help.class.getClassLoader(), this.findHelpSet(helpSetName));
        }
        catch (HelpSetException ee) {
            System.out.println("Help Set " + helpSetName + " could not be loaded.");
            ee.printStackTrace();
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return helpSet;
    }

    private void buildHelpRoot(String helpSetName) {
        rootHelpSet = this.newHelpSet(helpSetName);
        if (rootHelpSet != null) {
            helpBroker = new HelpBrokerTS(rootHelpSet);
            helpBroker.enableHelpKey(GuiMain.pGuiMain.getRootPane(), defaultHelp, null);
        }
    }

    private void addHelpSet(String helpSetName) {
        HelpSet newHS;
        if (rootHelpSet != null && (newHS = this.newHelpSet(helpSetName)) != null) {
            rootHelpSet.add(newHS);
        }
    }

    protected void createMenu(JMenu helpMenu) {
        helpMenu.add(this.helpDir);
        this.helpDir.setText(helpDirText);
        this.helpDir.addActionListener(this);
        GuiUtil.setAccessible(this.helpDir, helpDirText, helpDirText);
        helpMenu.add(this.helpCS);
        this.helpCS.setText(MessageLog.getMessageNoID("GUI0075L"));
        this.helpCS.addActionListener(helpBroker);
        this.helpCS.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        GuiUtil.setAccessible(this.helpCS, helpCSText, helpCSText);
        helpMenu.add(this.about);
        this.about.setText(MessageLog.getMessageNoID("GUI0074L"));
        this.about.addActionListener(this);
        GuiUtil.setAccessible(this.about, helpAboutText, helpAboutText);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.helpDir) {
            helpBroker.setCurrentID(defaultHelp);
            helpBroker.setDisplayed(true);
        } else if (source == this.about) {
            new About();
        }
    }

    public static void setHelpID(Component comp, String helpID) {
        if (helpBroker != null) {
            helpBroker.enableHelp(comp, helpID, rootHelpSet);
        }
    }

    public static ActionListener getDisplayHelpFromSource() {
        ActionListener al = null;
        if (helpBroker != null) {
            al = helpBroker.getDisplayHelpFromSource();
        }
        return al;
    }

    public static boolean isValidID(String helpID) {
        boolean result = false;
        if (rootHelpSet != null) {
            result = rootHelpSet.getCombinedMap().isValidID(helpID, rootHelpSet);
        }
        return result;
    }
}

