/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DateTimeSelector;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TimeSelector;
import org.eclipse.aperi.xmsg.MessageLog;

public class JSgcScheduleCreateWhenData
implements ActionListener {
    protected GridBagConstraints gbcIndent = new GridBagConstraints();
    protected GridBagConstraints gbcIndentLast = new GridBagConstraints();
    protected GridBagConstraints gbcPlop = new GridBagConstraints();
    protected GridBagConstraints gbcLast = new GridBagConstraints();
    protected GridBagConstraints gbcThree = new GridBagConstraints();
    protected Insets insetA = new Insets(0, 18, 0, 0);
    protected Insets insetB = new Insets(0, 55, 0, 0);
    protected Insets insetC = new Insets(0, 36, 0, 0);
    protected Insets insetD = new Insets(3, 36, 0, 0);
    protected Insets insetE = new Insets(0, 18, 5, 0);
    JPanel panel;
    protected JPanel whenPanel;
    JPanel zonePanel;
    protected JLabel filler = new JLabel(" ");
    protected JRadioButton runApplicationDefined;
    protected JRadioButton runNow;
    protected JRadioButton runOnce;
    protected JRadioButton runRepeat;
    protected DateTimeSelector onceDateTime;
    protected DateTimeSelector repeatDateTime;
    protected TimeSelector repeatTime;
    JLabel runAt = new JLabel();
    protected JRadioButton repeatRepeat;
    protected JRadioButton repeatOnDays;
    protected JComboBox repeatNumber;
    protected JComboBox repeatTerm;
    protected JCheckBox repeatSunday;
    protected JCheckBox repeatMonday;
    protected JCheckBox repeatTuesday;
    protected JCheckBox repeatWednesday;
    protected JCheckBox repeatThursday;
    protected JCheckBox repeatFriday;
    protected JCheckBox repeatSaturday;
    protected JRadioButton zoneLocal;
    protected JRadioButton zoneGlobal;
    protected JRadioButton tzServer;
    protected JRadioButton tzZone;
    protected JComboBox zoneName;
    protected boolean repeatOnDaysOnly;
    protected String[] repeatChoices = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"};
    protected String[] repeatTypes = new String[]{MessageLog.getMessageNoID("GUI5034L"), MessageLog.getMessageNoID("GUI5035L"), MessageLog.getMessageNoID("GUI5036L"), MessageLog.getMessageNoID("GUI5037L"), MessageLog.getMessageNoID("GUI5038L")};
    String[] zoneChoices = new String[]{MessageLog.getMessageNoID("GUI5041L"), MessageLog.getMessageNoID("GUI5042L")};
    int currentYear;
    int currentMonth;
    int currentDay;
    int currentHour;
    int currentMinute;
    int currentAmPm;
    public Object[] msgParm = new String[1];
    protected short startYear;
    boolean serverJob;
    protected ScheduleHeader header;
    private CreateOrEditDDI DDI;
    protected boolean noRepeats;
    private short jobType;
    protected static IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public JSgcScheduleCreateWhenData(short jobType, CreateOrEditDDI pDDI) {
        this(jobType, pDDI, false, false, null);
    }

    public JSgcScheduleCreateWhenData(short jobType, CreateOrEditDDI pDDI, boolean repeatOnDaysOnly) {
        this(jobType, pDDI, repeatOnDaysOnly, false, null);
    }

    public JSgcScheduleCreateWhenData(short jobType, CreateOrEditDDI pDDI, boolean repeatOnDaysOnly, boolean noRepeats, JRadioButton runApplicationDefined) {
        String msgID;
        this.DDI = pDDI;
        this.repeatOnDaysOnly = repeatOnDaysOnly;
        this.noRepeats = noRepeats;
        this.runApplicationDefined = runApplicationDefined;
        this.jobType = jobType;
        switch (jobType) {
            case 16: {
                msgID = "GUI5045L";
                break;
            }
            case 17: {
                this.serverJob = true;
                msgID = "GUI5044L";
                break;
            }
            case 36: {
                msgID = "GUI5075L";
                break;
            }
            default: {
                this.serverJob = true;
                msgID = "STG4092L";
            }
        }
        this.msgParm[0] = Util.getString(msgID);
    }

    public JPanel build(ScheduleHeader header) {
        this.header = header;
        this.setDefaults();
        this.gbcIndent.anchor = 17;
        this.gbcIndentLast.anchor = 17;
        this.gbcIndentLast.gridwidth = 0;
        this.gbcPlop.anchor = 17;
        this.gbcLast.anchor = 17;
        this.gbcLast.gridwidth = 0;
        this.gbcThree.anchor = 17;
        this.gbcThree.gridwidth = 3;
        this.gbcThree.insets = this.insetC;
        this.makeWhenPanel();
        this.makeZonePanel();
        this.panel = GuiUtil.getPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.whenPanel, "North");
        if (this.jobType != 104) {
            this.panel.add((Component)this.zonePanel, "Center");
        }
        this.setFields();
        this.enableWhenFields();
        this.addListeners();
        return this.panel;
    }

    private void setDefaults() {
        if (this.header.scheduleType == 0) {
            this.header.scheduleType = 1;
        }
        if (this.serverJob) {
            this.header.timezoneType = (byte)2;
        }
        Calendar calendar = Calendar.getInstance();
        this.startYear = (short)calendar.get(1);
        if (this.startYear < 2000) {
            this.startYear = (short)2000;
        }
        if (this.header.startYear < 2000) {
            this.header.startYear = this.startYear;
            this.header.startMonth = (short)(calendar.get(2) + 1);
            this.header.startDay = (short)calendar.get(5);
            this.header.startHour = (short)calendar.get(11);
            this.header.startMinute = (short)calendar.get(12);
        }
        if (this.header.startYear < this.startYear) {
            this.startYear = this.header.startYear;
        }
    }

    protected void makeWhenPanel() {
        this.whenPanel = new JPanel();
        this.whenPanel.setBorder(GuiUtil.getBorder(MessageLog.getMessageNoID("GUI5046L")));
        this.whenPanel.setLayout(new BorderLayout());
        JPanel subPanel1 = this.getPanel1();
        if (!this.repeatOnDaysOnly) {
            this.whenPanel.add((Component)subPanel1, "North");
        }
        this.whenPanel.add((Component)this.getPanel2(), "Center");
        this.whenPanel.add((Component)this.getPanel3(), "South");
    }

    protected JPanel getPanel1() {
        JPanel panel1 = GuiUtil.getPanel();
        this.runNow = new JRadioButton(MessageLog.getMessageNoID("GUI8219L"));
        this.runOnce = new JRadioButton(MessageLog.getMessageNoID("GUI8220L"));
        this.runRepeat = new JRadioButton(MessageLog.getMessageNoID("GUI8221L"));
        GuiUtil.setAccessible(this.runNow, MessageLog.getMessageNoID("GUI5018L"), MessageLog.getMessageNoID("GUI5018L"));
        GuiUtil.setAccessible(this.runOnce, MessageLog.getMessageNoID("GUI5019L"), MessageLog.getMessageNoID("GUI5019L"));
        GuiUtil.setAccessible(this.runRepeat, MessageLog.getMessageNoID("GUI5020L"), MessageLog.getMessageNoID("GUI5020L"));
        ButtonGroup runGroup = new ButtonGroup();
        runGroup.add(this.runNow);
        runGroup.add(this.runOnce);
        if (!this.noRepeats) {
            runGroup.add(this.runRepeat);
        }
        if (this.runApplicationDefined != null) {
            runGroup.add(this.runApplicationDefined);
            panel1.add((Component)this.runApplicationDefined, this.gbcLast);
        }
        panel1.add((Component)this.runNow, this.gbcLast);
        panel1.add((Component)this.runOnce, this.gbcLast);
        this.gbcIndent.insets = this.insetA;
        this.onceDateTime = new DateTimeSelector(this.header.startYear, this.header.startMonth, this.header.startDay, this.header.startHour, this.header.startMinute);
        panel1.add((Component)this.onceDateTime, this.gbcIndent);
        GuiUtil.setAccessible(this.onceDateTime, Util.getString("LABEL_DATE_TIME_SELECTOR"), Util.getString("LABEL_DATE_TIME_SELECTOR"));
        GuiUtil.completePanel(panel1);
        return panel1;
    }

    protected JPanel getPanel2() {
        JPanel panel2 = GuiUtil.getPanel();
        this.repeatDateTime = new DateTimeSelector(this.header.startYear, this.header.startMonth, this.header.startDay, this.header.startHour, this.header.startMinute);
        GuiUtil.setAccessible(this.repeatDateTime, Util.getString("LABEL_DATE_TIME_SELECTOR"), Util.getString("LABEL_DATE_TIME_SELECTOR"));
        this.repeatRepeat = new JRadioButton(MessageLog.getMessageNoID("GUI5048L"));
        this.repeatOnDays = new JRadioButton(MessageLog.getMessageNoID("GUI5049L"));
        GuiUtil.setAccessible(this.repeatRepeat, MessageLog.getMessageNoID("GUI5048L"), MessageLog.getMessageNoID("GUI5048L"));
        GuiUtil.setAccessible(this.repeatOnDays, MessageLog.getMessageNoID("GUI5049L"), MessageLog.getMessageNoID("GUI5049L"));
        ButtonGroup repeatGroup = new ButtonGroup();
        repeatGroup.add(this.repeatRepeat);
        repeatGroup.add(this.repeatOnDays);
        this.repeatNumber = new TComboBox(this.repeatChoices);
        this.repeatTerm = new TComboBox(this.repeatTypes);
        GuiUtil.setAccessible(this.repeatNumber, MessageLog.getMessageNoID("GUI5048L"), MessageLog.getMessageNoID("GUI5048L"));
        GuiUtil.setAccessible(this.repeatTerm, MessageLog.getMessageNoID("GUI5048L"), MessageLog.getMessageNoID("GUI5048L"));
        if (this.repeatOnDaysOnly) {
            this.runAt.setText(MessageLog.getMessageNoID("GUI0258L"));
            this.gbcIndentLast.insets = this.insetE;
            panel2.add((Component)this.runAt, this.gbcIndentLast);
            this.repeatTime = new TimeSelector();
            GuiUtil.setAccessible(this.repeatTime, Util.getString("LABEL_DATE_TIME_SELECTOR"), Util.getString("LABEL_DATE_TIME_SELECTOR"));
            this.gbcIndentLast.insets = this.insetA;
            if (!this.noRepeats) {
                panel2.add((Component)this.repeatTime, this.gbcIndentLast);
            }
        } else if (!this.noRepeats) {
            panel2.add((Component)this.runRepeat, this.gbcLast);
            this.runAt.setText(MessageLog.getMessageNoID("GUI5047L"));
            this.gbcIndentLast.insets = this.insetE;
            panel2.add((Component)this.runAt, this.gbcIndentLast);
            this.gbcIndentLast.insets = this.insetA;
            panel2.add((Component)this.repeatDateTime, this.gbcIndentLast);
            panel2.add((Component)this.filler, this.gbcLast);
            panel2.add((Component)this.repeatRepeat, this.gbcThree);
            panel2.add((Component)this.repeatNumber, this.gbcPlop);
            panel2.add((Component)this.repeatTerm, this.gbcLast);
        }
        GuiUtil.completePanel(panel2);
        return panel2;
    }

    protected JPanel getPanel3() {
        JPanel panel3 = GuiUtil.getPanel();
        this.gbcIndentLast.insets = this.insetC;
        if (!this.noRepeats) {
            if (this.repeatOnDaysOnly) {
                JLabel onTheseDays = new JLabel(MessageLog.getMessageNoID("GUI0259L"));
                panel3.add((Component)onTheseDays, this.gbcIndentLast);
            } else {
                panel3.add((Component)this.repeatOnDays, this.gbcIndentLast);
            }
        }
        this.repeatSunday = new JCheckBox(MessageLog.getMessageNoID("GUI5050L"));
        this.repeatMonday = new JCheckBox(MessageLog.getMessageNoID("GUI5051L"));
        this.repeatTuesday = new JCheckBox(MessageLog.getMessageNoID("GUI5052L"));
        this.repeatWednesday = new JCheckBox(MessageLog.getMessageNoID("GUI5053L"));
        this.repeatThursday = new JCheckBox(MessageLog.getMessageNoID("GUI5054L"));
        this.repeatFriday = new JCheckBox(MessageLog.getMessageNoID("GUI5055L"));
        this.repeatSaturday = new JCheckBox(MessageLog.getMessageNoID("GUI5056L"));
        GuiUtil.setAccessible(this.repeatSunday, MessageLog.getMessageNoID("GUI5050L"), MessageLog.getMessageNoID("GUI5050L"));
        GuiUtil.setAccessible(this.repeatMonday, MessageLog.getMessageNoID("GUI5051L"), MessageLog.getMessageNoID("GUI5051L"));
        GuiUtil.setAccessible(this.repeatTuesday, MessageLog.getMessageNoID("GUI5052L"), MessageLog.getMessageNoID("GUI5052L"));
        GuiUtil.setAccessible(this.repeatWednesday, MessageLog.getMessageNoID("GUI5053L"), MessageLog.getMessageNoID("GUI5053L"));
        GuiUtil.setAccessible(this.repeatThursday, MessageLog.getMessageNoID("GUI5054L"), MessageLog.getMessageNoID("GUI5054L"));
        GuiUtil.setAccessible(this.repeatFriday, MessageLog.getMessageNoID("GUI5055L"), MessageLog.getMessageNoID("GUI5055L"));
        GuiUtil.setAccessible(this.repeatSaturday, MessageLog.getMessageNoID("GUI5056L"), MessageLog.getMessageNoID("GUI5056L"));
        this.gbcIndent.insets = this.insetB;
        if (!this.noRepeats) {
            boolean sundayIsFirstDay;
            Calendar cal = Calendar.getInstance();
            boolean bl = sundayIsFirstDay = cal.getFirstDayOfWeek() == 1;
            if (Locale.getDefault().getLanguage().equals(new Locale("hu").getLanguage())) {
                sundayIsFirstDay = false;
            }
            if (sundayIsFirstDay) {
                panel3.add((Component)this.repeatSunday, this.gbcIndent);
                panel3.add((Component)this.repeatMonday, this.gbcPlop);
            } else {
                panel3.add((Component)this.repeatMonday, this.gbcIndent);
            }
            panel3.add((Component)this.repeatTuesday, this.gbcPlop);
            panel3.add((Component)this.repeatWednesday, this.gbcPlop);
            panel3.add((Component)this.repeatThursday, this.gbcPlop);
            panel3.add((Component)this.repeatFriday, this.gbcPlop);
            if (!sundayIsFirstDay) {
                panel3.add((Component)this.repeatSaturday, this.gbcPlop);
                panel3.add((Component)this.repeatSunday, this.gbcLast);
            } else {
                panel3.add((Component)this.repeatSaturday, this.gbcLast);
            }
        }
        GuiUtil.completePanel(panel3);
        return panel3;
    }

    private void makeZonePanel() {
        JLabel globalZone;
        this.zonePanel = GuiUtil.getTitledBorderedPanel(MessageLog.getMessageNoID("GUI5057L"));
        String str = (String)this.msgParm[0];
        JLabel runAt = new JLabel(str);
        this.zoneLocal = new JRadioButton(MessageLog.getMessageNoID("GUI5058L"));
        this.zoneGlobal = new JRadioButton(MessageLog.getMessageNoID("GUI5059L"));
        GuiUtil.setAccessible(this.zoneLocal, MessageLog.getMessageNoID("GUI5058L"), MessageLog.getMessageNoID("GUI5058L"));
        GuiUtil.setAccessible(this.zoneGlobal, MessageLog.getMessageNoID("GUI5059L"), MessageLog.getMessageNoID("GUI5059L"));
        ButtonGroup zoneGroup = new ButtonGroup();
        zoneGroup.add(this.zoneLocal);
        zoneGroup.add(this.zoneGlobal);
        if (!this.serverJob) {
            this.zonePanel.add((Component)runAt, this.gbcLast);
            this.gbcIndentLast.insets = this.insetA;
            this.zonePanel.add((Component)this.zoneLocal, this.gbcIndentLast);
            this.zonePanel.add((Component)this.zoneGlobal, this.gbcIndentLast);
            globalZone = new JLabel(MessageLog.getMessageNoID("GUI5060L"));
        } else {
            globalZone = new JLabel(MessageLog.getMessageNoID("GUI5064L"));
        }
        this.gbcLast.insets = this.insetD;
        this.zonePanel.add((Component)globalZone, this.gbcLast);
        this.tzServer = new JRadioButton(MessageLog.getMessageNoID("GUI5061L"));
        this.tzZone = new JRadioButton(MessageLog.getMessageNoID("GUI5062L"));
        GuiUtil.setAccessible(this.tzServer, MessageLog.getMessageNoID("GUI5061L"), MessageLog.getMessageNoID("GUI5061L"));
        GuiUtil.setAccessible(this.tzZone, MessageLog.getMessageNoID("GUI5062L"), MessageLog.getMessageNoID("GUI5062L"));
        ButtonGroup tzGroup = new ButtonGroup();
        tzGroup.add(this.tzServer);
        tzGroup.add(this.tzZone);
        this.gbcIndentLast.insets = this.insetB;
        this.zonePanel.add((Component)this.tzServer, this.gbcIndentLast);
        this.gbcIndent.insets = this.insetB;
        this.zonePanel.add((Component)this.tzZone, this.gbcIndent);
        String[] allZones = TimeZone.getAvailableIDs();
        ArrayList<String> allZonesList = new ArrayList<String>(allZones.length);
        for (int i = 0; i < allZones.length; ++i) {
            if (allZonesList.contains(TimeZone.getTimeZone(allZones[i]).getDisplayName(false, 0))) continue;
            allZonesList.add(TimeZone.getTimeZone(allZones[i]).getDisplayName(false, 0));
        }
        this.zoneName = new TComboBox(allZonesList.toArray());
        GuiUtil.setAccessible(this.zoneName, Util.getString("LABEL_TIME_ZONE"), Util.getString("LABEL_TIME_ZONE"));
        this.zonePanel.add((Component)this.zoneName, this.gbcLast);
        GuiUtil.completePanel(this.zonePanel);
    }

    public void setFields() {
        if (this.header.scheduleType == 3) {
            this.runRepeat.setSelected(true);
        } else if (this.header.scheduleType == 2) {
            this.runOnce.setSelected(true);
        } else if (this.header.scheduleType == 4 && this.runApplicationDefined != null) {
            this.runApplicationDefined.setSelected(true);
        } else {
            this.runNow.setSelected(true);
        }
        if (this.header.repeatType == 2) {
            this.repeatOnDays.setSelected(true);
        } else {
            this.repeatRepeat.setSelected(true);
        }
        if (this.header.intervalNumber < 1) {
            this.header.intervalNumber = 1;
        }
        this.repeatNumber.setSelectedIndex(this.header.intervalNumber - 1);
        if (this.header.intervalType == 5) {
            this.repeatTerm.setSelectedIndex(4);
        } else if (this.header.intervalType == 4) {
            this.repeatTerm.setSelectedIndex(3);
        } else if (this.header.intervalType == 3) {
            this.repeatTerm.setSelectedIndex(2);
        } else if (this.header.intervalType == 2) {
            this.repeatTerm.setSelectedIndex(1);
        } else {
            this.repeatTerm.setSelectedIndex(0);
        }
        if (this.header.runSunday == 2) {
            this.repeatSunday.setSelected(true);
        }
        if (this.header.runMonday == 2) {
            this.repeatMonday.setSelected(true);
        }
        if (this.header.runTuesday == 2) {
            this.repeatTuesday.setSelected(true);
        }
        if (this.header.runWednesday == 2) {
            this.repeatWednesday.setSelected(true);
        }
        if (this.header.runThursday == 2) {
            this.repeatThursday.setSelected(true);
        }
        if (this.header.runFriday == 2) {
            this.repeatFriday.setSelected(true);
        }
        if (this.header.runSaturday == 2) {
            this.repeatSaturday.setSelected(true);
        }
        if (this.header.timezoneType == 2) {
            this.zoneGlobal.setSelected(true);
            this.tzServer.setEnabled(true);
            this.tzZone.setEnabled(true);
            if (this.header.globalType == 2) {
                this.zoneName.setEnabled(true);
            } else {
                this.zoneName.setEnabled(false);
            }
        } else {
            this.zoneLocal.setSelected(true);
            this.tzServer.setEnabled(false);
            this.tzZone.setEnabled(false);
            this.zoneName.setEnabled(false);
        }
        boolean zone = false;
        if (this.header.globalType == 2) {
            this.tzZone.setSelected(true);
            try {
                this.zoneName.setSelectedItem(this.header.timezone);
            }
            catch (Exception e) {
                System.err.println("Failed to set timezone to saved value");
                this.zoneName.setSelectedItem("GMT");
            }
        } else {
            this.tzServer.setSelected(true);
            try {
                this.zoneName.setSelectedItem(TimeZone.getDefault().getDisplayName(false, 0));
            }
            catch (Exception e) {
                System.err.println("Failed to set timezone to local JVM default");
                this.zoneName.setSelectedItem("GMT");
            }
        }
    }

    private void addListeners() {
        if (this.runApplicationDefined != null) {
            this.runApplicationDefined.addActionListener(this);
        }
        this.runNow.addActionListener(this);
        this.runOnce.addActionListener(this);
        this.runRepeat.addActionListener(this);
        this.repeatRepeat.addActionListener(this);
        this.repeatOnDays.addActionListener(this);
        this.zoneLocal.addActionListener(this);
        this.zoneGlobal.addActionListener(this);
        this.tzServer.addActionListener(this);
        this.tzZone.addActionListener(this);
    }

    public ScheduleHeader getData() {
        short savedYear = this.header.startYear;
        short savedMonth = this.header.startMonth;
        short savedDay = this.header.startDay;
        this.header.clear();
        if (this.runNow.isSelected()) {
            this.header.scheduleType = 1;
        } else if (this.runApplicationDefined != null && this.runApplicationDefined.isSelected()) {
            this.header.scheduleType = (byte)4;
        } else {
            short[] dateTime;
            if (this.runOnce.isSelected()) {
                this.header.scheduleType = (byte)2;
                dateTime = this.onceDateTime.getDateTime();
            } else {
                this.header.scheduleType = (byte)3;
                if (this.repeatRepeat.isSelected()) {
                    this.header.repeatType = 1;
                    this.header.intervalNumber = (short)(this.repeatNumber.getSelectedIndex() + 1);
                    int num = this.repeatTerm.getSelectedIndex();
                    switch (num) {
                        case 4: {
                            this.header.intervalType = (byte)5;
                            break;
                        }
                        case 3: {
                            this.header.intervalType = (byte)4;
                            break;
                        }
                        case 2: {
                            this.header.intervalType = (byte)3;
                            break;
                        }
                        case 1: {
                            this.header.intervalType = (byte)2;
                            break;
                        }
                        default: {
                            this.header.intervalType = 1;
                            break;
                        }
                    }
                } else {
                    this.header.repeatType = (byte)2;
                    this.header.intervalType = (byte)3;
                    if (this.repeatSunday.isSelected()) {
                        this.header.runSunday = (byte)2;
                    }
                    if (this.repeatMonday.isSelected()) {
                        this.header.runMonday = (byte)2;
                    }
                    if (this.repeatTuesday.isSelected()) {
                        this.header.runTuesday = (byte)2;
                    }
                    if (this.repeatWednesday.isSelected()) {
                        this.header.runWednesday = (byte)2;
                    }
                    if (this.repeatThursday.isSelected()) {
                        this.header.runThursday = (byte)2;
                    }
                    if (this.repeatFriday.isSelected()) {
                        this.header.runFriday = (byte)2;
                    }
                    if (this.repeatSaturday.isSelected()) {
                        this.header.runSaturday = (byte)2;
                    }
                }
                dateTime = this.repeatOnDaysOnly ? this.repeatTime.getTime() : this.repeatDateTime.getDateTime();
            }
            if (this.repeatOnDaysOnly) {
                this.header.startYear = savedYear;
                this.header.startMonth = savedMonth;
                this.header.startDay = savedDay;
                this.header.startHour = dateTime[0];
                this.header.startMinute = dateTime[1];
            } else {
                this.header.startYear = dateTime[0];
                this.header.startMonth = (short)(dateTime[1] + 1);
                this.header.startDay = dateTime[2];
                this.header.startHour = dateTime[3];
                this.header.startMinute = dateTime[4];
            }
        }
        if (this.zoneLocal.isSelected()) {
            this.header.timezoneType = 1;
        } else {
            this.header.timezoneType = (byte)2;
            if (this.tzServer.isSelected()) {
                this.header.globalType = 1;
            } else {
                this.header.globalType = (byte)2;
                this.header.timezone = this.zoneName.getSelectedItem().toString();
            }
        }
        return this.header;
    }

    public void validate(ScheduleHeader header) throws GeneralException {
        if (header.repeatType == 2 && header.runSunday != 2 && header.runMonday != 2 && header.runTuesday != 2 && header.runWednesday != 2 && header.runThursday != 2 && header.runFriday != 2 && header.runSaturday != 2) {
            throw new GeneralException(MessageLog.getMessageNoTS("GUI0262E"));
        }
    }

    public static void displayJobSubmittedMessage(Object[] msgParms) {
        String msg = null;
        msg = MessageLog.getMessageNoID("GUI2017M", msgParms);
        String title = MessageLog.getMessageNoID("GUI0228L");
        JOptionPane.showMessageDialog(guiMain.getFrame(), msg, title, 1);
    }

    public void replace(ScheduleHeader header) {
        this.header = header;
        if (header.scheduleType == 1 && header.enabled && this.DDI.responseStatus <= 4) {
            JSgcScheduleCreateWhenData.displayJobSubmittedMessage(this.DDI.msgParm);
        }
    }

    private void enableWhenFields() {
        if (this.runNow.isSelected() || this.runApplicationDefined != null && this.runApplicationDefined.isSelected()) {
            this.onceDateTime.setEnabled(false);
            this.runAt.setEnabled(false);
            this.repeatDateTime.setEnabled(false);
            this.repeatNumber.setEnabled(false);
            this.repeatTerm.setEnabled(false);
            this.repeatRepeat.setEnabled(false);
            this.repeatOnDays.setEnabled(false);
            this.repeatSunday.setEnabled(false);
            this.repeatMonday.setEnabled(false);
            this.repeatTuesday.setEnabled(false);
            this.repeatWednesday.setEnabled(false);
            this.repeatThursday.setEnabled(false);
            this.repeatFriday.setEnabled(false);
            this.repeatSaturday.setEnabled(false);
        } else if (this.runOnce.isSelected()) {
            this.onceDateTime.setEnabled(true);
            this.runAt.setEnabled(false);
            this.repeatDateTime.setEnabled(false);
            this.repeatNumber.setEnabled(false);
            this.repeatTerm.setEnabled(false);
            this.repeatRepeat.setEnabled(false);
            this.repeatOnDays.setEnabled(false);
            this.repeatSunday.setEnabled(false);
            this.repeatMonday.setEnabled(false);
            this.repeatTuesday.setEnabled(false);
            this.repeatWednesday.setEnabled(false);
            this.repeatThursday.setEnabled(false);
            this.repeatFriday.setEnabled(false);
            this.repeatSaturday.setEnabled(false);
        } else {
            this.onceDateTime.setEnabled(false);
            this.runAt.setEnabled(true);
            this.repeatDateTime.setEnabled(true);
            this.repeatRepeat.setEnabled(true);
            this.repeatOnDays.setEnabled(true);
            if (this.repeatRepeat.isSelected()) {
                this.repeatNumber.setEnabled(true);
                this.repeatTerm.setEnabled(true);
                this.repeatSunday.setEnabled(false);
                this.repeatMonday.setEnabled(false);
                this.repeatTuesday.setEnabled(false);
                this.repeatWednesday.setEnabled(false);
                this.repeatThursday.setEnabled(false);
                this.repeatFriday.setEnabled(false);
                this.repeatSaturday.setEnabled(false);
            } else {
                this.repeatNumber.setEnabled(false);
                this.repeatTerm.setEnabled(false);
                this.repeatSunday.setEnabled(true);
                this.repeatMonday.setEnabled(true);
                this.repeatTuesday.setEnabled(true);
                this.repeatWednesday.setEnabled(true);
                this.repeatThursday.setEnabled(true);
                this.repeatFriday.setEnabled(true);
                this.repeatSaturday.setEnabled(true);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.runNow) {
            this.enableWhenFields();
        } else if (source == this.runApplicationDefined) {
            this.enableWhenFields();
        } else if (source == this.runOnce) {
            this.enableWhenFields();
        } else if (source == this.runRepeat) {
            this.enableWhenFields();
        } else if (source == this.repeatRepeat) {
            this.enableWhenFields();
        } else if (source == this.repeatOnDays) {
            this.enableWhenFields();
        } else if (source == this.zoneLocal) {
            this.tzServer.setEnabled(false);
            this.tzZone.setEnabled(false);
            this.zoneName.setEnabled(false);
        } else if (source == this.zoneGlobal) {
            this.tzServer.setEnabled(true);
            this.tzZone.setEnabled(true);
            if (this.tzServer.isSelected()) {
                this.zoneName.setEnabled(false);
            } else {
                this.zoneName.setEnabled(true);
            }
        } else if (source == this.tzServer) {
            this.zoneName.setEnabled(false);
        } else if (source == this.tzZone) {
            this.zoneName.setEnabled(true);
        }
    }
}

