/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrintFileChooser {
    private JFileChooser chooser;
    private JPanel subPanel;
    private JTextField nameField;
    private MyFileFilter fileFilter;
    private String suffix;
    private String description;
    static final String TITLE = MessageLog.getMessageNoID("GUI5007L");
    static final String SAVE = MessageLog.getMessageNoID("GUI5006L");
    static final String PDF_DESCRIPTION = MessageLog.getMessageNoID("GUI5096L");
    static final String HTML_DESCRIPTION = MessageLog.getMessageNoID("GUI5087L");
    static final String PS_DESCRIPTION = MessageLog.getMessageNoID("GUI5088L");
    static final String PCL_DESCRIPTION = MessageLog.getMessageNoID("GUI5093L");
    static final String CSV_DESCRIPTION = MessageLog.getMessageNoID("GUI5086L");
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public String getName(String path, String fileName) {
        String result = null;
        if (fileName.endsWith(".pdf")) {
            this.suffix = ".PDF";
            this.description = PDF_DESCRIPTION;
        } else if (fileName.endsWith(".html")) {
            this.suffix = ".HTML";
            this.description = HTML_DESCRIPTION;
        } else if (fileName.endsWith(".ps")) {
            this.suffix = ".PS";
            this.description = PS_DESCRIPTION;
        } else if (fileName.endsWith(".csv")) {
            this.suffix = ".CSV";
            this.description = CSV_DESCRIPTION;
        } else {
            this.suffix = ".PCL";
            this.description = PCL_DESCRIPTION;
        }
        this.chooser = new JFileChooser();
        this.chooser.setDialogTitle(TITLE);
        this.chooser.setFileSelectionMode(0);
        StringTokenizer cleanFileName = new StringTokenizer(fileName, Util.getString("COLON"));
        StringBuffer newFileName = new StringBuffer();
        while (cleanFileName.hasMoreTokens()) {
            newFileName.append(cleanFileName.nextToken());
        }
        fileName = newFileName.toString();
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.fileFilter = new MyFileFilter(this.suffix, this.description);
        this.chooser.addChoosableFileFilter(this.fileFilter);
        File file = new File(path + fileName);
        this.chooser.setCurrentDirectory(file);
        this.chooser.setSelectedFile(file);
        int status = this.chooser.showDialog(this.guiMain.getFrame(), SAVE);
        if (status == 0) {
            try {
                File resultFile;
                result = this.chooser.getSelectedFile().getCanonicalPath();
                String resultUC = result.toUpperCase();
                String suffixUC = this.suffix.toUpperCase();
                if (!resultUC.endsWith(suffixUC)) {
                    result = result + this.suffix;
                }
                if ((resultFile = new File(result)).exists()) {
                    String confirmMsg = MessageLog.getMessageNoID("GUI1622I", new Object[]{result});
                    if (!GuiUtil.getConfirmation(this.guiMain.getFrame(), "TITLE", confirmMsg, false)) {
                        result = null;
                    }
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return result;
    }

    private class MyFileFilter
    extends FileFilter {
        private String suffix;
        private String description;

        public MyFileFilter(String suffix, String description) {
            this.suffix = suffix;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean accept(File file) {
            String name = file.getName().toUpperCase();
            return file.isDirectory() || name.endsWith(this.suffix);
        }
    }
}

