/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SizeLimitedDocument
extends PlainDocument {
    private int maxLength;
    private boolean isNumber;

    public SizeLimitedDocument(int maxLength, boolean isNumber) {
        this.isNumber = isNumber;
        this.maxLength = maxLength;
    }

    public void setMaxSize(int maxLength) {
        this.maxLength = maxLength;
        int length = this.getLength();
        if (length > maxLength) {
            try {
                this.remove(0, length);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        if (s != null && s.length() > 0) {
            if (offset == 0 && s.charAt(0) == ' ') {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (s.length() + this.getLength() > this.maxLength) {
                Toolkit.getDefaultToolkit().beep();
                if (this.maxLength - this.getLength() < s.length()) {
                    s = s.substring(0, this.maxLength - this.getLength());
                } else {
                    return;
                }
            }
            if (this.isNumber) {
                for (int i = s.length() - 1; i >= 0; --i) {
                    if (Character.isDigit(s.charAt(i))) continue;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
        }
        super.insertString(offset, s, attributeSet);
    }
}

