/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiUtil;

public class SpinBox
extends GridBagPanel {
    private int startValue;
    private int minimumValue;
    private int maximumValue;
    private int incrementerValue;
    private FormattedTextField textField;
    private JButton up = new JButton();
    private JButton down = new JButton();
    private JPanel buttonPanel = new JPanel();
    private boolean minuteFormat = false;
    private ArrayList listeners = new ArrayList();

    public SpinBox() {
        this(0, 0, 100, 1);
    }

    public SpinBox(int minimumValue, int maximumValue) {
        this(minimumValue, minimumValue, maximumValue, 1);
    }

    public SpinBox(int startValue, int minimumValue, int maximumValue) {
        this(startValue, minimumValue, maximumValue, 1);
    }

    public SpinBox(int startValue, int minimumValue, int maximumValue, int incrementerValue) {
        super(new Insets(0, 0, 0, 0));
        if (minimumValue < 0 || maximumValue < minimumValue || startValue < minimumValue || startValue > maximumValue || incrementerValue > maximumValue) {
            throw new IllegalArgumentException("Invalid initial parameters for SpinBox");
        }
        this.startValue = startValue;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.incrementerValue = incrementerValue;
        this.setDefaultAnchor(21);
        this.setup();
    }

    private void setup() {
        this.textField = new FormattedTextField();
        this.setBorder(this.textField.getBorder());
        this.textField.setBorder(null);
        this.up.setBorder(null);
        this.down.setBorder(null);
        this.up.setIcon(GuiUtil.createImageIcon("SpinBoxButtonUp.gif"));
        this.down.setIcon(GuiUtil.createImageIcon("SpinBoxButtonDown.gif"));
        this.up.setPreferredSize(new Dimension(9, this.textField.getPreferredSize().height / 2));
        this.down.setPreferredSize(new Dimension(9, this.textField.getPreferredSize().height / 2));
        this.up.setFocusPainted(false);
        this.down.setFocusPainted(false);
        this.up.setBackground(this.textField.getBackground());
        this.down.setBackground(this.textField.getBackground());
        this.up.addMouseListener(new MouseListener(){
            Timer timer = new Timer(50, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (SpinBox.this.isEnabled()) {
                        SpinBox.this.increment();
                    }
                }
            });

            public void mousePressed(MouseEvent e) {
                this.timer.setInitialDelay(500);
                this.timer.start();
            }

            public void mouseReleased(MouseEvent e) {
                this.timer.stop();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                if (SpinBox.this.isEnabled()) {
                    SpinBox.this.increment();
                }
            }
        });
        this.down.addMouseListener(new MouseListener(){
            Timer timer2 = new Timer(50, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (SpinBox.this.isEnabled()) {
                        SpinBox.this.decrement();
                    }
                }
            });

            public void mousePressed(MouseEvent e) {
                this.timer2.setInitialDelay(500);
                this.timer2.start();
            }

            public void mouseReleased(MouseEvent e) {
                this.timer2.stop();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                if (SpinBox.this.isEnabled()) {
                    SpinBox.this.decrement();
                }
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    SpinBox.this.increment();
                } else if (e.getKeyCode() == 40) {
                    SpinBox.this.decrement();
                }
            }
        });
        this.textField.addFocusListener(new FocusListener(){
            boolean time = true;

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!SpinBox.this.isValid(SpinBox.this.textField.getText())) {
                    SpinBox.this.setToStartValue();
                }
            }
        });
        this.add(this.textField);
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.up, "North");
        this.buttonPanel.add((Component)this.down, "South");
        this.add((JComponent)this.buttonPanel, 0);
        this.setBackground(this.textField.getBackground());
        this.textField.setText(Integer.toString(this.maximumValue));
        JComboBox sizeBox = new JComboBox();
        this.textField.setPreferredSize(new Dimension(this.textField.getPreferredSize().width, sizeBox.getPreferredSize().height - 4));
        this.textField.setMinimumSize(this.textField.getPreferredSize());
        this.textField.setText(Integer.toString(this.startValue));
    }

    protected void fireActionEvent() {
        ActionEvent actionevent = new ActionEvent(this, 1001, "SpinBoxAction");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.get(i)).actionPerformed(actionevent);
        }
    }

    public void addActionListener(ActionListener actionlistener) {
        this.listeners.add(actionlistener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void setLeadingZero(boolean b) {
        this.minuteFormat = b;
        this.textField.setText(this.textField.getText());
    }

    public void setToStartValue() {
        this.textField.setText(new Integer(this.startValue).toString());
    }

    public void setColumns(int c) {
        this.textField.setColumns(c);
    }

    private void increment() {
        String str = this.textField.getText();
        int temp = Integer.parseInt(str) + this.incrementerValue;
        if (this.isValid(temp)) {
            this.textField.setText(new Integer(temp).toString());
        }
        this.fireActionEvent();
    }

    private void decrement() {
        String str = this.textField.getText();
        int temp = Integer.parseInt(str) - this.incrementerValue;
        if (this.isValid(temp)) {
            this.textField.setText(Integer.toString(temp));
        }
        this.fireActionEvent();
    }

    public boolean isValid(int value) {
        try {
            return value >= this.minimumValue && value <= this.maximumValue;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValid(String value) {
        try {
            return this.isValid(Integer.parseInt(value));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValid() {
        try {
            return this.isValid(this.textField.getText());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setMin(int value) {
        this.minimumValue = value;
    }

    public void setMax(int value) {
        this.maximumValue = value;
    }

    public int getMin() {
        return this.minimumValue;
    }

    public int getMax() {
        return this.maximumValue;
    }

    public int getIncrementer() {
        return this.incrementerValue;
    }

    public void setIncrementer(int value) {
        this.incrementerValue = value;
    }

    public int getValue() {
        String str = this.textField.getText();
        return Integer.parseInt(str);
    }

    public String getText() {
        String str = this.textField.getText();
        return str;
    }

    public void setValue(int value) {
        this.textField.setText(Integer.toString(value));
    }

    public void setEnabled(boolean enabled) {
        this.up.setEnabled(enabled);
        this.down.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        super.setEnabled(enabled);
        this.up.setBackground(this.textField.getBackground());
        this.down.setBackground(this.textField.getBackground());
    }

    public class FormattedTextField
    extends JTextField {
        protected Document createDefaultModel() {
            return new RangeValidatorDocument();
        }

        public void setText(String s) {
            if (SpinBox.this.minuteFormat) {
                int temp = Integer.parseInt(s);
                if (temp >= 0 && temp <= 9) {
                    super.setText("0" + s);
                } else {
                    super.setText(s);
                }
            } else {
                super.setText(s);
            }
        }

        class RangeValidatorDocument
        extends PlainDocument {
            private boolean first = true;
            private Timer checker;
            private Thread checkThread;

            RangeValidatorDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (this.first) {
                    this.first = false;
                    super.insertString(offs, str, a);
                    return;
                }
                if (str == null) {
                    return;
                }
                try {
                    Integer.parseInt(str);
                }
                catch (Exception e) {
                    this.handleProblem();
                    return;
                }
                if (this.getLength() + str.length() > new Integer(SpinBox.this.maximumValue).toString().length()) {
                    this.handleProblem();
                    return;
                }
                if (Integer.parseInt(SpinBox.this.textField.getText(0, this.getLength()) + str) > SpinBox.this.maximumValue) {
                    this.handleProblem();
                    return;
                }
                super.insertString(offs, str, a);
            }

            private void handleProblem() {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

