/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.TabCloseListener;
import org.eclipse.aperi.xmsg.MessageLog;

public class TCloseTabPane
extends JTabbedPane
implements TabCloseListener {
    public Vector keepOpenList;
    public Vector tabListenerList;
    private Mouser mouser;
    private TCloseTabPane tabPanel;
    private int mouseIndex = 0;

    public TCloseTabPane() {
        this.setupTabs();
    }

    public TCloseTabPane(int placement) {
        super(placement);
        this.setupTabs();
    }

    public TCloseTabPane(int placement, int layoutPolicy) {
        super(placement, layoutPolicy);
        this.setupTabs();
    }

    private void setupTabs() {
        this.setFont(BaseTree.boldFont);
        this.keepOpenList = new Vector();
        this.tabListenerList = new Vector();
        this.addMouser();
    }

    private void addToKeepOpenList(boolean closable) {
        int numTabs = this.getTabCount();
        if (numTabs == 1) {
            this.keepOpenList.add(new Boolean(true));
        } else if (numTabs > 1) {
            if (!closable) {
                this.keepOpenList.add(new Boolean(true));
            } else {
                this.keepOpenList.add(new Boolean(false));
            }
        }
    }

    private void addMouser() {
        this.mouser = new Mouser(this);
        this.addMouseListener(this.mouser);
    }

    public void addTab(String title, Component component, String tip) {
        super.addTab(title, null, component, tip);
        this.addToKeepOpenList(true);
        this.tabListenerList.add(this);
    }

    public void addTab(String title, Component component, String tip, boolean closable) {
        super.addTab(title, null, component, tip);
        this.addToKeepOpenList(closable);
        this.tabListenerList.add(this);
    }

    public void addTab(String title, Component component, String tip, boolean closable, TabCloseListener tabCloseListener) {
        super.addTab(title, null, component, tip);
        this.addToKeepOpenList(closable);
        this.tabListenerList.add(tabCloseListener);
    }

    public void addTabCloseListener(TabCloseListener closeListener, int tabIndex) {
        this.tabListenerList.set(tabIndex, closeListener);
    }

    public boolean closeTab(int index) {
        this.removeTabAt(index);
        this.tabListenerList.remove(this.mouseIndex);
        this.keepOpenList.remove(this.mouseIndex);
        return false;
    }

    private class Mouser
    extends MouseAdapter
    implements ActionListener {
        TCloseTabPane tabPanel;

        public Mouser(TCloseTabPane inTabPanel) {
            this.tabPanel = inTabPanel;
        }

        public void mousePressed(MouseEvent event) {
            this.checkPopup(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.checkPopup(event);
        }

        private void checkPopup(MouseEvent event) {
            if (event.isPopupTrigger()) {
                Boolean keepOpen;
                int x = event.getX();
                int y = event.getY();
                TCloseTabPane.this.mouseIndex = TCloseTabPane.this.getUI().tabForCoordinate(this.tabPanel, x, y);
                if (TCloseTabPane.this.mouseIndex > 0 && !(keepOpen = (Boolean)TCloseTabPane.this.keepOpenList.elementAt(TCloseTabPane.this.mouseIndex)).booleanValue()) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem mi = menu.add(MessageLog.getMessageNoID("GUI5008L"));
                    mi.setActionCommand("CloseTab");
                    mi.addActionListener(this);
                    menu.show(this.tabPanel, x, y);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            TabCloseListener listener;
            boolean needToClose;
            if (e.getActionCommand() == "CloseTab" && (needToClose = (listener = (TabCloseListener)TCloseTabPane.this.tabListenerList.get(TCloseTabPane.this.mouseIndex)) != null ? listener.closeTab(TCloseTabPane.this.mouseIndex) : true)) {
                this.tabPanel.removeTabAt(TCloseTabPane.this.mouseIndex);
                TCloseTabPane.this.tabListenerList.remove(TCloseTabPane.this.mouseIndex);
                TCloseTabPane.this.keepOpenList.remove(TCloseTabPane.this.mouseIndex);
            }
        }
    }
}

