/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.InbandFabricAgentDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.InbandFabricAgentHBAInfo;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;

public class InbandFabricAgentPanel
extends JTabbedPane
implements ChangeListener,
GuiRequestor {
    private BorderLayout blayout = new BorderLayout();
    private static GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints gridBagConstraintsStatusLabel = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsStatus = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsIPAddressLabel = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsIPAddress = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsHostnameLabel = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsHostname = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsOSLabel = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsOS = new GridBagConstraints();
    private GridBagConstraints gridBagConstraintsHBATable = new GridBagConstraints();
    private JPanel gOuterPanel = new JPanel(new FlowLayout(3));
    private JPanel gPanel = new JPanel(gridBag);
    private JScrollPane gTab = new JScrollPane(this.gOuterPanel);
    private String node_name;
    private int node_id;
    private InbandFabricAgentDDI node_ddi;
    private JLabel gStatus;
    private JLabel gIPAddress;
    private JLabel gHostname;
    private JLabel gOSVersion;
    private JTable gHBATable;
    private static final int LEFT_VALUE_INSET = 20;
    private static final int LEFT_LABEL_INSET = 40;
    private boolean inbandFabricAgentDetailsTabCreated = false;

    InbandFabricAgentPanel() {
        this.addTab(FabricGuiUtil.getString("FabricInband_DetailsTab"), this.gTab);
        this.addChangeListener(this);
        this.gridBagConstraintsStatusLabel.gridx = 0;
        this.gridBagConstraintsStatusLabel.gridy = 0;
        this.gridBagConstraintsStatusLabel.anchor = 17;
        this.gridBagConstraintsStatusLabel.insets.left = 40;
        this.gridBagConstraintsStatusLabel.insets.top = 40;
        this.gridBagConstraintsStatus.gridx = 1;
        this.gridBagConstraintsStatus.gridy = 0;
        this.gridBagConstraintsStatus.anchor = 17;
        this.gridBagConstraintsStatus.insets.left = 20;
        this.gridBagConstraintsStatus.insets.top = 40;
        this.gridBagConstraintsIPAddressLabel.gridx = 0;
        this.gridBagConstraintsIPAddressLabel.gridy = 1;
        this.gridBagConstraintsIPAddressLabel.anchor = 17;
        this.gridBagConstraintsIPAddressLabel.insets.left = 40;
        this.gridBagConstraintsIPAddress.gridx = 1;
        this.gridBagConstraintsIPAddress.gridy = 1;
        this.gridBagConstraintsIPAddress.anchor = 17;
        this.gridBagConstraintsIPAddress.insets.left = 20;
        this.gridBagConstraintsHostnameLabel.gridx = 0;
        this.gridBagConstraintsHostnameLabel.gridy = 2;
        this.gridBagConstraintsHostnameLabel.anchor = 17;
        this.gridBagConstraintsHostnameLabel.insets.left = 40;
        this.gridBagConstraintsHostname.gridx = 1;
        this.gridBagConstraintsHostname.gridy = 2;
        this.gridBagConstraintsHostname.anchor = 17;
        this.gridBagConstraintsHostname.insets.left = 20;
        this.gridBagConstraintsOSLabel.gridx = 0;
        this.gridBagConstraintsOSLabel.gridy = 3;
        this.gridBagConstraintsOSLabel.anchor = 17;
        this.gridBagConstraintsOSLabel.insets.left = 40;
        this.gridBagConstraintsOS.gridx = 1;
        this.gridBagConstraintsOS.gridy = 3;
        this.gridBagConstraintsOS.anchor = 17;
        this.gridBagConstraintsOS.insets.left = 20;
        this.gridBagConstraintsHBATable.gridx = 0;
        this.gridBagConstraintsHBATable.gridy = 7;
        this.gridBagConstraintsHBATable.gridwidth = 2;
        this.gridBagConstraintsHBATable.insets.left = 40;
        this.gridBagConstraintsHBATable.insets.top = 20;
        this.createInbandFabricAgentDetailsTab();
    }

    public void stateChanged(ChangeEvent event) {
        if (event == null || event.getSource() == this) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
            request.userName = GuiUtil.getUserName();
            InbandFabricAgentInfo ifai = new InbandFabricAgentInfo();
            request.requestData = ifai;
            request.flags = (byte)4;
            ifai.request_type = 1;
            ifai.hostId = this.node_id;
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short status, Response response) {
        if (response != null) {
            InbandFabricAgentInfo ifai = (InbandFabricAgentInfo)response.responseData;
            if (response.status == 0 && ifai != null) {
                this.gStatus.setText(FabricGuiUtil.getInbandFabricAgentStatusString(ifai.status));
                this.gIPAddress.setText(ifai.ipaddress);
                this.gHostname.setText(ifai.hostname);
                this.gOSVersion.setText(ifai.OperatingSystemAndVersion);
                this.setTableData(ifai);
                if (this.node_ddi != null) {
                    this.node_ddi.setNodeIconBasedOnStatusFromServer(ifai.status);
                }
            }
        }
    }

    void setTableData(InbandFabricAgentInfo ifai) {
        final Vector<String> lbls = new Vector<String>();
        lbls.add(FabricGuiUtil.getString("IFabricnband_Identifier"));
        lbls.add(FabricGuiUtil.getString("FabricInband_Status"));
        lbls.add(FabricGuiUtil.getString("FabricDetails_DriverVersion"));
        lbls.add(FabricGuiUtil.getString("FabricDetails_FirmwareVersion"));
        lbls.add(FabricGuiUtil.getString("FabricDetails_OptionROMVersion"));
        lbls.add(FabricGuiUtil.getString("FabricDetails_HardwareVersion"));
        final Vector data = new Vector();
        if (ifai != null) {
            InbandFabricAgentHBAInfo hbainfo = null;
            while ((hbainfo = ifai.getHBAInfo(hbainfo)) != null) {
                int status;
                try {
                    status = new Integer(hbainfo.status);
                }
                catch (NumberFormatException e) {
                    status = -1;
                }
                Vector<String> rowData = new Vector<String>();
                rowData.add(hbainfo.identifier);
                rowData.add((String)FabricGuiUtil.getStatusString(status));
                rowData.add(hbainfo.version);
                rowData.add(hbainfo.firm_version);
                rowData.add(hbainfo.rom_version);
                rowData.add(hbainfo.hardware_version);
                data.add(rowData);
            }
            Vector rowl = new Vector();
            if (data.size() < 1) {
                JLabel noDataLabel = new JLabel();
                noDataLabel.setText(Util.getString("STG0020M"));
                this.gPanel.add((Component)noDataLabel, this.gridBagConstraintsHBATable);
            } else {
                this.gHBATable.setModel(new AbstractTableModel(){

                    public String getColumnName(int column) {
                        return (String)lbls.get(column);
                    }

                    public int getColumnCount() {
                        return lbls.size();
                    }

                    public int getRowCount() {
                        return data.size();
                    }

                    public Object getValueAt(int rowIndex, int columnIndex) {
                        return ((Vector)data.get(rowIndex)).get(columnIndex);
                    }
                });
                this.gPanel.add((Component)this.gHBATable, this.gridBagConstraintsHBATable);
            }
        }
    }

    private void createInbandFabricAgentDetailsTab() {
        if (this.inbandFabricAgentDetailsTabCreated) {
            return;
        }
        this.inbandFabricAgentDetailsTabCreated = true;
        String StatusLabelString = FabricGuiUtil.getString("FabricInband_Status");
        JLabel gStatusLabel = new JLabel(StatusLabelString);
        this.gStatus = new JLabel();
        this.gPanel.add((Component)gStatusLabel, this.gridBagConstraintsStatusLabel);
        this.gPanel.add((Component)this.gStatus, this.gridBagConstraintsStatus);
        String IPAddressLabelString = FabricGuiUtil.getString("FabricInband_IPAddress");
        JLabel gIPAddressLabel = new JLabel(IPAddressLabelString);
        this.gIPAddress = new JLabel();
        this.gPanel.add((Component)gIPAddressLabel, this.gridBagConstraintsIPAddressLabel);
        this.gPanel.add((Component)this.gIPAddress, this.gridBagConstraintsIPAddress);
        String HostnameLabelString = FabricGuiUtil.getString("FabricInband_Hostname");
        JLabel gHostnameLabel = new JLabel(HostnameLabelString);
        this.gHostname = new JLabel();
        this.gPanel.add((Component)gHostnameLabel, this.gridBagConstraintsHostnameLabel);
        this.gPanel.add((Component)this.gHostname, this.gridBagConstraintsHostname);
        String OSVersionLabelString = FabricGuiUtil.getString("FabricInBand_OSVersion");
        JLabel gOSVersionLabel = new JLabel(OSVersionLabelString);
        this.gOSVersion = new JLabel();
        this.gPanel.add((Component)gOSVersionLabel, this.gridBagConstraintsOSLabel);
        this.gPanel.add((Component)this.gOSVersion, this.gridBagConstraintsOS);
        this.gHBATable = new JTable();
        this.gridBagConstraintsOSLabel.gridy = 6;
        this.gridBagConstraintsOSLabel.insets.top = 30;
        this.gPanel.add((Component)new JLabel(Util.getString("HBA_DATA_COLON")), this.gridBagConstraintsOSLabel);
        this.gOuterPanel.add(this.gPanel);
    }

    public void updateData(String nodename, int nodeid, InbandFabricAgentDDI ddi) {
        this.node_name = nodename;
        this.node_id = nodeid;
        this.stateChanged(null);
        this.node_ddi = ddi;
    }
}

