/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.agent.req.AgtStatusResp;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.admin.AgentDDI;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.JobDetail;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class JobTable
extends MegaTable
implements GuiRequestor,
ActionListener,
TJCTableMouseInterface {
    private static final String SCHEDULE = MessageLog.getMessageNoID("ADG0215L");
    private static final String JOB = MessageLog.getMessageNoID("ADG0216L");
    private static final String RUN = MessageLog.getMessageNoID("ADG0217L");
    private static final String STATUS = MessageLog.getMessageNoID("ADG0218L");
    private static final String SCHEDULED = MessageLog.getMessageNoID("ADG0220L");
    private static final String STARTED = MessageLog.getMessageNoID("ADG0221L");
    private static final String INIT = MessageLog.getMessageNoID("ADG0234T");
    private static final String WAITING = MessageLog.getMessageNoID("ADG0235T");
    private static final String EXECUTING = MessageLog.getMessageNoID("ADG0236T");
    private static final String COMPLETED = MessageLog.getMessageNoID("ADG0237T");
    private static final Byte INIT_BYTE = new Byte(73);
    private static final Byte WAIT_BYTE = new Byte(87);
    private static final Byte EXEC_BYTE = new Byte(69);
    private static final Byte COMP_BYTE = new Byte(67);
    private static final int SCHEDULE_COL = 0;
    private static final int JOB_COL = 1;
    private static final int RUN_COL = 2;
    private static final int STATUS_COL = 3;
    private static final int SCHEDULED_COL = 4;
    private static final int STARTED_COL = 5;
    private static final Color DARKGREEN = new Color(0, 75, 0);
    private static final Color DARKBLUE = new Color(0, 0, 175);
    private static final String[] colNames = new String[]{SCHEDULE, JOB, RUN, STATUS, SCHEDULED, STARTED};
    private JobTableModel jtm = null;
    protected StartedJob[] jobs = new StartedJob[0];
    private AgentTreeNode node = null;
    private AgtStatusResp asr = null;
    private int popupJob;
    private static final String LOG = "ADG0017L";

    public JobTable(AgentTreeNode node) {
        this.node = node;
        Request request = new Request();
        ServerRequest.agentJobs(request, node.computerID);
        this.popupJob = -1;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            this.asr = null;
        } else {
            this.asr = (AgtStatusResp)response.responseData;
            if (!this.asr.jobs.isEmpty()) {
                this.jobs = this.asr.jobs.toArray(this.jobs);
            }
        }
        this.jtm = new JobTableModel();
        this.setCellRenderer(Byte.class, new StatusRenderer());
        this.setCellRenderer(Date.class, TableCellRenderers.date);
        this.setRowIcon(10, true);
        this.setMouseListener(this);
        this.setBaseTableModel(this.jtm);
    }

    public boolean select(int viewRow, int viewCol) {
        return false;
    }

    public void doubleClick(int dataRow, int dataCol) {
        AgentDDI ddi = new AgentDDI();
        ddi.panel = new JobDetail(this.jobs[dataRow], this.node);
        ddi.setDescription(MessageLog.getMessageNoID("ADG0216L") + "   " + this.jobs[dataRow].getJobRun().getJobName());
        ddi.treeNode = this.node;
        ddi.runNumber = this.jobs[dataRow].getRunNumber();
        ddi.show();
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        this.popupJob = dataRow;
        JPopupMenu popup = new JPopupMenu();
        JMenuItem viewLog = new JMenuItem(MessageLog.getMessageNoID(LOG));
        viewLog.setToolTipText(MessageLog.getMessageNoID("ADG0259T"));
        viewLog.setActionCommand(LOG);
        viewLog.addActionListener(this);
        byte jobStatus = this.jobs[this.popupJob].getJobStatus();
        if (jobStatus == 69 || jobStatus == 67) {
            popup.add(viewLog);
        }
        popup.show(c, x, y);
        popup.requestFocus();
    }

    public void selectionChanged(boolean state) {
    }

    public void showDefaultChart(int dataRow) {
    }

    public void actionPerformed(ActionEvent event) {
        String source = event.getActionCommand();
        if (source == LOG) {
            LogViewer logViewer = new LogViewer(this.node.computerID, (BaseTreeNode)this.node, this.jobs[this.popupJob].getLogFileName());
        }
    }

    public class StatusRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object o) {
            if (o == null) {
                this.setText("");
            } else if (INIT_BYTE.compareTo((Byte)o) == 0) {
                this.setForeground(DARKBLUE);
                this.setText(INIT);
            } else if (WAIT_BYTE.compareTo((Byte)o) == 0) {
                this.setForeground(Color.black);
                this.setText(WAITING);
            } else if (EXEC_BYTE.compareTo((Byte)o) == 0) {
                this.setForeground(DARKGREEN);
                this.setText(EXECUTING);
            } else if (COMP_BYTE.compareTo((Byte)o) == 0) {
                this.setForeground(Color.red);
                this.setText(COMPLETED);
            } else {
                this.setText("");
            }
        }
    }

    private class JobTableModel
    extends BaseTableModel {
        JobTableModel() {
            this.columnNames = colNames;
            this.rowCount = JobTable.this.jobs.length;
        }

        public Object getTableDataItem(int row, int col) {
            JobRun jobRun = JobTable.this.jobs[row].getJobRun();
            switch (col) {
                case 0: {
                    return jobRun.getSchedCreator() + "." + jobRun.getSchedName();
                }
                case 1: {
                    return jobRun.getJobName();
                }
                case 2: {
                    return Integer.toString(JobTable.this.jobs[row].getRunNumber());
                }
                case 3: {
                    return new Byte(JobTable.this.jobs[row].getJobStatus());
                }
                case 4: {
                    return new Date(jobRun.getDesiredStartTime());
                }
                case 5: {
                    return new Date(JobTable.this.jobs[row].getStarted());
                }
            }
            return null;
        }
    }
}

