/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.TextUtil;
import org.eclipse.aperi.server.guireq.SnmpDestination;
import org.eclipse.aperi.xmsg.MessageLog;

public class SnmpSettingsPanel
extends JPanel {
    private JTextField community;
    private JTextField host;
    private JTextField port;
    private boolean setFocus;
    private SnmpDestination snmp;

    public SnmpSettingsPanel(SnmpDestination snmp, int destinationNumber) {
        this.snmp = snmp;
        this.setFocus = false;
        String s = Util.isEmpty(snmp.csSnmpCommunity) ? null : snmp.csSnmpCommunity;
        this.community = TTextField.newTTextField(s, 12, 64, false);
        s = Util.isEmpty(snmp.csSnmpServer) ? null : snmp.csSnmpServer;
        this.host = TTextField.newTTextField(s, 20, 128, false);
        s = snmp.csSnmpPort > 0 ? Integer.toString(snmp.csSnmpPort) : null;
        this.port = TTextField.newTTextField(s, 5, true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 0;
        c.insets.bottom = 10;
        c.insets.left = 0;
        c.insets.right = 2;
        c.anchor = 17;
        c.gridwidth = 0;
        s = MessageLog.getMessageNoID("GUI0270L", Integer.toString(destinationNumber + 1));
        JLabel label = new BlackLabel(s);
        this.add((Component)label, c);
        c.gridwidth = 1;
        c.insets.bottom = 4;
        s = MessageLog.getMessageNoID("GUI2048L");
        label = new JLabel(s);
        this.add((Component)label, c);
        GuiUtil.setAccessibleLabel(label, this.community, "MNEMONIC_COMMUNITY", s, "DESCRIPTION_COMMUNITY");
        c.insets.left = 1;
        c.gridwidth = 0;
        this.add((Component)this.community, c);
        s = MessageLog.getMessageNoID("GUI2049L");
        label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        c.insets.right = 0;
        c.insets.bottom = 5;
        c.insets.left = 0;
        this.add((Component)label, c);
        s = MessageLog.getMessageNoID("GUI2050L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.host, "MNEMONIC_HOST", s, "DESCRIPTION_HOST");
        c.anchor = 13;
        c.insets.bottom = 0;
        c.insets.right = 3;
        c.gridwidth = 1;
        this.add((Component)label, c);
        c.anchor = 17;
        c.gridwidth = 0;
        this.add((Component)this.host, c);
        s = MessageLog.getMessageNoID("GUI2051L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.port, "MNEMONIC_PORT", s, "DESCRIPTION_PORT");
        c.anchor = 13;
        c.insets.bottom = 5;
        c.gridwidth = 1;
        c.gridheight = 0;
        this.add((Component)label, c);
        c.anchor = 17;
        this.add((Component)this.port, c);
        s = MessageLog.getMessageNoID("GUI2052L");
        label = new JLabel(s);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)label, c);
    }

    public SnmpDestination getData() {
        this.snmp.csSnmpServer = TextUtil.getTrimmedText(this.host);
        boolean haveSnmpServer = !Util.isEmpty(this.snmp.csSnmpServer);
        String s = this.port.getText();
        this.snmp.csSnmpPort = s.length() > 0 ? Integer.parseInt(s) : (haveSnmpServer ? 162 : 0);
        s = TextUtil.getTrimmedText(this.community);
        this.snmp.csSnmpCommunity = s.length() > 0 ? s : (haveSnmpServer ? "public" : null);
        return this.snmp;
    }

    public boolean validateData() throws GeneralException {
        if ((this.snmp.csSnmpPort > 0 || !Util.isEmpty(this.snmp.csSnmpCommunity)) && Util.isEmpty(this.snmp.csSnmpServer)) {
            String text = MessageLog.getMessageNoTS("GUI2060E", null);
            throw new GeneralException(text);
        }
        return !Util.isEmpty(this.snmp.csSnmpServer);
    }

    public void requestFocus() {
        this.host.requestFocus();
    }
}

