/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialogCallbackInterface;
import org.eclipse.aperi.xmsg.MessageLog;

public class AperiChartCustomizationDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final int TITLE_LENGTH_MAX = 96;
    private int docOffset;
    private JButton saveButton;
    private JButton defaultsButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel panel;
    private JComboBox maxCharts = null;
    private JComboBox maxPerChart = null;
    private JRadioButton hoverOnly = null;
    private JRadioButton textOnly = null;
    private ChartOptions defaultOptions;
    private ChartOptions newOptions;
    private Insets inset2 = new Insets(0, 26, 0, 0);
    private Insets insetL1 = new Insets(2, 12, 2, 8);
    private JRadioButton typePie = null;
    private JRadioButton typeBar = null;
    private JRadioButton typeStacked = null;
    private JRadioButton typeStacked100 = null;
    private JRadioButton orientHoriz = null;
    private JRadioButton orientVert = null;
    private JCheckBox showTrends;
    private JTextField titleField;
    private boolean maxChartsEnabled;
    private boolean maxPerChartEnabled;
    private boolean hoverOnlyEnabled;
    private boolean chartTypeEnabled;
    private boolean historyEnabled;
    private AperiChartCustomizationDialogCallbackInterface customizableChart;

    public AperiChartCustomizationDialog(Frame myFrame, AperiChartCustomizationDialogCallbackInterface customizableChart, String title, String helpID, ChartOptions iCurrentOptions, ChartOptions iDefaultOptions, boolean maxChartsEnabled, boolean hoverOnlyEnabled, boolean chartTypeEnabled, boolean maxPerChartEnabled, boolean historyEnabled) {
        super(myFrame, title, true);
        this.defaultOptions = iDefaultOptions;
        this.newOptions = (ChartOptions)iCurrentOptions.clone();
        this.setMaxChartsEnabled(maxChartsEnabled);
        this.setHoverOnlyEnabled(hoverOnlyEnabled);
        this.setChartTypeEnabled(chartTypeEnabled);
        this.setMaxPerChartEnabled(maxPerChartEnabled);
        this.setHistoryEnabled(historyEnabled);
        this.setCustomizableChart(customizableChart);
        this.configureHelp(helpID);
        this.getContentPane().add(this.getMainPanel());
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.defaultsButton) {
            this.displayDefaults();
        }
        if (source == this.applyButton) {
            this.applyChanges();
        } else if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.saveButton || source == this.okButton) {
            this.applyChanges();
            this.saveChanges();
            this.dispose();
        } else if (source == this.maxCharts) {
            this.newOptions.chartsPerView = this.maxCharts.getSelectedIndex() + 1;
        } else if (source == this.maxPerChart) {
            this.newOptions.seriesPerChart = this.maxPerChart.getSelectedIndex() + 1;
        } else if (source == this.hoverOnly || source == this.textOnly) {
            this.newOptions.hoverText = !this.textOnly.isSelected();
        } else if (source == this.typePie) {
            this.newOptions.chartType = 1;
            this.orientVert.setEnabled(false);
            this.orientHoriz.setEnabled(false);
        } else if (source == this.typeBar || source == this.typeStacked || source == this.typeStacked100 || source == this.orientHoriz || source == this.orientVert) {
            this.setGraphType();
        } else if (source == this.showTrends) {
            this.newOptions.trends = this.showTrends.isSelected();
        }
    }

    private boolean isHoverOnlyEnabled() {
        return this.hoverOnlyEnabled;
    }

    private void setHoverOnlyEnabled(boolean hoverOnlyEnabled) {
        this.hoverOnlyEnabled = hoverOnlyEnabled;
    }

    private JPanel getMainPanel() {
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        JTextArea ta = new JTextArea(Util.getString("DESC_CHART_CUST_INSTRUCTIONS"));
        ta.setBackground(this.getBackground());
        ta.setEditable(false);
        gbc.insets = new Insets(5, 12, 2, 8);
        this.panel.add((Component)ta, gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 12, 1, 8);
        this.panel.add((Component)this.getTitlePanel(), gbc);
        ++gbc.gridy;
        this.panel.add((Component)this.getMaxChartsPanel(), gbc);
        ++gbc.gridy;
        this.panel.add((Component)this.getHoverPanel(), gbc);
        ++gbc.gridy;
        ++gbc.gridy;
        this.panel.add((Component)this.getGraphPanel(), gbc);
        ++gbc.gridy;
        this.panel.add((Component)this.getHistPanel(), gbc);
        this.defaultsButton = new JButton(Util.getString("RESTORE_DEFAULTS"));
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 12, 1, 8);
        this.panel.add((Component)this.defaultsButton, gbc);
        this.defaultsButton.addActionListener(this);
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.insets = new Insets(1, 12, 1, 8);
        this.panel.add((Component)this.getButtonPanel(), gbc);
        return this.panel;
    }

    private void displayDefaults() {
        this.newOptions = (ChartOptions)this.defaultOptions.clone();
        if (this.maxCharts.isEnabled()) {
            this.maxCharts.setSelectedIndex(this.newOptions.chartsPerView - 1);
        }
        if (this.maxPerChart.isEnabled()) {
            this.maxPerChart.setSelectedIndex(this.newOptions.seriesPerChart - 2);
        }
        this.hoverOnly.setSelected(this.newOptions.hoverText);
        this.displayGraphType(this.newOptions.chartType);
        if (this.showTrends.isEnabled()) {
            this.showTrends.setSelected(this.newOptions.trends);
        }
        this.titleField.setText(this.newOptions.title);
    }

    private void saveChanges() {
        this.newOptions.title = this.titleField.getText();
        this.getCustomizableChart().saveCustomOptions(this.newOptions);
    }

    private void applyChanges() {
        this.newOptions.title = this.titleField.getText();
        this.getCustomizableChart().setCustomOptions(this.newOptions);
    }

    private GridBagPanel getButtonPanel() {
        this.saveButton = new JButton(Util.getString("LABEL_SAVE"));
        this.okButton = new JButton(Util.getString("LABEL_OK"));
        this.applyButton = new JButton(Util.getString("LABEL_APPLY"));
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.getRootPane().setDefaultButton(this.saveButton);
        GridBagPanel bPanel = new GridBagPanel();
        bPanel.add(this.applyButton, -1, 0, 1, 1, 22, 0, new Insets(4, 4, 4, 4));
        bPanel.add(this.saveButton, -1, 1, 1, 1, 22, 0, new Insets(4, 4, 4, 4));
        bPanel.add(this.cancelButton, -1, 2, 1, 1, 22, 0, new Insets(4, 4, 4, 4));
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.okButton.addActionListener(this);
        return bPanel;
    }

    private JPanel getTitlePanel() {
        Insets insets;
        JPanel tPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(4, 12, 4, 8);
        gbc.anchor = 17;
        JLabel tta = new JLabel(Util.getString("CHART_TITLE"));
        tPanel.add((Component)tta, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.titleField = new JTextField(new SizeLimitedDocument(96, false), this.newOptions.title, 0);
        if (!this.defaultOptions.isTitleCustomizable) {
            this.titleField.setEditable(false);
        } else {
            this.titleField.getDocument().addDocumentListener(this);
        }
        tPanel.add((Component)this.titleField, gbc);
        tta.setLabelFor(this.titleField);
        return tPanel;
    }

    private JPanel getMaxChartsPanel() {
        Insets insets;
        JPanel mcPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(1, 12, 1, 8);
        gbc.gridx = 0;
        gbc.gridy = 0;
        JLabel l = new JLabel(Util.getString("MAX_NUM_CHARTS"));
        mcPanel.add((Component)l, gbc);
        this.maxCharts = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"});
        l.setLabelFor(this.maxCharts);
        this.maxCharts.setEnabled(this.isMaxChartsEnabled());
        this.maxCharts.addActionListener(this);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        mcPanel.add((Component)this.maxCharts, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        JLabel l2 = new JLabel(Util.getString("MAX_NUM_SERIES"));
        mcPanel.add((Component)l2, gbc);
        this.maxPerChart = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"});
        l2.setLabelFor(this.maxPerChart);
        this.maxPerChart.setEnabled(this.isMaxPerChartEnabled());
        this.maxPerChart.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        ++gbc.gridx;
        mcPanel.add((Component)this.maxPerChart, gbc);
        return mcPanel;
    }

    private JPanel getHoverPanel() {
        Insets insets;
        JPanel hPanel = new JPanel();
        hPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(1, 12, 1, 8);
        gbc.anchor = 17;
        this.hoverOnly = new JRadioButton(Util.getString("HOVER_ONLY"));
        gbc.weightx = 1.0;
        ButtonGroup butGroup = new ButtonGroup();
        JLabel l = new JLabel(Util.getString("SHOW_VALUES"));
        hPanel.add((Component)l, gbc);
        gbc.insets = new Insets(0, 26, 0, 0);
        gbc.gridy = 1;
        this.textOnly = new JRadioButton(Util.getString("ALWAYS"));
        l.setLabelFor(this.hoverOnly);
        hPanel.add((Component)this.hoverOnly, gbc);
        gbc.gridy = 2;
        hPanel.add((Component)this.textOnly, gbc);
        butGroup.add(this.hoverOnly);
        butGroup.add(this.textOnly);
        if (this.isHoverOnlyEnabled()) {
            this.hoverOnly.setEnabled(true);
            this.textOnly.setEnabled(true);
            if (this.newOptions.hoverText) {
                this.textOnly.setSelected(false);
                this.hoverOnly.setSelected(true);
            } else {
                this.textOnly.setSelected(true);
                this.hoverOnly.setSelected(false);
            }
        } else {
            this.hoverOnly.setEnabled(false);
            this.textOnly.setEnabled(false);
        }
        this.hoverOnly.addActionListener(this);
        this.textOnly.addActionListener(this);
        return hPanel;
    }

    private JPanel getGraphPanel() {
        JPanel gpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 12, 1, 8);
        gbc.anchor = 17;
        gbc.gridy = 0;
        gpanel.setBorder(GuiUtil.getBorder(Util.getString("GRAPH_CHARTS")));
        ButtonGroup bg = new ButtonGroup();
        ButtonGroup bg2 = new ButtonGroup();
        JLabel jl = new JLabel(Util.getString("CHART_TYPE"));
        jl.setLabelFor(this.typePie);
        gpanel.add((Component)jl, gbc);
        this.typePie = new JRadioButton(MessageLog.getMessageNoID("STG1261T"));
        this.typeBar = new JRadioButton(MessageLog.getMessageNoID("STG1262T"));
        this.typeStacked = new JRadioButton(MessageLog.getMessageNoID("STG1264T"));
        this.typeStacked100 = new JRadioButton(MessageLog.getMessageNoID("STG1265T"));
        if (!this.isChartTypeEnabled()) {
            this.typePie.setEnabled(false);
            this.typeBar.setEnabled(false);
            this.typeStacked.setEnabled(false);
            this.typeStacked100.setEnabled(false);
        } else {
            this.typePie.addActionListener(this);
            this.typeBar.addActionListener(this);
            this.typeStacked.addActionListener(this);
            this.typeStacked100.addActionListener(this);
            bg.add(this.typePie);
            bg.add(this.typeBar);
            bg.add(this.typeStacked);
            bg.add(this.typeStacked100);
        }
        ++gbc.gridy;
        gbc.insets = this.inset2;
        gpanel.add((Component)this.typePie, gbc);
        ++gbc.gridy;
        gpanel.add((Component)this.typeBar, gbc);
        ++gbc.gridy;
        gpanel.add((Component)this.typeStacked, gbc);
        ++gbc.gridy;
        gpanel.add((Component)this.typeStacked100, gbc);
        ++gbc.gridy;
        ++gbc.gridy;
        gbc.insets = this.insetL1;
        jl = new JLabel(Util.getString("CHART_ORIENTATION"));
        gpanel.add((Component)jl, gbc);
        gbc.insets = this.inset2;
        this.orientHoriz = new JRadioButton(Util.getString("HORIZONTAL"));
        this.orientVert = new JRadioButton(Util.getString("VERTICAL"));
        jl.setLabelFor(this.orientHoriz);
        if (this.isChartTypeEnabled()) {
            this.orientHoriz.addActionListener(this);
            this.orientVert.addActionListener(this);
            bg2.add(this.orientHoriz);
            bg2.add(this.orientVert);
        } else {
            this.orientHoriz.setEnabled(false);
            this.orientVert.setEnabled(false);
        }
        switch (this.newOptions.chartType) {
            case 2: {
                bg.setSelected(this.typeBar.getModel(), true);
                bg2.setSelected(this.orientHoriz.getModel(), true);
                break;
            }
            case 3: {
                bg.setSelected(this.typeBar.getModel(), true);
                bg2.setSelected(this.orientVert.getModel(), true);
                break;
            }
            case 1: {
                bg.setSelected(this.typePie.getModel(), true);
                bg2.setSelected(this.orientHoriz.getModel(), true);
                this.orientVert.setEnabled(false);
                this.orientHoriz.setEnabled(false);
                break;
            }
            case 4: {
                bg.setSelected(this.typeStacked.getModel(), true);
                bg2.setSelected(this.orientHoriz.getModel(), true);
                break;
            }
            case 5: {
                bg.setSelected(this.typeStacked.getModel(), true);
                bg2.setSelected(this.orientVert.getModel(), true);
                break;
            }
            case 6: {
                bg.setSelected(this.typeStacked100.getModel(), true);
                bg2.setSelected(this.orientHoriz.getModel(), true);
                break;
            }
            case 7: {
                bg.setSelected(this.typeStacked100.getModel(), true);
                bg2.setSelected(this.orientVert.getModel(), true);
            }
        }
        ++gbc.gridy;
        gpanel.add((Component)this.orientHoriz, gbc);
        ++gbc.gridy;
        gpanel.add((Component)this.orientVert, gbc);
        GuiUtil.completePanel(gpanel);
        return gpanel;
    }

    private void setGraphType() {
        int orient;
        int n = orient = this.orientVert.isSelected() ? 1 : 0;
        if (this.typeBar.getModel().isSelected()) {
            this.newOptions.chartType = 2 + orient;
        }
        if (this.typeStacked.getModel().isSelected()) {
            this.newOptions.chartType = 4 + orient;
        }
        if (this.typeStacked100.getModel().isSelected()) {
            this.newOptions.chartType = 6 + orient;
        }
        this.orientVert.setEnabled(true);
        this.orientHoriz.setEnabled(true);
    }

    private void displayGraphType(int graphType) {
        this.orientHoriz.setSelected(true);
        switch (graphType) {
            case 0: {
                break;
            }
            case 1: {
                this.typePie.getModel().setSelected(true);
                break;
            }
            case 2: {
                this.typeBar.getModel().setSelected(true);
                this.orientHoriz.setSelected(true);
                break;
            }
            case 3: {
                this.typeBar.getModel().setSelected(true);
                break;
            }
            case 4: {
                this.typeStacked.getModel().setSelected(true);
                this.orientHoriz.setSelected(true);
                break;
            }
            case 5: {
                this.typeStacked.getModel().setSelected(true);
                break;
            }
            case 6: {
                this.typeStacked100.getModel().setSelected(true);
                this.orientHoriz.setSelected(true);
                break;
            }
            case 7: {
                this.typeStacked100.getModel().setSelected(true);
            }
        }
    }

    private JPanel getHistPanel() {
        Insets insets;
        JPanel gpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(2, 12, 2, 8);
        gbc.anchor = 17;
        gpanel.setBorder(GuiUtil.getBorder(Util.getString("HISTORY_CHARTS")));
        this.showTrends = new JCheckBox(MessageLog.getMessageNoID("STG2095T"));
        gpanel.add((Component)this.showTrends, gbc);
        if (!this.isHistoryEnabled()) {
            this.showTrends.setEnabled(false);
        } else {
            this.showTrends.setSelected(this.newOptions.trends);
            this.showTrends.addActionListener(this);
        }
        gbc.gridy = 1;
        GuiUtil.completePanel(gpanel);
        return gpanel;
    }

    public void changedUpdate(DocumentEvent de) {
        this.checkForUndoEvent(de);
    }

    public void insertUpdate(DocumentEvent de) {
        this.checkForUndoEvent(de);
    }

    public void removeUpdate(DocumentEvent de) {
    }

    private void checkForUndoEvent(DocumentEvent de) {
        if (de.getDocument().getLength() > 96) {
            this.docOffset = de.getOffset();
            EventQueue queue = new EventQueue();
            queue.postEvent(new UndoEvent());
        }
    }

    private void configureHelp(String helpID) {
        if (helpID != null) {
            Help.setHelpID(this.getRootPane(), helpID);
            this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
            this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        }
    }

    private boolean isMaxChartsEnabled() {
        return this.maxChartsEnabled;
    }

    private void setMaxChartsEnabled(boolean maxChartsEnabled) {
        this.maxChartsEnabled = maxChartsEnabled;
    }

    private boolean isChartTypeEnabled() {
        return this.chartTypeEnabled;
    }

    private void setChartTypeEnabled(boolean chartTypeEnabled) {
        this.chartTypeEnabled = chartTypeEnabled;
    }

    private boolean isMaxPerChartEnabled() {
        return this.maxPerChartEnabled;
    }

    private void setMaxPerChartEnabled(boolean maxPerChartEnabled) {
        this.maxPerChartEnabled = maxPerChartEnabled;
    }

    private boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    private void setHistoryEnabled(boolean historyEnabled) {
        this.historyEnabled = historyEnabled;
    }

    private AperiChartCustomizationDialogCallbackInterface getCustomizableChart() {
        return this.customizableChart;
    }

    private void setCustomizableChart(AperiChartCustomizationDialogCallbackInterface customizableChart) {
        this.customizableChart = customizableChart;
    }

    private class UndoEvent
    extends AWTEvent
    implements ActiveEvent {
        private static final long serialVersionUID = 1L;

        public UndoEvent() {
            super(new Object(), 2000);
        }

        public void dispatch() {
            try {
                AperiChartCustomizationDialog.this.titleField.getDocument().remove(AperiChartCustomizationDialog.this.docOffset, 1);
                AperiChartCustomizationDialog.this.titleField.setCaretPosition(AperiChartCustomizationDialog.this.docOffset);
                Toolkit.getDefaultToolkit().beep();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

