/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.charting.AperiChartAdapter;

public class AperiChartFactory {
    private static Class currentChartEngineClass;
    private static String currentChartEngineName;
    private static String currentChartEngineChoice;
    private static final String choiceJClassChartEngine = "JClass Chart Engine";
    private static final String choiceEclipseChartEngine = "Eclipse Chart Engine";
    private static final String classJClassChartEngine = "org.eclipse.aperi.gui.charting.AperiJClassChart";
    private static final String classEclipseChartEngine = "org.eclipse.aperi.gui.charting.AperiEclipseChart";
    private static HashMap engineMap;
    private static IGuiMain guiMain;

    public static JMenuItem getChartEngineMenu() {
        JMenuItem jmiChart = new JMenuItem("Select Chart Engine");
        jmiChart.setMnemonic('e');
        jmiChart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AperiChartFactory.selectChartEngine();
            }
        });
        return jmiChart;
    }

    private static void setEngineChoice(String choice) {
        AperiChartFactory.setCurrentChartEngineChoice(choice);
        AperiChartFactory.setCurrentChartEngineName();
        AperiChartFactory.setCurrentChartEngineClass();
    }

    private static void selectChartEngine() {
        String choice = (String)JOptionPane.showInputDialog(guiMain.getFrame(), "Select Chart Engine", "Chart Engine Selector", -1, IconFactory.getPieChartIcon(), engineMap.keySet().toArray(), AperiChartFactory.getCurrentChartEngineChoice());
        if (choice != null) {
            AperiChartFactory.setEngineChoice(choice);
        }
    }

    public static AperiChartAdapter newChart() {
        try {
            return (AperiChartAdapter)AperiChartFactory.getCurrentChartEngineClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class getCurrentChartEngineClass() {
        return currentChartEngineClass;
    }

    private static void setCurrentChartEngineClass() {
        try {
            currentChartEngineClass = Class.forName(currentChartEngineName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getCurrentChartEngineName() {
        return currentChartEngineName;
    }

    private static void setCurrentChartEngineName() {
        currentChartEngineName = (String)engineMap.get(AperiChartFactory.getCurrentChartEngineChoice());
    }

    private static String getCurrentChartEngineChoice() {
        return currentChartEngineChoice;
    }

    private static void setCurrentChartEngineChoice(String currentChartEngineChoice) {
        AperiChartFactory.currentChartEngineChoice = currentChartEngineChoice;
    }

    static {
        engineMap = new HashMap();
        guiMain = GuiManager.getGuiManager().getGuiMain();
        engineMap.put(choiceEclipseChartEngine, classEclipseChartEngine);
        AperiChartFactory.setEngineChoice(choiceEclipseChartEngine);
    }
}

