/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialog;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialogCallbackInterface;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationKey;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;

public class AperiCustomizableChart
extends AperiChart
implements AperiChartCustomizationDialogCallbackInterface {
    private static final long serialVersionUID = 1L;
    private ChartOptions defaultSettings;
    private ChartOptions currentSettings;
    private AperiChartCustomizationKey customizationKey;
    private JButton prevButton = new JButton(Util.getString("CHART_PREV"));
    private JButton upButton = new JButton(Util.getString("CHART_UP"));
    private JLabel interactiveStatus = new JLabel();
    private JButton downButton = new JButton(Util.getString("CHART_DOWN"));
    private JButton nextButton = new JButton(Util.getString("CHART_NEXT"));
    JPanel buttonPanel = new JPanel();
    private boolean buttonsEnabled = false;

    public AperiCustomizableChart(int yAxisType, int xAxisType, double[][] yValues, double[][] xValues, String[] seriesNames, ChartOptions defaultOptions, GuiReportReq grr) {
        super(0, yAxisType, xAxisType, yValues, xValues, seriesNames);
        this.configureCustomization(defaultOptions, grr);
        this.configurePaging();
    }

    private void configurePaging() {
        if (this.isPageable()) {
            this.add(this.createButtonPanel(), "South");
        }
    }

    public AperiCustomizableChart(int yAxisType, int xAxisType, Number[][] chartData, String[] seriesNames, String[] categoryNames, ChartOptions defaultOptions, GuiReportReq grr) {
        super(1, yAxisType, xAxisType, chartData, seriesNames, (Object[])categoryNames);
        this.configureCustomization(defaultOptions, grr);
        this.configurePaging();
    }

    private boolean isPrevNext() {
        if (this.getChart().getChartType() == 0 && this.getCurrentSettings().seriesPerChart != -1 && this.getChart().getYValues() != null && this.getChart().getYValues().length > this.getCurrentSettings().seriesPerChart) {
            return true;
        }
        return this.getCurrentSettings().chartsPerView != -1 && this.getChart().getXCategories() != null && this.getChart().getXCategories().length > 1 && this.getChart().getYSeries() != null && this.getChart().getYSeries().length > 0 && this.getChart().getYSeries()[0] != null && this.getChart().getYSeries()[0].length > this.getCurrentSettings().chartsPerView;
    }

    private boolean isUpDown() {
        return this.getCurrentSettings().seriesPerChart != -1 && this.getChart().getChartType() != 0 && this.getChart().getXCategories().length == 1 && this.getChart().getYSeries().length > this.getCurrentSettings().seriesPerChart;
    }

    private boolean isPageable() {
        return this.isPrevNext() || this.isUpDown();
    }

    private void configureCustomization(ChartOptions defaultOptions, GuiReportReq grr) {
        this.setCustomizationKey(new AperiChartCustomizationKey(grr));
        this.getChart().addMouseListener(new MyMouseAdapter());
        this.setDefaultSettings(defaultOptions);
        ChartOptions co = AperiChartCustomizationManager.getManager().getChartCustomization(this.getCustomizationKey());
        if (co == null) {
            this.setCurrentSettings((ChartOptions)this.defaultSettings.clone());
        } else {
            this.setCurrentSettings(co);
        }
        this.applyOptions(this.getCurrentSettings());
    }

    private Component createButtonPanel() {
        this.buttonPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.buttonPanel.setVisible(true);
        this.buttonPanel.setLayout(new FlowLayout());
        if (this.isPrevNext()) {
            this.buttonPanel.add(this.getPrevButton());
        }
        if (this.isUpDown()) {
            this.buttonPanel.add(this.getUpButton());
        }
        this.buttonPanel.add(this.getInteractiveStatus());
        if (this.isUpDown()) {
            this.buttonPanel.add(this.getDownButton());
        }
        if (this.isPrevNext()) {
            this.buttonPanel.add(this.getNextButton());
        }
        return this.buttonPanel;
    }

    private void applyOptions(ChartOptions options) {
        this.getChart().setChartTitle(options.title);
        this.getChart().setYValuePointsVisible(!options.hoverText);
        if (this.getChart().getChartType() == 0) {
            if (options.chartType != 0) {
                throw new RuntimeException("Attempt to change history chart type not allowed");
            }
            if (options.seriesPerChart != -1) {
                this.enablePrevNextSeriesButtons();
            }
            this.getChart().setTrendLineVisible(options.trends);
        } else {
            switch (options.chartType) {
                case 2: {
                    this.getChart().setChartType(2);
                    this.getChart().setChartOrientation(0);
                    this.getChart().setYAxisScaling(0);
                    break;
                }
                case 3: {
                    this.getChart().setChartType(2);
                    this.getChart().setChartOrientation(1);
                    this.getChart().setYAxisScaling(0);
                    break;
                }
                case 4: {
                    this.getChart().setChartType(3);
                    this.getChart().setChartOrientation(0);
                    this.getChart().setYAxisScaling(0);
                    break;
                }
                case 5: {
                    this.getChart().setChartType(3);
                    this.getChart().setChartOrientation(1);
                    this.getChart().setYAxisScaling(0);
                    break;
                }
                case 6: {
                    this.getChart().setChartType(3);
                    this.getChart().setChartOrientation(0);
                    this.getChart().setYAxisScaling(1);
                    break;
                }
                case 7: {
                    this.getChart().setChartType(3);
                    this.getChart().setChartOrientation(1);
                    this.getChart().setYAxisScaling(1);
                    break;
                }
                default: {
                    this.getChart().setYAxisScaling(0);
                    this.getChart().setChartType(1);
                }
            }
            this.getChart().setChartSubtype(this.determineChartSubtype(options));
            if (options.chartsPerView != -1 && options.chartsPerView != 1) {
                this.enablePrevNextChartsButtons();
            } else if (options.seriesPerChart != -1) {
                this.enableUpDownButtons();
            }
        }
    }

    private void refreshInteractiveStatus() {
        int through;
        int offset;
        int total;
        if (this.getChart().getChartType() == 0) {
            total = this.getChart().getYValues().length;
            offset = this.getChart().getSeriesOffset();
            through = Math.min(this.getChart().getSeriesOffset() + this.getChart().getSeriesPerChart(), total);
        } else if (this.getChart().getChartSubtype() == 0) {
            total = this.getChart().getYSeries().length;
            offset = this.getChart().getSeriesOffset();
            through = Math.min(this.getChart().getSeriesOffset() + this.getChart().getSeriesPerChart(), total);
        } else {
            total = this.getChart().getXCategories().length;
            offset = this.getChart().getCategoryOffset();
            through = Math.min(this.getChart().getCategoryOffset() + this.getChart().getChartsPerView(), total);
        }
        this.getInteractiveStatus().setText(Util.getString("CHART_STATUS", new String[]{String.valueOf(offset), String.valueOf(through), String.valueOf(total)}));
    }

    private void enableUpDownButtons() {
        this.getChart().setSeriesPerChart(0, this.getCurrentSettings().seriesPerChart);
        if (!this.buttonsEnabled) {
            this.getDownButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AperiCustomizableChart.this.getChart().setSeriesPerChart(AperiCustomizableChart.this.getChart().getSeriesOffset() + ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart, ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart);
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() + AperiCustomizableChart.this.getChart().getSeriesPerChart() > AperiCustomizableChart.this.getChart().getYSeries().length) {
                        AperiCustomizableChart.this.getDownButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() > 0) {
                        AperiCustomizableChart.this.getUpButton().setEnabled(true);
                    }
                    AperiCustomizableChart.this.refreshInteractiveStatus();
                }
            });
        }
        this.getDownButton().setEnabled(true);
        if (!this.buttonsEnabled) {
            this.getUpButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AperiCustomizableChart.this.getChart().setSeriesPerChart(Math.max(0, AperiCustomizableChart.this.getChart().getSeriesOffset() - ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart), ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart);
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() == 0) {
                        AperiCustomizableChart.this.getUpButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() + AperiCustomizableChart.this.getChart().getSeriesPerChart() < AperiCustomizableChart.this.getChart().getYSeries().length) {
                        AperiCustomizableChart.this.getDownButton().setEnabled(true);
                    }
                    AperiCustomizableChart.this.refreshInteractiveStatus();
                }
            });
        }
        this.getUpButton().setEnabled(false);
        this.refreshInteractiveStatus();
        this.buttonsEnabled = true;
    }

    private void enablePrevNextChartsButtons() {
        this.getChart().setChartsPerView(0, this.getCurrentSettings().chartsPerView);
        this.getChart().setSeriesPerChart(0, this.getCurrentSettings().seriesPerChart);
        if (!this.buttonsEnabled) {
            this.getNextButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AperiCustomizableChart.this.getChart().setChartsPerView(AperiCustomizableChart.this.getChart().getCategoryOffset() + ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().chartsPerView, ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().chartsPerView);
                    if (AperiCustomizableChart.this.getChart().getCategoryOffset() + AperiCustomizableChart.this.getChart().getChartsPerView() > AperiCustomizableChart.this.getChart().getXCategories().length) {
                        AperiCustomizableChart.this.getNextButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getCategoryOffset() > 0) {
                        AperiCustomizableChart.this.getPrevButton().setEnabled(true);
                    }
                }
            });
        }
        this.getNextButton().setEnabled(true);
        if (!this.buttonsEnabled) {
            this.getPrevButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AperiCustomizableChart.this.getChart().setChartsPerView(Math.min(0, AperiCustomizableChart.this.getChart().getChartsPerView() - ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().chartsPerView), ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().chartsPerView);
                    if (AperiCustomizableChart.this.getChart().getCategoryOffset() == 0) {
                        AperiCustomizableChart.this.getPrevButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getCategoryOffset() + AperiCustomizableChart.this.getChart().getChartsPerView() <= AperiCustomizableChart.this.getChart().getXCategories().length) {
                        AperiCustomizableChart.this.getNextButton().setEnabled(true);
                    }
                }
            });
        }
        this.getPrevButton().setEnabled(false);
        this.buttonsEnabled = true;
    }

    private void enablePrevNextSeriesButtons() {
        this.getChart().setSeriesPerChart(0, this.getCurrentSettings().seriesPerChart);
        if (!this.buttonsEnabled) {
            this.getNextButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AperiCustomizableChart.this.getChart().setSeriesPerChart(AperiCustomizableChart.this.getChart().getSeriesOffset() + ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart, ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart);
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() + AperiCustomizableChart.this.getChart().getSeriesPerChart() > AperiCustomizableChart.this.getChart().getYValues().length) {
                        AperiCustomizableChart.this.getNextButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() > 0) {
                        AperiCustomizableChart.this.getPrevButton().setEnabled(true);
                    }
                    AperiCustomizableChart.this.refreshInteractiveStatus();
                }
            });
        }
        this.getNextButton().setEnabled(true);
        if (!this.buttonsEnabled) {
            this.getPrevButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AperiCustomizableChart.this.getChart().setSeriesPerChart(Math.max(0, AperiCustomizableChart.this.getChart().getSeriesOffset() - ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart), ((AperiCustomizableChart)AperiCustomizableChart.this).getCurrentSettings().seriesPerChart);
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() == 0) {
                        AperiCustomizableChart.this.getPrevButton().setEnabled(false);
                    }
                    if (AperiCustomizableChart.this.getChart().getSeriesOffset() + AperiCustomizableChart.this.getChart().getSeriesPerChart() < AperiCustomizableChart.this.getChart().getYValues().length) {
                        AperiCustomizableChart.this.getNextButton().setEnabled(true);
                    }
                    AperiCustomizableChart.this.refreshInteractiveStatus();
                }
            });
        }
        this.getPrevButton().setEnabled(false);
        this.refreshInteractiveStatus();
        this.buttonsEnabled = true;
    }

    private int determineChartSubtype(ChartOptions options) {
        return options.seriesPerChart != -1 ? 0 : 1;
    }

    public void setCustomOptions(ChartOptions customOptions) {
        this.setCurrentSettings((ChartOptions)customOptions.clone());
        this.applyOptions(this.getCurrentSettings());
    }

    public void saveCustomOptions(ChartOptions customOptions) {
        if (customOptions.equals(this.defaultSettings)) {
            AperiChartCustomizationManager.getManager().deleteChartCustomization(this.getCustomizationKey());
        } else {
            AperiChartCustomizationManager.getManager().saveChartCustomization(this.getCustomizationKey(), customOptions);
        }
    }

    private AperiCustomizableChart getSelfReference() {
        return this;
    }

    private ChartOptions getDefaultSettings() {
        return this.defaultSettings;
    }

    private void setDefaultSettings(ChartOptions defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    private ChartOptions getCurrentSettings() {
        return this.currentSettings;
    }

    private void setCurrentSettings(ChartOptions currentSettings) {
        this.currentSettings = currentSettings;
    }

    private AperiChartCustomizationKey getCustomizationKey() {
        return this.customizationKey;
    }

    private void setCustomizationKey(AperiChartCustomizationKey customizationKey) {
        this.customizationKey = customizationKey;
    }

    private JButton getDownButton() {
        return this.downButton;
    }

    private void setDownButton(JButton downButton) {
        this.downButton = downButton;
    }

    private JLabel getInteractiveStatus() {
        return this.interactiveStatus;
    }

    private void setInteractiveStatus(JLabel interactiveStatus) {
        this.interactiveStatus = interactiveStatus;
    }

    private JButton getNextButton() {
        return this.nextButton;
    }

    private void setNextButton(JButton nextButton) {
        this.nextButton = nextButton;
    }

    private JButton getPrevButton() {
        return this.prevButton;
    }

    private void setPrevButton(JButton prevButton) {
        this.prevButton = prevButton;
    }

    private JButton getUpButton() {
        return this.upButton;
    }

    private void setUpButton(JButton upButton) {
        this.upButton = upButton;
    }

    private class MyMouseAdapter
    extends MouseAdapter
    implements ActionListener {
        private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

        private MyMouseAdapter() {
        }

        public void mousePressed(MouseEvent event) {
            this.showPopup(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.showPopup(event);
        }

        private void showPopup(MouseEvent event) {
            if (event.isPopupTrigger()) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem mi = menu.add(Util.getString("CUSTOMIZE_THIS_CHART"));
                mi.setActionCommand("Customize");
                mi.addActionListener(this);
                menu.show(event.getComponent(), event.getX(), event.getY());
            }
        }

        public void actionPerformed(ActionEvent e) {
            AperiChartCustomizationDialog cd = new AperiChartCustomizationDialog(this.guiMain.getFrame(), AperiCustomizableChart.this.getSelfReference(), Util.getString("CHART_CUSTOMIZATION"), null, AperiCustomizableChart.this.getCurrentSettings(), AperiCustomizableChart.this.getDefaultSettings(), AperiCustomizableChart.this.getChart().getChartType() != 0, true, AperiCustomizableChart.this.getChart().getChartType() != 0, AperiCustomizableChart.this.getChart().getChartSubtype() == 0, AperiCustomizableChart.this.getChart().getChartType() == 0);
            GuiUtil.centerDialog(cd);
            cd.setVisible(true);
        }
    }
}

