/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeSet;
import org.eclipse.aperi.gui.charting.AperiChartAdapter;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.PluginSettings;

public class AperiEclipseChart
extends AperiChartAdapter
implements IUpdateNotifier {
    private static final long serialVersionUID = 1L;
    private IDeviceRenderer idr = null;
    private GeneratedChartState gcs = null;
    private Chart cm = null;
    private boolean needsRebuild = true;
    private ColorDefinition backgroundColor;
    private String yUnits = null;
    private double yScale = 1.0;
    protected static final String DECIMAL_FMT = "###,###.00";
    protected static final String NUMBER_FMT = "###,###";
    protected static final String BYTE_LABEL = "b";
    protected static final String KBYTE_LABEL = "KB";
    protected static final String MBYTE_LABEL = "MB";
    protected static final String GBYTE_LABEL = "GB";
    protected static final String TBYTE_LABEL = "TB";
    protected static final String PBYTE_LABEL = "PB";
    protected static final long BYTE_THRESHOLD = 1L;
    protected static final long KBYTE_THRESHOLD = 1024L;
    protected static final long MBYTE_THRESHOLD = 0x100000L;
    protected static final long GBYTE_THRESHOLD = 0x40000000L;
    protected static final long TBYTE_THRESHOLD = 0x10000000000L;
    protected static final long PBYTE_THRESHOLD = 0x4000000000000L;
    private static Date date;
    Double[][] doubleTrendSeries;
    Double[][] doubleYSeries;
    Double[] doubleXSeries;
    Calendar[] typedXSeries;
    private double max = 0.0;

    public void setChartOrientation(int chartOrientation) {
        super.setChartOrientation(chartOrientation);
        this.repaintIfNeeded();
    }

    public void setChartType(int chartType) {
        super.setChartType(chartType);
        this.repaintIfNeeded();
    }

    public void setLegendAnchor(int chartLegendAnchor) {
        super.setLegendAnchor(chartLegendAnchor);
        this.repaintIfNeeded();
    }

    public void setLegendOrientation(int chartLegendOrientation) {
        super.setLegendOrientation(chartLegendOrientation);
        this.repaintIfNeeded();
    }

    public void setLegendVisible(boolean chartLegendVisible) {
        super.setLegendVisible(chartLegendVisible);
        this.repaintIfNeeded();
    }

    public void setXAxisTitleText(String axisLabelText) {
        super.setXAxisTitleText(axisLabelText);
        this.repaintIfNeeded();
    }

    public void setXAxisTitleVisible(boolean axisLabelVisible) {
        super.setXAxisTitleVisible(axisLabelVisible);
        this.repaintIfNeeded();
    }

    public void setXCategories(String[] series) {
        super.setXCategories(series);
        this.repaintIfNeeded();
    }

    public void setYAxisTitleText(String axisLabelText) {
        super.setYAxisTitleText(axisLabelText);
        this.repaintIfNeeded();
    }

    public void setYAxisTitleVisible(boolean axisLabelVisible) {
        super.setYAxisTitleVisible(axisLabelVisible);
        this.repaintIfNeeded();
    }

    public void setYAxisScaling(int axisScaling) {
        super.setYAxisScaling(axisScaling);
        this.repaintIfNeeded();
    }

    public void setYSeries(Number[][] series) {
        int j;
        int i;
        boolean copyReqd = false;
        block0: for (i = 0; i < series.length; ++i) {
            if (series[i] == null) continue;
            for (j = 0; j < series[i].length; ++j) {
                if (series[i][j] == null || series[i][j] instanceof Double) continue;
                copyReqd = true;
                continue block0;
            }
        }
        if (copyReqd) {
            Number[][] newSeries = new Double[series.length][];
            for (i = 0; i < newSeries.length; ++i) {
                if (series[i] == null) continue;
                newSeries[i] = new Double[series[i].length];
                for (j = 0; j < series[i].length; ++j) {
                    newSeries[i][j] = series[i][j] != null && !(series[i][j] instanceof Double) ? new Double(series[i][j].doubleValue()) : (Double)series[i][j];
                }
            }
            super.setYSeries(newSeries);
        } else {
            super.setYSeries(series);
        }
        this.calcYUnitsAndScaling();
        this.repaintIfNeeded();
    }

    public void setYSeriesNames(String[] seriesNames) {
        super.setYSeriesNames(seriesNames);
        this.repaintIfNeeded();
    }

    public void setChartTitle(String chartTitle) {
        super.setChartTitle(chartTitle);
        this.repaintIfNeeded();
    }

    public void setYAxisTitleOrientation(int axisLabelOrientation) {
        super.setYAxisTitleOrientation(axisLabelOrientation);
        this.repaintIfNeeded();
    }

    public void setChartTitleVisible(boolean chartTitleVisible) {
        super.setChartTitleVisible(chartTitleVisible);
        this.repaintIfNeeded();
    }

    public void setXAxisTitleOrientation(int xisLabelOrientation) {
        super.setXAxisTitleOrientation(xisLabelOrientation);
        this.repaintIfNeeded();
    }

    public void setYValueLabelsVisible(boolean valueLabelsVisible) {
        super.setYValueLabelsVisible(valueLabelsVisible);
        this.repaintIfNeeded();
    }

    public void setYValueLabelsOrientation(int valueLabelsOrientation) {
        super.setYValueLabelsOrientation(valueLabelsOrientation);
        this.repaintIfNeeded();
    }

    public void setYValuePointsVisible(boolean valuePointsVisible) {
        super.setYValuePointsVisible(valuePointsVisible);
        this.repaintIfNeeded();
    }

    public void setYValueFormat(int valueFormat) {
        super.setYValueFormat(valueFormat);
        this.calcYUnitsAndScaling();
        this.repaintIfNeeded();
    }

    public AperiEclipseChart() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.idr = ps.getDevice("dv.SWING");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(this.getMinimumSize());
    }

    private void repaintIfNeeded() {
        this.setNeedsRebuild(true);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.backgroundColor = ColorDefinitionImpl.create((int)this.getBackground().getRed(), (int)this.getBackground().getGreen(), (int)this.getBackground().getBlue(), (int)this.getBackground().getAlpha());
        Graphics2D g2d = (Graphics2D)g;
        this.idr.setProperty("device.output.context", (Object)g2d);
        this.idr.setProperty("device.component", (Object)this);
        Dimension d = this.getSize();
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        if (this.isNeedsRebuild()) {
            this.cm = this.buildChart();
            this.setNeedsRebuild(false);
        }
        try {
            this.gcs = gr.build(this.idr.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.idr, this.gcs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Chart buildChart() {
        switch (this.getChartType()) {
            case 0: {
                return this.createHistoryChart();
            }
            case 1: {
                return this.createPieChart();
            }
            case 2: 
            case 3: {
                return this.createBarChart();
            }
        }
        throw new RuntimeException("Bad Chart Type " + this.getChartType());
    }

    public Chart createBarChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setSeriesThickness(1.0);
        cwaBar.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        cwaBar.getBlock().setBackground((Fill)this.backgroundColor);
        cwaBar.getBlock().getOutline().setVisible(false);
        cwaBar.setTransposed(this.getChartOrientation() == 0);
        Plot p = cwaBar.getPlot();
        p.getClientArea().setBackground(null);
        p.getOutline().setVisible(false);
        cwaBar.getTitle().getLabel().getCaption().setValue(this.getChartTitle());
        cwaBar.getTitle().getLabel().getCaption().getFont().setSize(8.0f);
        cwaBar.getTitle().setVisible(this.isChartTitleVisible());
        Legend lg = cwaBar.getLegend();
        lg.setVisible(this.isLegendVisible());
        lg.setPosition(this.mapPosition(this.getLegendAnchor()));
        lg.setAnchor(this.mapAnchor(this.getLegendAnchor()));
        lg.setOrientation(this.mapOrientation(this.getLegendOrientation()));
        lg.getText().getFont().setSize(8.0f);
        lg.setBackground(null);
        lg.getOutline().setVisible(false);
        lg.setItemType(LegendItemType.SERIES_LITERAL);
        Axis xAxisPrimary = cwaBar.getPrimaryBaseAxes()[0];
        this.setChartAxisLabelFormatter(xAxisPrimary, this.getXValueFormat());
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getTitle().getCaption().setValue(this.getXAxisTitleText());
        xAxisPrimary.getTitle().setVisible(this.isXAxisTitleVisible());
        Axis yAxisPrimary = cwaBar.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.setChartYAxisScaling(yAxisPrimary);
        if (this.getYAxisScaling() != 1) {
            this.setChartAxisLabelFormatter(yAxisPrimary, this.getYValueFormat());
        }
        yAxisPrimary.getTitle().setVisible(this.isYAxisTitleVisible());
        yAxisPrimary.getTitle().getCaption().setValue(this.getYAxisTitleText());
        if (cwaBar.isTransposed()) {
            yAxisPrimary.getTitle().getCaption().getFont().setRotation(this.mapRotation(this.getYAxisTitleOrientation()) - 90.0);
        } else {
            yAxisPrimary.getTitle().getCaption().getFont().setRotation(this.mapRotation(this.getYAxisTitleOrientation()));
        }
        yAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        yAxisPrimary.getLabel().setVisible(this.isYValueLabelsVisible());
        yAxisPrimary.getLabel().getCaption().getFont().setSize(8.0f);
        if (this.getChartOrientation() == 0) {
            yAxisPrimary.getLabel().getCaption().getFont().setRotation(90.0);
            xAxisPrimary.getLabel().getCaption().getFont().setRotation(-90.0);
        }
        if (this.getChartSubtype() == 0) {
            int seriesID;
            Series seCategory = SeriesImpl.create();
            seCategory.setDataSet((DataSet)TextDataSetImpl.create((Object)this.getXCategories()));
            SeriesDefinition sdX = SeriesDefinitionImpl.create();
            xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
            sdX.getSeries().add((Object)seCategory);
            SeriesDefinition sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().update(0);
            yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
            double max = 0.0;
            for (seriesID = this.getSeriesOffset(); seriesID < Math.min(this.getYSeries().length, this.getSeriesOffset() + this.getSeriesPerChart()); ++seriesID) {
                BarSeries bs = (BarSeries)BarSeriesImpl.create();
                bs.setSeriesIdentifier((Object)this.getYSeriesNames()[seriesID]);
                if ((Double)this.getYSeries()[seriesID][0] > max) {
                    max = (Double)this.getYSeries()[seriesID][0];
                }
                bs.setDataSet((DataSet)NumberDataSetImpl.create((Object)new Double[]{(Double)this.getYSeries()[seriesID][0]}));
                bs.getLabel().setVisible(this.isYValuePointsVisible());
                this.configureDataPoint((Series)bs);
                if (this.getChartType() == 3) {
                    bs.setStacked(true);
                }
                sdY.getSeries().add((Object)bs);
            }
            if (seriesID < this.getYSeries().length) {
                double remainder = 0.0;
                for (int i = seriesID; i < this.getYSeries().length; ++i) {
                    remainder += this.getYSeries()[i][0].doubleValue();
                }
                BarSeries remainderSeries = (BarSeries)BarSeriesImpl.create();
                remainderSeries.setSeriesIdentifier((Object)"Other");
                remainderSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)new double[]{remainder}));
                remainderSeries.getLabel().setVisible(this.isYValuePointsVisible());
                this.configureDataPoint((Series)remainderSeries);
                if (this.getChartType() == 3) {
                    remainderSeries.setStacked(true);
                }
                sdY.getSeries().add((Object)remainderSeries);
                if (remainder > max) {
                    max = remainder;
                }
            }
            if (this.getYValueFormat() != 8 && this.getYAxisScaling() != 1) {
                yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
                if (max == 0.0) {
                    max = 10.0;
                }
                double step = Math.round(max / 10.0);
                yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)Math.round(max + step)));
                yAxisPrimary.getScale().setStep(step);
                yAxisPrimary.getScale().setMinorGridsPerUnit(1);
            }
        } else {
            Series seCategory = SeriesImpl.create();
            seCategory.setDataSet((DataSet)this.extractCategoryNamesSubset());
            SeriesDefinition sdX = SeriesDefinitionImpl.create();
            xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
            sdX.getSeries().add((Object)seCategory);
            SeriesDefinition sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().update(0);
            yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
            for (int seriesID = 0; seriesID < this.getYSeries().length; ++seriesID) {
                BarSeries bs = (BarSeries)BarSeriesImpl.create();
                bs.setSeriesIdentifier((Object)this.getYSeriesNames()[seriesID]);
                bs.setDataSet((DataSet)this.extractSeriesDataSubset(this.getYSeries()[seriesID]));
                bs.getLabel().setVisible(this.isYValuePointsVisible());
                this.configureDataPoint((Series)bs);
                if (this.getChartType() == 3) {
                    bs.setStacked(true);
                }
                this.configureDataPoint((Series)bs);
                sdY.getSeries().add((Object)bs);
            }
        }
        return cwaBar;
    }

    private TextDataSet extractCategoryNamesSubset() {
        String[] names = (String[])this.getXCategories();
        String[] subset = new String[Math.min(this.getChartsPerView(), names.length - this.getCategoryOffset())];
        int j = 0;
        int i = this.getCategoryOffset();
        while (i < Math.min(names.length, this.getCategoryOffset() + this.getChartsPerView())) {
            subset[j] = names[i];
            ++i;
            ++j;
        }
        return TextDataSetImpl.create((Object)subset);
    }

    private void setChartAxisLabelFormatter(Axis axis, int valueFormat) {
        axis.setFormatSpecifier(this.getYValueFormatSpecifier(valueFormat));
        axis.getScale().unsetStep();
        switch (valueFormat) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                axis.setType(AxisType.LINEAR_LITERAL);
                break;
            }
            case 5: {
                axis.setType(AxisType.DATE_TIME_LITERAL);
                break;
            }
            case 7: {
                axis.setType(AxisType.TEXT_LITERAL);
                break;
            }
            case 8: {
                axis.setType(AxisType.LINEAR_LITERAL);
                axis.getScale().setStep(10.0);
                axis.getScale().setMax((DataElement)NumberDataElementImpl.create((double)100.0));
                break;
            }
            default: {
                axis.setType(AxisType.LINEAR_LITERAL);
            }
        }
    }

    private void setChartYAxisScaling(Axis yAxisPrimary) {
        if (this.getYAxisScaling() == 1) {
            yAxisPrimary.setPercent(true);
            yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
            yAxisPrimary.setFormatSpecifier((FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0'%'"));
            yAxisPrimary.getScale().setStep(10.0);
            yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)100.0));
        } else if (this.getYAxisScaling() == 2) {
            yAxisPrimary.setPercent(false);
            yAxisPrimary.setType(AxisType.LOGARITHMIC_LITERAL);
        } else {
            yAxisPrimary.setPercent(false);
            yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        }
    }

    private double mapRotation(int orientation) {
        if (orientation == 0) {
            return 0.0;
        }
        return 90.0;
    }

    private NumberDataSet extractCategoryData(Number[][] series, int seriesID) {
        Double[] values;
        if (this.getChartSubtype() != 0) {
            values = new Double[series.length];
            this.extractCategorySubset(series, seriesID, 0, values, series.length);
        } else if (this.getSeriesPerChart() < series.length - this.getSeriesOffset()) {
            int size = this.getSeriesPerChart() + 1;
            values = new Double[size];
            this.extractCategorySubset(series, seriesID, this.getSeriesOffset(), values, size - 1);
            double theRemainder = 0.0;
            for (int j = this.getSeriesOffset() + 1; j < series.length; ++j) {
                theRemainder += ((Double)series[j][seriesID]).doubleValue();
            }
            values[size - 1] = new Double(theRemainder);
        } else {
            int size = series.length - this.getSeriesOffset();
            values = new Double[size];
            this.extractCategorySubset(series, seriesID, this.getSeriesOffset(), values, size);
        }
        return NumberDataSetImpl.create((Object)values);
    }

    private TextDataSet extractYSeriesNamesSubset() {
        String[] subset;
        String[] names = this.getYSeriesNames();
        if (this.getChartSubtype() != 0) {
            subset = names;
        } else if (this.getSeriesPerChart() < names.length - this.getSeriesOffset()) {
            subset = new String[this.getSeriesPerChart() + 1];
            for (int i = 0; i < subset.length - 1; ++i) {
                subset[i] = names[this.getSeriesOffset() + i];
            }
            subset[subset.length - 1] = "Other";
        } else {
            subset = new String[names.length - this.getSeriesOffset()];
            for (int i = 0; i < subset.length; ++i) {
                subset[i] = names[this.getSeriesOffset() + i];
            }
        }
        return TextDataSetImpl.create((Object)subset);
    }

    private void extractCategorySubset(Number[][] series, int seriesID, int offset, Double[] values, int size) {
        for (int i = 0; i < size; ++i) {
            try {
                values[i] = (Double)series[i + offset][seriesID];
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private NumberDataSet extractSeriesDataSubset(Number[] series) {
        Double[] subset = new Double[Math.min(this.getChartsPerView(), series.length - this.getCategoryOffset())];
        int j = 0;
        int i = this.getCategoryOffset();
        while (i < Math.min(series.length, this.getCategoryOffset() + this.getChartsPerView())) {
            subset[j] = (Double)series[i];
            ++i;
            ++j;
        }
        return NumberDataSetImpl.create((Object)subset);
    }

    public Chart createHistoryChart() {
        this.convertSeries();
        ChartWithAxes cwaPlot = ChartWithAxesImpl.create();
        cwaPlot.setSeriesThickness(1.0);
        cwaPlot.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        cwaPlot.getBlock().setBackground((Fill)this.backgroundColor);
        cwaPlot.getBlock().getOutline().setVisible(false);
        Plot p = cwaPlot.getPlot();
        p.getClientArea().setBackground(null);
        p.getOutline().setVisible(false);
        cwaPlot.getTitle().getLabel().getCaption().setValue(this.getChartTitle());
        cwaPlot.getTitle().getLabel().getCaption().getFont().setSize(8.0f);
        cwaPlot.getTitle().setVisible(this.isChartTitleVisible());
        Legend lg = cwaPlot.getLegend();
        lg.setVisible(this.isLegendVisible());
        lg.setPosition(this.mapPosition(this.getLegendAnchor()));
        lg.setAnchor(this.mapAnchor(this.getLegendAnchor()));
        lg.setOrientation(this.mapOrientation(this.getLegendOrientation()));
        lg.getText().getFont().setSize(8.0f);
        lg.setBackground(null);
        lg.getOutline().setVisible(false);
        lg.setItemType(LegendItemType.SERIES_LITERAL);
        Axis xAxisPrimary = cwaPlot.getPrimaryBaseAxes()[0];
        this.setChartAxisLabelFormatter(xAxisPrimary, this.getXValueFormat());
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getTitle().getCaption().setValue(this.getXAxisTitleText());
        xAxisPrimary.getTitle().setVisible(this.isXAxisTitleVisible());
        xAxisPrimary.getLabel().getCaption().getFont().setSize(8.0f);
        xAxisPrimary.getLabel().getCaption().getFont().setRotation(90.0);
        Axis yAxisPrimary = cwaPlot.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)DateTimeDataSetImpl.create((Object)this.typedXSeries));
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.getSeries().add((Object)seCategory);
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().update(-2);
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        this.setChartYAxisScaling(yAxisPrimary);
        if (this.getYAxisScaling() != 1) {
            this.setChartAxisLabelFormatter(yAxisPrimary, this.getYValueFormat());
        }
        yAxisPrimary.getTitle().setVisible(this.isYAxisTitleVisible());
        yAxisPrimary.getTitle().getCaption().setValue(this.getYAxisTitleText());
        yAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        yAxisPrimary.getLabel().setVisible(this.isYValueLabelsVisible());
        yAxisPrimary.getLabel().getCaption().getFont().setSize(8.0f);
        if (this.getYValueFormat() != 8 && this.getYAxisScaling() != 1) {
            yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            if (this.max == 0.0) {
                this.max = 10.0;
            }
            double step = Math.round(this.max / 10.0);
            yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)Math.round(this.max + step)));
            yAxisPrimary.getScale().setStep(step);
            yAxisPrimary.getScale().setMinorGridsPerUnit(1);
        }
        for (int i = this.getSeriesOffset(); i < Math.min(this.getYSeriesNames().length, this.getSeriesOffset() + this.getSeriesPerChart()); ++i) {
            ScatterSeries mainSS = (ScatterSeries)ScatterSeriesImpl.create();
            mainSS.setSeriesIdentifier((Object)this.getYSeriesNames()[i]);
            mainSS.setDataSet((DataSet)NumberDataSetImpl.create((Object)this.doubleYSeries[i]));
            mainSS.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
            mainSS.getLineAttributes().setStyle(LineStyle.SOLID_LITERAL);
            mainSS.getLineAttributes().setVisible(true);
            mainSS.getMarker().setType(MarkerType.BOX_LITERAL);
            mainSS.getLabel().setVisible(this.isYValuePointsVisible());
            this.configureDataPoint((Series)mainSS);
            sdY.getSeries().add((Object)mainSS);
            if (!this.isTrendLineVisible() || this.doubleTrendSeries[i] == null) continue;
            ScatterSeries trendSS = (ScatterSeries)ScatterSeriesImpl.create();
            trendSS.setSeriesIdentifier((Object)"");
            trendSS.setDataSet((DataSet)NumberDataSetImpl.create((Object)this.doubleTrendSeries[i]));
            trendSS.getLineAttributes().setColor(ColorDefinitionImpl.BLUE());
            trendSS.getLineAttributes().setStyle(LineStyle.DASHED_LITERAL);
            trendSS.getLineAttributes().setVisible(true);
            trendSS.getMarker().setType(MarkerType.CROSSHAIR_LITERAL);
            trendSS.getLabel().setVisible(false);
            this.configureDataPoint((Series)trendSS);
            sdY.getSeries().add((Object)trendSS);
        }
        return cwaPlot;
    }

    private void convertSeries() {
        boolean fakeit = true;
        if (fakeit) {
            // empty if block
        }
        this.createTrendValues();
        this.buildXSeries();
        this.buildYSeries();
        this.buildTrendSeries();
        this.typeXaxis();
    }

    private void typeXaxis() {
        this.typedXSeries = new Calendar[this.doubleXSeries.length];
        for (int i = 0; i < this.doubleXSeries.length; ++i) {
            date.setTime((long)this.doubleXSeries[i].doubleValue());
            this.typedXSeries[i] = new CDateTime(date);
        }
    }

    private void buildTrendSeries() {
        this.doubleTrendSeries = new Double[this.getYValues().length][];
        for (int i = 0; i < this.doubleTrendSeries.length; ++i) {
            if (this.xTrend[i][0] == Double.MIN_VALUE) {
                this.doubleTrendSeries[i] = null;
                continue;
            }
            this.doubleTrendSeries[i] = new Double[this.doubleXSeries.length];
            Arrays.fill((Object[])this.doubleTrendSeries[i], null);
            int k = 0;
            for (int j = 0; j < this.doubleXSeries.length && k < this.xTrend[i].length; ++j) {
                if (this.xTrend[i][k] != this.doubleXSeries[j]) continue;
                this.doubleTrendSeries[i][j] = new Double(this.yTrend[i][k]);
                if (this.doubleTrendSeries[i][j] > this.max) {
                    this.max = this.doubleTrendSeries[i][j];
                }
                ++k;
            }
        }
    }

    private void buildYSeries() {
        this.doubleYSeries = new Double[this.getYValues().length][this.doubleXSeries.length];
        for (int i = 0; i < this.getYValues().length; ++i) {
            Arrays.fill((Object[])this.doubleYSeries[i], null);
            int k = 0;
            for (int j = 0; j < this.doubleXSeries.length && k < this.getXValues()[i].length; ++j) {
                if (this.getXValues()[i][k] != this.doubleXSeries[j]) continue;
                this.doubleYSeries[i][j] = new Double(this.getYValues()[i][k]);
                if (this.doubleYSeries[i][j] > this.max) {
                    this.max = this.doubleYSeries[i][j];
                }
                ++k;
            }
        }
    }

    private void buildXSeries() {
        int j;
        int i;
        TreeSet<Double> foo = new TreeSet<Double>();
        for (i = 0; i < this.getXValues().length; ++i) {
            for (j = 0; j < this.getXValues()[i].length; ++j) {
                foo.add(new Double(this.getXValues()[i][j]));
            }
        }
        for (i = 0; i < this.xTrend.length; ++i) {
            for (j = 0; j < this.xTrend[i].length; ++j) {
                foo.add(new Double(this.xTrend[i][j]));
            }
        }
        this.doubleXSeries = foo.toArray(new Double[foo.size()]);
    }

    public Chart createPieChart() {
        ChartWithoutAxes cwoaPie = ChartWithoutAxesImpl.create();
        cwoaPie.setSeriesThickness(20.0);
        cwoaPie.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        cwoaPie.getBlock().setBackground((Fill)this.backgroundColor);
        Plot p = cwoaPie.getPlot();
        p.getClientArea().setBackground(null);
        p.getOutline().setVisible(false);
        cwoaPie.getTitle().getLabel().getCaption().setValue(this.getChartTitle());
        cwoaPie.getTitle().getLabel().getCaption().getFont().setSize(8.0f);
        cwoaPie.getTitle().setVisible(this.isChartTitleVisible());
        Legend lg = cwoaPie.getLegend();
        lg.setVisible(this.isLegendVisible());
        lg.setPosition(this.mapPosition(this.getLegendAnchor()));
        lg.setAnchor(this.mapAnchor(this.getLegendAnchor()));
        lg.setOrientation(this.mapOrientation(this.getLegendOrientation()));
        lg.getText().getFont().setSize(8.0f);
        lg.setBackground(null);
        lg.getOutline().setVisible(false);
        if (this.getXCategories() == null || this.getXCategories().length == 1) {
            cwoaPie.setGridColumnCount(1);
        } else {
            cwoaPie.setGridColumnCount((int)Math.round(Math.sqrt(this.getChartsPerView())));
        }
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)this.extractYSeriesNamesSubset());
        SeriesDefinition sd = SeriesDefinitionImpl.create();
        cwoaPie.getSeriesDefinitions().add((Object)sd);
        sd.getSeriesPalette().update(0);
        sd.getSeries().add((Object)seCategory);
        SeriesDefinition sdCity = SeriesDefinitionImpl.create();
        sd.getSeriesDefinitions().add((Object)sdCity);
        Number[][] ySeries = this.getYSeries();
        for (int i = this.getCategoryOffset(); i < Math.min(this.getXCategories().length, this.getCategoryOffset() + this.getChartsPerView()); ++i) {
            PieSeries sePie1 = (PieSeries)PieSeriesImpl.create();
            sePie1.setRatio(0.0);
            sePie1.setExplosion(0);
            sePie1.setSeriesIdentifier(this.getXCategories()[i]);
            sePie1.setDataSet((DataSet)this.extractCategoryData(ySeries, i));
            sePie1.setTitlePosition(Position.BELOW_LITERAL);
            sePie1.getTitle().getCaption().getFont().setSize(8.0f);
            this.configureDataPoint((Series)sePie1);
            sdCity.getSeries().add((Object)sePie1);
        }
        return cwoaPie;
    }

    private void configureDataPoint(Series se) {
        se.getLabel().setVisible(this.isYValuePointsVisible());
        if (this.getChartType() == 0) {
            se.setLabelPosition(Position.ABOVE_LITERAL);
        } else {
            se.setLabelPosition(Position.INSIDE_LITERAL);
        }
        DataPoint dp = se.getDataPoint();
        dp.getComponents().clear();
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, (FormatSpecifier)this.getYValueFormatSpecifier(this.getYValueFormat())));
        dp.setSeparator(" ");
        if (this.getChartType() == 1) {
            dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.BASE_VALUE_LITERAL, null));
        } else {
            dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.SERIES_VALUE_LITERAL, null));
        }
        if (!this.isYValuePointsVisible()) {
            se.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)1, null))));
        }
    }

    private FormatSpecifier getYValueFormatSpecifier(int valueFormat) {
        JavaDateFormatSpecifier formatSpecifier = null;
        switch (valueFormat) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                formatSpecifier = JavaNumberFormatSpecifierImpl.create((String)(this.getYJavaNumberFormat() + " " + this.getYUnits()));
                ((JavaNumberFormatSpecifier)formatSpecifier).setMultiplier(1.0 / this.getYScale());
                break;
            }
            case 5: {
                formatSpecifier = JavaDateFormatSpecifierImpl.create((String)"dd-MMM-yy:HH:mm:ss");
                break;
            }
            case 8: {
                formatSpecifier = JavaNumberFormatSpecifierImpl.create((String)"0'%'");
                break;
            }
            default: {
                formatSpecifier = null;
            }
        }
        return formatSpecifier;
    }

    private Anchor mapAnchor(int anchor) {
        return Anchor.get((int)anchor);
    }

    private Position mapPosition(int anchor) {
        switch (anchor) {
            case 0: 
            case 1: 
            case 7: {
                return Position.ABOVE_LITERAL;
            }
            case 3: 
            case 4: 
            case 5: {
                return Position.BELOW_LITERAL;
            }
            case 2: {
                return Position.RIGHT_LITERAL;
            }
            case 6: {
                return Position.LEFT_LITERAL;
            }
        }
        return Position.OUTSIDE_LITERAL;
    }

    private Orientation mapOrientation(int orientation) {
        if (orientation == 1) {
            return Orientation.VERTICAL_LITERAL;
        }
        return Orientation.HORIZONTAL_LITERAL;
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.gcs.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.repaint();
    }

    public void repaintChart() {
        this.repaint();
    }

    public boolean isNeedsRebuild() {
        return this.needsRebuild;
    }

    public void setNeedsRebuild(boolean needsRebuild) {
        this.needsRebuild = needsRebuild;
    }

    protected String getYUnits() {
        return this.yUnits;
    }

    private void calcYUnitsAndScaling() {
        switch (this.getYValueFormat()) {
            case 1: {
                this.calcByteUnitsAndScaling();
                break;
            }
            case 3: {
                this.setYUnits("msecs");
                this.setYScale(1.0);
                break;
            }
            case 4: {
                this.setYUnits("days");
                this.setYScale(86400.0);
                break;
            }
            default: {
                this.setYUnits("");
                this.setYScale(1.0);
            }
        }
    }

    private void calcByteUnitsAndScaling() {
        block6: {
            block5: {
                if (this.getChartType() == 0) break block5;
                Number[][] yValues = this.getYSeries();
                if (yValues == null) break block6;
                this.setYUnits(BYTE_LABEL);
                this.setYScale(1.0);
                for (int i = 0; i < yValues.length; ++i) {
                    for (int j = 0; j < yValues[i].length; ++j) {
                        this.setByteUnitsAndScaling(yValues[i][j].doubleValue());
                    }
                }
                break block6;
            }
            double[][] yValues = this.getYValues();
            if (yValues != null) {
                this.setYUnits(BYTE_LABEL);
                this.setYScale(1.0);
                for (int i = 0; i < yValues.length; ++i) {
                    for (int j = 0; j < yValues[i].length; ++j) {
                        this.setByteUnitsAndScaling(yValues[i][j]);
                    }
                }
            }
        }
    }

    private void setByteUnitsAndScaling(double yValue) {
        if (yValue > 1.125899906842624E15) {
            this.setYUnits(PBYTE_LABEL);
            this.setYScale(1.125899906842624E15);
        } else if (yValue > 1.099511627776E12) {
            this.setYUnits(TBYTE_LABEL);
            this.setYScale(1.099511627776E12);
        } else if (yValue > 1.073741824E9) {
            this.setYUnits(GBYTE_LABEL);
            this.setYScale(1.073741824E9);
        } else if (yValue > 1048576.0) {
            this.setYUnits(MBYTE_LABEL);
            this.setYScale(1048576.0);
        } else if (yValue > 1024.0) {
            this.setYUnits(KBYTE_LABEL);
            this.setYScale(1024.0);
        }
    }

    protected String getYJavaNumberFormat() {
        switch (this.getYValueFormat()) {
            case 1: 
            case 2: {
                return DECIMAL_FMT;
            }
        }
        return NUMBER_FMT;
    }

    private double getYScale() {
        return this.yScale;
    }

    private void setYScale(double scale) {
        this.yScale = scale;
    }

    private void setYUnits(String units) {
        this.yUnits = units;
    }

    public void setXCategories(Object[] series) {
        super.setXCategories(series);
        this.repaintIfNeeded();
    }

    public void setXValueFormat(int valueFormat) {
        super.setXValueFormat(valueFormat);
        this.repaintIfNeeded();
    }

    public void setXYValues(double[][] xValues, double[][] yValues) {
        super.setXYValues(xValues, yValues);
        this.calcYUnitsAndScaling();
        this.repaintIfNeeded();
    }

    public void setTrendLineVisible(boolean trendLineVisible) {
        super.setTrendLineVisible(trendLineVisible);
        this.repaintIfNeeded();
    }

    public void setChartsPerView(int start, int count) {
        super.setChartsPerView(start, count);
        this.repaintIfNeeded();
    }

    public void setSeriesPerChart(int start, int count) {
        super.setSeriesPerChart(start, count);
        this.repaintIfNeeded();
    }

    public void setChartSubtype(int chartSubtype) {
        super.setChartSubtype(chartSubtype);
        this.repaintIfNeeded();
    }

    static {
        System.setProperty("STANDALONE", "true");
        System.setProperty("RUN_UNDER_ECLIPSE", "false");
        date = new Date();
    }
}

