/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;

public class ManageElementManagersPanel
extends GridBagPanel {
    HashMap model = new HashMap();
    private String NO_MAPPING;
    private DirtyListenerInterface dirtyListener;
    JButton firstDeleteButton = null;
    JButton lastDeleteButton = null;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();

    public ManageElementManagersPanel(String[][] model) {
        this.NO_MAPPING = Util.getString("ELEMENT_MANAGER_DELETED");
        this.setTitle(Util.getString("ELEMENT_MANAGER_DDI_TITLE"));
        this.buildPanel(model);
        this.addComponentListener(new DeleteButtonAdapter());
    }

    private void buildPanel(String[][] model) {
        this.firstDeleteButton = this.addDeleteAllButton(model.length);
        for (int i = 0; i < model.length; ++i) {
            this.buildRow(model[i], i);
        }
        if (model.length > 0) {
            this.lastDeleteButton = this.addDeleteAllButton(model.length);
        }
        this.createStretchBox();
    }

    private JButton addDeleteAllButton(int rows) {
        JButton deleteButton = new JButton(Util.getString("ELEMENT_MANAGER_DELETE_ALL_BUTTON"));
        GuiUtil.setAccessible(deleteButton, deleteButton.getText(), deleteButton.getText());
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int choice = JOptionPane.showConfirmDialog(ManageElementManagersPanel.this.guiMain.getFrame(), Util.getString("ELEMENT_MANAGER_DELETE_ALL"), Util.getString("ELEMENT_MANAGER_DELETE_ALL_TITLE"), 0);
                if (choice == 0) {
                    Iterator i = ManageElementManagersPanel.this.model.keySet().iterator();
                    while (i.hasNext()) {
                        ManageElementManagersPanel.this.deleteAllValues((String)i.next());
                    }
                    ManageElementManagersPanel.this.talkDirty(null);
                }
            }
        });
        deleteButton.setEnabled(this.capabilities.isAperiAdmin() && rows > 0);
        this.add(deleteButton);
        this.newRow();
        return deleteButton;
    }

    private void buildRow(String[] rowData, int order) {
        JComponent managerTextField;
        String bigGuid = rowData[0] + " " + rowData[1];
        BoldLabel label = new BoldLabel(bigGuid);
        this.add(label);
        String[] tmpData = new String[rowData.length - 2];
        System.arraycopy(rowData, 2, tmpData, 0, rowData.length - 2);
        if (tmpData.length == 1) {
            managerTextField = new JTextField(tmpData[0]);
            ((JTextField)managerTextField).setEditable(false);
        } else {
            managerTextField = new JComboBox<String>(tmpData);
        }
        GuiUtil.setAccessibleLabel(label, managerTextField, "", bigGuid, bigGuid);
        this.add(managerTextField, 21, 2);
        RowData rd = new RowData(rowData, managerTextField, order);
        this.model.put(bigGuid, rd);
        JButton editButton = new JButton(Util.getString("LABEL_EDIT"));
        editButton.setActionCommand(bigGuid);
        editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ManageElementManagersPanel.this.editTextField(ae.getActionCommand());
            }
        });
        editButton.setEnabled(this.capabilities.isAperiAdmin());
        this.add((JComponent)editButton, 21, 0);
        JButton deleteButton = new JButton(Util.getString("LABEL_DELETE"));
        deleteButton.setActionCommand(bigGuid);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ManageElementManagersPanel.this.deleteTextField(ae.getActionCommand());
            }
        });
        deleteButton.setEnabled(this.capabilities.isAperiAdmin());
        this.add((JComponent)deleteButton, 21, 0);
        this.newRow();
    }

    protected void editTextField(String BigGuid) {
        String manager = this.getTextValue(BigGuid);
        manager = (String)JOptionPane.showInputDialog(this.guiMain.getFrame(), Util.getString("GUI8208I", BigGuid), Util.getString("ELEMENT_MANAGER_EDIT_TITLE"), 3, null, null, manager);
        if (manager != null) {
            this.setTextValue(BigGuid, manager);
            this.talkDirty(null);
        }
    }

    protected void deleteTextField(String BigGuid) {
        if (this.NO_MAPPING.equals(this.getTextValue(BigGuid))) {
            return;
        }
        int choice = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), Util.getString("GUI8202I", this.getTextValue(BigGuid), BigGuid), Util.getString("ELEMENT_MANAGER_DELETE_TITLE"), 0);
        if (choice == 0) {
            this.setTextValue(BigGuid, this.NO_MAPPING);
            this.talkDirty(null);
        }
    }

    private void setTextValue(String key, String value) {
        JComponent textField = ((RowData)this.model.get((Object)key)).textField;
        if (value.trim().equals("")) {
            return;
        }
        if (textField instanceof JTextField) {
            ((JTextField)textField).setText(value);
        } else if (textField instanceof JComboBox) {
            int i = ((JComboBox)textField).getSelectedIndex();
            ((JComboBox)textField).removeItemAt(i);
            if (!this.NO_MAPPING.equals(value) || this.NO_MAPPING.equals(value) && ((JComboBox)textField).getItemCount() == 0) {
                ((JComboBox)textField).insertItemAt(value, i);
                ((JComboBox)textField).setSelectedIndex(i);
            }
        }
    }

    private void deleteAllValues(String key) {
        JComponent textField = ((RowData)this.model.get((Object)key)).textField;
        if (textField instanceof JTextField) {
            ((JTextField)textField).setText(this.NO_MAPPING);
        } else if (textField instanceof JComboBox) {
            ((JComboBox)textField).removeAllItems();
            ((JComboBox)textField).addItem(this.NO_MAPPING);
        }
    }

    private String getTextValue(String key) {
        JComponent textField = ((RowData)this.model.get((Object)key)).textField;
        if (textField instanceof JTextField) {
            return ((JTextField)textField).getText();
        }
        return (String)((JComboBox)textField).getSelectedItem();
    }

    public String[][] getModel(TreeSet modifiedLines) {
        String[][] tempModel = new String[this.model.size()][];
        int count = 0;
        for (String key : this.model.keySet()) {
            RowData value = (RowData)this.model.get(key);
            String[] textFieldData = value.getTextFieldData();
            if (textFieldData != null) {
                ++count;
                tempModel[value.order] = new String[2 + textFieldData.length];
                tempModel[value.order][0] = value.rowData[0];
                tempModel[value.order][1] = value.rowData[1];
                System.arraycopy(textFieldData, 0, tempModel[value.order], 2, textFieldData.length);
                if (modifiedLines == null || !value.isDataModified()) continue;
                modifiedLines.add(value.rowData[0]);
                continue;
            }
            if (modifiedLines == null) continue;
            modifiedLines.add(value.rowData[0]);
        }
        String[][] finalModel = new String[count][];
        int k = 0;
        for (int j = 0; j < tempModel.length; ++j) {
            if (tempModel[j] == null) continue;
            finalModel[k++] = tempModel[j];
        }
        return finalModel;
    }

    private void talkDirty(String label) {
        if (this.dirtyListener != null) {
            this.dirtyListener.dirtyTalk(this, label);
        }
    }

    public void addDirtyListener(DirtyListenerInterface dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public void removeDirtyListener(DirtyListenerInterface dirtyListener) {
        if (this.dirtyListener == this.dirtyListener) {
            this.dirtyListener = null;
        }
    }

    private class DeleteButtonAdapter
    extends ComponentAdapter {
        private DeleteButtonAdapter() {
        }

        public void componentShown(ComponentEvent e) {
            this.activateLastDelete((ManageElementManagersPanel)e.getComponent());
        }

        public void componentResized(ComponentEvent e) {
            this.activateLastDelete((ManageElementManagersPanel)e.getComponent());
        }

        private void activateLastDelete(ManageElementManagersPanel pane) {
            Rectangle visible = pane.getVisibleRect();
            Rectangle bounds = pane.getBounds();
            if (bounds.height == visible.height) {
                if (pane.lastDeleteButton != null && pane.lastDeleteButton.isVisible()) {
                    pane.lastDeleteButton.setVisible(false);
                }
            } else if (pane.lastDeleteButton != null && !pane.lastDeleteButton.isVisible()) {
                pane.lastDeleteButton.setVisible(true);
            }
        }
    }

    private class RowData {
        JComponent textField;
        String[] rowData;
        int order;

        public RowData(String[] rowData, JComponent textField, int order) {
            this.rowData = rowData;
            this.textField = textField;
            this.order = order;
        }

        String[] getTextFieldData() {
            if (this.textField instanceof JTextField) {
                if (!ManageElementManagersPanel.this.NO_MAPPING.equals(((JTextField)this.textField).getText())) {
                    return new String[]{((JTextField)this.textField).getText()};
                }
                return null;
            }
            if (((JComboBox)this.textField).getItemCount() == 0 || ((JComboBox)this.textField).getItemCount() == 1 && ManageElementManagersPanel.this.NO_MAPPING.equals((String)((JComboBox)this.textField).getItemAt(0))) {
                return null;
            }
            int count = ((JComboBox)this.textField).getItemCount();
            TreeSet<String> data = new TreeSet<String>();
            ArrayList<String> al = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                if (!data.add((String)((JComboBox)this.textField).getItemAt(i))) continue;
                al.add((String)((JComboBox)this.textField).getItemAt(i));
            }
            return al.toArray(new String[al.size()]);
        }

        boolean isDataModified() {
            int i;
            boolean modified = false;
            if (this.textField instanceof JTextField) {
                return ((JTextField)this.textField).getText().equals(this.rowData[2]);
            }
            int count = ((JComboBox)this.textField).getItemCount();
            if (count != this.rowData.length - 2) {
                return true;
            }
            TreeSet tsFieldData = new TreeSet();
            for (i = 0; i < count; ++i) {
                tsFieldData.add(((JComboBox)this.textField).getItemAt(i));
            }
            for (i = 2; i < this.rowData.length; ++i) {
                if (tsFieldData.remove(this.rowData[i])) continue;
                modified = true;
            }
            return modified || tsFieldData.size() > 0;
        }
    }
}

