/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComponent;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.common.DDIInitialState;
import org.eclipse.aperi.gui.common.DDIState;
import org.eclipse.aperi.gui.common.DDIStateInterface;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;
import org.eclipse.aperi.gui.common.RolesGridBagPanel;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;
import org.eclipse.aperi.server.req.RolesUpdateReq;
import org.eclipse.aperi.server.req.ServerRequest;

public class RolesDDI
extends DataDisplayInfo
implements DDIStateInterface {
    private DDIState state = DDIInitialState.getInstance();
    private Hashtable dirtyRows = new Hashtable();
    private boolean closing = false;
    DDIStateInterface selfReference;
    ActionListener saveActionListener;
    HashMap model = null;

    private void refreshModel(Serializable smodel) {
        RoleData[] trd = ((RolesUpdateReq)smodel).roleData;
        this.model = new HashMap();
        for (int idx = 0; idx < trd.length; ++idx) {
            this.model.put(trd[idx].getRoleName(), trd[idx]);
        }
    }

    public void dirtyPanel() {
        guiMain.setSaveActionEnabled(true, false);
        guiMain.setSaveActionToolTip(Util.getString("ROLES_CFG_SAVE"));
        guiMain.addSaveActionListener(this.saveActionListener);
    }

    public void cleanPanel() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this.saveActionListener);
    }

    public void showPanel() {
        this.show();
        this.cleanPanel();
        if (this.changesPending()) {
            this.dirtyPanel();
        }
    }

    public void buildPanel() {
        this.panel = new RolesGridBagPanel(this.model);
        ((RolesGridBagPanel)this.panel).addDirtyListener(new DirtyListenerInterface(){

            public void dirtyTalk(JComponent component, String label) {
                if (RolesDDI.this.dirtyRows != null) {
                    RolesDDI.this.dirtyRows.put(label, "");
                }
                RolesDDI.this.state = RolesDDI.this.state.dirty(RolesDDI.this.selfReference);
            }
        });
    }

    public void destroyPanel() {
        this.panel = null;
    }

    public void saveState() {
        this.model = ((RolesGridBagPanel)this.panel).getModel();
    }

    public void persistState() {
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    RolesDDI.this.state = RolesDDI.this.state.saved(RolesDDI.this.selfReference);
                    if (RolesDDI.this.dirtyRows != null) {
                        RolesDDI.this.dirtyRows.clear();
                    }
                    if (RolesDDI.this.closing) {
                        RolesDDI.this.remove();
                    }
                }
                RolesDDI.this.closing = false;
            }
        }, this.preparePersistRequest());
    }

    private Request preparePersistRequest() {
        RoleData[] req = new RoleData[this.model.size()];
        Iterator i = this.model.keySet().iterator();
        int idx = 0;
        while (i.hasNext()) {
            RoleData roleData = (RoleData)this.model.get(i.next());
            if (this.dirtyRows != null && !this.dirtyRows.containsKey(roleData.getRoleName())) continue;
            req[idx++] = roleData;
        }
        if (idx < req.length) {
            RoleData[] req1 = new RoleData[idx];
            System.arraycopy(req, 0, req1, 0, idx);
            req = req1;
            req1 = null;
        }
        Request request = new Request();
        ServerRequest.updateGroup2Roles(request, (byte)2, req);
        return request;
    }

    private void fetchModel() {
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    RolesDDI.this.refreshModel(response.responseData);
                    RolesDDI.this.state = RolesDDI.this.state.show(RolesDDI.this.selfReference);
                    if (RolesDDI.this.dirtyRows != null) {
                        RolesDDI.this.dirtyRows.clear();
                    }
                } else {
                    RolesDDI.this.treeNode.ddi = null;
                }
            }
        }, this.prepareRefreshRequest());
    }

    private Request prepareRefreshRequest() {
        Request request = new Request();
        ServerRequest.updateGroup2Roles(request, (byte)4, null);
        return request;
    }

    public RolesDDI(BaseTreeNode node) {
        super(Util.getString("ROLES_CFG_MAIN_TITLE"));
        this.treeNode = node;
        node.ddi = this;
        this.selfReference = this;
        this.saveActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (((RolesGridBagPanel)RolesDDI.this.panel).validatePanel(RolesDDI.this.dirtyRows)) {
                    RolesDDI.this.closing = false;
                    RolesDDI.this.state = RolesDDI.this.state.persist(RolesDDI.this.selfReference);
                }
            }
        };
        this.fetchModel();
    }

    public void panelToBeNulled() {
        this.state = this.state.nullPanel(this);
    }

    public boolean changesPending() {
        return this.state.isDirty();
    }

    public boolean isEditable() {
        return true;
    }

    public void saveAndClose() {
        if (((RolesGridBagPanel)this.panel).validatePanel(this.dirtyRows)) {
            this.closing = true;
            this.state = this.state.persist(this);
        }
    }

    public void losingFocus() {
        this.state = this.state.hide(this);
    }

    public void reDisplay() {
        this.state = this.state.show(this);
    }

    public void goingAway() {
        this.treeNode.ddi = null;
    }

    public String getHelpID() {
        return "adm_cfg_rolegroupmappings";
    }
}

