/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.common.model;

import java.io.Serializable;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.common.model.DataAccessor;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.request.Response;

public class DiskDataController {
    private static DiskDataController diskDataController = null;

    public static DiskDataController getInstance() {
        if (diskDataController == null) {
            diskDataController = new DiskDataController();
        }
        return diskDataController;
    }

    public static void sendDiskSubsystemJobRequest(GuiRequestor requestor, GUIRequestData requestData) {
        DataAccessor.sendJobRequest(requestor, "org.eclipse.aperi.server.handler.scheduler.SubsystemActionHandler", DeviceRequest.DR_DISK, requestData);
    }

    public static void sendDiskFabricJobRequest(GuiRequestor requestor, GUIRequestData requestData) {
        DataAccessor.sendJobRequest(requestor, "org.eclipse.aperi.server.handler.scheduler.FabricActionHandler", DeviceRequest.DR_FABRIC, requestData);
    }

    public void createVolumes(GuiRequestor requestor, long size, String stgpoolId, long numOfVolumes, String[] volNames) {
        this.createVolumes(requestor, size, stgpoolId, numOfVolumes, volNames, true);
    }

    public void createVolumes(GuiRequestor requestor, long size, String stgpoolId, long numOfVolumes, String[] volNames, boolean willWaitForComplete) {
        GUIRequestData reqData = new GUIRequestData(0);
        reqData.setWillWaitForComplete(willWaitForComplete);
        reqData.addParameter("volume.size", new Long(size));
        reqData.addParameter("storagepool.id", (Serializable)((Object)stgpoolId));
        reqData.addParameter("num.of.volumes", new Long(numOfVolumes));
        reqData.addParameter("volume.names", (Serializable)volNames);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void createVolumesExt(GuiRequestor requestor, long[] volSizes, String[] stgpoolIds, String[] volNames, HashMap goal) {
        this.createVolumesExt(requestor, volSizes, stgpoolIds, volNames, goal, true);
    }

    public void createVolumesExt(GuiRequestor requestor, long[] volSizes, String[] stgpoolIds, String[] volNames, HashMap goal, boolean willWaitForComplete) {
        GUIRequestData reqData = new GUIRequestData(6);
        reqData.setWillWaitForComplete(willWaitForComplete);
        reqData.addParameter("volume.sizes", (Serializable)volSizes);
        reqData.addParameter("storagepool.ids", (Serializable)stgpoolIds);
        reqData.addParameter("volume.names", (Serializable)volNames);
        reqData.addParameter("volume.crgoal", goal);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void createVDisks(GuiRequestor requestor, long size, String mdiskGroupId, String[] vdiskNames, boolean formatOnCreate, int vdiskType, int ioGroupId, String[] mdiskIds, int numOfVDisks) {
        this.createVDisks(requestor, size, mdiskGroupId, vdiskNames, formatOnCreate, vdiskType, ioGroupId, mdiskIds, numOfVDisks, true);
    }

    public void createVDisks(GuiRequestor requestor, long size, String mdiskGroupId, String[] vdiskNames, boolean formatOnCreate, int vdiskType, int ioGroupId, String[] mdiskIds, int numOfVDisks, boolean willWaitForComplete) {
        GUIRequestData reqData = new GUIRequestData(1);
        reqData.setWillWaitForComplete(willWaitForComplete);
        reqData.addParameter("vdisk.size", new Long(size));
        reqData.addParameter("mdiskgroup.id", (Serializable)((Object)mdiskGroupId));
        reqData.addParameter("vdisk.names", (Serializable)vdiskNames);
        reqData.addParameter("vdisk.format.oncreate", new Boolean(formatOnCreate));
        reqData.addParameter("vdisk.type", new Integer(vdiskType));
        reqData.addParameter("iogroup.id", new Integer(ioGroupId));
        reqData.addParameter("mdisk.ids", (Serializable)mdiskIds);
        reqData.addParameter("num.of.vdisks", new Integer(numOfVDisks));
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void addMisks(GuiRequestor requestor, String mdiskGroupId, String[] mdiskIds) {
        GUIRequestData reqData = new GUIRequestData(2);
        reqData.addParameter("mdiskgroup.id", (Serializable)((Object)mdiskGroupId));
        reqData.addParameter("mdisk.ids", (Serializable)mdiskIds);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void deleteVolumes(GuiRequestor requestor, String[] volumeIds) {
        GUIRequestData reqData = new GUIRequestData(3);
        reqData.addParameter("volume.ids", (Serializable)volumeIds);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void assignPorts(GuiRequestor requestor, String[] volumeIds, String[] systemPortWwpns, String[] hostPortWwpns) {
        this.assignPorts(requestor, volumeIds, systemPortWwpns, hostPortWwpns, true);
    }

    public void assignPorts(GuiRequestor requestor, String[] volumeIds, String[] systemPortWwpns, String[] hostPortWwpns, boolean willWaitForComplete) {
        GUIRequestData reqData = new GUIRequestData(4);
        reqData.setWillWaitForComplete(willWaitForComplete);
        reqData.addParameter("volume.ids", (Serializable)volumeIds);
        reqData.addParameter("system.ports", (Serializable)systemPortWwpns);
        reqData.addParameter("host.ports", (Serializable)hostPortWwpns);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void createVolumesAndAssignPorts(GuiRequestor requestor, long size, String stgpoolId, long numOfVolumes, String[] volNames, String[] systemPortWwpns, String[] hostPortWwpns) {
        GUIRequestData reqData = new GUIRequestData(7);
        reqData.addParameter("volume.size", new Long(size));
        reqData.addParameter("storagepool.id", (Serializable)((Object)stgpoolId));
        reqData.addParameter("num.of.volumes", new Long(numOfVolumes));
        reqData.addParameter("volume.names", (Serializable)volNames);
        reqData.addParameter("system.ports", (Serializable)systemPortWwpns);
        reqData.addParameter("host.ports", (Serializable)hostPortWwpns);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void createVolumesExtAndAssignPorts(GuiRequestor requestor, long[] volSizes, String[] stgpoolIds, String[] volNames, HashMap goal, String[] systemPortWwpns, String[] hostPortWwpns) {
        GUIRequestData reqData = new GUIRequestData(8);
        reqData.addParameter("volume.sizes", (Serializable)volSizes);
        reqData.addParameter("storagepool.ids", (Serializable)stgpoolIds);
        reqData.addParameter("volume.names", (Serializable)volNames);
        reqData.addParameter("volume.crgoal", goal);
        reqData.addParameter("system.ports", (Serializable)systemPortWwpns);
        reqData.addParameter("host.ports", (Serializable)hostPortWwpns);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void createVDisksAndAssignPorts(GuiRequestor requestor, long size, String mdiskGroupId, String[] vdiskNames, boolean formatOnCreate, int vdiskType, int ioGroupId, String[] mdiskIds, int numOfVDisks, String[] systemPortWwpns, String[] hostPortWwpns) {
        GUIRequestData reqData = new GUIRequestData(9);
        reqData.addParameter("vdisk.size", new Long(size));
        reqData.addParameter("mdiskgroup.id", (Serializable)((Object)mdiskGroupId));
        reqData.addParameter("vdisk.names", (Serializable)vdiskNames);
        reqData.addParameter("vdisk.format.oncreate", new Boolean(formatOnCreate));
        reqData.addParameter("vdisk.type", new Integer(vdiskType));
        reqData.addParameter("iogroup.id", new Integer(ioGroupId));
        reqData.addParameter("mdisk.ids", (Serializable)mdiskIds);
        reqData.addParameter("num.of.vdisks", new Integer(numOfVDisks));
        reqData.addParameter("system.ports", (Serializable)systemPortWwpns);
        reqData.addParameter("host.ports", (Serializable)hostPortWwpns);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void unassignPorts(GuiRequestor requestor, String[] volumeIds, String[] hostPortWwpns) {
        this.unassignPorts(requestor, volumeIds, hostPortWwpns, true);
    }

    public void unassignPorts(GuiRequestor requestor, String[] volumeIds, String[] hostPortWwpns, boolean willWaitForComplete) {
        GUIRequestData reqData = new GUIRequestData(5);
        reqData.setWillWaitForComplete(willWaitForComplete);
        reqData.addParameter("volume.ids", (Serializable)volumeIds);
        reqData.addParameter("host.ports", (Serializable)hostPortWwpns);
        DiskDataController.sendDiskSubsystemJobRequest(requestor, reqData);
    }

    public void createZone(GuiRequestor requestor, String fabricId, String zoneSetName, String zoneName, String[] portWwpns) {
        GUIRequestData reqData = new GUIRequestData(30);
        reqData.addParameter("fabric.id", (Serializable)((Object)fabricId));
        reqData.addParameter("zoneset.name", (Serializable)((Object)zoneSetName));
        reqData.addParameter("zone.name", (Serializable)((Object)zoneName));
        reqData.addParameter("ports", (Serializable)portWwpns);
        DiskDataController.sendDiskFabricJobRequest(requestor, reqData);
    }

    public void updateZone(GuiRequestor requestor, String fabricId, String zoneSetName, String zoneName, String[] portWwpns) {
        GUIRequestData reqData = new GUIRequestData(31);
        reqData.addParameter("fabric.id", (Serializable)((Object)fabricId));
        reqData.addParameter("zoneset.name", (Serializable)((Object)zoneSetName));
        reqData.addParameter("zone.name", (Serializable)((Object)zoneName));
        reqData.addParameter("ports", (Serializable)portWwpns);
        DiskDataController.sendDiskFabricJobRequest(requestor, reqData);
    }

    public void releaseFabric(GuiRequestor requestor, String fabricId) {
        GUIRequestData reqData = new GUIRequestData(32);
        reqData.addParameter("fabric.id", (Serializable)((Object)fabricId));
        DataAccessor.sendDeviceRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.DiskDeviceActionHandler", DeviceRequest.DR_DISK, reqData);
    }

    public void rollbackFabricTransaction(GuiRequestor requestor, String fabricId) {
        GUIRequestData reqData = new GUIRequestData(33);
        reqData.addParameter("fabric.id", (Serializable)((Object)fabricId));
        DataAccessor.sendDeviceRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.DiskDeviceActionHandler", DeviceRequest.DR_DISK, reqData);
    }

    public static void test() {
        DiskDataController diskAccessor = DiskDataController.getInstance();
        diskAccessor.createVolumes(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                int jobID;
                Response jobStatusResponse;
                if (status <= 4 && (jobStatusResponse = GuiDeviceJob.getJobStatus(jobID = ((Integer)response.responseData).intValue(), true)) != null) {
                    AsyncResult result = (AsyncResult)jobStatusResponse.responseData;
                    AsyncResult[] subResults = result.getSubJobResults();
                    for (int i = 0; i < subResults.length; ++i) {
                        VolumeID[] volumeIds = (VolumeID[])subResults[i].getResults();
                    }
                }
            }
        }, 10000000L, "poolAlpha", 5L, null);
    }
}

