/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.job;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryRunDDI;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.disk.job.DiskJobsNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.scheduler.SchHistoryRequestNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskJobsHelper
implements GuiRequestor,
NameListToTreeNode {
    private DiskJobsNode jobNode;
    private int scheduleID;
    private String description;

    public DiskJobsHelper(DiskJobsNode pJobNode, String pDescription, int pScheduleID) {
        this.jobNode = pJobNode;
        this.description = pDescription;
        this.scheduleID = pScheduleID;
    }

    public void sendRequest() {
        SchHistoryRequestNode historyRequest = new SchHistoryRequestNode();
        historyRequest.queryType = 1;
        historyRequest.queryID = this.scheduleID;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleGuiHandler";
        request.requestData = historyRequest;
        GuiClient.doRequest(this, request);
    }

    public void sendUpdateRequest() {
        SchHistoryRequestNode historyRequest = new SchHistoryRequestNode();
        Request request = new Request();
        historyRequest.queryID = this.scheduleID;
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.UpdateJobStatusHndlr";
        request.requestData = historyRequest;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        this.jobNode.refresh(response, this);
        DataDisplayInfo current = DataDisplayInfo.getCurrent();
        Enumeration<TreeNode> e = this.jobNode.children();
        while (e.hasMoreElements()) {
            BaseTreeNode node = (BaseTreeNode)e.nextElement();
            DataDisplayInfo ddi = node.ddi;
            if (ddi == null) continue;
            ddi.nullOutPanel();
            if (ddi != current) continue;
            ddi.reDisplay();
        }
    }

    public void makeRunDDI() {
        Object[] args = new Object[]{this.description};
        String runDescription = MessageLog.getMessageNoID("JSS1000L", args);
        new EditableObjectHistoryRunDDI(this.scheduleID, this.jobNode, runDescription);
    }

    public BaseTreeNode makeChild(NameList element) {
        return new EditableObjectHistoryNode(element, this.description){};
    }

    public int getKey(NameList element) {
        return element.nlID2;
    }
}

