/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.system;

import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;

public class SubsystemTableModel
extends BaseTableModel {
    private SubsystemDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("DISK_SUBSYSTEM_COLUMN_SYSID_LABEL"), Util.getString("DISK_COMMON_LABEL"), Util.getString("DISK_SUBSYSTEM_COLUMN_TYPE_LABEL"), Util.getString("DISK_SUBSYSTEM_COLUMN_STATUS_LABEL"), Util.getString("DISK_SUBSYSTEM_COLUMN_UNUSEDCAP_LABEL"), Util.getString("DISK_SUBSYSTEM_COLUMN_USEDCAP_LABEL")};
    private static final int SYS_ID = 0;
    private static final int SYS_NAME = 1;
    private static final int SYS_TYPE = 2;
    private static final int SYS_STATUS = 3;
    private static final int SYS_USED = 4;
    private static final int SYS_UNUSED = 5;

    SubsystemTableModel(SubsystemDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getSubsystems().size();
    }

    public Object getTableDataItem(int row, int col) {
        try {
            GUIStorageSubsystem sys = (GUIStorageSubsystem)this.aDDI.getSubsystems().elementAt(row);
            switch (col) {
                case 0: {
                    return GUIEntityUtil.getDisplayText(sys.getDeviceId());
                }
                case 1: {
                    return GUIEntityUtil.getDisplayText(sys.getUserProvidedName());
                }
                case 3: {
                    JLabel lb = GUIEntityUtil.getEntityStateLabel(sys);
                    return lb;
                }
                case 2: {
                    if (sys.getType() == 0) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_ESS");
                    }
                    if (sys.getType() == 1) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_FASTT");
                    }
                    if (sys.getType() == 2) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_DS6000");
                    }
                    if (sys.getType() == 3) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_DS8000");
                    }
                    if (sys.getType() == 4) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_SVC");
                    }
                    if (sys.getType() == 5) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_HDS");
                    }
                    if (sys.getType() == 6) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_EMC");
                    }
                    if (sys.getType() == 7) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_HP");
                    }
                    if (sys.getType() == 8) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_SUN");
                    }
                    if (sys.getType() == 9) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_FUJITSU");
                    }
                    if (sys.getType() == 10) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_HPXP128");
                    }
                    if (sys.getType() == 99) {
                        return Util.getString("DISK_SUBSYSTEMS_TYPE_OTHER");
                    }
                }
                case 5: {
                    return new Double(GUIEntityUtil.convertStorageCapacity(sys.getUsedCapacity(), 0, 3, 10));
                }
                case 4: {
                    return new Double(GUIEntityUtil.convertStorageCapacity(sys.getUnusedCapacity(), 0, 3, 10));
                }
            }
            return "";
        }
        catch (ArrayIndexOutOfBoundsException arrayex) {
            return "";
        }
    }
}

