/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.FormattedTextFieldVerifier;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeWizard;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class CreateVolumeSetCharacteristicsStep
extends WizardPage
implements ActionListener {
    private JLabel titleLabel = null;
    private JLabel descLabel = null;
    private JLabel raidLevelLabel = null;
    private JLabel volumeSizeLabel = null;
    private JLabel unitsLabel = null;
    private JLabel availableArraysLabel = null;
    private JLabel volumeQuantityLabel = null;
    private JLabel volumeNameLabel = null;
    private JLabel volumePrefixLabel = null;
    private JComboBox raidLevelComboBox = new JComboBox();
    private JSpinner volumeSizeSpinner = null;
    private JComboBox unitsComboBox = null;
    private JDialog wizardDialog = null;
    private JSpinner volumeQuantitySpinner = null;
    private JComboBox availableArraysComboBox = new JComboBox();
    private JButton nextButton = null;
    private JTextField volumeNameTextField = null;
    private JFormattedTextField volumeQuantityTextField = new JFormattedTextField();
    private JFormattedTextField volumeSizeTextField = new JFormattedTextField();
    private int minSpinnerValue = 1;
    private int maxQuantitySpinnerValue = 255;
    private long minSizeSpinnerValue = 1L;
    private long maxSizeSpinnerValue = Long.MAX_VALUE;
    private int spinnerStep = 1;
    private long minSize = 1L;
    private long maxSize = 0L;
    private long[] volumeSize = new long[]{0L, 0L};
    private CreateVolumeWizard cvWizard = null;
    private String subSystemID = null;
    private int width = 0;
    private int height = 0;
    private boolean isHelpSet = false;
    private GUIStorageSubsystem subSystem = null;
    protected DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
    private SpinnerNumberModel volumeQModel = null;
    private boolean isVolumeSizeRangeRetrieved = true;
    private boolean isArrayRetrieved = false;
    private NumberFormat numFormat;
    private String volumeName = null;
    private String[] volumeIDs;
    private String raidLevel = new String();
    private String units = null;
    private String volumeQuantity = null;
    private String selectedArray = null;
    private Vector raidArrayESS = null;
    private HashMap aArrays = new HashMap();
    private Vector arrayStrings = new Vector();
    private HashMap raidArray = new HashMap();
    private HashMap arrayForRAID = new HashMap();
    private String[] unitsArray = new String[]{Util.getString("DISK_KB"), Util.getString("DISK_MB"), Util.getString("DISK_GB")};

    public CreateVolumeSetCharacteristicsStep(int buttonFlags, GUIStorageSubsystem ss) {
        super(buttonFlags);
        this.setName("CreateVolumeSetCharacteristicsStep");
        this.subSystem = ss;
        this.subSystemID = this.subSystem.getId();
        this.getPreviousButton().setEnabled(false);
        this.getFinishButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        Container pane = this.getContentPane();
        pane.add(this.create());
        this.setUpHelp(DiskConstants.DISK_CREATE_VOLUME_SET_CHARACTERISTICS);
    }

    public Object next() {
        return "CreateVolumeSelectHostPortsStep";
    }

    public JPanel create() {
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BoxLayout(tempPanel, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VOLUME_CHARACTERISTICS_LABEL"));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        titlePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        tempPanel.add(titlePanel);
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        this.descLabel = new JLabel(Util.getString("DISK_VOLUME_CHARACTERISTICS_DESC_LABEL"));
        this.descLabel.setAlignmentX(0.0f);
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        descPanel.add(this.descLabel);
        descPanel.add(Box.createHorizontalGlue());
        tempPanel.add(descPanel);
        GridBagPanel arrayInfoPanel = new GridBagPanel();
        this.raidLevelLabel = new JLabel(Util.getString("DISK_RAIDLEVEL_LABEL"));
        this.raidLevelComboBox.addActionListener(this);
        this.height = this.raidLevelComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.raidLevelComboBox.setMinimumSize(new Dimension(100, this.height));
        this.raidLevelComboBox.setMaximumSize(new Dimension(100, this.height));
        this.raidLevelComboBox.setPreferredSize(new Dimension(100, this.height));
        this.raidLevelLabel.setAlignmentY(0.5f);
        arrayInfoPanel.add((JComponent)this.raidLevelLabel, 23);
        arrayInfoPanel.add(this.raidLevelComboBox);
        arrayInfoPanel.add((JComponent)new JLabel(), 0, 1, 2);
        arrayInfoPanel.newRow();
        GuiUtil.setAccessibleLabel(this.raidLevelLabel, this.raidLevelComboBox, "", this.raidLevelLabel.getText(), this.raidLevelLabel.getText());
        int typeESS = this.subSystem.getType();
        this.availableArraysLabel = typeESS == 3 || typeESS == 2 ? new JLabel(Util.getString("DISK_VOLUME_AVAILABLE_EXTENT_POOLS_LABEL")) : new JLabel(Util.getString("DISK_VOLUME_AVAILABLE_ARRAYS_LABEL"));
        this.availableArraysComboBox.addActionListener(this);
        this.height = this.availableArraysComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.availableArraysComboBox.setMinimumSize(new Dimension(100, this.height));
        this.availableArraysComboBox.setMaximumSize(new Dimension(100, this.height));
        this.availableArraysComboBox.setPreferredSize(new Dimension(100, this.height));
        arrayInfoPanel.add(this.availableArraysLabel);
        arrayInfoPanel.add(this.availableArraysComboBox);
        arrayInfoPanel.add((JComponent)new JLabel(), 0, 1, 2);
        arrayInfoPanel.newRow();
        GuiUtil.setAccessibleLabel(this.availableArraysLabel, this.availableArraysComboBox, "", this.availableArraysLabel.getText(), this.availableArraysLabel.getText());
        this.volumeQuantityLabel = new JLabel(Util.getString("DISK_VOLUME_QUANTITY_LABEL"));
        this.maxQuantitySpinnerValue = (int)this.subSystem.getCapabilityData().getNumVolumesSupported();
        this.getVolumesQuantity();
        this.volumeQModel = new SpinnerNumberModel(this.minSpinnerValue, this.minSpinnerValue, this.maxQuantitySpinnerValue, this.spinnerStep);
        this.volumeQuantitySpinner = new JSpinner(this.volumeQModel);
        JSpinner.NumberEditor volumeQuantityEditor = (JSpinner.NumberEditor)this.volumeQuantitySpinner.getEditor();
        this.volumeQuantityTextField = volumeQuantityEditor.getTextField();
        this.volumeQuantityTextField.setInputVerifier(new FormattedTextFieldVerifier());
        this.width = this.volumeQModel.getMaximum().toString().length() * this.volumeQuantitySpinner.getFontMetrics(this.getFont()).charWidth(0) + 20;
        this.height = this.volumeQuantitySpinner.getFontMetrics(this.getFont()).getHeight() + 5;
        this.volumeQuantitySpinner.setMinimumSize(new Dimension(this.width, this.height));
        this.volumeQuantitySpinner.setPreferredSize(new Dimension(this.width, this.height));
        this.volumeQuantitySpinner.setMaximumSize(new Dimension(this.width * 2, this.height));
        arrayInfoPanel.add(this.volumeQuantityLabel);
        arrayInfoPanel.add(this.volumeQuantitySpinner);
        arrayInfoPanel.add((JComponent)new JLabel(), 0, 1, 2);
        arrayInfoPanel.newRow();
        GuiUtil.setAccessibleLabel(this.volumeQuantityLabel, this.volumeQuantitySpinner, "", this.volumeQuantityLabel.getText(), this.volumeQuantityLabel.getText());
        JPanel volumeInfoPanel = new JPanel();
        GridBagConstraints volcon = new GridBagConstraints();
        volcon.anchor = 23;
        volcon.insets = new Insets(5, 0, 5, 10);
        volcon.gridx = 0;
        volcon.gridy = 0;
        volcon.gridwidth = 1;
        volcon.gridheight = 1;
        volcon.weightx = 0.5;
        volumeInfoPanel.setLayout(new GridBagLayout());
        this.volumeSizeLabel = new JLabel(Util.getString("DISK_VOLUME_SIZE_LABEL"));
        this.volumeQModel = new SpinnerNumberModel(this.minSizeSpinnerValue, this.minSizeSpinnerValue, this.maxSizeSpinnerValue, (double)this.spinnerStep);
        this.volumeSizeSpinner = new JSpinner(this.volumeQModel);
        JSpinner.NumberEditor volumeSizeEditor = (JSpinner.NumberEditor)this.volumeSizeSpinner.getEditor();
        this.volumeSizeTextField = volumeSizeEditor.getTextField();
        this.volumeSizeTextField.setInputVerifier(new FormattedTextFieldVerifier());
        this.volumeSizeSpinner.setPreferredSize(new Dimension(85, this.volumeSizeSpinner.getFontMetrics(this.getFont()).getHeight() + 5));
        this.volumeSizeSpinner.setEnabled(false);
        this.volumeSizeLabel.setAlignmentY(0.5f);
        arrayInfoPanel.add(this.volumeSizeLabel);
        volumeInfoPanel.add((Component)this.volumeSizeSpinner, volcon);
        GuiUtil.setAccessibleLabel(this.volumeSizeLabel, this.volumeSizeSpinner, "", this.volumeSizeLabel.getText(), this.volumeSizeLabel.getText());
        arrayInfoPanel.add(volumeInfoPanel);
        arrayInfoPanel.add((JComponent)new JLabel(), 0, 1, 2);
        arrayInfoPanel.newRow();
        this.unitsLabel = new JLabel(Util.getString("DISK_UNITS_LABEL"));
        this.unitsComboBox = new JComboBox<String>(this.unitsArray);
        this.unitsComboBox.addActionListener(this);
        this.width = this.unitsArray[2].length() * this.unitsComboBox.getFontMetrics(this.getFont()).charWidth(0) + 38;
        this.height = this.unitsComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.unitsComboBox.setPreferredSize(new Dimension(this.width, this.height));
        this.unitsComboBox.setSelectedIndex(2);
        this.unitsLabel.setAlignmentY(0.5f);
        volcon.gridx = 1;
        volumeInfoPanel.add((Component)this.unitsLabel, volcon);
        volcon.gridx = 2;
        volumeInfoPanel.add((Component)this.unitsComboBox, volcon);
        GuiUtil.setAccessibleLabel(this.unitsLabel, this.unitsComboBox, "", this.unitsLabel.getText(), this.unitsLabel.getText());
        this.volumeNameLabel = new JLabel(Util.getString("DISK_NAME_LABEL"));
        this.volumePrefixLabel = new JLabel(Util.getString("DISK_VDISK_PREFIX_LABEL"));
        PlainDocument pd = new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str != null && str.length() + this.getLength() <= 15) {
                    super.insertString(offs, str, a);
                }
            }
        };
        this.volumeNameTextField = new JTextField(pd, "", 15);
        this.width = 16 * this.volumeNameTextField.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.volumeNameTextField.getFontMetrics(this.getFont()).getHeight() + 5;
        this.volumeNameTextField.setMinimumSize(new Dimension(this.width, this.height));
        this.volumeNameTextField.setPreferredSize(new Dimension(this.width, this.height));
        this.volumeNameTextField.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.volumeNameTextField.setAlignmentX(0.0f);
        arrayInfoPanel.add(this.volumeNameLabel);
        JPanel volumeNamePanel = new JPanel();
        GridBagConstraints namecon = new GridBagConstraints();
        namecon.anchor = 23;
        namecon.insets = new Insets(5, 0, 5, 10);
        namecon.gridx = 0;
        namecon.gridy = 0;
        namecon.gridwidth = 1;
        namecon.gridheight = 1;
        namecon.weightx = 0.5;
        volumeNamePanel.setLayout(new GridBagLayout());
        arrayInfoPanel.add(volumeNamePanel);
        arrayInfoPanel.add((JComponent)new JLabel(), 0, 1, 2);
        arrayInfoPanel.newRow();
        volumeNamePanel.add((Component)this.volumeNameTextField, namecon);
        namecon.gridx = 1;
        volumeNamePanel.add((Component)this.volumePrefixLabel, namecon);
        GuiUtil.setAccessibleLabel(this.volumeNameLabel, this.volumeNameTextField, "", this.volumeNameLabel.getText(), this.volumeNameLabel.getText());
        arrayInfoPanel.add((JComponent)new JLabel(), 1);
        tempPanel.add(arrayInfoPanel);
        this.getAvailableArrays();
        return tempPanel;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = null;
        if (e == null) {
            return;
        }
        source = e.getSource();
        if (source == null) {
            return;
        }
        if (source.equals(this.raidLevelComboBox)) {
            String raidl = (String)this.raidLevelComboBox.getSelectedItem();
            this.raidLevelComboBox.setPreferredSize(new Dimension(70, this.raidLevelComboBox.getHeight()));
            this.getArraysForRAID(raidl);
            if (this.arrayStrings.size() > 0) {
                Iterator iter = this.arrayStrings.iterator();
                int maxLength = 0;
                while (iter.hasNext()) {
                    int length = iter.next().toString().length();
                    if (length <= maxLength) continue;
                    maxLength = length;
                }
                this.width = maxLength;
                this.availableArraysComboBox.setSelectedIndex(0);
            } else {
                this.width = 20;
            }
            this.width *= this.availableArraysComboBox.getFontMetrics(this.getFont()).charWidth(0);
            this.height = this.availableArraysComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
            this.availableArraysComboBox.setPreferredSize(new Dimension(this.width, this.height));
        }
        if (source.equals(this.availableArraysComboBox) && this.availableArraysComboBox.getSelectedItem() != null) {
            GUIStoragePool selPool = (GUIStoragePool)this.aArrays.get(this.availableArraysComboBox.getSelectedItem().toString());
            String poolID = String.valueOf(selPool.getId());
            String ssID = String.valueOf(this.subSystem.getId());
            this.enableControls(false);
            this.diskAccessor.getVolumeSizeRange(new GuiRequestor(){

                public void handleResponse(short status, Response response) {
                    CreateVolumeSetCharacteristicsStep.this.isVolumeSizeRangeRetrieved = false;
                    if (status <= 4 && response != null) {
                        CreateVolumeSetCharacteristicsStep.access$102(CreateVolumeSetCharacteristicsStep.this, (long[])response.responseData);
                        CreateVolumeSetCharacteristicsStep.this.minSize = CreateVolumeSetCharacteristicsStep.this.volumeSize[0];
                        CreateVolumeSetCharacteristicsStep.this.maxSize = CreateVolumeSetCharacteristicsStep.this.volumeSize[1];
                    }
                    if (CreateVolumeSetCharacteristicsStep.this.maxSize == 0L) {
                        CreateVolumeSetCharacteristicsStep.this.maxSize = Long.MAX_VALUE;
                    }
                    if (CreateVolumeSetCharacteristicsStep.this.minSize == 0L) {
                        CreateVolumeSetCharacteristicsStep.this.minSize = 1L;
                    }
                    CreateVolumeSetCharacteristicsStep.this.isVolumeSizeRangeRetrieved = true;
                    CreateVolumeSetCharacteristicsStep.this.enableControls(true);
                }
            }, ssID, poolID);
        }
    }

    public JDialog getWizardDialog() {
        CreateVolumeWizard cvWizard = (CreateVolumeWizard)this.getParent();
        JDialog wizardDialog = (JDialog)cvWizard.getParent().getParent().getParent().getParent();
        return wizardDialog;
    }

    public boolean nextBegin() {
        this.raidLevel = (String)this.raidLevelComboBox.getModel().getSelectedItem();
        String aString = new String();
        String selectedArray = new String();
        GUIStoragePool sPool = null;
        Vector vPorts = new Vector();
        long actVolSize = 0L;
        long volSize = 0L;
        long maxVolSize = 0L;
        BevelBorder bb = (BevelBorder)this.volumeSizeTextField.getBorder();
        if (bb != null && bb.getHighlightOuterColor().equals(Color.RED)) {
            return false;
        }
        BevelBorder bb1 = (BevelBorder)this.volumeQuantityTextField.getBorder();
        if (bb1 != null && bb1.getHighlightOuterColor().equals(Color.RED)) {
            return false;
        }
        Object tempObject = this.availableArraysComboBox.getSelectedItem();
        if (tempObject != null) {
            selectedArray = tempObject.toString();
        }
        if (selectedArray != null && this.aArrays.size() > 0) {
            sPool = (GUIStoragePool)this.aArrays.get(selectedArray);
        }
        this.volumeQuantity = this.volumeQuantitySpinner.getModel().getValue().toString();
        Double dd = new Double(this.volumeSizeSpinner.getModel().getValue().toString());
        volSize = actVolSize = dd.longValue();
        actVolSize = GUIEntityUtil.convertStorageCapacity(actVolSize, this.unitsComboBox.getSelectedIndex() + 1, 0);
        long unusedCapacity = 0L;
        long volQuantity = Long.parseLong(this.volumeQuantity);
        if (sPool == null) {
            String[] args = new String[]{this.availableArraysLabel.getText()};
            String s = Util.getString("DMSG_DISK_VOLUME_SELECT_STORAGE_POOL");
            JOptionPane.showMessageDialog(this, s, this.availableArraysLabel.getText(), 0);
            return false;
        }
        unusedCapacity = sPool.getUnusedCapacity();
        if (actVolSize < this.minSize) {
            float spinnerValue = GUIEntityUtil.convertStorageCapacityDecimal(this.minSize, 0, this.unitsComboBox.getSelectedIndex() + 1, 2);
            String[] args = new String[]{spinnerValue + " " + (String)this.unitsComboBox.getModel().getSelectedItem()};
            String s = Util.getString("DMSG_DISK_VOLUME_MIN_SIZE", args);
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VOLUME_SIZE_LABEL"), 0);
            return false;
        }
        maxVolSize = this.maxSize;
        if (maxVolSize > unusedCapacity) {
            maxVolSize = unusedCapacity;
        }
        float cap = GUIEntityUtil.convertStorageCapacityDecimal(maxVolSize /= volQuantity, 0, 3, 2);
        String capunits = this.unitsArray[2];
        if (cap < 1.0f) {
            cap = GUIEntityUtil.convertStorageCapacityDecimal(maxVolSize, 0, 2, 2);
            capunits = this.unitsArray[1];
        }
        if (actVolSize > maxVolSize) {
            this.maxSizeSpinnerValue = GUIEntityUtil.convertStorageCapacity(maxVolSize, 0, this.unitsComboBox.getSelectedIndex() + 1);
            String[] args = new String[]{String.valueOf(cap) + " " + capunits};
            String s = Util.getString("DMSG_DISK_VOLUME_MAX_SIZE", args);
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VOLUME_SIZE_LABEL"), 0);
            return false;
        }
        this.units = (String)this.unitsComboBox.getModel().getSelectedItem();
        this.volumeName = this.volumeNameTextField.getText();
        this.cvWizard = (CreateVolumeWizard)this.getParent();
        this.cvWizard.addVolumeData(Util.getString("DISK_RAIDLEVEL_LABEL"), this.raidLevel);
        this.cvWizard.addVolumeData(Util.getString("DISK_VOLUME_AVAILABLE_ARRAYS_LABEL"), sPool);
        this.cvWizard.addVolumeData(Util.getString("DISK_VOLUME_QUANTITY_LABEL"), this.volumeQuantity);
        this.cvWizard.addVolumeData(Util.getString("DISK_VOLUME_SIZE_LABEL"), String.valueOf(volSize));
        this.cvWizard.addVolumeData(Util.getString("DISK_UNITS_LABEL"), this.units);
        this.cvWizard.addVolumeData(Util.getString("DISK_NAME_LABEL"), this.volumeName);
        this.raidLevel = new String();
        return true;
    }

    private void enableControls(boolean enable) {
        enable = this.isArrayRetrieved && this.isVolumeSizeRangeRetrieved && enable;
        this.raidLevelComboBox.setEnabled(enable);
        this.availableArraysComboBox.setEnabled(enable);
        this.nextButton.setEnabled(enable);
        if (this.volumeSizeSpinner != null) {
            this.volumeSizeSpinner.setEnabled(enable);
        }
        this.unitsComboBox.setEnabled(enable);
        this.volumeQuantitySpinner.setEnabled(enable);
        this.volumeNameTextField.setEnabled(enable);
    }

    private void getAvailableArrays() {
        this.enableControls(false);
        this.isArrayRetrieved = false;
        this.diskAccessor.getStoragePoolsBySubsytstem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                CreateVolumeSetCharacteristicsStep.this.aArrays = new HashMap();
                CreateVolumeSetCharacteristicsStep.this.raidArray = new HashMap();
                GUIStoragePool sPool2 = null;
                Vector<GUIStoragePool> pools = new Vector<GUIStoragePool>();
                Vector<Object> raids = new Vector();
                Vector<GUIStoragePool> poolForRaid = new Vector<GUIStoragePool>();
                int poolRL = -1;
                if (status <= 4) {
                    HashMap arraysmap;
                    if (response != null && (arraysmap = (HashMap)response.responseData) != null) {
                        Vector<Integer> rlValues = new Vector<Integer>();
                        for (GUIStoragePool sPool2 : arraysmap.values()) {
                            pools.add(sPool2);
                            poolRL = sPool2.getRaidLevel();
                            Integer rVal = new Integer(poolRL);
                            if (rlValues.contains(rVal)) continue;
                            rlValues.add(rVal);
                        }
                        Collections.sort(rlValues);
                        Iterator<Object> iter = rlValues.iterator();
                        while (iter.hasNext()) {
                            poolRL = (Integer)iter.next();
                            if (poolRL == 77) {
                                if (CreateVolumeSetCharacteristicsStep.this.raidArray.get(Util.getString("DISK_MIXED_LABEL")) != null) continue;
                                CreateVolumeSetCharacteristicsStep.this.raidArray.put(Util.getString("DISK_MIXED_LABEL"), String.valueOf(poolRL));
                                CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.addItem(Util.getString("DISK_MIXED_LABEL"));
                                continue;
                            }
                            if (poolRL == 99) {
                                if (CreateVolumeSetCharacteristicsStep.this.raidArray.get(MessageLog.getMessageNoID("GUI0129T")) != null) continue;
                                CreateVolumeSetCharacteristicsStep.this.raidArray.put(MessageLog.getMessageNoID("GUI0129T"), String.valueOf(poolRL));
                                CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.addItem(MessageLog.getMessageNoID("GUI0129T"));
                                continue;
                            }
                            if (CreateVolumeSetCharacteristicsStep.this.raidArray.get(Util.getString("DISK_RAID_LABEL", String.valueOf(poolRL))) != null) continue;
                            CreateVolumeSetCharacteristicsStep.this.raidArray.put(Util.getString("DISK_RAID_LABEL", String.valueOf(poolRL)), String.valueOf(poolRL));
                            CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.addItem(Util.getString("DISK_RAID_LABEL", String.valueOf(poolRL)));
                        }
                        raids = new Vector(CreateVolumeSetCharacteristicsStep.this.raidArray.values());
                        for (int j = 0; j < raids.size(); ++j) {
                            poolRL = Integer.parseInt(raids.get(j).toString());
                            poolForRaid = new Vector();
                            for (int i = 0; i < pools.size(); ++i) {
                                sPool2 = (GUIStoragePool)pools.get(i);
                                if (poolRL != sPool2.getRaidLevel()) continue;
                                poolForRaid.add(sPool2);
                            }
                            if (CreateVolumeSetCharacteristicsStep.this.arrayForRAID.get(String.valueOf(poolRL)) != null) continue;
                            CreateVolumeSetCharacteristicsStep.this.arrayForRAID.put(String.valueOf(poolRL), poolForRaid);
                        }
                    }
                    CreateVolumeSetCharacteristicsStep.this.isArrayRetrieved = true;
                }
                CreateVolumeSetCharacteristicsStep.this.enableControls(true);
                if (CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.getModel().getSize() > 0) {
                    CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.setSelectedIndex(0);
                }
            }
        }, this.subSystemID);
    }

    private int getVolumesQuantity() {
        this.diskAccessor.getVolumeIdsBySubsystem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    CreateVolumeSetCharacteristicsStep.access$1002(CreateVolumeSetCharacteristicsStep.this, (String[])response.responseData);
                    CreateVolumeSetCharacteristicsStep.this.maxQuantitySpinnerValue = CreateVolumeSetCharacteristicsStep.this.maxQuantitySpinnerValue - CreateVolumeSetCharacteristicsStep.this.volumeIDs.length;
                    ((SpinnerNumberModel)CreateVolumeSetCharacteristicsStep.this.volumeQuantitySpinner.getModel()).setMaximum(new Integer(CreateVolumeSetCharacteristicsStep.this.maxQuantitySpinnerValue));
                }
            }
        }, this.subSystemID);
        return this.maxQuantitySpinnerValue;
    }

    private void getArraysForRAID(String raidLevel) {
        GUIStoragePool sPool = null;
        int storageType = -1;
        int arrayFormat = -1;
        String aString = new String();
        float poolCapacity = -1.0f;
        Vector pools = new Vector();
        String units = new String();
        this.arrayStrings = new Vector();
        Vector<String> ids = new Vector<String>();
        String rL = (String)this.raidArray.get(raidLevel);
        pools = (Vector)this.arrayForRAID.get(rL);
        if (pools == null) {
            return;
        }
        for (int i = 0; i < pools.size(); ++i) {
            sPool = (GUIStoragePool)pools.get(i);
            units = this.unitsArray[2];
            poolCapacity = GUIEntityUtil.convertStorageCapacityDecimal(sPool.getUnusedCapacity(), 0, 3, 2);
            if (poolCapacity < 1.0f) {
                poolCapacity = GUIEntityUtil.convertStorageCapacityDecimal(sPool.getUnusedCapacity(), 0, 2, 2);
                units = this.unitsArray[1];
            }
            if ((storageType = this.subSystem.getType()) == 0 || storageType == 2 || storageType == 3) {
                arrayFormat = 0;
            }
            if (arrayFormat != -1 && sPool.getFormat() != arrayFormat) continue;
            String id = sPool.getDeviceId();
            if (ids.contains(id) || id.length() == 0) {
                ids.add(id);
                id = id + " (" + sPool.getInstanceId() + ")" + " ( " + poolCapacity + " " + units + " )";
            } else {
                ids.add(id);
                id = id + " ( " + poolCapacity + " " + units + " )";
            }
            this.aArrays.put(id, sPool);
            this.arrayStrings.add(id);
        }
        if (this.arrayStrings.size() <= 0) {
            this.arrayStrings.add(Util.getString("DISK_NO_DATA_LABEL"));
        }
        Collections.sort(this.arrayStrings);
        DefaultComboBoxModel model = new DefaultComboBoxModel(this.arrayStrings);
        this.availableArraysComboBox.setModel(model);
    }

    static /* synthetic */ long[] access$102(CreateVolumeSetCharacteristicsStep x0, long[] x1) {
        x0.volumeSize = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1002(CreateVolumeSetCharacteristicsStep x0, String[] x1) {
        x0.volumeIDs = x1;
        return x1;
    }
}

