/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.GUIVDisk;
import org.eclipse.aperi.gui.disk.volume.VDiskDDI;

public class VDiskDetailsPanel
extends JPanel
implements ActionListener {
    private VDiskDDI theVdDDI;
    private GUIVDisk vdisk;
    private JLabel lbVdisk;
    private JLabel lbVdiskName;
    private JLabel lbIOGroupID;
    private JLabel lbIOGroupName;
    private JLabel lbStatus;
    private JLabel lbMDiskGroupID;
    private JLabel lbMDiskGroupName;
    private JLabel lbCapacity;
    private JLabel lbType;
    private JLabel lbFormatted;
    private JLabel lbMDiskID;
    private JLabel lbMDiskName;
    private JLabel lbFlashCopyID;
    private JLabel lbFlashCopyName;
    private JLabel lbMMID;
    private JLabel lbMMName;
    private JLabel lbIOTH;
    private JLabel lbPrefNode;
    private JLabel lbMapped;
    private JLabel lbFastWrite;
    private JLabel lbUID;
    private JPanel propPanel = new JPanel();
    Vector portvec = new Vector();

    public VDiskDetailsPanel(VDiskDDI ddi, GUIVDisk vd) {
        this.theVdDDI = ddi;
        this.vdisk = vd;
    }

    public JComponent getComponent() {
        this.setLayout(new FlowLayout(0));
        this.propPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.insets = new Insets(3, 20, 3, 3);
        c.gridx = 0;
        c.gridy = 0;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_VDISK_ID_LABEL")), c);
        c.gridx = 1;
        c.gridy = 0;
        this.lbVdisk = new JLabel();
        this.lbVdisk.setText(GUIEntityUtil.getDisplayText(this.vdisk.getName()));
        this.propPanel.add((Component)this.lbVdisk, c);
        c.gridx = 0;
        c.gridy = 1;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_NAME_LABEL")), c);
        c.gridx = 1;
        c.gridy = 1;
        this.lbVdiskName = new JLabel();
        this.lbVdiskName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getDeviceId()));
        this.propPanel.add((Component)this.lbVdiskName, c);
        c.gridx = 0;
        c.gridy = 2;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_IOGROUPID_LABEL")), c);
        c.gridx = 1;
        c.gridy = 2;
        this.lbIOGroupID = new JLabel();
        this.lbIOGroupID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getIoGrpId()));
        this.propPanel.add((Component)this.lbIOGroupID, c);
        c.gridx = 0;
        c.gridy = 3;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_IOGROUPNAME_LABEL")), c);
        c.gridx = 1;
        c.gridy = 3;
        this.lbIOGroupName = new JLabel();
        this.lbIOGroupName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getIoGroupName()));
        this.propPanel.add((Component)this.lbIOGroupName, c);
        c.gridx = 0;
        c.gridy = 4;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_STATUS_LABEL")), c);
        c.gridx = 1;
        c.gridy = 4;
        this.lbStatus = new JLabel();
        if (this.vdisk.getNativeStatus() == 1) {
            this.lbStatus.setText(Util.getString("DISK_ONLINE_LABEL"));
        } else if (this.vdisk.getNativeStatus() == 0) {
            this.lbStatus.setText(Util.getString("DISK_OFFLINE_LABEL"));
        } else if (this.vdisk.getNativeStatus() == 2) {
            this.lbStatus.setText(Util.getString("DISK_DEGRADED_LABEL"));
        } else {
            this.lbStatus.setText(Util.getString("DISK_NA_LABEL"));
        }
        this.propPanel.add((Component)this.lbStatus, c);
        c.gridx = 0;
        c.gridy = 5;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_MDISKGROUPNAME_LABEL")), c);
        c.gridx = 1;
        c.gridy = 5;
        this.lbMDiskGroupName = new JLabel();
        this.lbMDiskGroupName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getStoragePoolName()));
        this.propPanel.add((Component)this.lbMDiskGroupName, c);
        c.gridx = 0;
        c.gridy = 6;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_CAPACITY_LABEL_MB")), c);
        c.gridx = 1;
        c.gridy = 6;
        this.lbCapacity = new JLabel();
        double capacity = GUIEntityUtil.convertStorageCapacity(this.vdisk.getCapacity(), 0, 2, 10);
        this.lbCapacity.setText(GUIEntityUtil.getNumberString(new Double(capacity), 2, Locale.getDefault()));
        this.propPanel.add((Component)this.lbCapacity, c);
        c.gridx = 0;
        c.gridy = 7;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_TYPE_LABEL")), c);
        c.gridx = 1;
        c.gridy = 7;
        this.lbType = new JLabel();
        if (this.vdisk.getType() == 0) {
            this.lbType.setText(Util.getString("DISK_SEQUENTIAL_LABEL"));
        } else if (this.vdisk.getType() == 1) {
            this.lbType.setText(Util.getString("DISK_STRIPED_LABEL"));
        } else if (this.vdisk.getType() == 3) {
            this.lbType.setText(Util.getString("DISK_IMAGE_LABEL"));
        } else {
            this.lbType.setText(Util.getString("DISK_NA_LABEL"));
        }
        this.propPanel.add((Component)this.lbType, c);
        c.gridx = 0;
        c.gridy = 8;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_FORMATTED_LABEL")), c);
        c.gridx = 1;
        c.gridy = 8;
        this.lbFormatted = new JLabel();
        if (this.vdisk.isFormatted()) {
            this.lbFormatted.setText(Util.getString("DISK_YES_LABEL"));
        } else {
            this.lbFormatted.setText(Util.getString("DISK_NO_LABEL"));
        }
        this.propPanel.add((Component)this.lbFormatted, c);
        c.gridx = 0;
        c.gridy = 9;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_MDISKID_LABEL")), c);
        c.gridx = 1;
        c.gridy = 9;
        this.lbMDiskID = new JLabel();
        this.lbMDiskID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getMdiskId()));
        this.propPanel.add((Component)this.lbMDiskID, c);
        c.gridx = 0;
        c.gridy = 10;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_MDISKNAME_LABEL")), c);
        c.gridx = 1;
        c.gridy = 10;
        this.lbMDiskName = new JLabel();
        this.lbMDiskName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getMdiskName()));
        this.propPanel.add((Component)this.lbMDiskName, c);
        c.gridx = 0;
        c.gridy = 11;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_FLASHCOPYID_LABEL")), c);
        c.gridx = 1;
        c.gridy = 11;
        this.lbFlashCopyID = new JLabel();
        this.lbFlashCopyID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getFlashCopyId()));
        this.propPanel.add((Component)this.lbFlashCopyID, c);
        c.gridx = 0;
        c.gridy = 12;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_FLASHCOPYNAME_LABEL")), c);
        c.gridx = 1;
        c.gridy = 12;
        this.lbFlashCopyName = new JLabel();
        this.lbFlashCopyName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getFlashCopyName()));
        this.propPanel.add((Component)this.lbFlashCopyName, c);
        c.gridx = 0;
        c.gridy = 13;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_METROMIRRORID_LABEL")), c);
        c.gridx = 1;
        c.gridy = 13;
        this.lbMMID = new JLabel();
        this.lbMMID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getMetroMirrorId()));
        this.propPanel.add((Component)this.lbMMID, c);
        c.gridx = 0;
        c.gridy = 14;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_METROMIRRORNAME_LABEL")), c);
        c.gridx = 1;
        c.gridy = 14;
        this.lbMMName = new JLabel();
        this.lbMMName.setText(GUIEntityUtil.getDisplayText(this.vdisk.getMetroMirrorName()));
        this.propPanel.add((Component)this.lbMMName, c);
        c.gridx = 0;
        c.gridy = 15;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_IOTHROTTLING_LABEL")), c);
        c.gridx = 1;
        c.gridy = 15;
        this.lbIOTH = new JLabel();
        this.lbIOTH.setText(String.valueOf(this.vdisk.getIoThrottling()));
        this.propPanel.add((Component)this.lbIOTH, c);
        c.gridx = 0;
        c.gridy = 16;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_PREFNODE_LABEL")), c);
        c.gridx = 1;
        c.gridy = 16;
        this.lbPrefNode = new JLabel();
        this.lbPrefNode.setText(GUIEntityUtil.getDisplayText(this.vdisk.getPreferredNodeForIO()));
        this.propPanel.add((Component)this.lbPrefNode, c);
        c.gridx = 0;
        c.gridy = 17;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_MAPPEDTOAHOST_LABEL")), c);
        c.gridx = 1;
        c.gridy = 17;
        this.lbMapped = new JLabel();
        if (this.vdisk.isAssigned()) {
            this.lbMapped.setText(Util.getString("DISK_YES_LABEL"));
        } else {
            this.lbMapped.setText(Util.getString("DISK_NO_LABEL"));
        }
        this.propPanel.add((Component)this.lbMapped, c);
        c.gridx = 0;
        c.gridy = 18;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_FASTWRITE_LABEL")), c);
        c.gridx = 1;
        c.gridy = 18;
        this.lbFastWrite = new JLabel();
        if (this.vdisk.getFastWriteState() == 0) {
            this.lbFastWrite.setText(Util.getString("DISK_FASTWRITE_STATE_EMPTY"));
        } else if (this.vdisk.getFastWriteState() == 1) {
            this.lbFastWrite.setText(Util.getString("DISK_FASTWRITE_STATE_NOTEMPTY"));
        } else if (this.vdisk.getFastWriteState() == 2) {
            this.lbFastWrite.setText(Util.getString("DISK_FASTWRITE_STATE_CORRUPT"));
        }
        this.propPanel.add((Component)this.lbFastWrite, c);
        c.gridx = 0;
        c.gridy = 19;
        this.propPanel.add((Component)new BoldLabel(Util.getString("DISK_UID_LABEL")), c);
        c.gridx = 1;
        c.gridy = 19;
        this.lbUID = new JLabel();
        this.lbUID.setText(GUIEntityUtil.getDisplayText(this.vdisk.getUid()));
        this.propPanel.add((Component)this.lbUID, c);
        this.add((Component)this.propPanel, "Before");
        return this;
    }

    public void actionPerformed(ActionEvent e) {
    }
}

