/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.GUIVDisk;
import org.eclipse.aperi.gui.disk.volume.VDiskDDI;

public class VDiskTableModel
extends BaseTableModel {
    private VDiskDDI aDDI;
    private static final String[] COL_NAMES = new String[]{Util.getString("DISK_NAME_LABEL"), Util.getString("DISK_IOGROUP_LABEL"), Util.getString("DISK_STATUS_LABEL"), Util.getString("DISK_MDISKGROUPNAME_LABEL"), Util.getString("DISK_CAPACITY_LABEL_MB"), Util.getString("DISK_TYPE_LABEL"), Util.getString("DISK_FCPAIRNAME_LABEL"), Util.getString("DISK_MMNAME_LABEL")};
    private static final int NAME = 0;
    private static final int IO_GROUP = 1;
    private static final int STATUS = 2;
    private static final int MD_GROUP_NAME = 3;
    private static final int CAPACITY = 4;
    private static final int TYPE = 5;
    private static final int FC_PAIR_NAME = 6;
    private static final int MM_NAME = 7;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_BY_ARRAY = 1;
    public static final int FILTER_BY_HOST = 2;
    public static final int FILTER_ALL = 3;

    VDiskTableModel(VDiskDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getRowCount();
    }

    public Object getTableDataItem(int row, int col) {
        try {
            GUIVDisk vdsk = this.aDDI.getRowDataAt(row);
            switch (col) {
                case 0: {
                    return GUIEntityUtil.getDisplayText(vdsk.getDeviceId());
                }
                case 1: {
                    return GUIEntityUtil.getDisplayText(vdsk.getIoGroupName());
                }
                case 2: {
                    if (vdsk.getNativeStatus() == 1) {
                        return Util.getString("DISK_ONLINE_LABEL");
                    }
                    if (vdsk.getNativeStatus() == 0) {
                        return Util.getString("DISK_OFFLINE_LABEL");
                    }
                    if (vdsk.getNativeStatus() == 2) {
                        return Util.getString("DISK_DEGRADED_LABEL");
                    }
                    return Util.getString("DISK_NA_LABEL");
                }
                case 3: {
                    return GUIEntityUtil.getDisplayText(vdsk.getStoragePoolName());
                }
                case 4: {
                    return new Double(GUIEntityUtil.convertStorageCapacity(vdsk.getCapacity(), 0, 2, 10));
                }
                case 5: {
                    if (vdsk.getType() == 0) {
                        return Util.getString("DISK_SEQUENTIAL_LABEL");
                    }
                    if (vdsk.getType() == 1) {
                        return Util.getString("DISK_STRIPED_LABEL");
                    }
                    if (vdsk.getType() == 3) {
                        return Util.getString("DISK_IMAGE_LABEL");
                    }
                    return Util.getString("DISK_NA_LABEL");
                }
                case 6: {
                    return GUIEntityUtil.getDisplayText(vdsk.getFlashCopyName());
                }
                case 7: {
                    return GUIEntityUtil.getDisplayText(vdsk.getMetroMirrorName());
                }
            }
            return "";
        }
        catch (ArrayIndexOutOfBoundsException arrayex) {
            return "";
        }
    }
}

