/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.disk.common.DiskGuiTable;
import org.eclipse.aperi.gui.disk.common.TableCapacityRenderer;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeWizard;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentWizard;
import org.eclipse.aperi.gui.disk.volume.VolumeDDI;
import org.eclipse.aperi.gui.disk.volume.VolumeTableModel;
import org.eclipse.aperi.request.Response;

public class VolumeListPanel
extends JPanel
implements ActionListener,
TJCTableMouseInterface {
    private JTextField volume_id;
    private JLabel lbmsg;
    private JLabel lbview;
    private JRadioButton radioButArray;
    private JRadioButton radioButHost;
    private String str_poolradio;
    private JComboBox cbvolume;
    private JComboBox cbhost;
    private JButton buttoncreate;
    private JButton buttondelete;
    private JButton buttonHPA;
    private JButton buttonGOa;
    private JButton buttonGOh;
    private JLabel label;
    private ButtonGroup group = new ButtonGroup();
    public VolumeDDI theVolDDI;
    private GUIVolume vol;
    private DiskGuiTable table;
    private VolumeTableModel tableModel;
    private JPanel mainpanel = new JPanel();
    private JPanel filterpanel = new JPanel();
    private boolean dblClick = false;
    private HashMap hmapArrofSS;
    private GUIStoragePool[] arrpool;
    private HashMap hmapHostPortofSS;
    private static final String ACTION_VIEW_DETAILS = Util.getString("DISK_VIEW_DETAILS_LABEL");
    private GridBagConstraints con = new GridBagConstraints();
    private int filtermode = 3;
    private String filtername = "NONE";
    private String strHPnameBr = "( ";
    private String endHPnameBr = " )";
    private String noselect = Util.getString("DISK_COMMON_NO_SELECTION");
    private int width = 0;
    private int height = 0;
    private boolean hostplistavailable = false;
    private static TableCellRenderer capacityRenderer = new TableCapacityRenderer();
    private JDialog wizardDialog = null;
    private CreateVolumeWizard crvol = null;
    private PortAssignmentWizard HPAwiz = null;
    private JPanel tablePanel = GuiUtil.getPanel();
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent click) {
            if (VolumeListPanel.this.radioButArray.isSelected()) {
                VolumeListPanel.this.cbvolume.setEnabled(true);
                VolumeListPanel.this.cbhost.setEnabled(false);
                VolumeListPanel.this.buttonGOa.setEnabled(true);
                VolumeListPanel.this.buttonGOh.setEnabled(false);
            } else if (VolumeListPanel.this.radioButHost.isSelected()) {
                if (!VolumeListPanel.this.hostplistavailable) {
                    VolumeListPanel.this.theVolDDI.diskAccessor.getAssignedHostPortsBySubsystem(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                            if (status <= 4) {
                                VolumeListPanel.this.hmapHostPortofSS = (HashMap)response.responseData;
                                Collection colhost = VolumeListPanel.this.hmapHostPortofSS.values();
                                VolumeListPanel.this.cbhost.addItem(VolumeListPanel.this.noselect);
                                ArrayList<String> list = new ArrayList<String>();
                                for (GUIPort port : colhost) {
                                    String hpwwpn = port.getWwpn();
                                    String hpname = port.getHostName();
                                    if (hpwwpn == null || hpwwpn.equals("null")) continue;
                                    if (hpname != null && hpname.trim().length() > 0) {
                                        hpwwpn = hpwwpn + VolumeListPanel.this.strHPnameBr + hpname + VolumeListPanel.this.endHPnameBr;
                                    }
                                    list.add(hpwwpn);
                                }
                                Collections.sort(list);
                                for (int i = 0; i < list.size(); ++i) {
                                    VolumeListPanel.this.cbhost.addItem(list.get(i));
                                }
                            }
                        }
                    }, VolumeListPanel.this.theVolDDI.subsystem.getId());
                }
                VolumeListPanel.this.hostplistavailable = true;
                VolumeListPanel.this.cbhost.setEnabled(true);
                VolumeListPanel.this.buttonGOh.setEnabled(true);
                VolumeListPanel.this.cbvolume.setEnabled(false);
                VolumeListPanel.this.buttonGOa.setEnabled(false);
            }
        }
    };
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    Component bottomHalf = null;

    public VolumeListPanel(VolumeDDI ddi) {
        this.theVolDDI = ddi;
        this.table = new DiskGuiTable();
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        this.mainpanel.setLayout(new BorderLayout());
        this.buttoncreate = new JButton(Util.getString("DISK_CREATE_BUTTON"));
        this.buttoncreate.addActionListener(this);
        GuiUtil.setAccessible(this.buttoncreate, this.buttoncreate.getText(), this.buttoncreate.getText());
        this.buttonHPA = new JButton(Util.getString("DISK_HPA_BUTTON"));
        this.buttonHPA.addActionListener(this);
        GuiUtil.setAccessible(this.buttonHPA, this.buttonHPA.getText(), this.buttonHPA.getText());
        this.buttondelete = new JButton(Util.getString("DISK_DELETE_BUTTON"));
        this.buttondelete.addActionListener(this);
        GuiUtil.setAccessible(this.buttondelete, this.buttondelete.getText(), this.buttondelete.getText());
        this.buttondelete.setEnabled(false);
        JPanel pbutton_line1 = new JPanel();
        pbutton_line1.setLayout(new FlowLayout(0));
        pbutton_line1.add(this.buttoncreate);
        pbutton_line1.add(this.buttonHPA);
        pbutton_line1.add(this.buttondelete);
        this.filterpanel.setLayout(new GridBagLayout());
        this.con.anchor = 17;
        this.con.insets = new Insets(3, 3, 3, 3);
        this.theVolDDI.diskAccessor.areVolumeActionsInProgress(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    boolean inProgress = (Boolean)response.responseData;
                    if (inProgress) {
                        VolumeListPanel.this.lbmsg.setText(Util.getString("DISK_VOLUME_PROGRESS_LABEL"));
                    } else {
                        VolumeListPanel.this.lbmsg.setText("");
                    }
                }
            }
        }, Integer.toString(this.theVolDDI.subsystem.getInternalId()));
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 4;
        this.lbmsg = new JLabel("");
        this.lbmsg.setForeground(Color.red);
        this.filterpanel.add((Component)this.lbmsg, this.con);
        this.con.insets = new Insets(3, 3, 3, 0);
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 1;
        this.lbview = new JLabel(Util.getString("DISK_VOLVW_LABEL"));
        this.filterpanel.add((Component)this.lbview, this.con);
        this.con.gridx = 0;
        this.con.gridy = 2;
        this.con.gridwidth = 1;
        this.str_poolradio = this.theVolDDI.subsystem.getType() == 2 || this.theVolDDI.subsystem.getType() == 3 ? Util.getString("DISK_FILTER_POOL_LABEL") : Util.getString("DISK_FILTER_ARRAY_LABEL");
        this.radioButArray = new JRadioButton(this.str_poolradio, true);
        this.radioButArray.addMouseListener(this.mouseListener);
        GuiUtil.setAccessible(this.radioButArray, this.radioButArray.getText(), this.radioButArray.getText());
        this.filterpanel.add((Component)this.radioButArray, this.con);
        this.group.add(this.radioButArray);
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.con.gridwidth = 1;
        this.cbvolume = new JComboBox();
        this.cbvolume.setEnabled(true);
        GuiUtil.setAccessible(this.cbvolume, this.radioButArray.getText(), this.radioButArray.getText());
        this.width = 50 * this.cbvolume.getFontMetrics(this.getFont()).charWidth(0) + 15;
        this.height = this.cbvolume.getFontMetrics(this.getFont()).getHeight() + 5;
        this.cbvolume.setMinimumSize(new Dimension(this.width, this.height));
        this.cbvolume.setPreferredSize(new Dimension(this.width, this.height));
        this.cbvolume.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.filterpanel.add((Component)this.cbvolume, this.con);
        this.theVolDDI.diskAccessor.getStoragePoolsBySubsytstem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    VolumeListPanel.this.hmapArrofSS = (HashMap)response.responseData;
                    Collection colpool = VolumeListPanel.this.hmapArrofSS.values();
                    VolumeListPanel.access$1302(VolumeListPanel.this, new GUIStoragePool[colpool.size()]);
                    VolumeListPanel.access$1302(VolumeListPanel.this, colpool.toArray(VolumeListPanel.this.arrpool));
                    VolumeListPanel.this.cbvolume.addItem(VolumeListPanel.this.noselect);
                    boolean sorted = false;
                    while (!sorted) {
                        sorted = true;
                        for (int i = 0; i < VolumeListPanel.this.arrpool.length - 1; ++i) {
                            if (VolumeListPanel.this.arrpool[i].getDeviceId().compareTo(VolumeListPanel.this.arrpool[i + 1].getDeviceId()) <= 0) continue;
                            GUIStoragePool pool = VolumeListPanel.this.arrpool[i];
                            ((VolumeListPanel)VolumeListPanel.this).arrpool[i] = VolumeListPanel.this.arrpool[i + 1];
                            ((VolumeListPanel)VolumeListPanel.this).arrpool[i + 1] = pool;
                            sorted = false;
                        }
                    }
                    Vector<String> ids = new Vector<String>();
                    for (int i = 0; i < VolumeListPanel.this.arrpool.length; ++i) {
                        String id = VolumeListPanel.this.arrpool[i].getDeviceId();
                        if (ids.contains(id) || id.length() == 0) {
                            id = id + " (" + VolumeListPanel.this.arrpool[i].getInstanceId() + ")";
                        }
                        ids.add(id);
                        VolumeListPanel.this.cbvolume.addItem(id);
                    }
                }
            }
        }, this.theVolDDI.subsystem.getId());
        this.con.gridx = 2;
        this.con.gridy = 2;
        this.con.gridwidth = 1;
        this.buttonGOa = new JButton(Util.getString("DISK_GO_BUTTON"));
        this.buttonGOa.addActionListener(this);
        GuiUtil.setAccessible(this.buttonGOa, this.buttonGOa.getText(), this.buttonGOa.getText());
        this.filterpanel.add((Component)this.buttonGOa, this.con);
        this.con.gridx = 0;
        this.con.gridy = 3;
        this.con.gridwidth = 1;
        this.radioButHost = new JRadioButton(Util.getString("DISK_FILTER_HOST_LABEL"));
        this.radioButHost.addMouseListener(this.mouseListener);
        GuiUtil.setAccessible(this.radioButHost, this.radioButHost.getText(), this.radioButHost.getText());
        this.filterpanel.add((Component)this.radioButHost, this.con);
        this.group.add(this.radioButHost);
        this.con.gridx = 1;
        this.con.gridy = 3;
        this.con.gridwidth = 1;
        this.cbhost = new JComboBox();
        this.cbhost.setEnabled(false);
        GuiUtil.setAccessible(this.cbhost, this.radioButHost.getText(), this.radioButHost.getText());
        this.cbhost.setMinimumSize(new Dimension(this.width, this.height));
        this.cbhost.setPreferredSize(new Dimension(this.width, this.height));
        this.cbhost.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.filterpanel.add((Component)this.cbhost, this.con);
        this.hostplistavailable = false;
        this.con.gridx = 2;
        this.con.gridy = 3;
        this.con.gridwidth = 1;
        this.buttonGOh = new JButton(Util.getString("DISK_GO_BUTTON"));
        this.buttonGOh.addActionListener(this);
        this.buttonGOh.setEnabled(false);
        GuiUtil.setAccessible(this.buttonGOh, this.buttonGOh.getText(), this.buttonGOh.getText());
        this.filterpanel.add((Component)this.buttonGOh, this.con);
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(Util.getString("DISK_VOLUMES_LABEL") + " " + "(" + this.theVolDDI.subsystem.getName() + "):"));
        this.theVolDDI.getVolumes(this.filtername, this.filtermode);
        this.add((Component)this.mainpanel, "Center");
        JPanel operational_panel = new JPanel();
        operational_panel.setLayout(new BorderLayout());
        operational_panel.add((Component)pbutton_line1, "North");
        operational_panel.add((Component)this.filterpanel, "West");
        this.mainpanel.add((Component)operational_panel, "North");
        this.mainpanel.add((Component)this.tablePanel, "Center");
        return this;
    }

    public void actionPerformed(ActionEvent event) {
        int[] selectedRows;
        Object sourceB = null;
        String sourceKM = null;
        sourceB = event.getSource();
        sourceKM = event.getActionCommand();
        if (event == null) {
            return;
        }
        if (sourceB == null) {
            return;
        }
        if (sourceB == this.buttondelete) {
            this.doDelete();
        } else if (sourceB == this.buttoncreate) {
            this.openCreateWizard(this.theVolDDI.subsystem);
        } else if (sourceB == this.buttonHPA) {
            this.openWizardHPA(this.theVolDDI.subsystem);
        } else if (sourceB == this.buttonGOa) {
            int idx = this.cbvolume.getSelectedIndex();
            String sel = idx == 0 ? this.noselect : this.arrpool[idx - 1].getName();
            if (sel == this.noselect) {
                this.filtermode = 3;
                this.filtername = "NONE";
            } else {
                this.filtername = this.arrpool[idx - 1].getId();
                this.filtermode = 1;
            }
            this.theVolDDI.getVolumes(this.filtername, this.filtermode);
        } else if (sourceB == this.buttonGOh) {
            String sel;
            int idx = this.cbhost.getSelectedIndex();
            if (idx == 0) {
                sel = this.noselect;
            } else {
                sel = (String)this.cbhost.getItemAt(idx);
                int ii = sel.indexOf(this.strHPnameBr);
                if (ii > 0) {
                    sel = sel.substring(0, ii);
                }
            }
            if (sel == this.noselect) {
                this.filtermode = 3;
                this.filtername = "NONE";
            } else {
                this.filtername = sel;
                this.filtermode = 2;
            }
            this.theVolDDI.getVolumes(this.filtername, this.filtermode);
        } else if (sourceKM == ACTION_VIEW_DETAILS && (selectedRows = this.table.getSelectedRows()).length > 0) {
            this.theVolDDI.showDetails(selectedRows[0]);
        }
    }

    public void doDelete() {
        int sel = this.table.getNumRows();
        if (sel != 0) {
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows.length > 0) {
                this.vol = this.theVolDDI.getRowDataAt(selectedRows[0]);
                if (!this.theVolDDI.subsystem.isVolumeDeletionSupported()) {
                    String s = Util.getString("DMSG_DISK_VOLUME_BELONGS_ESS2105", this.vol.getDeviceId());
                    JOptionPane.showMessageDialog(this.guiMain.getFrame(), s, Util.getString("DISK_DELETE_LABEL"), 0);
                } else {
                    this.theVolDDI.diskAccessor.getPortAssignments(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                            if (status <= 4) {
                                HashMap hmapHostPortVol = (HashMap)response.responseData;
                                if (!hmapHostPortVol.isEmpty()) {
                                    String[] args = new String[]{VolumeListPanel.this.vol.getDeviceId()};
                                    String s = Util.getString("DMSG_DISK_VOLUME_EXISTING_ASSIGNMENTS", args);
                                    JOptionPane.showMessageDialog(VolumeListPanel.this.guiMain.getFrame(), s, Util.getString("DISK_DELETE_LABEL"), 0);
                                } else {
                                    String[] args = new String[]{VolumeListPanel.this.vol.getDeviceId()};
                                    int action = JOptionPane.showConfirmDialog(VolumeListPanel.this.guiMain.getFrame(), Util.getString("DISK_REALLY_DELETE_LABEL", args), Util.getString("DISK_DELETE_LABEL"), 1);
                                    switch (action) {
                                        case 1: {
                                            break;
                                        }
                                        case 2: {
                                            break;
                                        }
                                        case 0: {
                                            DiskDataController.getInstance().deleteVolumes(new GuiRequestor(){

                                                public void handleResponse(short status, Response response) {
                                                    AsyncResult[] subResults;
                                                    AsyncResult result;
                                                    int jobID;
                                                    Response jobStatusResponse;
                                                    if (status <= 4 && (jobStatusResponse = GuiDeviceJob.getJobStatus(jobID = ((Integer)response.responseData).intValue(), true)) != null && (result = (AsyncResult)jobStatusResponse.responseData) != null && (subResults = result.getSubJobResults()) != null && subResults.length == 1) {
                                                        Exception tpcEx = subResults[0].getReturnException();
                                                        if (tpcEx != null) {
                                                            String errorMsg = tpcEx.getMessage();
                                                            if (tpcEx instanceof SRMRuntimeException) {
                                                                errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                                                            }
                                                            if (errorMsg != null) {
                                                                JOptionPane.showMessageDialog(VolumeListPanel.this.guiMain.getFrame(), errorMsg, Util.getString("DISK_DELETE_LABEL"), 0);
                                                            }
                                                        }
                                                        VolumeID[] volumeIds = (VolumeID[])subResults[0].getResults();
                                                        VolumeListPanel.this.theVolDDI.getVolumes(VolumeListPanel.this.filtername, VolumeListPanel.this.filtermode);
                                                    }
                                                }
                                            }, new String[]{VolumeListPanel.this.vol.getId()});
                                        }
                                    }
                                }
                            }
                        }
                    }, this.theVolDDI.subsystem.getId(), this.vol.getId());
                }
            }
        } else {
            String s = Util.getString("DMSG_DISK_NO_RESOURCE");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_DELETE_LABEL"), 0);
        }
    }

    public void openCreateWizard(GUIStorageSubsystem ss) {
        this.crvol = new CreateVolumeWizard(ss);
        this.wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_CREATE_VOLUMES_WIZARD_LABEL", ss.getDeviceId()), true);
        this.wizardDialog.getContentPane().add(this.crvol);
        this.wizardDialog.setResizable(false);
        this.wizardDialog.pack();
        GuiUtil.centerDialog(this.wizardDialog);
        this.wizardDialog.setDefaultCloseOperation(0);
        this.wizardDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                VolumeListPanel.this.crvol.cancel();
            }
        });
        this.wizardDialog.show();
    }

    public void openWizardHPA(GUIStorageSubsystem ss) {
        int sel = this.table.getNumRows();
        if (sel != 0) {
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows.length > 0) {
                this.vol = this.theVolDDI.getRowDataAt(selectedRows[0]);
                this.HPAwiz = new PortAssignmentWizard(ss, this.vol);
                this.wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_HPA_WIZARD_LABEL", ss.getDeviceId()), true);
                this.wizardDialog.getContentPane().add(this.HPAwiz);
                this.wizardDialog.setResizable(false);
                this.wizardDialog.pack();
                GuiUtil.centerDialog(this.wizardDialog);
                this.wizardDialog.setDefaultCloseOperation(0);
                this.wizardDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent event) {
                        VolumeListPanel.this.HPAwiz.cancel();
                    }
                });
                this.wizardDialog.show();
            }
        } else {
            String s = Util.getString("DMSG_DISK_NO_RESOURCE");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_HPA_WIZARD_LABEL"), 0);
        }
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (dataRow < 0 || dataCol < 0) {
            return;
        }
        int selectedRow = this.table.getPointedRow(y);
        this.table.setSelectedRows(selectedRow, selectedRow);
        this.selectionChanged(true);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem mi = menu.add(Util.getString("DISK_VIEW_DETAILS_LABEL"));
        mi.setActionCommand(ACTION_VIEW_DETAILS);
        mi.addActionListener(this);
        mi.setEnabled(true);
        menu.show(c, x, y);
        menu.requestFocus();
    }

    public void selectionChanged(boolean state) {
        if (this.capabilities.isDiskAdmin() && this.theVolDDI.subsystem.isVolumeCreationSupported() && this.theVolDDI.subsystem.getCapabilityData() != null && this.theVolDDI.subsystem.isDetectable()) {
            this.buttoncreate.setEnabled(true);
        } else {
            this.buttoncreate.setEnabled(false);
        }
        if (this.table.getSelectedRows().length <= 0) {
            this.buttondelete.setEnabled(false);
            this.buttonHPA.setEnabled(false);
            return;
        }
        if (this.theVolDDI.getRowCount() != 0) {
            if (this.capabilities.isDiskAdmin() && this.theVolDDI.subsystem.isVolumeDeletionSupported() && this.theVolDDI.subsystem.getCapabilityData() != null && this.theVolDDI.subsystem.isDetectable()) {
                this.buttondelete.setEnabled(true);
            } else {
                this.buttondelete.setEnabled(false);
            }
            if (this.capabilities.isDiskAdmin() && this.theVolDDI.subsystem.isPortAssignmentSupported() && this.theVolDDI.subsystem.getCapabilityData() != null && this.theVolDDI.subsystem.isDetectable()) {
                this.buttonHPA.setEnabled(true);
            } else {
                this.buttonHPA.setEnabled(false);
            }
        } else {
            this.buttondelete.setEnabled(false);
            this.buttonHPA.setEnabled(false);
        }
    }

    public void doubleClick(int dataRow, int dataCol) {
        this.dblClick = true;
        this.theVolDDI.showDetails(dataRow);
    }

    public void showDefaultChart(int dataRow) {
    }

    public void buildtable() {
        this.table = new DiskGuiTable();
        this.tableModel = new VolumeTableModel(this.theVolDDI);
        this.table.setMouseListener(this);
        this.table.setFrozenColumns(1);
        this.table.setRowIcon(10, true);
        this.table.setSelectionPolicy(0);
        this.table.setBaseTableModel(this.tableModel);
        this.table.sortByColumn(0, 1);
        this.table.setCellRenderer(Double.class, capacityRenderer);
        this.table.updateUI();
        GridBagConstraints tgbc = new GridBagConstraints();
        tgbc.gridheight = 0;
        tgbc.insets.bottom = 0;
        tgbc.insets.top = 10;
        tgbc.gridwidth = 1;
        tgbc.anchor = 10;
        tgbc.fill = 1;
        tgbc.weighty = 1.0;
        tgbc.weightx = 0.5;
        tgbc.insets = new Insets(3, 3, 3, 3);
        if (this.table == this.bottomHalf) {
            return;
        }
        if (this.bottomHalf != null) {
            this.tablePanel.remove(this.bottomHalf);
        }
        this.bottomHalf = this.table;
        this.tablePanel.add((Component)this.table, tgbc);
        if (this.theVolDDI.panel != null) {
            this.theVolDDI.show();
        }
    }

    static /* synthetic */ GUIStoragePool[] access$1302(VolumeListPanel x0, GUIStoragePool[] x1) {
        x0.arrpool = x1;
        return x1;
    }
}

