/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.details;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.details.ElemMgrHlprObj;
import org.eclipse.aperi.gui.fabric.details.LabeledDetailsPanel;
import org.eclipse.aperi.server.guireq.fabric.details.GuiDetailsReq;

class DetailsSubPanel
extends LabeledDetailsPanel
implements ActionListener {
    private JButton buLaunch;
    private JButton buSet;
    private JButton buReset;
    JLabel statusLabel;
    SwitchElementManagerHelper elementManagerHelper;
    ElemMgrHlprObj dummy;

    public DetailsSubPanel(String entityType, String entityId) {
        super(entityType, entityId);
        this.dummy = new ElemMgrHlprObj();
    }

    public DetailsSubPanel(String entityType, String entityID, Insets insets, boolean wantButtons) {
        super(entityType, entityID, insets, wantButtons);
        this.elementManagerHelper = null;
    }

    protected JPanel makeDetailPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)super.makeDetailPanel(), "Center");
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.buLaunch = new JButton(Util.getString("DISK_LAUNCH_ELEMENT_MANAGER_LABEL"));
        this.buLaunch.setEnabled(false);
        this.buLaunch.addActionListener(this);
        GuiUtil.setAccessible(this.buLaunch, this.buLaunch.getText(), this.buLaunch.getText());
        p2.add(this.buLaunch);
        this.buSet = new JButton(Util.getString("DISK_SET_LAUNCHELEMENTMGR_BUTTON"));
        this.buSet.setEnabled(false);
        this.buSet.addActionListener(this);
        GuiUtil.setAccessible(this.buSet, this.buSet.getText(), this.buSet.getText());
        p2.add(this.buSet);
        this.buReset = new JButton(Util.getString("DISK_RESET_LAUNCHELEMENTMGR_BUTTON"));
        this.buReset.setEnabled(false);
        GuiUtil.setAccessible(this.buReset, this.buReset.getText(), this.buReset.getText());
        this.buReset.addActionListener(this);
        p2.add(this.buReset);
        JPanel p3 = new JPanel();
        p3.setLayout(new BorderLayout());
        p3.add((Component)new JLabel(" "), "North");
        p3.add((Component)p2, "South");
        p.add((Component)p3, "South");
        return p;
    }

    public void displayDataInPanel(GuiDetailsReq data) {
        if (data != null) {
            this.dataInDb = data;
            this.elementManagerHelper = new SwitchElementManagerHelper();
            this.buLaunch.setEnabled(true);
            this.buSet.setEnabled(true);
            this.buReset.setEnabled(true);
        }
        super.displayDataInPanel(data);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buLaunch) {
            if (this.getElementManagerHelper() != null) {
                ElementManagerManager.getInstance().launchElementManager(this.dummy, this.getElementManagerHelper());
            }
        } else if (e.getSource() == this.buSet) {
            if (this.getElementManagerHelper() != null) {
                ElementManagerManager.getInstance().setElementManagerDialog(this.dummy, this.getElementManagerHelper());
            }
        } else if (e.getSource() == this.buReset) {
            if (this.getElementManagerHelper() != null) {
                ElementManagerManager.getInstance().deleteElementManager(this.dummy, this.getElementManagerHelper());
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return this.elementManagerHelper;
    }

    protected JComponent createFieldValueComponent(String fname) {
        if (fname.equals("FabricDetails_State")) {
            this.statusLabel = new JLabel("");
            return this.statusLabel;
        }
        return super.createFieldValueComponent(fname);
    }

    public void setFieldValue(JComponent c, Object value) {
        if (c == this.statusLabel) {
            Integer i = new Integer((String)value);
            JLabel l = FabricGuiUtil.getConsolidatedStateLabel(i);
            this.statusLabel.setText(l.getText());
            this.statusLabel.setIcon(l.getIcon());
        } else {
            super.setFieldValue(c, value);
        }
    }

    protected JLabel getFieldLabel(String fname) {
        if (fname.equals("FabricDetails_State")) {
            return new JLabel(Util.getString("DISK_STATE_LABEL"));
        }
        if (fname.equals("FabricDetails_ManagementAddress")) {
            return new JLabel(Util.getString("DISK_MANAGEMENT_ADDRESS_LABEL"));
        }
        return super.getFieldLabel(fname);
    }

    private class SwitchElementManagerHelper
    implements ElementManagerHelperInterface {
        private SwitchElementManagerHelper() {
        }

        public String extractGUID(Object element) {
            if (DetailsSubPanel.this.dataInDb != null && DetailsSubPanel.this.dataInDb.data != null) {
                return "switch:" + DetailsSubPanel.this.entityID;
            }
            return "";
        }

        public String extractDefaultElementManager(Object element) {
            if (DetailsSubPanel.this.dataInDb != null && DetailsSubPanel.this.dataInDb.data != null) {
                return "" + DetailsSubPanel.this.dataInDb.data.get("FabricDetails_ManagementAddress");
            }
            return "";
        }

        public String extractDisplayName(Object element) {
            if (DetailsSubPanel.this.dataInDb != null && DetailsSubPanel.this.dataInDb.data != null) {
                return "" + DetailsSubPanel.this.dataInDb.data.get("FabricDetails_Label");
            }
            return "";
        }
    }
}

