/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.details;

import java.net.URL;
import javax.swing.JComponent;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.details.IconComboBox;
import org.eclipse.aperi.gui.fabric.details.LabeledDetailsPanel;
import org.eclipse.aperi.gui.fabric.images.ImageLoader;
import org.eclipse.aperi.server.guireq.fabric.details.GuiDetailsReq;

class PortDetailsPanel
extends LabeledDetailsPanel {
    private static boolean dbg = false;
    IconComboBox iconBox;
    static final int[] iconVals = new int[]{100, 101, 103, 104, 105, 107, 108, 109};
    public static String[] fabricDetailsIconIDs = new String[]{"bridge", "disk", "nas", "server", "subsystem", "switch", "tape", "unknown"};
    int origIconBoxValue = 109;

    public PortDetailsPanel(String entityType, String entityID) {
        super(entityType, entityID);
    }

    public static boolean enableNodeDisplayIcon(int nodeType) {
        switch (nodeType) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return false;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return false;
            }
            case 16: {
                return false;
            }
            case 17: {
                return false;
            }
            case 18: {
                return false;
            }
            case 19: {
                return false;
            }
            case 100: {
                return true;
            }
            case 101: {
                return true;
            }
            case 102: {
                return true;
            }
            case 103: {
                return true;
            }
            case 104: {
                return true;
            }
            case 105: {
                return true;
            }
            case 106: {
                return true;
            }
            case 107: {
                return true;
            }
            case 108: {
                return true;
            }
            case 109: {
                return true;
            }
        }
        return false;
    }

    public static boolean enablePortDisplayIcon(int nodeType) {
        if (FabricGuiUtil.isSwitchPort(nodeType)) {
            return false;
        }
        switch (nodeType) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return false;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return false;
            }
            case 16: {
                return false;
            }
            case 17: {
                return false;
            }
            case 18: {
                return false;
            }
            case 19: {
                return false;
            }
            case 100: {
                return true;
            }
            case 101: {
                return true;
            }
            case 102: {
                return true;
            }
            case 103: {
                return true;
            }
            case 104: {
                return true;
            }
            case 105: {
                return true;
            }
            case 106: {
                return true;
            }
            case 107: {
                return true;
            }
            case 108: {
                return true;
            }
            case 109: {
                return true;
            }
        }
        return false;
    }

    boolean enableDisplayIcon(int type) {
        boolean result = this.entityType.equals("port") ? PortDetailsPanel.enableNodeDisplayIcon(type) : PortDetailsPanel.enablePortDisplayIcon(type);
        return result;
    }

    protected JComponent createFieldValueComponent(String fname) {
        if (fname.equals("FabricDetails_Type")) {
            this.iconBox = new IconComboBox();
            for (int i = 0; i < iconVals.length; ++i) {
                URL url = ImageLoader.getResourceURL(fabricDetailsIconIDs[i] + ".gif");
                this.iconBox.addIconFromURL(ImageLoader.getResourceURL(fabricDetailsIconIDs[i] + ".gif"), FabricGuiUtil.getIconTypeString(PortDetailsPanel.selectedIndexToId(i)), PortDetailsPanel.selectedIndexToId(i));
            }
            this.iconBox.setSelectedIndex(PortDetailsPanel.iconDbValueToSelected(109));
            this.iconBox.setEnabled(false);
            return this.iconBox;
        }
        return super.createFieldValueComponent(fname);
    }

    public static int iconDbValueToSelected(int dbVal) {
        int sel = iconVals.length - 1;
        for (int i = 0; i < iconVals.length; ++i) {
            if (dbVal != iconVals[i]) continue;
            sel = i;
            break;
        }
        if (dbg) {
            System.out.println("selectedIndexToId val:" + dbVal + "  ndx:" + sel);
        }
        return sel;
    }

    public static int selectedIndexToId(int val) {
        int ndx = val >= 0 && val < iconVals.length ? iconVals[val] : 109;
        if (dbg) {
            System.out.println("selectedIndexToId val:" + val + "  ndx:" + ndx);
        }
        return ndx;
    }

    public void setFieldValue(JComponent c, Object value) {
        if (c == this.iconBox) {
            String s = (String)value;
            if (dbg) {
                System.out.println("setFieldValue icon value " + s);
            }
            s = s.trim();
            try {
                Integer integer = new Integer(s);
                this.origIconBoxValue = this.entityType.equals("node") && (integer == 9 || integer == 6) ? 104 : (this.entityType.equals("port") && FabricGuiUtil.isSwitchPort(integer) ? 107 : (integer >= 100 && integer < 109 ? integer : 109));
                this.iconBox.setSelectedIndex(PortDetailsPanel.iconDbValueToSelected(this.origIconBoxValue));
                this.iconBox.setEnabled(this.enableDisplayIcon(integer));
            }
            catch (NumberFormatException nfe) {
                this.origIconBoxValue = 109;
                this.iconBox.setSelectedIndex(PortDetailsPanel.iconDbValueToSelected(109));
            }
            this.invalidate();
            this.validate();
        } else {
            super.setFieldValue(c, value);
        }
    }

    public boolean isEditable() {
        return true;
    }

    public boolean changesPending() {
        boolean result = false;
        if (this.iconBox.isEnabled()) {
            if (dbg) {
                System.out.println("Comparing [" + this.origIconBoxValue + "] [" + this.iconBox.getSelectedId() + "]");
            }
            if (this.origIconBoxValue != this.iconBox.getSelectedId()) {
                result = true;
            }
        }
        if (!result) {
            result = this.isFieldChanged("FabricDetails_Label");
        }
        return result;
    }

    public void getDataFromPanel(GuiDetailsReq data) {
        if (this.changesPending()) {
            if (this.iconBox.isEnabled()) {
                data.data.put("FabricDetails_icon", "" + this.iconBox.getSelectedId());
                this.origIconBoxValue = this.iconBox.getSelectedId();
            }
            data.data.put("FabricDetails_Label", "" + this.getFieldValue(this.label));
        }
        if (dbg) {
            data.dump();
        }
    }
}

