/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GridBagPanel
extends JPanel {
    public static final int C_HORZ = 2;
    public static final int C_VERT = 3;
    public static final int C_BOTH = 1;
    public static final int C_NONE = 0;
    public static final int C_CENTER = 10;
    public static final int C_WEST = 17;
    public static final int C_EAST = 13;
    public static final int C_NW = 18;
    public static final int C_NE = 12;
    public static final int C_SW = 16;
    public static final int C_SE = 14;
    public static final int C_NORTH = 11;
    public static final int C_WIDTH = 1;
    public static final int C_HEIGHT = 1;
    public static final Dimension TEXTFIELDSIZE = new Dimension(165, 25);
    public static final Dimension TEXTAREASIZE;
    public static final Dimension TABLESIZE;
    private GridBagConstraints gbc;
    private Insets m_insets;
    private Insets titleInsets = new Insets(8, 5, 0, 8);
    private Insets subtitleInsets = new Insets(8, 10, 0, 8);
    private Insets descriptionInsets = new Insets(4, 12, 2, 8);
    private int m_anchor = 18;
    private int m_column = 0;
    private int m_row = 0;
    private JLabel topLabel;
    private JLabel descriptionLabel;

    public GridBagPanel() {
        this(new Insets(4, 12, 0, 8));
    }

    public GridBagPanel(Insets ins) {
        super(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = this.m_anchor;
        this.gbc.insets = this.m_insets = ins;
        this.gbc.fill = 2;
    }

    public void setDefaultAnchor(int anchor) {
        this.gbc.anchor = this.m_anchor = anchor;
    }

    public void setDefaultInsets(Insets ins) {
        this.gbc.insets = this.m_insets = ins;
    }

    public void changeTitle(String text) {
        this.topLabel.setText(text);
    }

    public void changeDescription(String text) {
        this.descriptionLabel.setText(text);
    }

    public void newRow() {
        ++this.m_row;
        this.m_column = 0;
    }

    public void skipColumn() {
        ++this.m_column;
    }

    public void add(JComponent component) {
        this.addComponent(component, this.m_row, this.m_column, 1, 1, this.m_anchor, 2);
    }

    public void add(JComponent component, int fill) {
        this.addComponent(component, this.m_row, this.m_column, 1, 1, this.m_anchor, fill);
    }

    public void add(JComponent component, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, this.m_row, this.m_column, 1, 1, this.m_anchor, 2);
    }

    public void add(JComponent component, int anchor, int fill) {
        this.addComponent(component, this.m_row, this.m_column, 1, 1, anchor, fill);
    }

    public void add(JComponent component, int fill, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, this.m_row, this.m_column, 1, 1, this.m_anchor, fill);
    }

    public void add(JComponent component, int anchor, int fill, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, this.m_row, this.m_column, 1, 1, anchor, fill);
    }

    public void add(JComponent component, int width, int height, int fill) {
        this.addComponent(component, this.m_row, this.m_column, width, height, this.m_anchor, fill);
    }

    public void add(JComponent component, int width, int height, int fill, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, this.m_row, this.m_column, width, height, this.m_anchor, fill);
    }

    public void add(JComponent component, int row, int col, int width, int height, int anchor, int fill, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, row, col, width, height, anchor, fill);
    }

    public void createBox() {
        JPanel panel = new JPanel();
        panel.setBackground(this.getBackground());
        this.addComponent(panel, this.m_row, this.m_column, 1, 1, this.m_anchor, 0);
    }

    public void createStretchBox() {
        JPanel sbox = new JPanel();
        sbox.setBackground(this.getBackground());
        sbox.setPreferredSize(new Dimension(0, 0));
        sbox.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        sbox.setMinimumSize(new Dimension(0, 0));
        this.addComponent(sbox, this.m_row, this.m_column, 1, 1, this.m_anchor, 1);
    }

    public void addComponent(JComponent component, int row, int col, int width, int height, int anchor, int fill) {
        this.gbc.gridx = col;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.anchor = anchor;
        double weightx = 0.0;
        double weighty = 0.0;
        if (width > 1) {
            weightx = 1.0;
        }
        if (height > 1) {
            weighty = 1.0;
        }
        switch (fill) {
            case 2: {
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 0.0;
                break;
            }
            case 3: {
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 1.0;
                break;
            }
            case 1: {
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 1.0;
                break;
            }
            case 0: {
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 0.0;
                break;
            }
        }
        this.gbc.fill = fill;
        super.add((Component)component, this.gbc);
        this.gbc.insets = this.m_insets;
        this.gbc.anchor = this.m_anchor;
        this.m_column = col + width;
        this.m_row = row + height - 1;
    }

    static {
        TABLESIZE = TEXTAREASIZE = new Dimension(165, 100);
    }
}

