/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneConfigurationTree;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneConfigurationPanel
extends JPanel
implements ActionListener {
    protected ZoneCNS zoneCNS = null;
    protected JButton refreshButton;
    protected JButton editButton;
    protected JLabel leftTitle;
    protected JLabel rightTitle;
    protected ZoneConfigurationTree zoneTree;
    protected ZoneConfigurationTree activeZoneTree;
    protected JPanel returnPanel;
    protected JPanel activePanel;
    protected JPanel definitionPanel;
    private JLabel statusLabel = new JLabel("");
    private JLabel zsActiveLabel = new JLabel("");
    private String sanWWN = null;
    private String sanLabel = null;

    public ZoneConfigurationPanel(ZoneCNS cns) {
        this.zoneCNS = cns;
        this.sanWWN = this.zoneCNS.getSanWWN();
        this.sanLabel = this.zoneCNS.getSanLabel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createButtonPanel(), "North");
        this.refreshButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.enableEditButton(false);
        this.add((Component)this.createZonePanels(), "Center");
    }

    private JPanel createZonePanels() {
        this.returnPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.activePanel = this.createActiveZonePanel();
        this.definitionPanel = this.createZoneDefinitionPanel();
        this.leftTitle = new JLabel(FabricGuiUtil.getString("FabricZone_ActiveConfig"));
        this.rightTitle = new JLabel(FabricGuiUtil.getString("FabricZoneSetPage_title"));
        this.leftTitle.setLabelFor(this.activePanel);
        this.rightTitle.setLabelFor(this.definitionPanel);
        JPanel leftPane = this.getPane(this.activePanel, this.leftTitle);
        JPanel rightPane = this.getPane(this.definitionPanel, this.rightTitle);
        GuiUtil.setAccessible(this.leftTitle, FabricGuiUtil.getString("FabricZone_ActiveConfig"), FabricGuiUtil.getString("FabricZone_Active_Tree_Description"));
        GuiUtil.setAccessible(this.rightTitle, FabricGuiUtil.getString("FabricZone_ConfigDef"), FabricGuiUtil.getString("FabricZone_Def_Tree_Description"));
        gbc.gridheight = 0;
        gbc.insets.bottom = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.returnPanel.add((Component)leftPane, gbc);
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.weightx = 0.5;
        gbc.gridwidth = 0;
        this.returnPanel.add((Component)rightPane, gbc);
        return this.returnPanel;
    }

    public ZoneCNS getZoneCNS() {
        return this.zoneCNS;
    }

    private JPanel createZoneDefinitionPanel() {
        JPanel returnPane = GuiUtil.getPanel();
        returnPane.setLayout(new BorderLayout());
        this.zoneTree = new ZoneConfigurationTree(this.zoneCNS, false);
        JScrollPane treePane = new JScrollPane(this.zoneTree);
        returnPane.add(this.zoneTree);
        return returnPane;
    }

    private JPanel createActiveZonePanel() {
        JPanel returnPane = GuiUtil.getPanel();
        returnPane.setLayout(new BorderLayout());
        this.activeZoneTree = new ZoneConfigurationTree(this.zoneCNS, true);
        returnPane.add((Component)this.activeZoneTree, "Center");
        return returnPane;
    }

    public void refreshZoneConfigTab() {
        this.sanWWN = this.zoneCNS.getSanWWN();
        this.sanLabel = this.zoneCNS.getSanLabel();
        this.setActiveText();
        this.zoneTree.populateTree();
        this.activeZoneTree.populateTree();
        this.remove(this.returnPanel);
        this.add((Component)this.createZonePanels(), "Center");
    }

    private JPanel createButtonPanel() {
        JPanel tempPanel = GuiUtil.getBorderedPanel();
        tempPanel.setLayout(new GridBagLayout());
        tempPanel.setBorder(new TitledBorder(Util.getString("FabricZone_DisplayZones")));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.refreshButton = new JButton(FabricGuiUtil.getString("FabricZone_Refresh"));
        GuiUtil.setAccessible(this.refreshButton, FabricGuiUtil.getString("FabricZone_Refresh"), FabricGuiUtil.getString("FabricZone_Refresh"));
        this.refreshButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_Refresh_M")));
        this.editButton = new JButton(FabricGuiUtil.getString("FabricZone_EditConfig"));
        GuiUtil.setAccessible(this.editButton, FabricGuiUtil.getString("FabricZone_EditConfig"), FabricGuiUtil.getString("FabricZone_EditConfig"));
        this.editButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_EditConfig_M")));
        buttonPanel.add(this.refreshButton);
        buttonPanel.add(this.editButton);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(15, 10, 0, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        tempPanel.add((Component)buttonPanel, c);
        c.insets = new Insets(15, 10, 0, 10);
        c.gridx = 0;
        c.gridy = 1;
        tempPanel.add((Component)this.zsActiveLabel, c);
        c.insets = new Insets(15, 10, 15, 10);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        tempPanel.add((Component)this.statusLabel, c);
        return tempPanel;
    }

    public void setStatusText(String status) {
        this.statusLabel.setText(status);
        GuiUtil.setAccessibleLabel(this.statusLabel, this, "", status, status);
    }

    public void setActiveText() {
        String zoneSetName = this.zoneCNS.getActiveZoneSetLabel();
        if (zoneSetName != null && !zoneSetName.equals("")) {
            String activeLabel = IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_CurrentAct"), new Object[]{zoneSetName});
            this.zsActiveLabel.setText(activeLabel);
            GuiUtil.setAccessibleLabel(this.zsActiveLabel, this, "", activeLabel, activeLabel);
        } else {
            this.zsActiveLabel.setText("");
        }
    }

    private JPanel getPane(JComponent component, JLabel title) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(component);
        scrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)title, "North");
        pane.add((Component)scrollPane, "Center");
        return pane;
    }

    public void enableEditButton(boolean enable) {
        this.editButton.setEnabled(enable);
    }

    public void enableRefreshButton(boolean enable) {
        this.refreshButton.setEnabled(enable);
    }

    public String getSanWWN() {
        return this.sanWWN;
    }

    public String getSanLabel() {
        return this.sanLabel;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.refreshButton) {
            this.zoneCNS.reDisplay();
        } else if (source == this.editButton) {
            this.zoneCNS.showZoneDefPanel();
        }
    }
}

