/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.HashMap;
import org.eclipse.aperi.gui.TCloseTabPane;
import org.eclipse.aperi.gui.TabCloseListener;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.FabricTablePanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneConfigurationPanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneDDI;
import org.eclipse.aperi.gui.fabric.zone.ZoneDefinitionPanel;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneControlTabbedPane
extends TCloseTabPane
implements TabCloseListener {
    ZoneDDI zoneDDI = null;
    FabricTablePanel fabricPanel = null;
    public static int fabricPanelInt = 0;
    ZoneConfigurationPanel zc;
    HashMap[] sans = null;
    private HashMap zoneConfigTabs = new HashMap();
    private HashMap zoneDefTabs = new HashMap();
    private HashMap tabCounter = new HashMap();
    private HashMap tabPanelTracker = new HashMap();
    private HashMap tabLabelTracker = new HashMap();

    public ZoneControlTabbedPane(ZoneDDI ddi) {
        this.zoneDDI = ddi;
    }

    public boolean closeTab(int tab) {
        this.setTabsCounter();
        String tabWWN = this.getTabWWN(tab);
        String delim = tabWWN.substring(0, 2);
        String sanwwn = tabWWN.substring(2);
        if (delim.equalsIgnoreCase("D:") && this.zoneDefTabs.containsKey(sanwwn)) {
            ZoneDefinitionPanel zDef = (ZoneDefinitionPanel)this.zoneDefTabs.get(sanwwn);
            this.removeZoneDefTab(sanwwn, zDef.getSanLabel());
        } else if (delim.equalsIgnoreCase("C:") && this.zoneConfigTabs.containsKey(sanwwn)) {
            ZoneConfigurationPanel zConf = (ZoneConfigurationPanel)this.zoneConfigTabs.get(sanwwn);
            this.removeZoneConfigTab(sanwwn, zConf.getSanLabel());
        }
        return true;
    }

    public void refreshConfigurationPanel(String sanWWN) {
        if (this.zoneConfigTabs.containsKey(sanWWN)) {
            ((ZoneConfigurationPanel)this.zoneConfigTabs.get(sanWWN)).refreshZoneConfigTab();
        }
    }

    public int getConfigTabIndex(String sanWWN, String sanLabel) {
        String tabLabel = this.getConfigTabLabel(sanLabel);
        this.setTabsCounter();
        return (Integer)this.tabCounter.get(tabLabel);
    }

    public int getDefTabIndex(String sanWWN, String sanLabel) {
        String tabLabel = this.getDefTabLabel(sanLabel);
        this.setTabsCounter();
        return (Integer)this.tabCounter.get(tabLabel);
    }

    public void refreshDefinitionPanel(String sanWWN) {
        if (this.zoneDefTabs.containsKey(sanWWN)) {
            ((ZoneDefinitionPanel)this.zoneDefTabs.get(sanWWN)).refreshDefPanel();
        }
    }

    public void addZoneDefTab(String sanWWN) {
        ZoneCNS zoneCNS = ((ZoneConfigurationPanel)this.zoneConfigTabs.get(sanWWN)).getZoneCNS();
        String tabLabel = this.getDefTabLabel(zoneCNS.getSanLabel());
        if (this.zoneConfigTabs.containsKey(sanWWN) && !this.zoneDefTabs.containsKey(sanWWN)) {
            ZoneDefinitionPanel panel = new ZoneDefinitionPanel(zoneCNS);
            this.zoneDefTabs.put(sanWWN, panel);
            this.addTab(tabLabel, panel, tabLabel, true);
            this.tabLabelTracker.put(tabLabel, "D:" + sanWWN);
        } else {
            this.refreshDefinitionPanel(sanWWN);
        }
        this.setTabsCounter();
        Integer tab = (Integer)this.tabCounter.get(tabLabel);
        this.setSelectedIndex(tab);
    }

    private void setTabsCounter() {
        int numTabs = this.getTabCount();
        this.tabCounter = new HashMap();
        this.tabPanelTracker = new HashMap();
        for (int i = 0; i < numTabs; ++i) {
            String tabLabel = this.getTitleAt(i);
            Integer tabInteger = new Integer(i);
            if (this.tabLabelTracker.containsKey(tabLabel)) {
                this.tabPanelTracker.put(tabInteger, this.tabLabelTracker.get(tabLabel));
            }
            this.tabCounter.put(tabLabel, tabInteger);
        }
    }

    private void showPanel() {
        this.zoneDDI.show();
    }

    public void addZoneConfigTab(String sanWWN, String sanLabel) {
        ZoneCNS cns = new ZoneCNS(this.zoneDDI, sanLabel, sanWWN);
        String tabLabel = this.getConfigTabLabel(cns.getSanLabel());
        if (this.zoneConfigTabs.containsKey(sanWWN)) {
            this.refreshConfigurationPanel(sanWWN);
        } else {
            cns.populateZoneDefinition();
            cns.ping();
            ZoneConfigurationPanel panel = new ZoneConfigurationPanel(cns);
            this.zoneConfigTabs.put(sanWWN, panel);
            this.addTab(tabLabel, panel, tabLabel, true);
            this.tabLabelTracker.put(tabLabel, "C:" + sanWWN);
        }
        this.setTabsCounter();
        this.setSelectedIndex((Integer)this.tabCounter.get(tabLabel));
    }

    public void removeZoneDefTab(String sanWWN, String sanLabel) {
        if (this.zoneDefTabs.containsKey(sanWWN)) {
            String tabLabel = this.getDefTabLabel(sanLabel);
            this.setTabsCounter();
            int tabIndex = (Integer)this.tabCounter.get(tabLabel);
            this.zoneDefTabs.remove(sanWWN);
            this.tabLabelTracker.remove(tabLabel);
            this.setTabsCounter();
        }
    }

    public void removeZoneConfigTab(String sanWWN, String sanLabel) {
        if (this.zoneConfigTabs.containsKey(sanWWN)) {
            String tabLabel = this.getConfigTabLabel(sanLabel);
            this.setTabsCounter();
            int tabIndex = (Integer)this.tabCounter.get(tabLabel);
            this.zoneConfigTabs.remove(sanWWN);
            this.tabLabelTracker.remove(tabLabel);
            this.setTabsCounter();
        }
    }

    private String getConfigTabLabel(String sanLabel) {
        return IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_ZoningTabTitle"), new Object[]{sanLabel});
    }

    private String getDefTabLabel(String sanLabel) {
        return IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_DefTabTitle"), new Object[]{sanLabel});
    }

    private String getTabWWN(int tab) {
        String returnString = "";
        Integer tabInt = new Integer(tab);
        if (this.tabPanelTracker.containsKey(tabInt)) {
            return (String)this.tabPanelTracker.get(tabInt);
        }
        return returnString;
    }

    public void enableEditButton(boolean enable, String sanWWN) {
        try {
            if (this.zoneConfigTabs.containsKey(sanWWN)) {
                ((ZoneConfigurationPanel)this.zoneConfigTabs.get(sanWWN)).enableEditButton(enable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void enableRefreshButton(boolean enable, String sanWWN) {
        try {
            if (this.zoneConfigTabs.containsKey(sanWWN)) {
                ((ZoneConfigurationPanel)this.zoneConfigTabs.get(sanWWN)).enableRefreshButton(enable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reinitialize() {
        this.removeAll();
        this.addFirstTab(this.sans);
    }

    public void addFirstTab(HashMap[] sans) {
        String tabLabel = FabricGuiUtil.getString("Fabric_TabTitle");
        this.fabricPanel = new FabricTablePanel(sans, this);
        this.addTab(tabLabel, this.fabricPanel, tabLabel, false);
        this.setSelectedIndex(fabricPanelInt);
    }

    public void refreshSanTab(HashMap[] sans) {
        this.fabricPanel.refreshTable(sans);
    }

    public void setStatusText(String text, String sanWWN) {
        try {
            if (this.zoneConfigTabs.containsKey(sanWWN)) {
                ((ZoneConfigurationPanel)this.zoneConfigTabs.get(sanWWN)).setStatusText(text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

