/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneSetWizard;

public class ZoneSetNameDescriptionStep
extends WizardPage
implements ActionListener {
    boolean newZS = true;
    JTextField nameField;
    JTextField descField;

    public ZoneSetNameDescriptionStep(int buttonFlags, boolean sZone, String name, String desc) {
        super(buttonFlags);
        this.setName("ZoneSetNameDescriptionStep");
        Container pane = this.getContentPane();
        pane.add(this.createTitlePanel(sZone, name, desc));
        this.setUpHelp(FabricGuiUtil.FHELP_ZC_ZSWIZ1);
    }

    public Object next() {
        return "AssignZonesStep";
    }

    private JPanel createTitlePanel(boolean isNewZoneSet, String name, String desc) {
        Container pane = this.getContentPane();
        this.newZS = isNewZoneSet;
        GridBagPanel tempPanel = new GridBagPanel();
        tempPanel.setTitle(Util.getString("FabricZone_ZoneSetConfigTitle"));
        tempPanel.newRow();
        tempPanel.newRow();
        tempPanel.newRow();
        String nameText = Util.getString("FabricDetails_Name");
        JLabel nameLabel = new JLabel(nameText);
        this.nameField = new JTextField(name, 20);
        GuiUtil.setAccessibleLabel(nameLabel, this.nameField, "", nameText, nameText);
        this.nameField.setEditable(true);
        tempPanel.add(nameLabel);
        tempPanel.add(this.nameField);
        tempPanel.add((JComponent)new JLabel(), 0, 1, 2);
        tempPanel.newRow();
        tempPanel.newRow();
        tempPanel.newRow();
        this.descField = new JTextField(desc, 20);
        this.descField.setEditable(true);
        String descText = Util.getString("FabricDetails_Description");
        JLabel descLabel = new JLabel(descText);
        GuiUtil.setAccessibleLabel(descLabel, this.descField, "", descText, descText);
        tempPanel.add(descLabel);
        tempPanel.add(this.descField);
        tempPanel.add((JComponent)new JLabel(), 0, 1, 2);
        tempPanel.newRow();
        tempPanel.add((JComponent)new JLabel(), 1);
        return tempPanel;
    }

    public boolean nextBegin() {
        String name = this.nameField.getText();
        String desc = this.descField.getText();
        boolean next = true;
        ZoneSetWizard zsWizard = (ZoneSetWizard)this.getParent();
        if (this.newZS && zsWizard.hasZoneSet(name)) {
            next = false;
            JOptionPane.showMessageDialog(this, Util.getString("FabricZoneSetFrame_DuplicateZoneSetNameErrorMsg"));
            this.nameField.requestFocus();
            return next;
        }
        if (!zsWizard.isSupportsSameZoneSetAndZoneName() && zsWizard.hasZone(name)) {
            next = false;
            JOptionPane.showMessageDialog(this, Util.getString("FabricZone_ZoneZoneSetSameNameError"));
            this.nameField.requestFocus();
            return next;
        }
        if (name.equalsIgnoreCase("")) {
            next = false;
            JOptionPane.showMessageDialog(this, Util.getString("FabricZoneSetFrame_NoZoneSetNameErrorMsg"));
            this.nameField.requestFocus();
            return next;
        }
        String error = zsWizard.checkZSNameString(name);
        if (error != null) {
            next = false;
            JOptionPane.showMessageDialog(this, error);
            this.nameField.requestFocus();
            return next;
        }
        zsWizard.setZSNameDesc(name, desc);
        return next;
    }

    public void actionPerformed(ActionEvent e) {
    }
}

