/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.TUpDownListSelector;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneSetSelectorPanel
implements ActionListener {
    ZoneCNS zoneCNS;
    Zone zone;
    ZoneSet[] origZS;
    DefaultListModel srcModel = new DefaultListModel();
    DefaultListModel selModel = new DefaultListModel();
    JList selList;
    TUpDownListSelector listSelector;

    public ZoneSetSelectorPanel(ZoneCNS cns, Zone newZone, ZoneSet[] zs) {
        this.zoneCNS = cns;
        this.zone = newZone;
        this.origZS = zs;
    }

    public JPanel createPanel() {
        JPanel returnPanel = new JPanel(new BorderLayout());
        this.selList = this.createCurrentZoneSetList();
        this.listSelector = new TUpDownListSelector(this.createAvailableZoneSetList(), this.selList, FabricGuiUtil.getString("FabricZone_PotentialZoneSets"), FabricGuiUtil.getString("FabricZone_CurrentZonesets"), false);
        this.populateModels();
        returnPanel.add((Component)this.listSelector, "Center");
        return returnPanel;
    }

    private void populateModels() {
        int i;
        ZoneSet[] allZS = this.zoneCNS.getZoneSets();
        HashMap<String, String> zSets = new HashMap<String, String>();
        if (this.origZS != null) {
            for (i = 0; i < this.origZS.length; ++i) {
                this.selModel.addElement(this.origZS[i].getName());
                zSets.put(this.origZS[i].getName(), this.origZS[i].getName());
            }
        }
        for (i = 0; i < allZS.length; ++i) {
            if (zSets.containsKey(allZS[i].getName())) continue;
            this.srcModel.addElement(allZS[i].getName());
        }
    }

    public ArrayList getSelectList() {
        return this.listSelector.getSelList();
    }

    private JList createAvailableZoneSetList() {
        return new JList(this.srcModel);
    }

    private JList createCurrentZoneSetList() {
        return new JList(this.selModel);
    }

    public void actionPerformed(ActionEvent e) {
    }
}

