/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneSetWizard;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneSetTablePanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener {
    protected ZoneCNS zoneCNS = null;
    private MegaTable zsTable = new MegaTable();
    private JPanel tablePanel;
    private ZoneSetTableModel zsModel;
    private ZoneSet[] zsTableData;
    private boolean dblClick = false;
    private JButton addZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSetPanel_add"));
    private JButton delZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSet_Delete"));
    private JButton dupZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSet_Duplicate"));
    private JButton editZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSet_Edit"));
    private JButton actZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSetPage_ActivateButton"));
    private JButton deactZSButton = new JButton(FabricGuiUtil.getString("FabricZoneSetPage_DeactivateButton"));
    private static final ImageIcon ERROR_ICON = GuiUtil.createImageIcon("images/exclam.gif", Util.getString("DESC_ZONE_SETTING_ERROR"));
    private static final int ZONESET_COL = 0;
    private static final int ZONESET_ACTIVE_COL = 1;
    private static final int ZONESET_DESCRIPTION_COL = 2;
    private static final String[] ZONESET_COL_NAMES = new String[]{FabricGuiUtil.getString("FabricZone_ZS_Column"), FabricGuiUtil.getString("FabricZoneSetPage_ActiveZoneSet"), FabricGuiUtil.getString("FabricZone_Description_Column")};
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ZoneSetTablePanel(ZoneCNS cns) {
        this.zoneCNS = cns;
        this.setBorder(new TitledBorder(Util.getString("FabricZoneSetPage_PageTitle")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 0, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        JPanel tempPanel = new JPanel(new BorderLayout());
        tempPanel.add((Component)this.createButtonPanel(), "North");
        this.tablePanel = this.createZSTable();
        tempPanel.add((Component)this.tablePanel, "Center");
        this.add((Component)tempPanel, c);
        this.addZSButton.addActionListener(this);
        this.editZSButton.addActionListener(this);
        this.dupZSButton.addActionListener(this);
        this.delZSButton.addActionListener(this);
        this.actZSButton.addActionListener(this);
        this.deactZSButton.addActionListener(this);
        this.refreshTable(this.zoneCNS);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        GuiUtil.setAccessible(this.addZSButton, FabricGuiUtil.getString("FabricZoneSetPanel_add"), FabricGuiUtil.getString("FabricZoneSetPanel_add"));
        this.addZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSetPanel_add_M")));
        buttonPanel.add(this.addZSButton);
        GuiUtil.setAccessible(this.delZSButton, FabricGuiUtil.getString("FabricZoneSet_Delete"), FabricGuiUtil.getString("FabricZoneSet_Delete"));
        this.delZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSet_Delete_M")));
        buttonPanel.add(this.delZSButton);
        GuiUtil.setAccessible(this.editZSButton, FabricGuiUtil.getString("FabricZoneSet_Edit"), FabricGuiUtil.getString("FabricZoneSet_Edit"));
        this.editZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSet_Edit_M")));
        buttonPanel.add(this.editZSButton);
        GuiUtil.setAccessible(this.dupZSButton, FabricGuiUtil.getString("FabricZoneSet_Duplicate"), FabricGuiUtil.getString("FabricZoneSet_Duplicate"));
        this.dupZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSet_Duplicate_M")));
        buttonPanel.add(this.dupZSButton);
        GuiUtil.setAccessible(this.deactZSButton, FabricGuiUtil.getString("FabricZoneSetPage_DeactivateButton"), FabricGuiUtil.getString("FabricZoneSetPage_DeactivateButton"));
        this.deactZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSetPage_Deactivate_M")));
        buttonPanel.add(this.deactZSButton);
        GuiUtil.setAccessible(this.actZSButton, FabricGuiUtil.getString("FabricZoneSetPage_ActivateButton"), FabricGuiUtil.getString("FabricZoneSetPage_ActivateButton"));
        this.actZSButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZoneSetPage_Activate_M")));
        buttonPanel.add(this.actZSButton);
        return buttonPanel;
    }

    private JPanel createZSTable() {
        JPanel fabricPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(15, 10, 0, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        JPanel tempPanel = new JPanel(new FlowLayout());
        this.initializeZSTable();
        tempPanel.add(this.zsTable);
        fabricPanel.add((Component)tempPanel, c);
        return tempPanel;
    }

    public void refreshTable(ZoneCNS cns) {
        this.zoneCNS = cns;
        boolean empty = this.zsModel.refreshTableData();
        this.zsModel.tableDataReset();
        this.tablePanel.removeAll();
        if (!empty) {
            this.tablePanel.add(this.zsTable);
        } else {
            this.tablePanel.add(ReportingDDI.getNoDataMessage(null));
        }
        this.zsTable.sortByColumn(0, -1);
    }

    private void initializeZSTable() {
        this.zsTable.setSelectionPolicy(0);
        this.zsTable.setMouseListener(this);
        this.zsModel = new ZoneSetTableModel();
        this.zsTable.setCellRenderer(String.class, new IconTableCellRenderer());
        this.zsTable.setBaseTableModel(this.zsModel);
        boolean vColIndex = false;
        this.zsTable.sortByColumn(0, -1);
    }

    public void actionPerformed(ActionEvent event) {
        ZoneSet[] zoneSets;
        Object source = event.getSource();
        if (source == this.addZSButton) {
            int maxZS = this.zoneCNS.getZoneCapabilities().getMaxZoneSets();
            int rowZS = this.zsTable.getNumRows();
            if (maxZS != -1 && maxZS <= rowZS) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_MaxZoneSets"));
            } else {
                ZoneSetWizard wiz = new ZoneSetWizard(this.zoneCNS);
                JDialog wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneSetConfigTitle"), true);
                wizardDialog.getContentPane().add(wiz);
                wizardDialog.pack();
                GuiUtil.centerDialog(wizardDialog);
                wizardDialog.show();
            }
        } else if (source == this.delZSButton) {
            int result = JOptionPane.showConfirmDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_DeleteZoneSetWarning"), FabricGuiUtil.getString("FabricZoneSetPage_DeleteZoneSetTitle"), 0);
            if (result == 0) {
                ZoneSet[] zoneSetArray = this.getSelectedZoneSets();
                this.zoneCNS.deleteZoneSets(zoneSetArray);
                for (int i = 0; i < zoneSetArray.length; ++i) {
                    Vector orphanZones;
                    this.zoneCNS.removeZoneSetConfigError(zoneSetArray[i].getName());
                    if (this.zoneCNS.getZoneCapabilities().isSupportsOrphanZones() || (orphanZones = this.zoneCNS.checkForOrphanZones()) == null || orphanZones.size() <= 0) continue;
                    for (int j = 0; j < orphanZones.size(); ++j) {
                        this.zoneCNS.addZoneConfigError(((Zone)orphanZones.get(j)).getName());
                    }
                }
                this.zoneCNS.refreshDefinitionPanel();
            }
        } else if (source == this.dupZSButton) {
            if (this.zoneCNS.getZoneCapabilities().getMaxZoneSets() >= this.zsTable.getNumRows()) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_MaxZoneSets"));
            } else {
                ZoneSet[] zoneSets2 = this.getSelectedZoneSets();
                if (zoneSets2 != null && zoneSets2.length > 0) {
                    ZoneSet editZS = zoneSets2[0];
                    ZoneSetWizard wiz = new ZoneSetWizard(editZS, this.zoneCNS, true, false);
                    JDialog wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneSetConfigTitle"), true);
                    wizardDialog.getContentPane().add(wiz);
                    wizardDialog.pack();
                    GuiUtil.centerDialog(wizardDialog);
                    wizardDialog.show();
                }
            }
        } else if (source == this.editZSButton && (zoneSets = this.getSelectedZoneSets()) != null && zoneSets.length > 0) {
            ZoneSet editZS = zoneSets[0];
            ZoneSetWizard wiz = new ZoneSetWizard(editZS, this.zoneCNS, false, true);
            JDialog wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("FabricZone_ZoneSetConfigTitle"), true);
            wizardDialog.getContentPane().add(wiz);
            wizardDialog.pack();
            GuiUtil.centerDialog(wizardDialog);
            wizardDialog.show();
        }
        if (source == this.actZSButton) {
            ZoneSet[] zsArray = this.getSelectedZoneSets();
            if (zsArray.length > 1) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_MultipleZoneSetsActivated"), FabricGuiUtil.getString("FabricZoneSetPage_ZoneSetActivationErrorTitle"), 0);
                return;
            }
            if (zsArray != null && zsArray.length > 0) {
                this.zoneCNS.activateZoneSet(zsArray[0]);
                this.zoneCNS.refreshDefinitionPanel();
            }
        } else if (source == this.deactZSButton) {
            ZoneSet[] zsArray = this.getSelectedZoneSets();
            if (zsArray.length > 1) {
                JOptionPane.showMessageDialog(this, FabricGuiUtil.getString("FabricZoneSetPage_MultipleZoneSetsDeactivated"), FabricGuiUtil.getString("FabricZoneSetPage_ZoneSetActivationErrorTitle"), 0);
                return;
            }
            if (zsArray != null && zsArray.length > 0) {
                this.zoneCNS.deactivateZoneSet(zsArray[0]);
                this.zoneCNS.refreshDefinitionPanel();
            }
        }
    }

    private ZoneSet[] getSelectedZoneSets() {
        int[] selected = this.zsTable.getSelectedRows();
        ZoneSet[] zs = new ZoneSet[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            zs[i] = this.zsTableData[selected[i]];
        }
        return zs;
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
    }

    public void selectionChanged(boolean state) {
    }

    public void doubleClick(int dataRow, int dataCol) {
    }

    public void showDefaultChart(int dataRow) {
    }

    static /* synthetic */ ZoneSet[] access$102(ZoneSetTablePanel x0, ZoneSet[] x1) {
        x0.zsTableData = x1;
        return x1;
    }

    class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object o) {
            this.setHorizontalAlignment(2);
            this.setVerticalTextPosition(1);
            String name = (String)o;
            if (name != null && this.hasIcon(name)) {
                this.setIcon(ERROR_ICON);
            } else {
                this.setIcon(null);
            }
            this.setText(name);
        }

        protected boolean hasIcon(String name) {
            boolean error = ZoneSetTablePanel.this.zoneCNS.hasZoneSetError(name);
            return error;
        }
    }

    private class ZoneSetTableModel
    extends BaseTableModel {
        ZoneSetTableModel() {
            this.populateTable();
            this.tableDataReset();
        }

        public int getNumRows() {
            return this.rowCount;
        }

        public boolean populateTable() {
            boolean empty = false;
            this.columnNames = ZONESET_COL_NAMES;
            ZoneSetTablePanel.access$102(ZoneSetTablePanel.this, ZoneSetTablePanel.this.zoneCNS.getZoneDefinition(false).getZoneSets());
            if (ZoneSetTablePanel.this.zsTableData == null || ZoneSetTablePanel.this.zsTableData.length == 0) {
                empty = true;
                return empty;
            }
            return empty;
        }

        public void tableDataReset() {
            this.rowCount = ZoneSetTablePanel.this.zsTableData.length;
            this.fireTableDataChanged();
        }

        public boolean refreshTableData() {
            return this.populateTable();
        }

        public Object getTableDataItem(int row, int col) {
            try {
                switch (col) {
                    case 0: {
                        return ZoneSetTablePanel.this.zsTableData[row].getName();
                    }
                    case 2: {
                        return ZoneSetTablePanel.this.zsTableData[row].getDescription();
                    }
                    case 1: {
                        return this.zsActiveState(ZoneSetTablePanel.this.zsTableData[row]);
                    }
                }
                return FabricGuiUtil.getString("FabricAgent_Unknown");
            }
            catch (Exception ex) {
                return "";
            }
        }

        private String zsActiveState(ZoneSet zs) {
            String isActive = FabricGuiUtil.getString("FabricZoneSetPage_InactiveZoneSet");
            ZoneSet origZS = ZoneSetTablePanel.this.zoneCNS.getOriginalActivatedZoneSet();
            if (ZoneSetTablePanel.this.zoneCNS.isZoneSetActive(zs)) {
                isActive = origZS == null ? FabricGuiUtil.getString("FabricZoneSetPage_ActivatedPending") : (origZS.getName().equals(zs.getName()) ? FabricGuiUtil.getString("FabricZoneSetPage_ActiveZoneSet") : FabricGuiUtil.getString("FabricZoneSetPage_ActivatedPending"));
            } else if (origZS != null && origZS.getName().equals(zs.getName())) {
                isActive = FabricGuiUtil.getString("FabricZoneSetPage_DeactivatePending");
            }
            return isActive;
        }

        public void addRow() {
            ++this.rowCount;
            this.fireTableDataChanged();
            ZoneSetTablePanel.this.zsTable.sortByColumn(0, -1);
        }

        public void deleteRow() {
            --this.rowCount;
            this.fireTableDataChanged();
            ZoneSetTablePanel.this.zsTable.sortByColumn(0, -1);
        }
    }
}

