/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.HashMap;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;

public class ZoneUIAccessor {
    private static ZoneUIAccessor zoneAccessor = null;

    public static ZoneUIAccessor getInstance() {
        if (zoneAccessor == null) {
            zoneAccessor = new ZoneUIAccessor();
        }
        return zoneAccessor;
    }

    public static void sendGuiRequest(GuiRequestor requestor, String requestSubType, HashMap requestData) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = requestSubType;
        request.requestData = requestData;
        request.flags = (byte)2;
        GuiClient.doRequest(requestor, request);
    }

    public static void sendJobRequest(GuiRequestor requestor, String requestSubType, short managerType, HashMap requestData) {
        DeviceRequest request = new DeviceRequest("org.eclipse.aperi.server.svp.SchedulerSvp", requestSubType, managerType);
        request.requestData = requestData;
        GuiClient.doRequest(requestor, request);
    }

    public static void sendDeviceRequest(GuiRequestor requestor, String requestSubType, short managerType, HashMap requestData) {
        DeviceRequest request = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", requestSubType, managerType);
        request.requestData = requestData;
        GuiClient.doRequest(requestor, request);
    }

    public void getActiveZoneDefinition(GuiRequestor requestor, String sanWWN) {
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.POPULATE_ACTIVEZONEDEF, sanWWN);
        ZoneUIAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", data2);
    }

    public void populateActiveZoneDefinition(GuiRequestor requestor, String sanWWN) {
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.POPULATE_ACTIVEZONEDEF, sanWWN);
        ZoneUIAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", data2);
    }

    public void reserveToken(GuiRequestor requestor, String sanWWN) {
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.RESERVE_TOKEN, sanWWN);
        ZoneUIAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", data2);
    }

    public void releaseToken(GuiRequestor requestor, String sanWWN, Token token) {
        HashMap<String, Object> data2 = new HashMap<String, Object>();
        data2.put(GuiZoneConstants.RELEASE_TOKEN, sanWWN);
        data2.put(GuiZoneConstants.TOKEN, token);
        ZoneUIAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", data2);
    }

    public void rollbackToken(GuiRequestor requestor, String sanWWN, Token token) {
        HashMap<String, Object> data2 = new HashMap<String, Object>();
        data2.put(GuiZoneConstants.ROLLBACK_TOKEN, sanWWN);
        data2.put(GuiZoneConstants.TOKEN, token);
        ZoneUIAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", data2);
    }

    public void saveDescriptions(GuiRequestor requestor, ZoneDefinition zDef, String sanWWN) {
        HashMap<String, Object> data2 = new HashMap<String, Object>();
        data2.put(GuiZoneConstants.SAVE_ZONE_DESCRIPTIONS, zDef);
        data2.put(GuiZoneConstants.SAN_WWN, sanWWN);
        ZoneUIAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", data2);
    }

    public void ping(GuiRequestor requestor, String sanWWN) {
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("pingZoneAgent", sanWWN);
        ZoneUIAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", data2);
    }

    public void saveZoneDefinition(GuiRequestor requestor, String sanWWN, int flag, ZoneDefinition zDef, Token token) {
        HashMap<String, Object> data2 = new HashMap<String, Object>();
        data2.put(GuiZoneConstants.SAVE_ZONEDEF, sanWWN);
        data2.put(GuiZoneConstants.FLAG, new Integer(flag));
        data2.put(GuiZoneConstants.ZONE_DEFINITION, zDef);
        data2.put(GuiZoneConstants.TOKEN, token);
        ZoneUIAccessor.sendJobRequest(requestor, "org.eclipse.aperi.server.handler.scheduler.ZoneDeviceHandler", DeviceRequest.DR_FABRIC, data2);
    }

    public void originalSaveZoneDefinition(GuiRequestor requestor, String sanWWN, int flag, ZoneDefinition zDef) {
        HashMap<String, Object> data2 = new HashMap<String, Object>();
        data2.put(GuiZoneConstants.SAVE_ZONEDEF, sanWWN);
        data2.put(GuiZoneConstants.FLAG, new Integer(flag));
        data2.put(GuiZoneConstants.ZONE_DEFINITION, zDef);
        ZoneUIAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler", data2);
    }
}

