/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;

public class MegaTable
extends JPanel
implements MouseListener {
    public static final Icon DOWN_ARROW = new IconFactory.DownArrowIcon();
    public static final Icon UP_ARROW = new IconFactory.UpArrowIcon();
    public static final Icon NO_ARROW = new IconFactory.BlankArrowIcon();
    private AbstractTableModel baseTableModel = null;
    private int frozenRows = 0;
    private Color frozenRowBackground = Color.YELLOW;
    private int frozenColumns = 0;
    public static final int SORT_DESCENDING = -1;
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    private int selectPolicy = 2;
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private static SortingDirective EMPTY_DIRECTIVE = new SortingDirective(-1, 0);
    private ArrayList currentSortingDirectives = new ArrayList();
    private ArrayList tableHeaders = new ArrayList(2);
    private HashMap cellRenderers = new HashMap();
    private HashMap hiddenColumns = new HashMap();
    public AskForRowIconInterface iconChanger = new AskForRowIconInterface(){

        public boolean changeIcon(int i) {
            return false;
        }
    };
    public Icon alternateRowIcon;
    private static final TableCellRenderer DUMMY_RENDERER = new DefaultTableCellRenderer.UIResource();
    private Map columnComparators = new HashMap();
    private Row[] viewToModelMap = null;
    private AbstractTableModel upperLeftModel = new AbstractTableModel(){

        public int getColumnCount() {
            return MegaTable.this.frozenColumns;
        }

        public int getRowCount() {
            return MegaTable.this.frozenRows;
        }

        public String getColumnName(int col) {
            return MegaTable.this.getBaseTableModel().getColumnName(col);
        }

        public Object getValueAt(int row, int col) {
            return MegaTable.this.getBaseTableModel().getValueAt(row, col);
        }

        public Class getColumnClass(int columnIndex) {
            return MegaTable.this.getBaseTableModel().getColumnClass(columnIndex);
        }
    };
    private AbstractTableModel upperRightModel = new AbstractTableModel(){

        public int getColumnCount() {
            return MegaTable.this.getBaseTableModel().getColumnCount() - MegaTable.this.frozenColumns;
        }

        public int getRowCount() {
            return MegaTable.this.frozenRows;
        }

        public String getColumnName(int col) {
            return MegaTable.this.getBaseTableModel().getColumnName(col + MegaTable.this.frozenColumns);
        }

        public Object getValueAt(int row, int col) {
            return MegaTable.this.getBaseTableModel().getValueAt(row, col + MegaTable.this.frozenColumns);
        }

        public Class getColumnClass(int columnIndex) {
            return MegaTable.this.getBaseTableModel().getColumnClass(columnIndex + MegaTable.this.frozenColumns);
        }
    };
    private AbstractTableModel lowerLeftModel = new AbstractTableModel(){

        public int getColumnCount() {
            return MegaTable.this.frozenColumns;
        }

        public int getRowCount() {
            return MegaTable.this.getBaseTableModel().getRowCount() - MegaTable.this.frozenRows;
        }

        public String getColumnName(int col) {
            return MegaTable.this.getBaseTableModel().getColumnName(col);
        }

        public Object getValueAt(int row, int col) {
            return MegaTable.this.getBaseTableModel().getValueAt(MegaTable.this.getModelIndex(row + MegaTable.this.frozenRows), col);
        }

        public Class getColumnClass(int columnIndex) {
            return MegaTable.this.getBaseTableModel().getColumnClass(columnIndex);
        }
    };
    private AbstractTableModel lowerRightModel = new AbstractTableModel(){

        public int getColumnCount() {
            return MegaTable.this.getBaseTableModel().getColumnCount() - MegaTable.this.frozenColumns;
        }

        public int getRowCount() {
            return MegaTable.this.getBaseTableModel().getRowCount() - MegaTable.this.frozenRows;
        }

        public String getColumnName(int col) {
            return MegaTable.this.getBaseTableModel().getColumnName(col + MegaTable.this.frozenColumns);
        }

        public Object getValueAt(int row, int col) {
            return MegaTable.this.getBaseTableModel().getValueAt(MegaTable.this.getModelIndex(row + MegaTable.this.frozenRows), col + MegaTable.this.frozenColumns);
        }

        public Class getColumnClass(int columnIndex) {
            return MegaTable.this.getBaseTableModel().getColumnClass(columnIndex + MegaTable.this.frozenColumns);
        }
    };
    private JScrollPane upperLeftScroll;
    private JScrollPane upperRightScroll;
    private JScrollPane lowerLeftScroll;
    private JScrollPane lowerRightScroll;
    private JTable upperLeftTable;
    private JTable upperRightTable;
    private JTable lowerLeftTable;
    private JTable lowerRightTable;
    private TJCTableMouseInterface mouseListener = new TJCTableMouseAdapter();
    protected Icon chartIcon;
    protected Icon rowIcon = NO_ARROW;
    protected int rowIconType = 0;
    private static final int NO_ROW_ICON = 0;
    private static final int CHART_ICON = 1;
    private static final int DETAIL_ICON = 2;
    private static final int BOTH_ICONS = 3;
    public static final int NO_CHART_ICON = 10;
    public static final int PIE_CHART = 11;
    public static final int BAR_CHART = 12;
    public static final int LINE_CHART = 13;

    public void setColumnComparator(Class type, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        Class<?> columnType = this.getBaseTableModel().getColumnClass(column);
        Comparator comparator = (Comparator)this.columnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMAPRATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    public MegaTable() {
    }

    public MegaTable(AbstractTableModel baseTableModel, int frozenRows, int frozenColumns) {
        this.setFrozenRows(frozenRows);
        this.setFrozenColumns(frozenColumns);
        this.setBaseTableModel(baseTableModel);
    }

    private void buildTables() {
        this.unBuildTables();
        if (this.getBaseTableModel() != null) {
            this.constructTableViews();
            this.prepareTableHeaders();
            this.layoutTablePanel();
        }
    }

    private void unBuildTables() {
        this.upperLeftScroll = null;
        this.upperRightScroll = null;
        this.lowerLeftScroll = null;
        this.lowerRightScroll = null;
        this.upperLeftTable = null;
        this.upperRightTable = null;
        this.lowerLeftTable = null;
        this.lowerRightTable = null;
        this.viewToModelMap = null;
        this.removeAll();
        this.setLayout(null);
    }

    private void initializeTable(JTable table) {
        this.applyCellRenderers(table);
        table.addMouseListener(this);
        table.setAutoResizeMode(0);
        table.setSelectionMode(this.getSelectPolicy());
        table.setColumnSelectionAllowed(false);
        table.setRowHeight(21);
    }

    private FrozenTable buildFrozenRowTable(AbstractTableModel model) {
        FrozenTable table = new FrozenTable(model, true);
        this.initializeTable(table);
        return table;
    }

    private JTable buildBasicTable(AbstractTableModel model) {
        FrozenTable table = new FrozenTable(model, false);
        this.initializeTable(table);
        return table;
    }

    private void applyCellRenderers(JTable table) {
        for (Object key : this.cellRenderers.keySet()) {
            table.setDefaultRenderer((Class)key, (TableCellRenderer)this.cellRenderers.get(key));
        }
    }

    private void constructTableViews() {
        if (this.getFrozenRows() > 0) {
            if (this.getFrozenColumns() > 0) {
                this.buildUpperLeftTable();
            }
            this.buildUpperRightTable();
        }
        if (this.getFrozenColumns() > 0) {
            this.buildLowerLeftTable();
        }
        this.buildLowerRightTable();
        this.linkTableScrolling2LowerRightTable();
        this.hideColumns();
    }

    private void linkTableScrolling2LowerRightTable() {
        if (this.getFrozenRows() > 0) {
            final JScrollBar bar1 = this.upperRightScroll.getHorizontalScrollBar();
            JScrollBar bar2 = this.lowerRightScroll.getHorizontalScrollBar();
            bar2.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    bar1.setValue(e.getValue());
                }
            });
        }
        if (this.getFrozenColumns() > 0) {
            final JScrollBar bar3 = this.lowerLeftScroll.getVerticalScrollBar();
            JScrollBar bar4 = this.lowerRightScroll.getVerticalScrollBar();
            bar4.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    bar3.setValue(e.getValue());
                }
            });
        }
    }

    private void buildLowerRightTable() {
        this.lowerRightTable = this.buildBasicTable(this.lowerRightModel);
        this.lowerRightScroll = this.getFrozenRows() > 0 ? new JScrollPane(this.lowerRightTable){

            public void setColumnHeaderView(Component view) {
            }
        } : new JScrollPane(this.lowerRightTable);
        this.lowerRightTable.setRowSelectionAllowed(true);
        if (this.lowerLeftTable != null) {
            this.lowerRightTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                        MegaTable.this.lowerLeftTable.clearSelection();
                    } else {
                        MegaTable.this.lowerLeftTable.setRowSelectionInterval(((ListSelectionModel)e.getSource()).getMinSelectionIndex(), ((ListSelectionModel)e.getSource()).getMaxSelectionIndex());
                    }
                    MegaTable.this.mouseListener.selectionChanged(true);
                }
            });
        } else {
            this.lowerRightTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    MegaTable.this.mouseListener.selectionChanged(true);
                }
            });
        }
    }

    private void buildLowerLeftTable() {
        this.lowerLeftTable = this.buildBasicTable(this.lowerLeftModel);
        this.lowerLeftScroll = this.getFrozenRows() > 0 ? new JScrollPane(this.lowerLeftTable){

            public void setColumnHeaderView(Component view) {
            }
        } : new JScrollPane(this.lowerLeftTable);
        this.lowerLeftScroll.setVerticalScrollBarPolicy(21);
        this.lowerLeftScroll.setHorizontalScrollBarPolicy(32);
        JScrollBar bar = this.lowerLeftScroll.getHorizontalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.lowerLeftScroll.setHorizontalScrollBar(dummyBar);
        this.lowerLeftTable.setRowSelectionAllowed(true);
        this.lowerLeftTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                    MegaTable.this.lowerRightTable.clearSelection();
                } else {
                    MegaTable.this.lowerRightTable.setRowSelectionInterval(((ListSelectionModel)e.getSource()).getMinSelectionIndex(), ((ListSelectionModel)e.getSource()).getMaxSelectionIndex());
                }
            }
        });
    }

    private void buildUpperRightTable() {
        this.upperRightTable = this.buildFrozenRowTable(this.upperRightModel);
        this.upperRightScroll = new JScrollPane(this.upperRightTable);
        this.upperRightScroll.setHorizontalScrollBarPolicy(31);
        this.upperRightScroll.setVerticalScrollBarPolicy(22);
        JScrollBar bar = this.upperRightScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.upperRightScroll.setVerticalScrollBar(dummyBar);
        this.upperRightTable.setCellSelectionEnabled(false);
    }

    private void buildUpperLeftTable() {
        this.upperLeftTable = this.buildFrozenRowTable(this.upperLeftModel);
        this.upperLeftScroll = new JScrollPane(this.upperLeftTable);
        this.upperLeftScroll.setHorizontalScrollBarPolicy(31);
        this.upperLeftScroll.setVerticalScrollBarPolicy(21);
        this.upperLeftTable.setCellSelectionEnabled(false);
    }

    private int[] getColumnSizes(JTable table) {
        int headerWidth = 0;
        int colWidth = 0;
        int width = 0;
        TableModel tableModel = table.getModel();
        Class<?> columnClass = null;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int colCount = table.getColumnCount();
        int[] sizes = new int[colCount];
        Arrays.fill(sizes, 0);
        int rowCount = table.getRowCount() > 150 ? 150 : table.getRowCount();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            TableColumn column = table.getColumnModel().getColumn(colIndex);
            Component comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, colIndex);
            headerWidth = comp.getPreferredSize().width;
            int colModelIndex = table.convertColumnIndexToModel(colIndex);
            colWidth = 0;
            columnClass = null;
            for (int row = 0; row < rowCount; ++row) {
                Object value = tableModel.getValueAt(row, colModelIndex);
                if (columnClass == null) {
                    columnClass = table.getModel().getColumnClass(colModelIndex);
                }
                if (columnClass == null || value == null) continue;
                comp = table.getDefaultRenderer(columnClass).getTableCellRendererComponent(table, value, false, false, row, colModelIndex);
                width = comp.getPreferredSize().width;
                colWidth = Math.max(colWidth, width);
            }
            sizes[colIndex] = Math.max(headerWidth, colWidth) + 5;
        }
        return sizes;
    }

    private void adjustColumnSizes(JTable upperTable, JTable lowerTable) {
        if (upperTable == null && lowerTable == null) {
            return;
        }
        int[] upperSizes = upperTable == null ? null : this.getColumnSizes(upperTable);
        int[] lowerSizes = lowerTable == null ? null : this.getColumnSizes(lowerTable);
        if (upperSizes == null) {
            upperSizes = new int[lowerSizes.length];
            Arrays.fill(upperSizes, 0);
        } else if (lowerSizes == null) {
            lowerSizes = new int[upperSizes.length];
            Arrays.fill(lowerSizes, 0);
        }
        for (int i = 0; i < upperSizes.length; ++i) {
            TableColumn tableColumn;
            if (lowerTable != null && (tableColumn = lowerTable.getColumnModel().getColumn(i)) != null) {
                tableColumn.setPreferredWidth(Math.max(upperSizes[i], lowerSizes[i]));
                tableColumn.setResizable(false);
            }
            if (upperTable == null || (tableColumn = upperTable.getColumnModel().getColumn(i)) == null) continue;
            tableColumn.setPreferredWidth(Math.max(upperSizes[i], lowerSizes[i]));
            tableColumn.setResizable(false);
        }
    }

    private void adjustColumnSize(JTable table) {
        int headerWidth = 0;
        int colWidth = 0;
        int width = 0;
        Class<?> columnClass = null;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int colCount = table.getColumnCount();
        int rowCount = table.getRowCount() > 150 ? 150 : table.getRowCount();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            TableColumn column = table.getColumnModel().getColumn(colIndex);
            Component comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, colIndex);
            headerWidth = comp.getPreferredSize().width;
            int colModelIndex = table.convertColumnIndexToModel(colIndex);
            colWidth = 0;
            columnClass = null;
            for (int row = 0; row < rowCount; ++row) {
                Object value = table.getModel().getValueAt(row, colModelIndex);
                if (columnClass == null) {
                    columnClass = table.getModel().getColumnClass(colModelIndex);
                }
                if (columnClass == null || value == null) continue;
                comp = table.getDefaultRenderer(columnClass).getTableCellRendererComponent(table, value, false, false, row, colModelIndex);
                width = comp.getPreferredSize().width;
                colWidth = Math.max(colWidth, width);
            }
            column.setPreferredWidth(Math.max(headerWidth, colWidth) + 5);
        }
    }

    private JLabel createBlankLabel(int size) {
        JLabel bLabel = new JLabel(IconFactory.getBlankIcon(size, size));
        bLabel.setBorder(new BevelBorder(0));
        Dimension dim = new Dimension(size, size);
        bLabel.setMaximumSize(dim);
        bLabel.setPreferredSize(dim);
        return bLabel;
    }

    private Component createBlankRowHeader(JTable table) {
        if (this.rowIconType == 0) {
            return null;
        }
        JPanel rowHeaderPanel = new JPanel();
        rowHeaderPanel.setLayout(new BoxLayout(rowHeaderPanel, 1));
        for (int i = 0; i < table.getRowCount(); ++i) {
            JPanel rowHeader = new JPanel();
            rowHeader.setLayout(new BoxLayout(rowHeader, 0));
            rowHeader.add(this.createBlankLabel(table.getRowHeight(i)));
            if (this.rowIconType == 3) {
                rowHeader.add(this.createBlankLabel(table.getRowHeight()));
            }
            rowHeaderPanel.add(rowHeader);
        }
        return rowHeaderPanel;
    }

    private JButton createChartButton(int row, int size) {
        DrillDownButton button = new DrillDownButton(this.chartIcon, row);
        button.setPreferredSize(new Dimension(size, size));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrillDownButton ddb = (DrillDownButton)e.getSource();
                MegaTable.this.setRowSelection(ddb.getViewRow(), ddb.getViewRow());
                MegaTable.this.mouseListener.showDefaultChart(MegaTable.this.getModelIndex(ddb.getViewRow() + MegaTable.this.getFrozenRows()));
            }
        });
        return button;
    }

    private JButton createDetailButton(int row, int size) {
        DrillDownButton button = new DrillDownButton(this.rowIcon, row);
        button.setPreferredSize(new Dimension(size, size));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrillDownButton ddb = (DrillDownButton)e.getSource();
                MegaTable.this.setRowSelection(ddb.getViewRow(), ddb.getViewRow());
                MegaTable.this.mouseListener.doubleClick(MegaTable.this.getModelIndex(ddb.getViewRow() + MegaTable.this.getFrozenRows()), -1);
            }
        });
        return button;
    }

    private Component createRowHeader(JTable table) {
        if (this.rowIconType == 0) {
            return null;
        }
        JPanel rowHeaderPanel = new JPanel();
        rowHeaderPanel.setLayout(new BoxLayout(rowHeaderPanel, 1));
        for (int i = 0; i < table.getRowCount(); ++i) {
            Icon icon;
            JPanel rowHeader = new JPanel();
            rowHeader.setLayout(new BoxLayout(rowHeader, 0));
            if (this.rowIconType == 1 || this.rowIconType == 3) {
                Icon icon2 = icon = this.iconChanger.changeIcon(this.getDataRow(i + this.frozenRows)) ? this.alternateRowIcon : this.chartIcon;
                if (icon == null || icon instanceof IconFactory.BlankIcon) {
                    rowHeader.add(this.createBlankLabel(table.getRowHeight(i)));
                } else {
                    rowHeader.add(this.createChartButton(i, table.getRowHeight(i)));
                }
            }
            if (this.rowIconType == 2 || this.rowIconType == 3) {
                if (this.rowIconType == 2) {
                    Icon icon3 = icon = this.iconChanger.changeIcon(this.getDataRow(i + this.frozenRows)) ? this.alternateRowIcon : this.rowIcon;
                    if (icon == null || icon instanceof IconFactory.BlankIcon) {
                        rowHeader.add(this.createBlankLabel(table.getRowHeight(i)));
                    } else {
                        rowHeader.add(this.createDetailButton(i, table.getRowHeight(i)));
                    }
                } else {
                    rowHeader.add(this.createDetailButton(i, table.getRowHeight(i)));
                }
            }
            rowHeaderPanel.add(rowHeader);
        }
        return rowHeaderPanel;
    }

    private void layoutTablePanel() {
        Dimension d;
        this.setLayout(new TableLayout());
        this.adjustColumnSizes(this.upperLeftTable, this.lowerLeftTable);
        this.adjustColumnSizes(this.upperRightTable, this.lowerRightTable);
        if (this.getFrozenRows() > 0) {
            if (this.getFrozenColumns() > 0) {
                this.upperLeftScroll.setRowHeaderView(this.createBlankRowHeader(this.upperLeftTable));
                d = new Dimension(this.upperLeftTable.getPreferredSize());
                d.height += this.upperLeftTable.getTableHeader().getPreferredSize().height;
                if (this.upperLeftScroll.getRowHeader() != null) {
                    d.width += this.upperLeftScroll.getRowHeader().getPreferredSize().width;
                }
                this.upperLeftScroll.setPreferredSize(d);
                this.upperLeftScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.add(this.upperLeftScroll);
            } else {
                this.add(new NullComponent());
            }
            if (this.getFrozenColumns() == 0) {
                this.upperRightScroll.setRowHeaderView(this.createBlankRowHeader(this.upperRightTable));
            }
            d = new Dimension(this.upperRightTable.getPreferredSize());
            d.height += this.upperRightTable.getTableHeader().getPreferredSize().height;
            d.width += this.upperRightScroll.getVerticalScrollBar().getPreferredSize().width;
            if (this.getFrozenColumns() == 0 && this.upperRightScroll.getRowHeader() != null) {
                d.width += this.upperRightScroll.getRowHeader().getPreferredSize().width;
            }
            this.upperRightScroll.setPreferredSize(d);
            this.upperRightScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add(this.upperRightScroll);
        } else {
            this.add(new NullComponent());
            this.add(new NullComponent());
        }
        if (this.getFrozenColumns() > 0) {
            this.lowerLeftScroll.setRowHeaderView(this.createRowHeader(this.lowerLeftTable));
            d = new Dimension(this.lowerLeftTable.getPreferredSize());
            d.height += this.lowerLeftScroll.getHorizontalScrollBar().getPreferredSize().height;
            if (this.getFrozenRows() == 0) {
                d.height += this.lowerLeftTable.getTableHeader().getPreferredSize().height;
            }
            if (this.lowerLeftScroll.getRowHeader() != null) {
                d.width += this.lowerLeftScroll.getRowHeader().getPreferredSize().width;
            }
            this.lowerLeftScroll.setPreferredSize(d);
            this.lowerLeftScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add(this.lowerLeftScroll);
        } else {
            this.add(new NullComponent());
        }
        if (this.getFrozenColumns() == 0) {
            this.lowerRightScroll.setRowHeaderView(this.createRowHeader(this.lowerRightTable));
        }
        d = new Dimension(this.lowerRightTable.getPreferredSize());
        d.height += this.lowerRightScroll.getHorizontalScrollBar().getPreferredSize().height;
        if (this.getFrozenRows() == 0) {
            d.height += this.lowerRightTable.getTableHeader().getPreferredSize().height;
        }
        d.width += this.lowerRightScroll.getVerticalScrollBar().getPreferredSize().width;
        if (this.getFrozenColumns() == 0 && this.lowerRightScroll.getRowHeader() != null) {
            d.width += this.lowerRightScroll.getRowHeader().getPreferredSize().width;
        }
        this.lowerRightScroll.setPreferredSize(d);
        this.lowerRightScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(this.lowerRightScroll);
    }

    private void prepareTableHeader(JTable table, int columnOffset) {
        this.tableHeaders.add(table.getTableHeader());
        table.getTableHeader().setReorderingAllowed(false);
        table.getTableHeader().addMouseListener(new HeaderListener(columnOffset));
        table.getTableHeader().setDefaultRenderer(new SortableHeaderRenderer(table.getTableHeader().getDefaultRenderer(), columnOffset));
    }

    private void prepareTableHeaders() {
        if (this.getFrozenRows() > 0) {
            if (this.getFrozenColumns() > 0) {
                this.prepareTableHeader(this.upperLeftTable, 0);
                this.prepareTableHeader(this.upperRightTable, this.getFrozenColumns());
            } else {
                this.prepareTableHeader(this.upperRightTable, 0);
            }
        } else if (this.getFrozenColumns() > 0) {
            this.prepareTableHeader(this.lowerLeftTable, 0);
            this.prepareTableHeader(this.lowerRightTable, this.getFrozenColumns());
        } else {
            this.prepareTableHeader(this.lowerRightTable, 0);
        }
    }

    private Row[] getViewToModelMap() {
        if (this.viewToModelMap == null) {
            int rowCount = this.getBaseTableModel().getRowCount();
            this.viewToModelMap = new Row[rowCount];
            for (int row = 0; row < rowCount; ++row) {
                this.viewToModelMap[row] = new Row(row);
            }
            if (this.currentSortingDirectives.size() != 0) {
                Arrays.sort(this.viewToModelMap, this.getFrozenRows(), rowCount);
            }
        }
        return this.viewToModelMap;
    }

    private int getModelIndex(int viewIndex) {
        return this.getViewToModelMap()[viewIndex].modelIndex;
    }

    private void cancelSorting() {
        this.currentSortingDirectives.clear();
        this.sortDirectionChanged();
    }

    private void sortDirectionChanged() {
        this.viewToModelMap = null;
        this.lowerRightModel.fireTableDataChanged();
        if (this.lowerLeftModel != null) {
            this.lowerLeftModel.fireTableDataChanged();
        }
        Iterator i = this.tableHeaders.iterator();
        while (i.hasNext()) {
            ((JTableHeader)i.next()).repaint();
        }
    }

    private int getSortDirection(int column) {
        return this.getDirective(column).direction;
    }

    private void setSortDirection(int column, int direction) {
        SortingDirective directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.currentSortingDirectives.remove(directive);
        }
        if (direction != 0) {
            this.currentSortingDirectives.add(new SortingDirective(column, direction));
        }
        this.sortDirectionChanged();
    }

    private SortingDirective getDirective(int column) {
        for (SortingDirective sd : this.currentSortingDirectives) {
            if (sd.column != column) continue;
            return sd;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public void setFrozenColumns(int frozenColumns) {
        this.frozenColumns = frozenColumns;
        this.buildTables();
    }

    public int getFrozenRows() {
        return this.frozenRows;
    }

    public void setFrozenRows(int frozenRows) {
        this.frozenRows = frozenRows;
        this.buildTables();
    }

    private AbstractTableModel getBaseTableModel() {
        return this.baseTableModel;
    }

    public void setBaseTableModel(AbstractTableModel baseTableModel) {
        this.baseTableModel = baseTableModel;
        this.buildTables();
    }

    public int getDataRow(int viewRow) {
        this.assertTableIsBuilt();
        return this.getModelIndex(viewRow);
    }

    public AbstractTableModel getDataSource() {
        return this.getBaseTableModel();
    }

    public int getNumRows() {
        this.assertTableIsBuilt();
        return this.getBaseTableModel().getRowCount();
    }

    public int[] getSelectedRows() {
        try {
            this.assertTableIsBuilt();
        }
        catch (RuntimeException e) {
            return new int[0];
        }
        int[] selectedRows = this.lowerRightTable.getSelectedRows();
        int[] selectedDataRows = new int[selectedRows.length];
        for (int i = 0; i < selectedDataRows.length; ++i) {
            selectedDataRows[i] = this.getModelIndex(selectedRows[i] + this.getFrozenRows());
        }
        return selectedDataRows;
    }

    public void setSelectedRows(int startRow, int endRow) {
        int rowCount = this.lowerRightTable.getRowCount();
        if (rowCount == 0 || startRow >= rowCount || endRow >= rowCount) {
            return;
        }
        this.assertTableIsBuilt();
        this.lowerRightTable.setRowSelectionInterval(startRow, endRow);
    }

    public int getViewRow(int modelRow) {
        this.assertTableIsBuilt();
        if (this.viewToModelMap != null) {
            for (int i = 0; i < this.viewToModelMap.length; ++i) {
                if (this.viewToModelMap[i].modelIndex != modelRow) continue;
                return i;
            }
        }
        return modelRow;
    }

    public int[] getViewToModelIndices() {
        this.assertTableIsBuilt();
        int[] viewToModelIndices = null;
        if (this.viewToModelMap != null) {
            viewToModelIndices = new int[this.viewToModelMap.length];
            for (int i = 0; i < this.viewToModelMap.length; ++i) {
                viewToModelIndices[i] = this.viewToModelMap[i].modelIndex;
            }
        }
        return viewToModelIndices;
    }

    public boolean isRowSelected(int viewRow) {
        this.assertTableIsBuilt();
        return this.lowerRightTable.isCellSelected(viewRow, 0);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            int viewRow = this.lowerRightTable.getSelectedRow();
            int modelRow = this.getModelIndex(viewRow + this.getFrozenRows());
            this.mouseListener.doubleClick(modelRow, -1);
            this.mouseListener.selectionChanged(true);
        }
    }

    public void mousePressed(MouseEvent event) {
        this.checkPopup(event);
    }

    public void mouseReleased(MouseEvent event) {
        this.checkPopup(event);
    }

    private void checkPopup(MouseEvent event) {
        if (event.isPopupTrigger()) {
            Point p = new Point(event.getX(), event.getY());
            int col = this.lowerRightTable.columnAtPoint(p);
            int row = this.lowerRightTable.rowAtPoint(p);
            row = this.getModelIndex(row);
            this.mouseListener.showPopup(row, col += this.getFrozenColumns(), event.getComponent(), event.getX(), event.getY());
        }
    }

    public void nullReferences() {
        this.setBaseTableModel(null);
    }

    public boolean rowsSelected() {
        try {
            this.assertTableIsBuilt();
        }
        catch (RuntimeException e) {
            return false;
        }
        return this.lowerRightTable.getSelectedRowCount() > 0;
    }

    public void setCellRenderer(Class columnClass, TableCellRenderer renderer) {
        this.cellRenderers.put(columnClass, renderer);
        this.buildTables();
    }

    private void setColunmHidden(JTable table, int column) {
        table.getColumnModel().removeColumn(table.getColumnModel().getColumn(table.convertColumnIndexToView(column)));
    }

    private void hideColumns() {
        Iterator i = this.hiddenColumns.keySet().iterator();
        while (i.hasNext()) {
            int column = (Integer)i.next();
            if (this.getFrozenColumns() > 0 && column < this.getFrozenColumns()) {
                this.setColunmHidden(this.lowerLeftTable, column);
                if (this.getFrozenRows() <= 0) continue;
                this.setColunmHidden(this.upperLeftTable, column);
                continue;
            }
            this.setColunmHidden(this.lowerRightTable, column -= this.getFrozenColumns());
            if (this.getFrozenRows() <= 0) continue;
            this.setColunmHidden(this.upperRightTable, column);
        }
    }

    public void setColumnHidden(int column, boolean hidden) {
        if (hidden) {
            this.hiddenColumns.put(new Integer(column), null);
        } else {
            this.hiddenColumns.remove(new Integer(column));
        }
        this.buildTables();
    }

    public void setDataSource(AbstractTableModel data) {
        this.setBaseTableModel(data);
    }

    public void setRowIcon(int chartType, boolean detail) {
        this.rowIconType = detail ? 2 : 0;
        this.rowIcon = detail ? IconFactory.getDetailIcon() : IconFactory.getBlankIcon(38, 16);
        switch (chartType) {
            case 10: {
                break;
            }
            case 11: {
                this.chartIcon = IconFactory.getPieChartIcon();
                ++this.rowIconType;
                break;
            }
            case 12: {
                this.chartIcon = IconFactory.getBarChartIcon();
                ++this.rowIconType;
                break;
            }
            case 13: {
                this.chartIcon = IconFactory.getLineChartIcon();
                ++this.rowIconType;
            }
        }
        this.buildTables();
    }

    private void setRowSelection(int start_row, int end_row) {
        this.assertTableIsBuilt();
        if (this.lowerRightTable.getRowCount() != 0) {
            this.lowerRightTable.setRowSelectionInterval(start_row, end_row);
        }
    }

    public void sortByColumn(int col, int direction) {
        this.assertTableIsBuilt();
        this.setSortDirection(col, direction);
    }

    public int YtoRow(int y) {
        this.assertTableIsBuilt();
        Point p = new Point(0, y);
        return this.lowerRightTable.rowAtPoint(p);
    }

    public TJCTableMouseInterface getMouseListener() {
        return this.mouseListener;
    }

    public void setMouseListener(TJCTableMouseInterface mouseListener) {
        this.mouseListener = mouseListener;
    }

    private final void assertTableIsBuilt() {
        if (this.getBaseTableModel() == null) {
            throw new RuntimeException("Operation requires table model to be set first");
        }
    }

    private int getSelectPolicy() {
        return this.selectPolicy;
    }

    private void setSelectPolicy(int selectPolicy) {
        this.selectPolicy = selectPolicy;
    }

    public void setSelectionPolicy(int mode) {
        this.setSelectPolicy(mode);
        if (this.lowerRightTable != null) {
            this.lowerRightTable.setSelectionMode(mode);
            if (this.lowerLeftTable != null) {
                this.lowerLeftTable.setSelectionMode(mode);
            }
        }
    }

    public Color getFrozenRowBackground() {
        return this.frozenRowBackground;
    }

    private Color getDefaultBackground() {
        return Color.WHITE;
    }

    public void setFrozenRowBackground(Color frozenRowBackground) {
        this.frozenRowBackground = frozenRowBackground;
    }

    public void setAsFirstColumn(int col) {
        int index = col - this.frozenColumns;
        if (index <= 0) {
            return;
        }
        if (this.upperRightTable != null) {
            this.upperRightTable.moveColumn(this.upperRightTable.convertColumnIndexToView(index), 0);
        }
        if (this.lowerRightTable != null) {
            this.lowerRightTable.moveColumn(this.lowerRightTable.convertColumnIndexToView(index), 0);
        }
    }

    private class DrillDownButton
    extends JButton {
        private int row;

        public DrillDownButton(Icon icon, int row) {
            super(icon);
            this.row = row;
            this.setBorder(new BevelBorder(0));
        }

        public int getViewRow() {
            return this.row;
        }
    }

    private static class TableLayout
    implements LayoutManager {
        private TableLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Dimension space = parent.getSize();
            Component NW = parent.getComponent(0);
            NW.setLocation(0, 0);
            NW.setSize(NW.getPreferredSize());
            Component NE = parent.getComponent(1);
            NE.setLocation(NW.getSize().width, 0);
            NE.setSize(Math.min(space.width - NW.getSize().width, NE.getPreferredSize().width), Math.max(NE.getPreferredSize().height, NW.getSize().height));
            Component SW = parent.getComponent(2);
            SW.setLocation(0, NW.getSize().height);
            SW.setSize(Math.max(NW.getPreferredSize().width, SW.getPreferredSize().width), Math.min(space.height - NW.getSize().height, SW.getPreferredSize().height));
            Component SE = parent.getComponent(3);
            SE.setLocation(SW.getSize().width, NE.getSize().height);
            SE.setSize(Math.min(space.width - SW.getSize().width, SE.getPreferredSize().width), Math.min(space.height - NE.getSize().height, SE.getPreferredSize().height));
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = new Dimension(0, 0);
            Dimension NW = parent.getComponent(0).getMinimumSize();
            Dimension NE = parent.getComponent(1).getMinimumSize();
            Dimension SW = parent.getComponent(2).getMinimumSize();
            Dimension SE = parent.getComponent(3).getMinimumSize();
            d.width = Math.max(NW.width + NE.width, SW.width + SE.width);
            d.height = Math.max(NW.height + SW.height, NE.height + SE.height);
            return d;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension(0, 0);
            Dimension NW = parent.getComponent(0).getPreferredSize();
            Dimension NE = parent.getComponent(1).getPreferredSize();
            Dimension SW = parent.getComponent(2).getPreferredSize();
            Dimension SE = parent.getComponent(3).getPreferredSize();
            d.width = Math.max(NW.width + NE.width, SW.width + SE.width);
            d.height = Math.max(NW.height + SW.height, NE.height + SE.height);
            return d;
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    private static class NullComponent
    extends JComponent {
        private Dimension zeroDimension = new Dimension(0, 0);

        private NullComponent() {
        }

        public Dimension getMaximumSize() {
            return this.zeroDimension;
        }

        public Dimension getMinimumSize() {
            return this.zeroDimension;
        }

        public Dimension getPreferredSize() {
            return this.zeroDimension;
        }

        public Dimension getSize(Dimension rv) {
            return this.zeroDimension;
        }

        public void paint(Graphics g) {
        }
    }

    private class FrozenTable
    extends JTable {
        private boolean frozen;

        public FrozenTable(AbstractTableModel model, boolean frozen) {
            super(model);
            this.frozen = frozen;
        }

        public TableCellRenderer getCellRenderer(int row, int col) {
            TableCellRenderer renderer = super.getCellRenderer(row, col);
            int colModelIndex = this.convertColumnIndexToModel(col);
            Object value = this.dataModel.getValueAt(row, colModelIndex);
            Component comp = renderer.getTableCellRendererComponent(this, value, false, false, row, colModelIndex);
            if (this.frozen) {
                comp.setBackground(MegaTable.this.getFrozenRowBackground());
            } else {
                comp.setBackground(MegaTable.this.getDefaultBackground());
            }
            return renderer;
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            for (SortingDirective directive : MegaTable.this.currentSortingDirectives) {
                int column = directive.column;
                Object o1 = MegaTable.this.getBaseTableModel().getValueAt(row1, column);
                Object o2 = MegaTable.this.getBaseTableModel().getValueAt(row2, column);
                int comparison = 0;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : MegaTable.this.getComparator(column).compare(o1, o2)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;
        private int columnOffset;
        private TableHeaderUI headerUI;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer, int columnOffset) {
            this.tableCellRenderer = tableCellRenderer;
            this.columnOffset = columnOffset;
        }

        private void checkAndFix(JTable table) {
            JTableHeader header = table.getTableHeader();
            if (this.headerUI == null || this.headerUI != header.getUI()) {
                TableCellRenderer saved = header.getDefaultRenderer();
                header.setDefaultRenderer(DUMMY_RENDERER);
                header.updateUI();
                this.headerUI = header.getUI();
                this.tableCellRenderer = header.getDefaultRenderer();
                if (this.tableCellRenderer == null || this.tableCellRenderer == saved || this.tableCellRenderer == DUMMY_RENDERER) {
                    this.tableCellRenderer = new JTableHeader().getDefaultRenderer();
                }
                header.setDefaultRenderer(saved);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.checkAndFix(table);
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                l.setHorizontalAlignment(2);
                l.setFont(table.getFont().deriveFont(1));
                switch (MegaTable.this.getDirective(table.convertColumnIndexToModel(column) + this.columnOffset).direction) {
                    case -1: {
                        l.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_DESCENDING"));
                        l.setIcon(DOWN_ARROW);
                        break;
                    }
                    case 1: {
                        l.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_ASCENDING"));
                        l.setIcon(UP_ARROW);
                        break;
                    }
                    default: {
                        l.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_NONE"));
                        l.setIcon(NO_ARROW);
                    }
                }
            }
            return c;
        }
    }

    private class HeaderListener
    extends MouseAdapter {
        private int columnOffset;

        public HeaderListener(int columnOffset) {
            this.columnOffset = columnOffset;
        }

        public void mouseClicked(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            TableColumnModel columnModel = header.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = columnModel.getColumn(viewColumn).getModelIndex();
            if ((column += this.columnOffset) != -1) {
                int direction = MegaTable.this.getSortDirection(column);
                if (!e.isControlDown()) {
                    MegaTable.this.cancelSorting();
                }
                direction += e.isShiftDown() ? -1 : 1;
                direction = (direction + 4) % 3 - 1;
                MegaTable.this.setSortDirection(column, direction);
            }
        }
    }

    private static class SortingDirective {
        private int column;
        private int direction;

        public SortingDirective(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }
}

