/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.cartridges;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.tape.cartridges.CartridgesListPanel;
import org.eclipse.aperi.gui.tape.cartridges.CartridgesPanel;
import org.eclipse.aperi.gui.tape.common.TapeConstants;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.common.model.TapeDataAccessor;
import org.eclipse.aperi.request.Response;

public class CartridgesDDI
extends DataDisplayInfo
implements ActionListener {
    private CartridgesPanel mainPanel;
    private boolean closing;
    private boolean initialized;
    private HashMap hmapCartridgesOfLib;
    public GUILibrary library;
    private Vector cartridges = new Vector();
    protected TapeDataAccessor tapeAccessor = TapeDataAccessor.getInstance();

    public CartridgesDDI(GUILibrary lib) {
        this.setDescription(Util.getString("TAPE_CARTRIDGES_LABEL"));
        this.displayInScrollPane = true;
        this.helpID = "tapesys";
        this.library = lib;
    }

    public String getHelpID() {
        Component panel = this.mainPanel.tabs.getSelectedComponent();
        if (panel instanceof CartridgesListPanel) {
            return TapeConstants.CARTRIDGES_HELP;
        }
        return "welcome_gettingstarted";
    }

    public void reDisplay() {
        if (this.panel == null || this.cartridges.isEmpty()) {
            this.getData();
        } else {
            this.show();
            guiMain.setSaveActionEnabled(false, false);
        }
        guiMain.addSaveActionListener(this);
    }

    public Vector getCartridges() {
        return this.cartridges;
    }

    public void getData() {
        this.cartridges.removeAllElements();
        this.tapeAccessor.getCartridgesByLibrary(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    CartridgesDDI.this.hmapCartridgesOfLib = (HashMap)response.responseData;
                    CartridgesDDI.this.cartridges = new Vector(CartridgesDDI.this.hmapCartridgesOfLib.values());
                    if (CartridgesDDI.this.mainPanel == null) {
                        CartridgesDDI.this.mainPanel = new CartridgesPanel(CartridgesDDI.this);
                    }
                    CartridgesDDI.this.panel = CartridgesDDI.this.mainPanel.getComponent();
                    ((CartridgesDDI)CartridgesDDI.this).mainPanel.listPanel.buildtable();
                    CartridgesDDI.this.show();
                }
            }
        }, this.library.getId());
    }

    public void panelToBeNulled() {
        this.mainPanel = null;
    }

    public void losingFocus() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this);
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        return false;
    }

    public void saveAndClose() {
        this.closing = true;
    }

    public void actionPerformed(ActionEvent event) {
    }
}

