/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.common.model;

import java.io.Serializable;
import java.util.Hashtable;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.common.model.DataAccessor;
import org.eclipse.aperi.gui.common.model.GUIRequestData;

public class TapeDataAccessor {
    private static TapeDataAccessor tapeDataAccessor = null;

    public static TapeDataAccessor getInstance() {
        if (tapeDataAccessor == null) {
            tapeDataAccessor = new TapeDataAccessor();
        }
        return tapeDataAccessor;
    }

    public void getAllTapeLibraries(GuiRequestor requestor) {
        GUIRequestData reqData = new GUIRequestData(1);
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.LibraryInfoHandler", reqData);
    }

    public void getLibraryDetails(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(2);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.LibraryDetailInfoHandler", reqData);
    }

    public void getDriveIdsByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(30);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.DriveInfoHandler", reqData);
    }

    public void getDrivesByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(31);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.DriveInfoHandler", reqData);
    }

    public void getMediaChangersIdsByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(40);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.MediaChangerInfoHandler", reqData);
    }

    public void getMediaChangersByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(41);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.MediaChangerInfoHandler", reqData);
    }

    public void getCartridgesIdsByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(50);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.CartridgeInfoHandler", reqData);
    }

    public void getCartridgesByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(51);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.CartridgeInfoHandler", reqData);
    }

    public void getFrameIdsByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(60);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.FrameInfoHandler", reqData);
    }

    public void getFramesByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(61);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.FrameInfoHandler", reqData);
    }

    public void getIoPortIdsByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(70);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.IOPortInfoHandler", reqData);
    }

    public void getIoPortsByLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(71);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.IOPortInfoHandler", reqData);
    }

    public void setLibraryAttributes(GuiRequestor requestor, String libraryId, Hashtable attributes) {
        GUIRequestData reqData = new GUIRequestData(3);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        reqData.addParameter("library.attrs", attributes);
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.LibraryInfoHandler", reqData);
    }

    public void deleteTapeLibrary(GuiRequestor requestor, String libraryId) {
        GUIRequestData reqData = new GUIRequestData(4);
        reqData.addParameter("library.id", (Serializable)((Object)libraryId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.tape.LibraryInfoHandler", reqData);
    }
}

