/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.common.model;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.discovery.RetryDeleteParameters;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNodeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeCartridgeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeDriveTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeFrameTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeIoportTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaChangerTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaLocationTable;
import org.eclipse.aperi.logging.TraceLogger;

public class TapeLibraryDBHelper {
    private static String CLASSNAME = TapeLibraryDBHelper.class.getName();
    private int cSUCCESS = 0;
    private int cNOLIBRARY = 1;
    private int cDBNOCONNECTIONERROR = 2;
    private int cDBERROR = 3;
    private int cROLLBACKERROR = 4;
    private int cDELETIONERROR = 5;
    private RetryDeleteParameters cRetryParms = new RetryDeleteParameters();

    public TapeLibraryDBHelper() {
        this.cRetryParms.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveProperties(String pLibraryName, Hashtable pProperties) {
        String methodName = "saveProperties";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, methodName, "lib name: " + pLibraryName + ", props: " + pProperties);
        }
        String mMEN = (String)pProperties.get("USER_PROVIDED_NAME");
        String mUDP1 = (String)pProperties.get("USER_ATTRIB1");
        String mUDP2 = (String)pProperties.get("USER_ATTRIB2");
        String mUDP3 = (String)pProperties.get("USER_ATTRIB3");
        int rc = this.cSUCCESS;
        DBConnection mConnection = null;
        try {
            mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        }
        catch (SQLException e1) {
            rc = this.cDBNOCONNECTIONERROR;
            return rc;
        }
        try {
            TapeLibrary mTapeLibrary = new TapeLibrary();
            String[] keys = pLibraryName.split("-multikey-");
            mTapeLibrary.setName(keys[0]);
            if (keys.length > 1) {
                mTapeLibrary.setNameFormat(Short.parseShort(keys[1]));
            }
            mTapeLibrary.retrieve(mConnection);
            if (mTapeLibrary.getTapeLibraryId() > 0) {
                mTapeLibrary.setUserProvidedName(mMEN);
                mTapeLibrary.setUserAttrib1(mUDP1);
                mTapeLibrary.setUserAttrib2(mUDP2);
                mTapeLibrary.setUserAttrib3(mUDP3);
                mTapeLibrary.update(mConnection);
                mConnection.commit();
                int n = rc = this.cSUCCESS;
                return n;
            }
            int n = rc = this.cNOLIBRARY;
            return n;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, methodName, e);
            }
            int n = rc = this.cDBERROR;
            return n;
        }
        finally {
            block22: {
                if (mConnection != null) {
                    try {
                        DBConnPoolDataSource.returnConnection(mConnection);
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(CLASSNAME, methodName, e);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CLASSNAME, methodName, rc);
            }
        }
    }

    public int deleteLibrary(String pLibraryName) {
        String methodName = "deleteLibrary";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, methodName, "lib name: " + pLibraryName);
        }
        DBConnection mConnection = null;
        try {
            mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        }
        catch (SQLException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, methodName, e1);
            }
            return this.cDBNOCONNECTIONERROR;
        }
        TapeLibrary mTapeLibrary = new TapeLibrary();
        String[] keys = pLibraryName.split("-multikey-");
        mTapeLibrary.setName(keys[0]);
        if (keys.length > 1) {
            mTapeLibrary.setNameFormat(Short.parseShort(keys[1]));
        }
        try {
            mTapeLibrary.retrieve(mConnection);
        }
        catch (SQLException e3) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, methodName, e3);
            }
            return this.cNOLIBRARY;
        }
        int rc = this.deleteLibraryByID(mTapeLibrary.getTapeLibraryId());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, methodName, rc);
        }
        return rc;
    }

    public void deleteLibrariesByID(int[] pIDs) {
        String methodName = "deleteLibrariesByID";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, methodName, "lib IDs: " + pIDs);
        }
        for (int id = 0; id < pIDs.length; ++id) {
            this.deleteLibraryByID(id);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteLibraryByID(int mLibraryID) {
        String methodName = "deleteLibraryByID";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, methodName, "lib ID: " + mLibraryID);
        }
        DBConnection mConnection = null;
        try {
            mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        }
        catch (SQLException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, methodName, e1);
            }
            return this.cDBNOCONNECTIONERROR;
        }
        Hashtable<ColumnInfo, String> mWhereCIMKeyTapeLibrary = new Hashtable<ColumnInfo, String>();
        mWhereCIMKeyTapeLibrary.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        Hashtable<ColumnInfo, String> mWhereCartridges = new Hashtable<ColumnInfo, String>();
        mWhereCartridges.put(TResTapeCartridgeTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        Hashtable<ColumnInfo, String> mWhereIOPort = new Hashtable<ColumnInfo, String>();
        mWhereIOPort.put(TResTapeIoportTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        Hashtable<ColumnInfo, String> mWhereChanger = new Hashtable<ColumnInfo, String>();
        mWhereChanger.put(TResTapeMediaChangerTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        Hashtable<ColumnInfo, String> mWhereDrives = new Hashtable<ColumnInfo, String>();
        mWhereDrives.put(TResTapeDriveTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        Hashtable<ColumnInfo, String> mWhereFrames = new Hashtable<ColumnInfo, String>();
        mWhereFrames.put(TResTapeFrameTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        Hashtable<ColumnInfo, String> mWhereLocation = new Hashtable<ColumnInfo, String>();
        mWhereLocation.put(TResTapeMediaLocationTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        Hashtable<ColumnInfo, String> mWhereNodes = new Hashtable<ColumnInfo, String>();
        mWhereNodes.put(TResNodeTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        Hashtable<ColumnInfo, String> mWhereLibrary = new Hashtable<ColumnInfo, String>();
        mWhereLibrary.put(TResTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(mLibraryID));
        int mCIMKeyTapeLibrary = 0;
        int mCartridgesDeleted = 0;
        int mIOPortssDeleted = 0;
        int mChangersDeleted = 0;
        int mDrivesDeleted = 0;
        int mFramesDeleted = 0;
        int mNodesDeleted = 0;
        int mSMLsDeleted = 0;
        int mLibraryDeleted = 0;
        try {
            mCIMKeyTapeLibrary = DBQueryAssistant.performDelete(TResCimkeyTapeLibraryTable.getTablename(), mConnection, mWhereCIMKeyTapeLibrary);
            mCartridgesDeleted = DBQueryAssistant.performDelete(TResTapeCartridgeTable.getTablename(), mConnection, mWhereCartridges);
            mIOPortssDeleted = DBQueryAssistant.performDelete(TResTapeIoportTable.getTablename(), mConnection, mWhereIOPort);
            mChangersDeleted = DBQueryAssistant.performDelete(TResTapeMediaChangerTable.getTablename(), mConnection, mWhereChanger);
            mDrivesDeleted = DBQueryAssistant.performDelete(TResTapeDriveTable.getTablename(), mConnection, mWhereDrives);
            mFramesDeleted = DBQueryAssistant.performDelete(TResTapeFrameTable.getTablename(), mConnection, mWhereFrames);
            mSMLsDeleted = DBQueryAssistant.performDelete(TResTapeMediaLocationTable.getTablename(), mConnection, mWhereLocation);
            mNodesDeleted = DBQueryAssistant.performDelete(TResNodeTable.getTablename(), mConnection, mWhereNodes);
            mLibraryDeleted = DBQueryAssistant.performDelete(TResTapeLibraryTable.getTablename(), mConnection, mWhereLibrary);
            mConnection.commit();
            if (TraceLogger.enableTrace) {
                StringBuffer mItemsDeleted = new StringBuffer();
                mItemsDeleted.append("Deleted TAPE_LIBRARY with ID: " + mLibraryID + "\n");
                mItemsDeleted.append("  - CIMKEY_TAPE_LIBRARY: " + mCIMKeyTapeLibrary + "\n");
                mItemsDeleted.append("  - CARTRIDGES: " + mCartridgesDeleted + "\n");
                mItemsDeleted.append("  - IO_PORTS: " + mIOPortssDeleted + "\n");
                mItemsDeleted.append("  - CHANGER_DEVICE: " + mChangersDeleted + "\n");
                mItemsDeleted.append("  - DRIVE: " + mDrivesDeleted + "\n");
                mItemsDeleted.append("  - FRAME: " + mFramesDeleted + "\n");
                mItemsDeleted.append("  - STORAGE_MEDIA_LOCATION: " + mSMLsDeleted + "\n");
                mItemsDeleted.append("  - NODES: " + mNodesDeleted + "\n");
                mItemsDeleted.append("  - LIBRARIES: " + mLibraryDeleted + "\n");
                mItemsDeleted.append("---------------------------------------------\n");
                TraceLogger.traceMessage(1, CLASSNAME, methodName, mItemsDeleted.toString());
            }
            int mItemsDeleted = this.cSUCCESS;
            return mItemsDeleted;
        }
        catch (SQLException e) {
            try {
                mConnection.rollback();
                int e2 = this.cDELETIONERROR;
                return e2;
            }
            catch (SQLException e2) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(CLASSNAME, methodName, e2);
                }
                int n = this.cROLLBACKERROR;
                return n;
            }
        }
        finally {
            block24: {
                if (mConnection != null) {
                    try {
                        DBConnPoolDataSource.returnConnection(mConnection);
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(CLASSNAME, methodName, e);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(CLASSNAME, methodName);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean deleteTapeDriveByID(int pTapeDriveID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean deleteTapeMediaChangerByID(int pTapeMediaChangerID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int deleteTapeDrive(String pDeviceID) {
        String methodName = "deleteTapeDrive";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, methodName, "device ID: " + pDeviceID);
        }
        DBConnection mConnection = null;
        try {
            mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        }
        catch (SQLException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, methodName, e1);
            }
            return this.cDBNOCONNECTIONERROR;
        }
        TapeDrive mTapeDrive = new TapeDrive();
        mTapeDrive.setDeviceId(pDeviceID);
        try {
            mTapeDrive.retrieve(mConnection);
        }
        catch (SQLException e3) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(CLASSNAME, methodName, e3);
            }
            return this.cNOLIBRARY;
        }
        int rc = 0;
        this.deleteTapeDriveByID(mTapeDrive.getTapeDriveId());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, methodName, rc);
        }
        return rc;
    }

    public boolean deleteTapeDrivesByID(int[] pDriveIDs) {
        String methodName = "deleteTapeDrivesByID";
        boolean mResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, methodName, "drive IDs: " + pDriveIDs);
        }
        for (int id = 0; id < pDriveIDs.length; ++id) {
            boolean bResult = this.deleteTapeDriveByID(pDriveIDs[id]);
            if (bResult) continue;
            mResult = false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, methodName);
        }
        return mResult;
    }

    public boolean deleteTapeMediaChangersByID(int[] pMediaChangerIDs) {
        String methodName = "deleteTapeDrivesByID";
        boolean mResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CLASSNAME, methodName, "media changer IDs: " + pMediaChangerIDs);
        }
        for (int id = 0; id < pMediaChangerIDs.length; ++id) {
            boolean bResult = this.deleteTapeMediaChangerByID(pMediaChangerIDs[id]);
            if (bResult) continue;
            mResult = false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CLASSNAME, methodName);
        }
        return mResult;
    }

    private HashMap getDrive(DBConnection pConnection, int pTapeDriveID) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResTapeDriveTable.getColumnInfo("TAPE_DRIVE_ID"), pTapeDriveID + "");
        String mQueryString = "SELECT LOCATION_ID,NODE_ID FROM " + TResTapeDriveTable.getTablename() + " WHERE " + "TAPE_DRIVE_ID" + " = (?)";
        DBResultSet mDbResult = ComplexQuery.sqlQuery(pConnection, mQueryString, mParameters);
        HashMap<String, Integer> mDriveAttributes = new HashMap<String, Integer>();
        while (mDbResult.next()) {
            mDriveAttributes.put("NODE_ID", new Integer(mDbResult.getInt(2)));
            mDriveAttributes.put("LOCATION_ID", new Integer(mDbResult.getInt(1)));
        }
        mDbResult.close();
        return mDriveAttributes;
    }

    private HashMap getMediaChanger(DBConnection pConnection, int pTapeMediaChangerID) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResTapeMediaChangerTable.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), pTapeMediaChangerID + "");
        String mQueryString = "SELECT LOCATION_ID,NODE_ID FROM " + TResTapeMediaChangerTable.getTablename() + " WHERE " + "TAPE_MEDIA_CHANGER_ID" + " = (?)";
        DBResultSet mDbResult = ComplexQuery.sqlQuery(pConnection, mQueryString, mParameters);
        HashMap<String, Integer> mDriveAttributes = new HashMap<String, Integer>();
        while (mDbResult.next()) {
            mDriveAttributes.put("NODE_ID", new Integer(mDbResult.getInt(2)));
            mDriveAttributes.put("LOCATION_ID", new Integer(mDbResult.getInt(1)));
        }
        mDbResult.close();
        return mDriveAttributes;
    }

    public static boolean handleDeadlock(DBConnection pConn, LogTraceHelper pLTH, RetryDeleteParameters pRetryParms, Exception pEx) {
        pLTH.traceInfo("Deadlock ..... rollback!");
        try {
            pConn.rollback();
        }
        catch (SQLException pEx2) {
            pLTH.traceInfo("Exception in rollback  " + pEx2.getMessage());
            pRetryParms.setToRetry(false);
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        pRetryParms.setNumRetries(pRetryParms.getNumRetries() + 1);
        if (pRetryParms.getNumRetries() > pRetryParms.getAllowed_Retries()) {
            pRetryParms.setToRetry(false);
            return false;
        }
        pLTH.traceInfo("Retry " + pRetryParms.getNumRetries() + " after deadlock");
        pRetryParms.setToRetry(true);
        pRetryParms.setMsWaitPeriod((long)((double)pRetryParms.getMult_Retry_Interval() * RetryDeleteParameters.getRandGen().nextDouble() * (double)pRetryParms.getNumRetries()));
        if (pRetryParms.getMsWaitPeriod() < pRetryParms.getMin_Retry_Internal()) {
            pRetryParms.setMsWaitPeriod(pRetryParms.getMin_Retry_Internal());
        }
        try {
            Thread.sleep(pRetryParms.getMsWaitPeriod());
        }
        catch (InterruptedException pEx3) {
            pLTH.traceInfo("InterruptedException " + pEx.getMessage());
        }
        return true;
    }
}

