/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.drives;

import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.tape.common.model.GUIDrive;
import org.eclipse.aperi.gui.tape.drives.DrivesDDI;

public class DrivesTableModel
extends BaseTableModel {
    private DrivesDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_DRIVE_LABEL"), Util.getString("TAPE_STATE_LABEL"), Util.getString("TAPE_NEEDS_CLEANING_LABEL"), Util.getString("TAPE_MOUNTS_LABEL"), Util.getString("TAPE_WWNN_LABEL"), Util.getString("TAPE_FIRMWARE_LABEL"), Util.getString("TAPE_LOCATION_LABEL")};
    private static final int DRIVES_NAME = 0;
    private static final int DRIVES_STATUS = 1;
    private static final int DRIVES_CLEANING = 2;
    private static final int DRIVES_MOUNTS = 3;
    private static final int DRIVES_WWPN = 4;
    private static final int DRIVES_FIRMWARE = 5;
    private static final int DRIVES_LOCATION = 6;

    DrivesTableModel(DrivesDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getDrives().size();
    }

    public Object getTableDataItem(int row, int col) {
        GUIDrive drive = (GUIDrive)this.aDDI.getDrives().elementAt(row);
        switch (col) {
            case 0: {
                return drive.getName();
            }
            case 1: {
                JLabel lb = GUIEntityUtil.getEntityStateLabel(drive);
                return lb;
            }
            case 2: {
                if (!drive.isNeedsCleaning()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 3: {
                return new Long(drive.getMounts());
            }
            case 4: {
                return drive.getWwpn();
            }
            case 5: {
                return drive.getVersion();
            }
            case 6: {
                return drive.getLocation();
            }
        }
        return "";
    }
}

