/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.ioports;

import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.tape.common.model.GUIIOPort;
import org.eclipse.aperi.gui.tape.ioports.IOPortsDDI;

public class IOPortsTableModel
extends BaseTableModel {
    private IOPortsDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_IOPORTS_LABEL"), Util.getString("TAPE_EXTENDED_LABEL"), Util.getString("TAPE_DESCRIPTION_LABEL"), Util.getString("TAPE_LOCATION_LABEL")};
    private static final int LIB_NAME = 0;
    private static final int LIB_EXT = 1;
    private static final int LIB_DESC = 2;
    private static final int LIB_LOC = 3;

    IOPortsTableModel(IOPortsDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getIoPorts().size();
    }

    public Object getTableDataItem(int row, int col) {
        GUIIOPort ioP = (GUIIOPort)this.aDDI.getIoPorts().elementAt(row);
        switch (col) {
            case 0: {
                return ioP.getName();
            }
            case 1: {
                if (!ioP.isExtended()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 2: {
                return ioP.getDescription();
            }
            case 3: {
                return ioP.getLocation();
            }
        }
        return "";
    }
}

