/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.tape.cartridges.CartridgesDDI;
import org.eclipse.aperi.gui.tape.common.TapeGuiTable;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.common.model.TapeDataAccessor;
import org.eclipse.aperi.gui.tape.drives.DrivesDDI;
import org.eclipse.aperi.gui.tape.frames.FramesDDI;
import org.eclipse.aperi.gui.tape.ioports.IOPortsDDI;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;
import org.eclipse.aperi.gui.tape.library.LibraryPanel;
import org.eclipse.aperi.gui.tape.library.LibraryTableModel;
import org.eclipse.aperi.gui.tape.mediachangers.MediaChangersDDI;
import org.eclipse.aperi.request.Response;

public class LibraryListPanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener {
    private static final String ACTION_VIEW_DETAILS = "TAPE_VIEW_DETAILS_LABEL";
    private LibraryDDI theDDI;
    public FramesDDI fDDI;
    public LibraryPanel mainPanel;
    private TapeGuiTable table = new TapeGuiTable();
    private LibraryTableModel tableModel;
    private JButton launchButton = null;
    private JButton drivesButton = null;
    private JButton mediaChangersButton = null;
    private JButton ioPortsButton = null;
    private JButton framesButton = null;
    private JButton cartridgesButton = null;
    private JButton removeButton = null;
    private JPanel p = new JPanel();
    private JPanel pb = new JPanel();
    private JPanel pbNorth = new JPanel();
    private JPanel pbSouth = new JPanel();
    private JPanel tablePanel = GuiUtil.getPanel();
    private boolean dblClick = false;
    private GUILibrary oLibrary;
    private static DefaultTableCellRenderer drillDownRenderer = new DrillDownRenderer();
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object element) {
            return ((GUILibrary)element).getId();
        }

        public String extractDefaultElementManager(Object element) {
            return ((GUILibrary)element).getElementManager();
        }

        public String extractDisplayName(Object element) {
            return ((GUILibrary)element).getName();
        }
    };

    public LibraryListPanel(LibraryDDI ddi) {
        this.theDDI = ddi;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        this.launchButton = new JButton(Util.getString("TAPE_LAUNCH_ELEMENT_MGR_LABEL"));
        this.launchButton.setEnabled(false);
        this.launchButton.addActionListener(this);
        GuiUtil.setAccessible(this.launchButton, this.launchButton.getText(), this.launchButton.getText());
        this.drivesButton = new JButton(Util.getString("TAPE_DRIVES_LABEL"));
        this.drivesButton.setEnabled(false);
        this.drivesButton.addActionListener(this);
        GuiUtil.setAccessible(this.drivesButton, this.drivesButton.getText(), this.drivesButton.getText());
        this.mediaChangersButton = new JButton(Util.getString("TAPE_MEDIA_CHANGERS_LABEL"));
        this.mediaChangersButton.setEnabled(false);
        this.mediaChangersButton.addActionListener(this);
        GuiUtil.setAccessible(this.mediaChangersButton, this.mediaChangersButton.getText(), this.mediaChangersButton.getText());
        this.ioPortsButton = new JButton(Util.getString("TAPE_IOPORTS_LABEL"));
        this.ioPortsButton.setEnabled(false);
        this.ioPortsButton.addActionListener(this);
        GuiUtil.setAccessible(this.ioPortsButton, this.ioPortsButton.getText(), this.ioPortsButton.getText());
        this.cartridgesButton = new JButton(Util.getString("TAPE_CARTRIDGES_LABEL"));
        this.cartridgesButton.setEnabled(false);
        this.cartridgesButton.addActionListener(this);
        GuiUtil.setAccessible(this.cartridgesButton, this.cartridgesButton.getText(), this.cartridgesButton.getText());
        this.removeButton = new JButton(Util.getString("TAPE_REMOVE_LABEL"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        GuiUtil.setAccessible(this.removeButton, this.removeButton.getText(), this.removeButton.getText());
        this.p.setLayout(new BorderLayout());
        this.pbNorth.setLayout(new FlowLayout(0));
        this.pbNorth.add(this.launchButton);
        this.pbNorth.add(this.drivesButton);
        this.pbNorth.add(this.mediaChangersButton);
        this.pbSouth.setLayout(new FlowLayout(0));
        this.pbSouth.add(this.ioPortsButton);
        this.pbSouth.add(this.cartridgesButton);
        this.pbSouth.add(this.removeButton);
        this.pb.setLayout(new BorderLayout());
        this.pb.add((Component)this.pbNorth, "North");
        this.pb.add((Component)this.pbSouth, "South");
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(Util.getString("TAPE_LIBRARIES_LABEL")));
        GridBagConstraints tgbc = new GridBagConstraints();
        tgbc.gridheight = 0;
        tgbc.insets.bottom = 0;
        tgbc.insets.top = 10;
        tgbc.gridwidth = 1;
        tgbc.anchor = 10;
        tgbc.fill = 1;
        tgbc.weighty = 1.0;
        tgbc.weightx = 0.5;
        tgbc.insets = new Insets(3, 3, 3, 3);
        this.buildtable();
        this.tablePanel.add((Component)this.table, tgbc);
        this.add((Component)this.p, "Center");
        this.p.add((Component)this.pb, "North");
        this.p.add((Component)this.tablePanel, "Center");
        this.showAndAddListeners();
        return this;
    }

    private void showAndAddListeners() {
        this.guiMain.setSaveActionEnabled(false, false);
        this.guiMain.addSaveActionListener(this);
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (dataRow < 0 || dataCol < 0) {
            return;
        }
        int selectedRow = this.table.getPointedRow(y);
        this.table.setSelectedRows(selectedRow, selectedRow);
        this.selectionChanged(true);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem mi = menu.add(Util.getString(ACTION_VIEW_DETAILS));
        mi.setActionCommand(ACTION_VIEW_DETAILS);
        mi.addActionListener(this);
        mi.setEnabled(true);
        menu.show(c, x, y);
        menu.requestFocus();
    }

    public void selectionChanged(boolean state) {
        boolean isProperAdmin = this.capabilities.isTapeAdmin();
        if (this.tableModel.getNumRows() != 0) {
            try {
                int[] rows = this.table.getSelectedRows();
                if (rows.length > 0) {
                    GUILibrary lib = (GUILibrary)this.theDDI.getLibrary().elementAt(rows[0]);
                    if (lib.getType() == 1) {
                        this.launchButton.setEnabled(state);
                        if (isProperAdmin) {
                            this.removeButton.setEnabled(state);
                        }
                        if (lib.getCatridges() == 0) {
                            this.cartridgesButton.setEnabled(false);
                        } else {
                            this.cartridgesButton.setEnabled(true);
                        }
                        if (lib.getDrives() == 0) {
                            this.drivesButton.setEnabled(false);
                        } else {
                            this.drivesButton.setEnabled(true);
                        }
                        if (lib.getIoPorts() == 0) {
                            this.ioPortsButton.setEnabled(false);
                        } else {
                            this.ioPortsButton.setEnabled(true);
                        }
                        if (lib.getMediaChangers() == 0) {
                            this.mediaChangersButton.setEnabled(false);
                        } else {
                            this.mediaChangersButton.setEnabled(true);
                        }
                    } else if (lib.getType() == 0) {
                        this.disableAllButtons();
                    }
                } else {
                    this.disableAllButtons();
                }
            }
            catch (ArrayIndexOutOfBoundsException arrex) {
                this.disableAllButtons();
                return;
            }
        }
    }

    public void doubleClick(int dataRow, int dataCol) {
        this.dblClick = true;
        this.theDDI.showDetails(dataRow);
    }

    public void showDefaultChart(int dataRow) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (source == this.drivesButton || source == this.mediaChangersButton || source == this.removeButton || source == this.launchButton || source == this.ioPortsButton || source == this.cartridgesButton || cmd.equals(ACTION_VIEW_DETAILS)) {
            int[] selRows;
            int[] rows = this.table.getSelectedRows();
            GUILibrary[] lib = new GUILibrary[rows.length];
            for (int i = 0; i < lib.length; ++i) {
                lib[i] = (GUILibrary)this.theDDI.getLibrary().elementAt(rows[i]);
            }
            if (source == this.drivesButton) {
                DrivesDDI theDDI = new DrivesDDI(lib[0]);
                ((DataDisplayInfo)theDDI).reDisplay();
            } else if (source == this.mediaChangersButton) {
                MediaChangersDDI theDDI = new MediaChangersDDI(lib[0]);
                ((DataDisplayInfo)theDDI).reDisplay();
            } else if (source == this.removeButton) {
                this.openLibDelete(lib[0]);
            } else if (source == this.launchButton) {
                this.openElementManager(lib[0]);
            } else if (source == this.ioPortsButton) {
                IOPortsDDI theDDI = new IOPortsDDI(lib[0]);
                ((DataDisplayInfo)theDDI).reDisplay();
            } else if (source == this.cartridgesButton) {
                CartridgesDDI theDDI = new CartridgesDDI(lib[0]);
                ((DataDisplayInfo)theDDI).reDisplay();
            } else if (cmd.equals(ACTION_VIEW_DETAILS) && (selRows = this.table.getSelectedRows()).length > 0) {
                this.theDDI.showDetails(selRows[0]);
            }
        }
    }

    public void openLibDelete(GUILibrary lib) {
        TapeDataAccessor tapeAccessor = TapeDataAccessor.getInstance();
        int action = JOptionPane.showConfirmDialog(this, Util.getString("TAPE_REALLY_DELETE_LABEL") + lib.getDisplayName(), Util.getString("TAPE_DELETE_LABEL"), 1);
        switch (action) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                tapeAccessor.deleteTapeLibrary(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                        int retcode;
                        Serializable respData;
                        if (status == 0 && (respData = response.responseData) != null && (retcode = ((Integer)respData).intValue()) == 0) {
                            LibraryListPanel.this.theDDI.nullOutPanel();
                            LibraryListPanel.this.theDDI.getData();
                        }
                    }
                }, lib.getId());
            }
        }
    }

    public void openElementManager(GUILibrary lib) {
        ElementManagerManager.getInstance().launchElementManager(lib, this.getElementManagerHelper());
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    public void buildtable() {
        this.table.setMouseListener(this);
        this.tableModel = new LibraryTableModel(this.theDDI);
        this.table.setCellRenderer(JLabel.class, drillDownRenderer);
        this.table.setCellRenderer(Double.class, new TableCellRenderers.DecimalRenderer(2, ""));
        this.table.setFrozenColumns(1);
        this.table.setRowIcon(10, true);
        this.table.setBaseTableModel(this.tableModel);
        this.table.sortByColumn(0, 1);
        this.table.setSelectionPolicy(0);
        this.table.updateUI();
    }

    public void disableAllButtons() {
        this.launchButton.setEnabled(false);
        this.drivesButton.setEnabled(false);
        this.mediaChangersButton.setEnabled(false);
        this.ioPortsButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.cartridgesButton.setEnabled(false);
    }

    private static class DrillDownRenderer
    extends DefaultTableCellRenderer {
        private DrillDownRenderer() {
        }

        public void setValue(Object o) {
            String str = ((JLabel)o).getText();
            this.setText(str);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(10);
            Icon icon = ((JLabel)o).getIcon();
            this.setIcon(icon);
        }
    }
}

