/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.TCloseTabPane;
import org.eclipse.aperi.gui.TabCloseListener;
import org.eclipse.aperi.gui.tape.common.model.GUIFrame;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.frames.FramesDDI;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;
import org.eclipse.aperi.gui.tape.library.LibraryDetailsPanel;
import org.eclipse.aperi.gui.tape.library.LibraryListPanel;

public class LibraryPanel
extends JPanel
implements FocusListener,
TabCloseListener {
    private LibraryDDI theDDI;
    private FramesDDI theFDDI;
    private GUILibrary lib;
    public LibraryListPanel listPanel = null;
    public JComponent panel = null;
    public LibraryDetailsPanel detailsPanel = null;
    public TCloseTabPane tabs = null;
    private Vector veAllTabs = new Vector();

    public LibraryPanel(LibraryDDI ddi) {
        this.theDDI = ddi;
    }

    public Vector getAllTabs() {
        return this.veAllTabs;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        if (this.tabs == null) {
            this.tabs = new TCloseTabPane(1);
            this.tabs.setFont(BaseTree.boldFont);
            this.tabs.addFocusListener(this);
            if (this.theDDI.getLibraryInternalId() == -1) {
                this.listPanel = new LibraryListPanel(this.theDDI);
                String title = Util.getString("TAPE_LIBRARIES_LABEL");
                this.tabs.addTab(title, this.listPanel.getComponent(), title, false);
            } else {
                this.lib = this.theDDI.getSingleLibrary();
                FramesDDI fDDI = new FramesDDI(this.lib);
                fDDI.reDisplayDetail(this);
            }
            this.add((Component)this.tabs, "Center");
        }
        return this;
    }

    public void showDetails(GUILibrary lib, GUIFrame frame, boolean closeable) {
        boolean tabExists = false;
        String tabTitle = String.valueOf(lib.getDisplayName() + " " + Util.getString("TAPE_DETAILS_LABEL"));
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            if (!this.tabs.getTitleAt(i).equals(tabTitle)) continue;
            this.tabs.setSelectedComponent(this.tabs.getComponent(i));
            tabExists = true;
        }
        if (!tabExists) {
            LibraryDetailsPanel detailPanel = new LibraryDetailsPanel(lib, frame, this.theDDI);
            this.tabs.addTab(tabTitle, detailPanel.getComponent(), tabTitle, closeable, this);
            this.tabs.setSelectedComponent(detailPanel);
            this.veAllTabs.addElement(detailPanel);
        }
    }

    public void refreshPanel() {
        if (this.listPanel != null) {
            this.listPanel.buildtable();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.listPanel.selectionChanged(true);
    }

    public boolean closeTab(int tabIndex) {
        LibraryDetailsPanel selTapeDetailPanel = (LibraryDetailsPanel)this.tabs.getComponentAt(tabIndex);
        selTapeDetailPanel.changesPending(true);
        this.veAllTabs.removeElement(selTapeDetailPanel);
        return true;
    }
}

