/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.library;

import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;

public class LibraryTableModel
extends BaseTableModel {
    private LibraryDDI aDDI;
    private JLabel lb = new JLabel();
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_LIBRARY_LABEL"), Util.getString("TAPE_NAME_LABEL"), Util.getString("TAPE_STATE_LABEL"), Util.getString("TAPE_DRIVES_LABEL"), Util.getString("TAPE_CARTRIDGES_LABEL"), Util.getString("TAPE_MAX_CARTRIDGES_LABEL"), Util.getString("TAPE_ELEMENT_MANAGER_LABEL")};
    private static final int TAPE_LBID = 0;
    private static final int TAPE_NAME = 1;
    private static final int TAPE_STATUS = 2;
    private static final int TAPE_DRIVERS = 3;
    private static final int TAPE_CATRID = 4;
    private static final int TAPE_MAX_CART = 5;
    private static final int TAPE_ELEMENT_MGR = 6;

    LibraryTableModel(LibraryDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getLibrary().size();
    }

    public Object getTableDataItem(int row, int col) {
        try {
            GUILibrary lib = (GUILibrary)this.aDDI.getLibrary().elementAt(row);
            switch (col) {
                case 0: {
                    return lib.getDisplayName();
                }
                case 1: {
                    return lib.getUserProvidedName();
                }
                case 2: {
                    this.lb = GUIEntityUtil.getEntityStateLabel(lib);
                    return this.lb;
                }
                case 3: {
                    return new Long(lib.getDrives());
                }
                case 4: {
                    return new Long(lib.getCatridges());
                }
                case 5: {
                    return new Long(lib.getCatridgeCapacity());
                }
                case 6: {
                    return lib.getElementManager();
                }
            }
            return "";
        }
        catch (ArrayIndexOutOfBoundsException arrayex) {
            return "";
        }
    }
}

