/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup2Computer;

public class GraphModelComputerL0
extends GraphModel {
    public static final GraphScopedType COMPUTERGROUP = new GraphScopedType(GraphComputerGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelComputerL0(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_COMPUTERBYOS;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(COMPUTERGROUP, groupByBitmap);
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocusComputer(groupBySet);
    }

    private void groupFocusComputer(Hashtable groupBySet) {
        this.removeAll(GraphComputerGroup.TYPE);
        this.removeAll(GraphComputerGroup2Computer.TYPE);
        Vector entityV = new Vector();
        Enumeration computerEnu = this.enumerate(GraphComputer.TYPE);
        while (computerEnu.hasMoreElements()) {
            GraphComputer computer = (GraphComputer)computerEnu.nextElement();
            entityV.add(computer);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(COMPUTERGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration computerGroupKeyEnu = groupH.keys();
        while (computerGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)computerGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphComputerGroup computerGroup = new GraphComputerGroup(idStr);
            GraphComputerGroup.ID computerGroupID = (GraphComputerGroup.ID)computerGroup.getEntityID();
            computerGroup.setDisplayName(key.getLabel());
            computerGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            computerGroup.setSortingValue(key);
            computerGroup.setGroupKey(key);
            this.put(computerGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphComputer computer = (GraphComputer)entityV.elementAt(i);
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                GraphComputerGroup2Computer assoc = new GraphComputerGroup2Computer(computerGroupID.getID() + "+" + computerID.getID());
                assoc.setComputerGroupID(computerGroupID);
                assoc.setComputerID(computerID);
                this.put(assoc);
            }
        }
    }

    public void applyFiltering(int filteringLevel) {
        Enumeration computerGroupEnu = this.enumerate(GraphComputerGroup.TYPE);
        while (computerGroupEnu.hasMoreElements()) {
            GraphComputerGroup computerGroup = (GraphComputerGroup)computerGroupEnu.nextElement();
            GraphComputerGroup.ID computerGroupID = (GraphComputerGroup.ID)computerGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration computerEnu = this.associator(GraphComputerGroup2Computer.TYPE, computerGroupID);
            while (computerEnu.hasMoreElements()) {
                GraphComputer computer = (GraphComputer)computerEnu.nextElement();
                ++totalCount;
                Boolean filterable = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(computer) ? Boolean.FALSE : Boolean.TRUE);
                computer.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            computerGroup.setNumOfComputers(new Integer(totalCount));
            computerGroup.setNumOfAbnormalComputers(new Integer(unfilteredCount));
            computerGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID() {
            super("ComputerL0", null);
        }
    }
}

