/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricGroup2Fabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewFabricL2Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup2TapeLibrary;

public class GraphModelFabricL2
extends GraphModel {
    public static final GraphScopedType COMPUTERGROUP = new GraphScopedType(GraphComputerGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType SUBSYSTEMGROUP = new GraphScopedType(GraphSubsystemGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType TAPELIBRARYGROUP = new GraphScopedType(GraphTapeLibraryGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType OTHERGROUP = new GraphScopedType(GraphOtherGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelFabricL2(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_COMPUTERBYOS;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(COMPUTERGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SWGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SUBSYSTEMBYMODEL;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SUBSYSTEMGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(TAPELIBRARYGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(OTHERGROUP, groupByBitmap);
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
        this.groupSubviewConnectivityComputer(groupBySet);
        this.groupSubviewConnectivitySwitch(groupBySet);
        this.groupSubviewConnectivitySubsystem(groupBySet);
        this.groupSubviewConnectivityTapeLibrary(groupBySet);
        this.groupSubviewConnectivityOther(groupBySet);
        this.groupSubviewConnectivity();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        GraphFabric.ID fabricID = (GraphFabric.ID)((ID)this.modelID).getFocusEntityID();
        String fabricGroupIDStr = "Focus";
        GraphFabricGroup fabricGroup = new GraphFabricGroup(fabricGroupIDStr);
        GraphFabricGroup.ID fabricGroupID = (GraphFabricGroup.ID)fabricGroup.getEntityID();
        fabricGroup.setIsHelper(Boolean.TRUE);
        this.put(fabricGroup);
        GraphFabricGroup2Fabric assoc = new GraphFabricGroup2Fabric(fabricGroupID.getID() + "+" + fabricID.getID());
        assoc.setFabricGroupID(fabricGroupID);
        assoc.setFabricID(fabricID);
        this.put(assoc);
    }

    private void groupSubviewConnectivityComputer(Hashtable groupBySet) {
        this.removeAll(GraphComputerGroup.TYPE);
        this.removeAll(GraphComputerGroup2Computer.TYPE);
        Vector entityV = new Vector();
        Enumeration computerEnu = this.enumerate(GraphComputer.TYPE);
        while (computerEnu.hasMoreElements()) {
            GraphComputer computer = (GraphComputer)computerEnu.nextElement();
            entityV.add(computer);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(COMPUTERGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration computerGroupKeyEnu = groupH.keys();
        while (computerGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)computerGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphComputerGroup computerGroup = new GraphComputerGroup(idStr);
            GraphComputerGroup.ID computerGroupID = (GraphComputerGroup.ID)computerGroup.getEntityID();
            computerGroup.setDisplayName(key.getLabel());
            computerGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            computerGroup.setSortingValue(key);
            computerGroup.setGroupKey(key);
            this.put(computerGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphComputer computer = (GraphComputer)entityV.elementAt(i);
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                GraphComputerGroup2Computer assoc = new GraphComputerGroup2Computer(computerGroupID.getID() + "+" + computerID.getID());
                assoc.setComputerGroupID(computerGroupID);
                assoc.setComputerID(computerID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable groupBySet) {
        this.removeAll(GraphSwitchGroup.TYPE);
        this.removeAll(GraphSwitchGroup2Switch.TYPE);
        Vector entityV = new Vector();
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            entityV.add(sw);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SWGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration swGroupKeyEnu = groupH.keys();
        while (swGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)swGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSwitchGroup swGroup = new GraphSwitchGroup(idStr);
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroup.setDisplayName(key.getLabel());
            swGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            swGroup.setSortingValue(key);
            swGroup.setGroupKey(key);
            this.put(swGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSwitch sw = (GraphSwitch)entityV.elementAt(i);
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID.getID() + "+" + swID.getID());
                assoc.setSwitchGroupID(swGroupID);
                assoc.setSwitchID(swID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivitySubsystem(Hashtable groupBySet) {
        this.removeAll(GraphSubsystemGroup.TYPE);
        this.removeAll(GraphSubsystemGroup2Subsystem.TYPE);
        Vector entityV = new Vector();
        Enumeration subsystemEnu = this.enumerate(GraphSubsystem.TYPE);
        while (subsystemEnu.hasMoreElements()) {
            GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
            entityV.add(subsystem);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SUBSYSTEMGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration subsystemGroupKeyEnu = groupH.keys();
        while (subsystemGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)subsystemGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSubsystemGroup subsystemGroup = new GraphSubsystemGroup(idStr);
            GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
            subsystemGroup.setDisplayName(key.getLabel());
            subsystemGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            subsystemGroup.setSortingValue(key);
            subsystemGroup.setGroupKey(key);
            this.put(subsystemGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSubsystem subsystem = (GraphSubsystem)entityV.elementAt(i);
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                GraphSubsystemGroup2Subsystem assoc = new GraphSubsystemGroup2Subsystem(subsystemGroupID.getID() + "+" + subsystemID.getID());
                assoc.setSubsystemGroupID(subsystemGroupID);
                assoc.setSubsystemID(subsystemID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivityTapeLibrary(Hashtable groupBySet) {
        this.removeAll(GraphTapeLibraryGroup.TYPE);
        this.removeAll(GraphTapeLibraryGroup2TapeLibrary.TYPE);
        Vector entityV = new Vector();
        Enumeration tapeLibraryEnu = this.enumerate(GraphTapeLibrary.TYPE);
        while (tapeLibraryEnu.hasMoreElements()) {
            GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)tapeLibraryEnu.nextElement();
            entityV.add(tapeLibrary);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(TAPELIBRARYGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration tapeLibraryGroupKeyEnu = groupH.keys();
        while (tapeLibraryGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)tapeLibraryGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphTapeLibraryGroup tapeLibraryGroup = new GraphTapeLibraryGroup(idStr);
            GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
            tapeLibraryGroup.setDisplayName(key.getLabel());
            tapeLibraryGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            tapeLibraryGroup.setSortingValue(key);
            tapeLibraryGroup.setGroupKey(key);
            this.put(tapeLibraryGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)entityV.elementAt(i);
                GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
                GraphTapeLibraryGroup2TapeLibrary assoc = new GraphTapeLibraryGroup2TapeLibrary(tapeLibraryGroupID.getID() + "+" + tapeLibraryID.getID());
                assoc.setTapeLibraryGroupID(tapeLibraryGroupID);
                assoc.setTapeLibraryID(tapeLibraryID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivityOther(Hashtable groupBySet) {
        this.removeAll(GraphOtherGroup.TYPE);
        this.removeAll(GraphOtherGroup2Other.TYPE);
        Vector entityV = new Vector();
        Enumeration otherEnu = this.enumerate(GraphOther.TYPE);
        while (otherEnu.hasMoreElements()) {
            GraphOther other = (GraphOther)otherEnu.nextElement();
            entityV.add(other);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(OTHERGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration otherGroupKeyEnu = groupH.keys();
        while (otherGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)otherGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphOtherGroup otherGroup = new GraphOtherGroup(idStr);
            GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
            otherGroup.setDisplayName(key.getLabel());
            otherGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            otherGroup.setSortingValue(key);
            otherGroup.setGroupKey(key);
            this.put(otherGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphOther other = (GraphOther)entityV.elementAt(i);
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                GraphOtherGroup2Other assoc = new GraphOtherGroup2Other(otherGroupID.getID() + "+" + otherID.getID());
                assoc.setOtherGroupID(otherGroupID);
                assoc.setOtherID(otherID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivity() {
        GraphSubviewFabricL2Connectivity connectivity = new GraphSubviewFabricL2Connectivity("Connectivity");
        GraphSubviewFabricL2Connectivity.ID connectivityID = (GraphSubviewFabricL2Connectivity.ID)connectivity.getEntityID();
        connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(connectivity);
        Enumeration computerGroupEnu = this.enumerate(GraphComputerGroup.TYPE);
        while (computerGroupEnu.hasMoreElements()) {
            GraphComputerGroup computerGroup = (GraphComputerGroup)computerGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), computerGroup.getHealthStatus()));
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), swGroup.getHealthStatus()));
        }
        Enumeration subsystemGroupEnu = this.enumerate(GraphSubsystemGroup.TYPE);
        while (subsystemGroupEnu.hasMoreElements()) {
            GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), subsystemGroup.getHealthStatus()));
        }
        Enumeration tapeLibraryGroupEnu = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (tapeLibraryGroupEnu.hasMoreElements()) {
            GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), tapeLibraryGroup.getHealthStatus()));
        }
        Enumeration otherGroupEnu = this.enumerate(GraphSubsystemGroup.TYPE);
        while (otherGroupEnu.hasMoreElements()) {
            GraphSubsystemGroup otherGroup = (GraphSubsystemGroup)otherGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), otherGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int filteringLevel) {
        GraphSwitch sw;
        GraphSwitch.ID swID;
        GraphSwitch2Computer sw2computer;
        Enumeration sw2computerEnu;
        Boolean filterable;
        int unfilteredCount;
        int totalCount;
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration swEnu = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw2 = (GraphSwitch)swEnu.nextElement();
                GraphSwitch.ID swID2 = (GraphSwitch.ID)sw2.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(sw2)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        sw2computerEnu = this.reference(GraphSwitch2Computer.TYPE, swID2);
                        while (sw2computerEnu.hasMoreElements()) {
                            sw2computer = (GraphSwitch2Computer)sw2computerEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2computer)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphComputer.ID computerID = sw2computer.getComputerID();
                            GraphComputer computer = (GraphComputer)this.get(computerID);
                            if (!GraphModelUtilities.isAbnormal(computer)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                        Enumeration sw2swEnu = this.reference(GraphSwitch2Switch.TYPE, swID2);
                        while (sw2swEnu.hasMoreElements()) {
                            GraphSwitch sw22;
                            GraphSwitch2Switch sw2sw = (GraphSwitch2Switch)sw2swEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2sw)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphSwitch.ID sw2ID = sw2sw.getSwitch1ID();
                            if (sw2ID.equals(swID2)) {
                                sw2ID = sw2sw.getSwitch2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(sw22 = (GraphSwitch)this.get(sw2ID))) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                        Enumeration sw2subsystemEnu = this.reference(GraphSwitch2Subsystem.TYPE, swID2);
                        while (sw2subsystemEnu.hasMoreElements()) {
                            GraphSwitch2Subsystem sw2subsystem = (GraphSwitch2Subsystem)sw2subsystemEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2subsystem)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphSubsystem.ID subsystemID = sw2subsystem.getSubsystemID();
                            GraphSubsystem subsystem = (GraphSubsystem)this.get(subsystemID);
                            if (!GraphModelUtilities.isAbnormal(subsystem)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                        Enumeration sw2tapeLibraryEnu = this.reference(GraphSwitch2TapeLibrary.TYPE, swID2);
                        while (sw2tapeLibraryEnu.hasMoreElements()) {
                            GraphSwitch2TapeLibrary sw2tapeLibrary = (GraphSwitch2TapeLibrary)sw2tapeLibraryEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2tapeLibrary)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphTapeLibrary.ID tapeLibraryID = sw2tapeLibrary.getTapeLibraryID();
                            GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)this.get(tapeLibraryID);
                            if (!GraphModelUtilities.isAbnormal(tapeLibrary)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                        Enumeration sw2otherEnu = this.reference(GraphSwitch2Other.TYPE, swID2);
                        while (sw2otherEnu.hasMoreElements()) {
                            GraphSwitch2Other sw2other = (GraphSwitch2Other)sw2otherEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2other)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphOther.ID otherID = sw2other.getOtherID();
                            GraphOther other = (GraphOther)this.get(otherID);
                            if (!GraphModelUtilities.isAbnormal(other)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                sw2.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            swGroup.setNumOfSwitches(new Integer(totalCount));
            swGroup.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            swGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration computerGroupEnu = this.enumerate(GraphComputerGroup.TYPE);
        while (computerGroupEnu.hasMoreElements()) {
            GraphComputerGroup computerGroup = (GraphComputerGroup)computerGroupEnu.nextElement();
            GraphComputerGroup.ID computerGroupID = (GraphComputerGroup.ID)computerGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration computerEnu = this.associator(GraphComputerGroup2Computer.TYPE, computerGroupID);
            while (computerEnu.hasMoreElements()) {
                GraphComputer computer = (GraphComputer)computerEnu.nextElement();
                GraphComputer.ID computerID = (GraphComputer.ID)computer.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(computer)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        sw2computerEnu = this.reference(GraphSwitch2Computer.TYPE, computerID);
                        while (sw2computerEnu.hasMoreElements()) {
                            sw2computer = (GraphSwitch2Computer)sw2computerEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2computer)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            swID = sw2computer.getSwitchID();
                            sw = (GraphSwitch)this.get(swID);
                            if (!GraphModelUtilities.isAbnormal(sw)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                computer.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            computerGroup.setNumOfComputers(new Integer(totalCount));
            computerGroup.setNumOfAbnormalComputers(new Integer(unfilteredCount));
            computerGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration subsystemGroupEnu = this.enumerate(GraphSubsystemGroup.TYPE);
        while (subsystemGroupEnu.hasMoreElements()) {
            GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu.nextElement();
            GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration subsystemEnu = this.associator(GraphSubsystemGroup2Subsystem.TYPE, subsystemGroupID);
            while (subsystemEnu.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(subsystem)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration sw2subsystemEnu = this.reference(GraphSwitch2Subsystem.TYPE, subsystemID);
                        while (sw2subsystemEnu.hasMoreElements()) {
                            GraphSwitch2Subsystem sw2subsystem = (GraphSwitch2Subsystem)sw2subsystemEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2subsystem)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            swID = sw2subsystem.getSwitchID();
                            sw = (GraphSwitch)this.get(swID);
                            if (!GraphModelUtilities.isAbnormal(sw)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                subsystem.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            subsystemGroup.setNumOfSubsystems(new Integer(totalCount));
            subsystemGroup.setNumOfAbnormalSubsystems(new Integer(unfilteredCount));
            subsystemGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration tapeLibraryGroupEnu = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (tapeLibraryGroupEnu.hasMoreElements()) {
            GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu.nextElement();
            GraphTapeLibraryGroup.ID tapeLibraryGroupID = (GraphTapeLibraryGroup.ID)tapeLibraryGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration tapeLibraryEnu = this.associator(GraphTapeLibraryGroup2TapeLibrary.TYPE, tapeLibraryGroupID);
            while (tapeLibraryEnu.hasMoreElements()) {
                GraphTapeLibrary tapeLibrary = (GraphTapeLibrary)tapeLibraryEnu.nextElement();
                GraphTapeLibrary.ID tapeLibraryID = (GraphTapeLibrary.ID)tapeLibrary.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(tapeLibrary)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration sw2tapeLibraryEnu = this.reference(GraphSwitch2TapeLibrary.TYPE, tapeLibraryID);
                        while (sw2tapeLibraryEnu.hasMoreElements()) {
                            GraphSwitch2TapeLibrary sw2tapeLibrary = (GraphSwitch2TapeLibrary)sw2tapeLibraryEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2tapeLibrary)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            swID = sw2tapeLibrary.getSwitchID();
                            sw = (GraphSwitch)this.get(swID);
                            if (!GraphModelUtilities.isAbnormal(sw)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                tapeLibrary.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            tapeLibraryGroup.setNumOfTapeLibraries(new Integer(totalCount));
            tapeLibraryGroup.setNumOfAbnormalTapeLibraries(new Integer(unfilteredCount));
            tapeLibraryGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration otherGroupEnu = this.enumerate(GraphOtherGroup.TYPE);
        while (otherGroupEnu.hasMoreElements()) {
            GraphOtherGroup otherGroup = (GraphOtherGroup)otherGroupEnu.nextElement();
            GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration otherEnu = this.associator(GraphOtherGroup2Other.TYPE, otherGroupID);
            while (otherEnu.hasMoreElements()) {
                GraphOther other = (GraphOther)otherEnu.nextElement();
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(other)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration sw2otherEnu = this.reference(GraphSwitch2Other.TYPE, otherID);
                        while (sw2otherEnu.hasMoreElements()) {
                            GraphSwitch2Other sw2other = (GraphSwitch2Other)sw2otherEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(sw2other)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            swID = sw2other.getSwitchID();
                            sw = (GraphSwitch)this.get(swID);
                            if (!GraphModelUtilities.isAbnormal(sw)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                other.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            otherGroup.setNumOfOthers(new Integer(totalCount));
            otherGroup.setNumOfAbnormalOthers(new Integer(unfilteredCount));
            otherGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration connectivityEnu = this.enumerate(GraphSubviewFabricL2Connectivity.TYPE);
        while (connectivityEnu.hasMoreElements()) {
            GraphSubviewFabricL2Connectivity connectivity = (GraphSubviewFabricL2Connectivity)connectivityEnu.nextElement();
            int totalCount2 = 0;
            int unfilteredCount2 = 0;
            Enumeration computerGroupEnu2 = this.enumerate(GraphComputerGroup.TYPE);
            while (computerGroupEnu2.hasMoreElements()) {
                GraphComputerGroup computerGroup = (GraphComputerGroup)computerGroupEnu2.nextElement();
                totalCount2 += computerGroup.getNumOfComputers().intValue();
                unfilteredCount2 += computerGroup.getNumOfAbnormalComputers().intValue();
            }
            connectivity.setNumOfComputers(new Integer(totalCount2));
            connectivity.setNumOfAbnormalComputers(new Integer(unfilteredCount2));
            totalCount2 = 0;
            unfilteredCount2 = 0;
            Enumeration swGroupEnu2 = this.enumerate(GraphSwitchGroup.TYPE);
            while (swGroupEnu2.hasMoreElements()) {
                GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu2.nextElement();
                totalCount2 += swGroup.getNumOfSwitches().intValue();
                unfilteredCount2 += swGroup.getNumOfAbnormalSwitches().intValue();
            }
            connectivity.setNumOfSwitches(new Integer(totalCount2));
            connectivity.setNumOfAbnormalSwitches(new Integer(unfilteredCount2));
            totalCount2 = 0;
            unfilteredCount2 = 0;
            Enumeration subsystemGroupEnu2 = this.enumerate(GraphSubsystemGroup.TYPE);
            while (subsystemGroupEnu2.hasMoreElements()) {
                GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu2.nextElement();
                totalCount2 += subsystemGroup.getNumOfSubsystems().intValue();
                unfilteredCount2 += subsystemGroup.getNumOfAbnormalSubsystems().intValue();
            }
            connectivity.setNumOfSubsystems(new Integer(totalCount2));
            connectivity.setNumOfAbnormalSubsystems(new Integer(unfilteredCount2));
            totalCount2 = 0;
            unfilteredCount2 = 0;
            Enumeration tapeLibraryGroupEnu2 = this.enumerate(GraphTapeLibraryGroup.TYPE);
            while (tapeLibraryGroupEnu2.hasMoreElements()) {
                GraphTapeLibraryGroup tapeLibraryGroup = (GraphTapeLibraryGroup)tapeLibraryGroupEnu2.nextElement();
                totalCount2 += tapeLibraryGroup.getNumOfTapeLibraries().intValue();
                unfilteredCount2 += tapeLibraryGroup.getNumOfAbnormalTapeLibraries().intValue();
            }
            connectivity.setNumOfTapeLibraries(new Integer(totalCount2));
            connectivity.setNumOfAbnormalTapeLibraries(new Integer(unfilteredCount2));
            totalCount2 = 0;
            unfilteredCount2 = 0;
            Enumeration otherGroupEnu2 = this.enumerate(GraphOtherGroup.TYPE);
            while (otherGroupEnu2.hasMoreElements()) {
                GraphOtherGroup otherGroup = (GraphOtherGroup)otherGroupEnu2.nextElement();
                totalCount2 += otherGroup.getNumOfOthers().intValue();
                unfilteredCount2 += otherGroup.getNumOfAbnormalOthers().intValue();
            }
            connectivity.setNumOfOthers(new Integer(totalCount2));
            connectivity.setNumOfAbnormalOthers(new Integer(unfilteredCount2));
            connectivity.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID(GraphFabric focusEntity) {
            super("FabricL2", focusEntity.getEntityID());
        }
    }
}

