/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup2Other;

public class GraphModelOtherL0
extends GraphModel {
    public static final GraphScopedType OTHERGROUP = new GraphScopedType(GraphOtherGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelOtherL0(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(OTHERGROUP, groupByBitmap);
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocusOther(groupBySet);
    }

    private void groupFocusOther(Hashtable groupBySet) {
        this.removeAll(GraphOtherGroup.TYPE);
        this.removeAll(GraphOtherGroup2Other.TYPE);
        Vector entityV = new Vector();
        Enumeration otherEnu = this.enumerate(GraphOther.TYPE);
        while (otherEnu.hasMoreElements()) {
            GraphOther other = (GraphOther)otherEnu.nextElement();
            entityV.add(other);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(OTHERGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration otherGroupKeyEnu = groupH.keys();
        while (otherGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)otherGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphOtherGroup otherGroup = new GraphOtherGroup(idStr);
            GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
            otherGroup.setDisplayName(key.getLabel());
            otherGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            otherGroup.setSortingValue(key);
            otherGroup.setGroupKey(key);
            this.put(otherGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphOther other = (GraphOther)entityV.elementAt(i);
                GraphOther.ID otherID = (GraphOther.ID)other.getEntityID();
                GraphOtherGroup2Other assoc = new GraphOtherGroup2Other(otherGroupID.getID() + "+" + otherID.getID());
                assoc.setOtherGroupID(otherGroupID);
                assoc.setOtherID(otherID);
                this.put(assoc);
            }
        }
    }

    public void applyFiltering(int filteringLevel) {
        Enumeration otherGroupEnu = this.enumerate(GraphOtherGroup.TYPE);
        while (otherGroupEnu.hasMoreElements()) {
            GraphOtherGroup otherGroup = (GraphOtherGroup)otherGroupEnu.nextElement();
            GraphOtherGroup.ID otherGroupID = (GraphOtherGroup.ID)otherGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration otherEnu = this.associator(GraphOtherGroup2Other.TYPE, otherGroupID);
            while (otherEnu.hasMoreElements()) {
                GraphOther other = (GraphOther)otherEnu.nextElement();
                ++totalCount;
                Boolean filterable = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(other) ? Boolean.FALSE : Boolean.TRUE);
                other.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            otherGroup.setNumOfOthers(new Integer(totalCount));
            otherGroup.setNumOfAbnormalOthers(new Integer(unfilteredCount));
            otherGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID() {
            super("OtherL0", null);
        }
    }
}

